/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   arc-definitions.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />

/**
 * Request / response information data used in ARC.
 * Contains definitions for status codes and request and response headers.
 *
 * The fileds may be empty when not yet initialized.
 *
 * The `<arc-definitions>` element listens at its nearest shadow root boundary for query events.
 * Other elements can send the `query-headers` and `query-status-codes` events that will be
 * handled by this element. Events will be stopped from propagation. Event returned value will
 * contain the data.
 *
 * ### Example
 * ```
 * <arc-definitions
 *   requests="{{requestsDefinitions}}"
 *   responses="{{responsesDefinitions}}"
 *   status-codes="{{statusCodesDefinitions}}"></arc-definitions>
 * ```
 *
 * ### Firing events Example
 *
 * ```javascript
 * // Polymer 1.x
 * let event = this.fire('query-headers', {
 *   'type': 'request', // or response, mandatory
 *   'query': 'Acce' // finds all request headers containing `acce` in their name
 * }, {
 *   cancelable: true
 * });
 * console.log(event.defaultPrevented); // true
 * let headers = event.detail.headers;  // Array[]
 * ```
 *
 * ```javascript
 * // Vanilla JavaScript
 * var event = new CustomEvent('query-headers', {
 *   detail: {
 *     'type': 'request',
 *     'query': 'Acce'
 *   },
 *   bubbles: true,
 *   composed: true,
 *   cancelable: true
 * });
 * document.body.dispatchEvent(event);
 * console.log(event.defaultPrevented); // true
 * let headers = event.detail.headers;  // Array[]
 * ```
 *
 * ```javascript
 * let event = this.fire('query-status-codes', {
 *   'code': 200
 * }, {
 *   cancelable: true
 * });
 * console.log(event.defaultPrevented); // true
 * let statusCode = event.detail.statusCode;  // Array[]
 * ```
 *
 * ```javascript
 * // Vanilla JavaScript
 * var event = new CustomEvent('query-status-codes', {
 *   detail: {
 *     'code': 200
 *   },
 *   bubbles: true,
 *   composed: true,
 *   cancelable: true
 * });
 * document.body.dispatchEvent(event);
 * console.log(event.defaultPrevented); // true
 * let statusCode = event.detail.statusCode; // Array[]
 * ```
 *
 * The event should be cancellable so the element can cancel it and other
 * instances of this element will not handle it again. Though it's not an error
 * dispatching this event as not cancelable.
 *
 * If the element was handled by the element and the event is cancelable then
 * event's `defaultPrevented` flag is set to `true`.
 *
 * If query event do not contain query value then all values for given query type
 * will be returned.
 *
 * For example following event returns all request headers
 *
 * ```javascript
 * let event = this.fire('query-headers', {
 *   'type': 'request',
 *   'query': '' // it might be not defined.
 * }, {
 *   cancelable: true
 * });
 * ```
 */
declare class ArcDefinitions extends Polymer.Element {

  /**
   * A list of request headers.
   *
   * Each object contains a `key`, `desc` and `example` property. `key` is a header name,
   * `desc` is a description of the header and `example` is an example of usage.
   *
   * ### Example
   * ```
   * [{
   *  "key": "Accept",
   *  "desc": "Content-Types that are acceptable.",
   *  "example": "Accept: text/plain"
   * }],
   * ```
   */
  readonly requestHeaders: any[]|null|undefined;

  /**
   * A list of response headers.
   *
   * Each object contains a `key`, `desc` and `example` property. `key` is a header name,
   * `desc` is a description of the header and `example` is an example of usage.
   *
   * ### Example
   * ```
   * [{
   *  "key": "Age",
   *  "desc": "The age the object has been in a proxy cache in seconds",
   *  "example": "Age: 12"
   * }],
   * ```
   */
  readonly responseHeaders: any[]|null|undefined;

  /**
   * A list of status codes definitions.
   *
   * Each object contains a `key`, `label` and `desc` property. `key` is a status code (as
   * a number), `label` is a status code message and `desc` is description for the status
   * code.
   *
   * ### Example
   * ```
   * [{
   *  "key": 306,
   *  "label": "Switch Proxy",
   *  "desc": "No longer used."
   * }]
   */
  readonly statusCodes: any[]|null|undefined;

  /**
   * If set the element will not load definitions into the memory when it's
   * created but rather when any data access function is called.
   *
   * This roperty is deprecated and will be removed in next major release
   * version. New behavior will always prohibit loading definitions
   * when component is ready.
   */
  loadOnDemand: boolean|null|undefined;
  ready(): void;
  connectedCallback(): void;
  disconnectedCallback(): void;
  _setDefinitions(): void;

  /**
   * Queries for request headers that containins a `query`. If query is
   * not set (value is falsy) then it returns all headers definitions array.
   *
   * @param name A header name to look for. It will match a header
   * where the header name contains the `name` param.
   * @returns Array of the request headers matched `name` in
   * the header's `key` field.
   */
  queryRequestHeaders(name: String|null): Array<object|null>|null;

  /**
   * Queries for response headers that containins a `query`. If query is
   * not set (value is falsy) then it returns all headers definitions array.
   *
   * @param name A header name to look for. It will match a header where the header
   * name contains the `name` param.
   * @returns Array of the response headers matched `name`
   * in the header's `key` field.
   */
  queryResponseHeaders(name: String|null): Array<object|null>|null;

  /**
   * Queries for headers containin a `query`. If query is not set
   * (value is falsy) then it returns all headers definitions array.
   *
   * @param query A query to search for in the `key` field of the
   * headers array.
   * @param type If this equals `request` then it will look in the
   * request headers array. In the response headers list otherwise.
   * @returns Array of the headers of selected `type`
   * matched a `query` in a header's `key` field.
   */
  queryHeaders(query: String|null, type: String|null): Array<object|null>|null;

  /**
   * Convinient function to look for a status code in the array.
   *
   * @param code The status code to look for.
   * @returns Status code definition or null if not found.
   */
  getStatusCode(code: Number|null): object|null;

  /**
   * A handler for the status headers query event
   */
  _queryHeadersHandler(e: CustomEvent|null): void;

  /**
   * A handler for the status code query event
   */
  _queryCodesHandler(e: CustomEvent|null): void;
  _stopEvent(e: any): void;
}

interface HTMLElementTagNameMap {
  "arc-definitions": ArcDefinitions;
}
