/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   authorization-panel.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../iron-meta/iron-meta.d.ts" />
/// <reference path="../paper-dropdown-menu/paper-dropdown-menu.d.ts" />
/// <reference path="../paper-item/paper-item.d.ts" />
/// <reference path="../paper-listbox/paper-listbox.d.ts" />
/// <reference path="../auth-methods/auth-methods.d.ts" />
/// <reference path="../events-target-behavior/events-target-behavior.d.ts" />
/// <reference path="../auth-methods/auth-method-step.d.ts" />
/// <reference path="../amf-helper-mixin/amf-helper-mixin.d.ts" />

declare namespace UiElements {

  /**
   * Authorization panel used in the request panel to get user authorization information.
   *
   * It is a set of forms that allow set up the authorization method for a HTTP request.
   *
   * The element do not perform authorization. Depending on selected method there
   * are different ways of dealing with the authorization.
   *
   * ## Auth methods availability
   *
   * By default the element renders all authorization methods available to it.
   *
   * Currently these are:
   * - none (auth is optional)
   * - basic
   * - digest
   * - ntlm
   * - OAuth 2.0
   * - OAuth 1.0
   *
   * The list can be changed by setting the `securedBy` property to the
   * [AMF](https://github.com/mulesoft/amf) security description.
   *
   * Alternatively, use `iron-meta` element with `key` property set to `auth-methods`
   * and `value` property set to list of suppored methods.
   *
   * #### Example
   *
   * ```html
   * <iron-meta key="auth-methods" value='[null, "basic", "oauth1", "oauth2"]'></iron-meta>
   * ```
   *
   * Keys can be any of `none`, `basic`, `ntlm`, `digest`, `oauth1` and `oauth2`.
   *
   * Note, that if you set meta data and `securedBy` property it will use combination
   * of both. The base list of rendered methods is meta data list and then reduced to
   * defined in RAML methods. Also note, that custom auth methods are always rendered.
   *
   * ## Supported methods
   *
   * Detailed information about authorization methods can be find in the
   * [auth-methods documentation page]
   * (https://elements.advancedrestclient.com/elements/auth-methods).
   *
   * ### Basic Authentication
   *
   * The element sends the `request-header-changed` custom event to inform any other
   * element that is listening to this event that header value has changed
   * (Authorization in this case). The `raml-headers-form` is an example of an
   * element that is listening for this event and change request headers value
   * when auth data change.
   *
   * ### OAuth 2.0
   *
   * The [Oauth 2 form]
   * (https://elements.advancedrestclient.com/elements/auth-methods?active=auth-method-oauth2)
   * sends the `oauth2-token-requested` custom event with the OAuth settings provided
   * by the user.
   * Any element / hosting app can handle this event and perform authorization.
   * ARC elements provides the
   * [oauth2-authorization](https://elements.advancedrestclient.com/elements/oauth-authorization)
   * element (from the `oauth-authorization` package) that can be placed anywhere
   * in the DOM (from current element where `authorization-panel` is attached up
   * to the body) and perform OAuth athorization.
   *
   * However it can be also done by any other element / app  or even server.
   * See `<oauth2-authorization>` for detailed documentation.
   *
   *
   * Note: OAuth 2.0 server flow probably will not work in regular browser
   * environment because main providers aren't setting CORS headers. Therefore the
   * request will be canceled by the browser.
   *
   * To make it work, handle the `oauth2-token-requested` fired from the inside of this element.
   * If it's browser flow type (implicit) then the `oauth2-authorization` element can be used.
   * For other other types, handle and cancel the event and use server to handle token exchange.
   * The ARC elements offers a
   * [Chrome extension](https://github.com/advanced-rest-client/api-console-extension)
   * that once installed will propxy auth requests and made the exchange even for
   * the server flow. The application should use
   * [api-console-ext-comm](https://github.com/advanced-rest-client/api-console-ext-comm)
   * element to communicate with the extension.
   *
   * #### `redirect-url` property for OAuth 2.0
   *
   * OAuth protocol requires to define a redirect URL that is registered in the
   * OAuth provider. The redirect URL should point to a page that will pass the URL
   * parameters to the opener page (OAuth 2 panel).
   * If you application uses the
   * [oauth-authorization](https://elements.advancedrestclient.com/elements/oauth-authorization)
   * element then it provides a popup that pases the data back to the application.
   * In this case your redirect URL would be
   * `https://your.domain.com/bower_components/oauth-authorization/oauth-popup.html`.
   * User have to change OAuth provider's settings and adjust the redirect URL to
   * point to this page.
   *
   * You can also use the
   * [oauth-popup.html]
   * (https://github.com/advanced-rest-client/oauth-authorization/blob/stage/oauth-popup.html)
   * to build your own page.
   *
   * ### OAuth 1.0a
   *
   * Oauth 1a is not currently supported. However, it uses obsolite hashing
   * algorithms and should not be used.
   *
   * ### Digest Authentication
   *
   * When the user provide all required information for Digest authorization then
   * this element will fire `request-header-changed` custom event which will do the
   * same thing as in case of Basic authentication.
   *
   * ### Example
   *
   * ```
   * <authorization-panel
   *  redirect-url="http://domain.com/bower_components/oauth-authorization/oauth-popup.html"
   *  ></authorization-panel>
   * ```
   *
   * ### Styling
   *
   * `<authorization-panel>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--authorization-panel` | Mixin applied to the element | `{}`
   * `--arc-font-body1` | Theme mixin, Mixin applied to the elements that are containg text | `{}`
   * `--empty-info` | Mixin applied to the element that renders no methods availability message | `{}`
   *
   * Also check [auth-methods documentation page]
   * (https://elements.advancedrestclient.com/elements/auth-methods)
   * for methods styling instructions.
   *
   * ## Changes in version 2
   *
   * - Renamed properties:
   *  - `redirectUrl` -> `redirectUri`
   *  - `_restoreSettings()` is not `restore()` function
   * - `auth-settings-changed` custom event is stopped from bubbling. Listen for
   * `authorization-settings-changed` event instead.
   */
  class AuthorizationPanel extends
    ArcBehaviors.EventsTargetBehavior(
    ApiElements.AmfHelperMixin(
    Object)) {

    /**
     * List of authorization methods supported by this element.
     * Each item has `id` and `name` property. The `id` is internal ID for
     * authorization methods. Can be any of: `none`, `basic`, `ntlm`, `digest`,
     * `oauth1` and `oauth2`. The `name` property is a lable for the method
     * used in UI.
     */
    readonly supportedMethods: Array<object|null>|null;
    readonly currentPanel: HTMLElement|null;

    /**
     * Selected authorization type. It is one of the types supported by
     * `advanced-rest-client/auth-methods` component.
     *
     * This corresponds to the index of `authMethods` array.
     */
    selected: number|null|undefined;

    /**
     * Computed value. `true` when authorization method is selected.
     */
    readonly isSelected: boolean|null|undefined;

    /**
     * Computed value from the AMF model.
     * If authorization is required by endpoint defined in the model,
     * then internally this property is set to `true`.
     *
     * It can be `false` if `selected` is `none`, meaning RAML spec
     * allows no authorization.
     */
    authRequired: boolean|null|undefined;

    /**
     * Determines if the user propertly provided authorization data into the
     * authorization form.
     *
     * For OAuth 1/2 authorization token must be set for this to be computed
     * to `true`.
     *
     * This property is only relevant when `authRequired` is set to true.
     * This status can be cancelled by setting `authRequired` to false.
     */
    readonly authValid: boolean|null|undefined;

    /**
     * Current settings of selected auth type.
     *
     * Can be `undefined` if the user hasn't filled all required fields in the
     * form.
     */
    settings: object|null|undefined;

    /**
     * Security definition for an endpoint in AMF json/ld model.
     * It is `http://raml.org/vocabularies/security#security`
     * property of the `http://www.w3.org/ns/hydra/core#supportedOperation`
     * property of an endpoint.
     */
    securedBy: any[]|null|undefined;

    /**
     * The OAuth2 redirect URL to be set in the OAuth2 form pane.
     */
    redirectUri: boolean|null|undefined;

    /**
     * List of currently rendered authorization methods.
     * This value changes when `securedBy` changes to reflect number of
     * authorization methods supported by current endpoint.
     */
    authMethods: any[]|null|undefined;

    /**
     * Computed value, `true` if any method is rendered.
     */
    readonly hasAuthMethods: boolean|null|undefined;

    /**
     * If true then the numbered steps aren't rendered.
     */
    noSteps: boolean|null|undefined;

    /**
     * List of currently available custom security schemes declared in
     * the AMF
     */
    customSchemes: any[]|null|undefined;

    /**
     * If true then the ripple effect on step title is disabled.
     */
    noink: boolean|null|undefined;

    /**
     * If true the panels won't render inline documentation if
     * the information is available.
     */
    noDocs: boolean|null|undefined;

    /**
     * Current HTTP method. Passed to digest method.
     */
    httpMethod: string|null|undefined;

    /**
     * Current request URL. Passed to digest method.
     */
    requestUrl: string|null|undefined;

    /**
     * Current request body. Passed to digest method.
     */
    requestBody: string|null|undefined;

    /**
     * If set, automatically selects first authorization method from
     * the `amfSettings`.
     */
    autoSelect: boolean|null|undefined;

    /**
     * When set, changes in the auth panels are not propagated through
     * the application.
     */
    readonly: boolean|null|undefined;
    _attachListeners(): void;
    _detachListeners(): void;
    ready(): void;

    /**
     * Clears the state of the panel.
     */
    clear(): void;

    /**
     * Replaces active panel with new one and dipatches
     * `authorization-type-changed` event.
     *
     * If the event is canceled it restores previous value in the selector.
     */
    _selectedChanged(selected: Number|null, oldValue: Number|null): void;

    /**
     * Ensures that the authorization header is removed if previously
     * selected (and now deselected) type is one of using Authorization
     * header.
     *
     * @param oldSelected Previously selected auth method
     */
    _ensureAuthHeaderRemoved(oldSelected: Number|null): void;

    /**
     * Dispatches `request-header-deleted` custom event to inform listeners
     * that `authorization` header should not be used.
     */
    _clearAuthHeader(): void;

    /**
     * Searches for AMF security description in the AMF model.
     *
     * @param type Security scheme type as defined in RAML spec.
     * @param name Display name of the security scheme
     * @returns [description]
     */
    _computeAmfSettings(type: String|null, name: String|null): any;

    /**
     * Changes property value on the panel, if any panel exists.
     *
     * @param prop The property name to set value on.
     * @param value The value
     */
    _changePanelValue(prop: String|null, value: any|null): void;

    /**
     * Updates `noSteps` property on current panel.
     *
     * @param value New value to set
     */
    _nostepChanged(value: String|null): void;

    /**
     * Updates events target property on current panel.
     *
     * @param target New target
     */
    _passEventsTarget(target: HTMLElement|null): void;

    /**
     * Updates `noink` property on panels.
     *
     * @param value Current value.
     */
    _noinkChanged(value: Boolean|null): void;

    /**
     * Updates `noDocs` property on panels.
     *
     * @param value Current value.
     */
    _noDocsChanged(value: Boolean|null): void;

    /**
     * Updates `redirectUri` property on oauth panels.
     *
     * @param uri New value to set
     */
    _redirectUriChanged(uri: String|null): void;

    /**
     * Updates `httpMethod` property on Digest panel.
     */
    _requestMethodChanged(method: String|null): void;

    /**
     * Updates `requestUrl` property on Digest panel.
     */
    _requestUrlChanged(url: String|null): void;

    /**
     * Updates `requestBody` property on Digest panel.
     */
    _requestBodyChanged(body: String|null): void;
    _amfModelChanged(amfModel: any): void;

    /**
     * Lists available authorization methods.
     * By default it returns list from `supportedMethods` property which is the
     * list of all supported methods by this element.
     * If `iron-meta` element with key `auth-methods` is set then it will use
     * this information to compute list of auth methods.
     * See element description for more information.
     *
     * @returns See `supportedMethods` property for data model.
     */
    _listAuthMethods(): Array<object|null>|null;

    /**
     * Creates a listing of methods from `iron-meta` definition.
     *
     * @returns List of methods defined in `iron-meta`
     * or undefined if not set.
     */
    _listMetaAuthMethods(): any[]|null|undefined;

    /**
     * Updates validation state for the selected form.
     * When element is initializing and RAML's `securedBy` property is set
     * during the initialization time, events with settings are fired before the form
     * is ready.
     */
    _updateValidationState(): void;

    /**
     * Handler for `auth-settings-changed` custom event.
     * Sets up `settings` property from the event.
     */
    _authSettingsHandler(e: CustomEvent|null): void;

    /**
     * Finds a RAML method name from both RAML type or auth panel type.
     *
     * @returns RAML type name
     */
    _panelTypeToRamType(type: String|null): String|null|undefined;

    /**
     * Notifies about changes to authorization settings object.
     *
     * @param record Change record
     */
    _authSettingsUpdated(record: object|null): void;

    /**
     * Restores settings to a panel including selection and data.
     *
     * @param settings The same settings object as dispatched in
     * `detail` object from this element.
     */
    restore(settings: object|null): void;

    /**
     * Notifies settings change if currently selected method is the same as
     * `settings.type`.
     *
     * @param settings Authorization settings to notify.
     * @param selected Selected model.
     */
    _notifySettings(settings: object|null, selected: object|null): void;

    /**
     * A handler called when the `securedBy` property changes.
     * It sets up the list of available auth methods
     *
     * @param secured List of AMF security definitions
     */
    _securedByChanged(secured: Array<object|null>|null): void;

    /**
     * Computes value for `isSelected` property.
     */
    _computeIsSelected(selected: any): any;

    /**
     * Computes label for step title.
     *
     * @param selected ID of selected method.
     * @returns Label for selection.
     */
    _computeSelectedLabel(selected: String|null): String|null;

    /**
     * Resets `selected` property.
     */
    _clearSelection(): void;

    /**
     * Computes value for the `authValid` property.
     * Authorization is valid when form panel reports it is valid and
     * an auth method is selected.
     *
     * @param formValid Reported state
     * @param selected Selected auth method
     * @param authRequired Value of `authRequired` property
     * @returns True if is valid and selected
     */
    _computeAuthValid(formValid: Boolean|null, selected: String|null, authRequired: Boolean|null): Boolean|null;

    /**
     * Rstores authorization settings if event is external.
     */
    _onAuthSettingsChanged(e: CustomEvent|null): void;

    /**
     * Processes incomming settings and acts if any action needed to authorize
     * the use has to be performed.
     *
     * @param settings Current settings.
     */
    _processPanelSettings(settings: object|null): void;

    /**
     * Handles the case when OAuth2 settings changed.
     *
     * @param settings Oauth2 auth settings object
     */
    _handleOauth2Settings(settings: object|null): void;

    /**
     * Handles the case when digest auth method settings changed.
     *
     * @param settings Digest auth method settings object
     * It can be either username and password (that will be passed to
     * transport method) then this function do nothing or list of Authorization
     * header parameters.
     */
    _handleDigestSettings(settings: object|null): void;
    fire(type: any, detail: any, options: any): any;

    /**
     * If selected authorization type is `oauth1` or `oauth2` it calls
     * `authorize()` function of selected panel.
     * If other method is selected it does nothing.
     *
     * @returns True if the panel received intent to authorize and
     * `false` otherwise
     */
    forceTokenAuthorization(): Boolean|null;

    /**
     * Computes value for `hasAuthMethods` property.
     *
     * @param authMethods List of current methods.
     * @returns True if at leas one methos is available to select.
     */
    _computeHasAuthMethods(authMethods: any[]|null): Boolean|null;

    /**
     * Dispatches analytics event.
     *
     * @param category Event category
     * @param action Event action
     * @param label Event label
     */
    _analyticsEvent(category: String|null, action: String|null, label: String|null): void;
  }
}

interface HTMLElementTagNameMap {
  "authorization-panel": UiElements.AuthorizationPanel;
}
