/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   bytes-counter.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />

/**
 * An element that computes number of bytes in `String`, `ArrayBuffer`, `Blob`
 * (and therefore `File`) and in supported browsers `FormData`.
 *
 * Note that Safari is excluded from FormData tests because there's some bug in
 * WebKit iplementation of the Request object and it doesn't read FormData
 * properly. Chrome had similar bug but they fixed it already. See demo page
 * to check if your browser support FormData.
 *
 * ### Example
 * ```
 * <textarea value="{{value::input}}"></textarea>
 * <bytes-counter value="[[value]]" bytes="{{bytes}}"></bytes-counter>
 * ```
 *
 * In the example above the `bytes` variable contains size of the input.
 *
 * Note that computations are synchronous and there is a delay between setting the
 * `value` property (or calling `calculate()` function) and getting a result.
 *
 * ## New in version 2
 *
 * - It does not include polyfills. Include polyfills library if you targeting
 * older browsers. Polyfill required for fetch API to support FormData.
 */
declare class BytesCounter extends Polymer.Element {

  /**
   * A value to be evaluated.
   * It can be text, blob (and therefore File), ArrayBuffer or FormData
   */
  value: string|null|undefined;

  /**
   * Calculated number of bytes from the `value`
   */
  readonly bytes: number|null|undefined;

  /**
   * Calculates number of bytes in the `value`.
   *
   * After computation it sets `bytes` property of the element.
   *
   * This function returns Promise but you may want to use synchronous versions
   * for values that contains a method to read size synchronously. Not all
   * values can be processed synchronously (FormData for example).
   *
   * @param value A value to compute
   * number of bytes from.
   * @returns Promise with number of bytes in the `value`. If
   * the `value` is not one of the supported types then the promise will
   * resolve to `undefined`;
   */
  calculate(value: String|ArrayBuffer|Blob|File|FormData|null): Promise<Number|null>;

  /**
   * Handles buffer size calculation.
   *
   * @param buffer Buffer created from the body.
   * @returns Promise resolved to number of bytes in the buffer.
   */
  _handleBuffer(buffer: ArrayBuffer|null): Promise<any>|null;

  /**
   * Calculates number of bytes in string.
   *
   * See: http://stackoverflow.com/a/23329386/1127848
   *
   * @param str A value to evaluate
   * @returns Number of bytes in the string.
   */
  stringBytes(str: String|null): Number|null;

  /**
   * Calculates number of bytes in Blob (and therefore in File).
   *
   * @param blob A value to evaluate
   * @returns Number of bytes in the blob.
   */
  blobBytes(blob: Blob|File|null): Number|null;

  /**
   * Calculates number of bytes in ArrayBuffer.
   *
   * Note, it is only possible to read number of allocated bytes by the buffer,
   * even if they are not containig any value. It is a size of the buffer at
   * the time it was created.
   *
   * @param buffer A value to evaluate
   * @returns Number of bytes in the buffer.
   */
  bufferBytes(buffer: ArrayBuffer|null): Number|null;

  /**
   * Transfer any object that is acceptable as a bidy parameter in the Request
   * object to ArrayBuffer.
   *
   * @param body An object
   * to pass to the Request object as a body property.
   * @returns Resolved promise with the ArrayBuffer. It will reject
   * if the browser doesn't support this method.
   */
  _bodyToArrayBuffer(body: Blob|BufferSource|FormData|URLSearchParams|String|null): Promise<any>|null;
}

interface HTMLElementTagNameMap {
  "bytes-counter": BytesCounter;
}
