/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   clipboard-copy.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />

declare namespace LogicElements {

  /**
   * An element that copies a text to clipboard.
   *
   * ### Example
   *
   * ```html
   * <clipboard-copy content="test"></clipboard-copy>
   * <script>
   * const elm = document.querySelectior('clipboard-copy');
   * if(elm.copy()) {
   *  console.info('Content has been copied to the clipboard');
   * } else {
   *  console.error('Content copy error. This browser is ancient!');
   * }
   * < /script>
   * ```
   */
  class ClipboardCopy extends Polymer.Element {

    /**
     * A content to be copied to the clipboard.
     * It must be set before calling the `copy` function.
     */
    content: string|null|undefined;

    /**
     * Execute content copy.
     *
     * @returns True if the content has been copied to the clipboard
     * and false if there was an error.
     */
    copy(): Boolean|null;

    /**
     * Sends the `content-copy` event.
     * If the event is canceled then the logic from this element won't be
     * executed. Useful if current platform doesn't support `execCommand('copy')`
     * and has other way to manage clipboard.
     *
     * @returns True if handler executed copy function.
     */
    _beforeCopy(): Boolean|null;

    /**
     * Sends the `content-copied` event that is not bubbling.
     */
    _notifyCopied(): any;
  }
}

interface HTMLElementTagNameMap {
  "clipboard-copy": LogicElements.ClipboardCopy;
}
