/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   date-time.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />

declare namespace UiElements {

  /**
   * An element to display formatted date and time.
   *
   * The `date` propery accepts Date object, Number as a timestamp or string
   * that will be parsed to the Date object.
   *
   * This element uses the `Intl` interface which is available in IE 11+ browsers.
   *
   * To format the date use [Intl.DateTimeFormat]
   * (https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat)
   * inteface options.
   *
   * The default value for each date-time component property is undefined,
   * but if all component properties are undefined, then year, month, and day
   * are assumed to be "numeric" (per spec).
   *
   * ### Example
   * ```html
   * <date-time date="2010-12-10T11:50:45Z" year="numeric" month="narrow" day="numeric"></date-time>
   * ```
   *
   * The element provides accessibility by using the `time` element and setting
   * the `datetime` attribute on it.
   *
   * ### Styling
   *
   * `<date-time>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--date-time` | Mixin applied to the element | `{}`
   */
  class DateTime extends Polymer.Element {

    /**
     * A string with a BCP 47 language tag, or an array of such strings.
     * For the general form and interpretation of the locales argument,
     * see the Intl page.
     * The following Unicode extension keys are allowed:
     * - nu - Numbering system. Possible values include: "arab", "arabext",
     * "bali", "beng", "deva", "fullwide", "gujr", "guru", "hanidec", "khmr",
     * "knda", "laoo", "latn", "limb", "mlym", "mong", "mymr", "orya",
     * "tamldec", "telu", "thai", "tibt".
     * - ca - Calendar. Possible values include: "buddhist", "chinese",
     * "coptic", "ethioaa", "ethiopic", "gregory", "hebrew", "indian",
     * "islamic", "islamicc", "iso8601", "japanese", "persian", "roc".
     */
    locales: string|null|undefined;

    /**
     * A date object to display
     */
    date: Date|null|undefined;

    /**
     * A string to display
     */
    display: string|null|undefined;

    /**
     * The representation of the year.
     * Possible values are "numeric", "2-digit".
     */
    year: string|null|undefined;

    /**
     * The representation of the month.
     * Possible values are "numeric", "2-digit", "narrow", "short", "long".
     */
    month: string|null|undefined;

    /**
     * The representation of the day.
     * Possible values are "numeric", "2-digit".
     */
    day: string|null|undefined;

    /**
     * The representation of the hour.
     * Possible values are "numeric", "2-digit".
     */
    hour: string|null|undefined;

    /**
     * The representation of the minute.
     * Possible values are "numeric", "2-digit".
     */
    minute: string|null|undefined;

    /**
     * The representation of the second.
     * Possible values are "numeric", "2-digit".
     */
    second: string|null|undefined;

    /**
     * The representation of the weekday.
     * Possible values are "narrow", "short", "long".
     */
    weekday: string|null|undefined;

    /**
     * The representation of the time zone name. Possible values are
     * "short", "long".
     */
    timeZoneName: string|null|undefined;

    /**
     * The representation of the era. Possible values are "narrow",
     * "short", "long".
     */
    era: string|null|undefined;

    /**
     * The time zone to use. The only value implementations must recognize
     * is "UTC"; the default is the runtime's default time zone.
     * Implementations may also recognize the time zone names of the IANA
     * time zone database, such as "Asia/Shanghai", "Asia/Kolkata",
     * "America/New_York".
     */
    timeZone: string|null|undefined;

    /**
     * Whether to use 12-hour time (as opposed to 24-hour time).
     * Possible values are `true` and `false`; the default is locale
     * dependent.
     */
    hour12: boolean|null|undefined;

    /**
     * An ISO string to attach to the `<time>` element.
     */
    readonly iso: string|null|undefined;

    /**
     * True when the element is ready.
     */
    isReady: boolean|null|undefined;
    ready(): void;

    /**
     * Handler for date property change. Computes date value.
     */
    _update(): void;
  }
}

interface HTMLElementTagNameMap {
  "date-time": UiElements.DateTime;
}
