/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   headers-list-view.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-repeat.d.ts" />
/// <reference path="../paper-dialog/paper-dialog.d.ts" />
/// <reference path="../paper-dialog-scrollable/paper-dialog-scrollable.d.ts" />
/// <reference path="../headers-parser-behavior/headers-parser-behavior.d.ts" />
/// <reference path="../paper-button/paper-button.d.ts" />

declare namespace UiElements {

  /**
   * An element that displays a list of headers.
   *
   * On double click on the list the `query-headers` event is dispatched to
   * get header definition. When information is handled by the application
   * then it dispays a dialog with header documentation.
   * Use `advanced-rest-client/arc-definitions` element to handle queries.
   *
   * The `headers` property accepts a HTTP headers string or `Headers` object
   * as defined in Fetch spec.
   *
   * ### Example
   *
   * ```html
   * <headers-list-view headers="Content-Type: application/json"></headers-list-view>
   * ```
   *
   * ### Styling
   * `<headers-list-view>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--headers-list-view` | Mixin applied to the element | `{}`
   * `--arc-font-body1` | Mixin applied to the example section in the details dialog. | `{}`
   * `--arc-font-body2` | Mixin applied to the description section in the details dialog. | `{}`
   * `--arc-font-code1` | Mixin apllied to the list | `{}`
   * `--headers-list-item-min-height` | Min height of the list item. | `20px`
   * `--arc-link` | Mixin applied to a link | `{}`
   */
  class HeadersListView extends
    ArcBehaviors.HeadersParserBehavior(
    Object) {

    /**
     * Returns a reference to main container of the list.
     */
    readonly container: HTMLElement|null;

    /**
     * A HTTP headers to display.
     */
    headers: string|null|undefined;

    /**
     * Parsed headers to the array of headers.
     */
    _headers: Array<object|null>|null;

    /**
     * Type of the header.
     * Can be either `request` or `response`.
     * It is required for displaying the help for the headers. The element
     * fires the `query-headers` event on double click which requires this
     * information to be set.
     */
    type: string|null|undefined;

    /**
     * Header title in the details dialog.
     */
    _hdTitle: string|null|undefined;

    /**
     * Header description in the details dialog.
     */
    _hdBody: string|null|undefined;

    /**
     * Header example in the details dialog.
     */
    _hdExample: string|null|undefined;

    /**
     * A regexp used to match links in headers string.
     */
    _linkR: RegExp|null;

    /**
     * The list view requires to add some markup dynamically therefore it cannot
     * use Polymer's replates and binding system.
     * Heaqders list is generated manually when headers string has changed.
     *
     * @param headers Headers to render
     */
    _headersChanged(headers: String|null): void;

    /**
     * Clears the list of headers.
     */
    _clearList(): void;

    /**
     * Creates a markup for a list item.
     *
     * @param item Headers model item.
     * @returns Markup for list item.
     */
    _getMarkup(item: object|null): String|null;

    /**
     * Double click on header line handler.
     * Will call model for data to display.
     */
    _displayHeaderInfo(e: any): void;

    /**
     * Dispatches `query-headers` custom event handled by `arc-definitions`
     * component.
     *
     * @param header Header name to query
     * @returns Event's detail object
     */
    _headersQueryEvent(header: String|null): object|null;

    /**
     * Dispatches analytics event.
     *
     * @param action Event action
     * @param label Event label
     */
    _analyticsEvent(action: String|null, label: String|null): void;

    /**
     * Finds URLs in input string and adds anchors tags.
     */
    _autoLink(input: any): any;
  }
}

interface HTMLElementTagNameMap {
  "headers-list-view": UiElements.HeadersListView;
}
