/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   json-table-array.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-repeat.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../paper-dropdown-menu/paper-dropdown-menu.d.ts" />
/// <reference path="../paper-listbox/paper-listbox.d.ts" />
/// <reference path="../paper-item/paper-item.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="json-table-mixin.d.ts" />
/// <reference path="json-table-object.d.ts" />
/// <reference path="json-table-primitive-teaser.d.ts" />

declare namespace UiElements {

  /**
   * `<json-table-array>` element displays array structure in a table.
   *
   * ### Example
   * ```
   * <json-table-array json="[...]"></json-table-array>
   * ```
   *
   * ### Styling
   * `<json-table-array>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--json-table-array` | Mixin applied to the element | `{}`
   *
   * An element that displays array structure.
   *
   * ### Example
   *
   * ```html
   * <json-table-array json="[...]"></json-table-array>
   * ```
   *
   * ### Styling
   *
   * `<json-table>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--json-table-array` | Mixin applied to the element | `{}`
   */
  class JsonTableArray extends
    JsonTableMixin(
    Object) {

    /**
     * An object to render.
     */
    json: any[]|null|undefined;

    /**
     * List of computed column names
     */
    readonly columns: any[]|null|undefined;

    /**
     * True if columns list is available.
     */
    readonly hasColumns: boolean|null|undefined;

    /**
     * data model created from the `json` attribute.
     */
    readonly display: any[]|null|undefined;

    /**
     * A label for start index in pagination (1-based)
     */
    readonly startItemLabel: number|null|undefined;

    /**
     * A label for end index in pagination (1-based)
     */
    readonly endItemLabel: number|null|undefined;

    /**
     * A label for end index in pagination (1-based)
     */
    readonly maxItemsLabel: number|null|undefined;

    /**
     * Creates a data model from the `json` property.
     *
     * TODO: This should be a deep data observer to update only the portion of the model that
     * actually has changed.
     */
    _jsonChanged(json: any): void;
    _computeDisplay(json: any, paginate: any, page: any, itemsPerPage: any): any;

    /**
     * Computes the list of column names for the table.
     * It will contain all properties keys fond in the array.
     */
    _computeColumns(json: any): any;

    /**
     * Sets the `hasColumns` property when columns array change
     */
    _columnsChanged(columns: any): void;

    /**
     * Checks if passed `item` is a primitive
     */
    _isPrimitive(item: any, column: any): any;
    _isObject(item: any, column: any): any;
    _isEnum(item: any, column: any): any;
    _isArray(item: any, column: any): any;
    _getValue(item: any, column: any): any;
    _toggleItem(e: any): void;

    /**
     * When pagination is enabled this will increase page number.
     * This will do nothing if pagination isn't enabled or there's no next page of results to
     * display.
     */
    nextPage(): any;

    /**
     * When pagination is enabled this will decrease page number.
     * This will do nothing if pagination isn't enabled or there's no previous page of results to
     * display.
     */
    previousPage(): void;

    /**
     * Computes if the previous page button for the pagination should be disabled.
     *
     * @param page Current page index
     * @returns true if there's previous page of the results
     */
    _isDisabedPrevious(page: Number|null): Boolean|null;
    _isDisabedNext(maxItemsLabel: any, endItemLabel: any): any;
    _computeValueSize(item: any, column: any): any;
  }
}

interface HTMLElementTagNameMap {
  "json-table-array": UiElements.JsonTableArray;
}
