/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   json-viewer.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../paper-spinner/paper-spinner.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="js-max-number-error.d.ts" />

/**
 * `<json-viewer>` A JSON payload viewer for the JSON response.
 *
 * This element uses a web worker to process the JSON data.
 * To simplify our lives and app build process the worker script is embeded in the
 * imported template body. It will extract worker data from it and create the
 * worker. Otherwise build process would need to incude a worker script file
 * into set path which is not very programmer friendly.
 *
 * ### Example
 *
 * ```html
 * <json-viewer json='{"json": "test"}'></json-viewer>
 * ```
 *
 * ## Custom search
 *
 * If the platform doesn't support native text search, this element implements
 * `ArcBehaviors.TextSearchBehavior` and exposes the `query` attribute.
 * Set any text to the `query` attribute and it will automatically highlight
 * occurance of the text.
 * See demo for example.
 *
 * ## Big numbers in JavaScript
 *
 * This element marks all numbers that are above `Number.MAX_SAFE_INTEGER` value
 * and locates the numeric value in source json if passed json was a string or
 * when `raw` attribute was set. In this case it will display a warning and
 * explanation about use of big numbers in JavaScript.
 * See js-max-number-error element documentation for more information.
 *
 * ## Content actions
 *
 * The element can render a actions pane above the code view. Action pane is to
 * display content actions that is relevan in context of the response displayed
 * below the icon buttons. It should be icon buttons or just buttons added to this
 * view.
 *
 * ```html
 * <json-viewer json='{"json": "test"}'>
 *  <paper-icon-button slot="content-action"
 *    title="Copy content to clipboard" icon="arc:content-copy"></paper-icon-button>
 * </json-viewer>
 * ```
 *
 * ### Styling
 *
 * `<json-viewer>` provides the following custom properties and mixins for styling:
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--json-viewer` | Mixin applied to the element | `{}`
 * `--code-type-null-value-color` | Color of the null value. | `#708`
 * `--code-type-boolean-value-color` | Color of the boolean value | `#708`
 * `--code-punctuation-value-color` | Punctuation color. | `black`
 * `--code-type-number-value-color` | Color of the numeric value | `blue`
 * `--code-type-text-value-color` | Color of the string value. | `#48A`
 * `--code-array-index-color` | Color of the array counter. | `rgb(119, 119, 119)`
 * `--code-type-link-color` | Color of link inserted into the viewer. | `#1976d2`
 * `--json-viewer-node` | Mixin applied to a "node" | `{}`
 * `--code-dimmed-punctuation-opacity` | Value of the opacity on the "dimmed" punctuation | `0.34`
 * `--code-background-color` | Background color of the code area | ``
 */
declare class JsonViewer extends Polymer.Element {

  /**
   * JSON data to parse and display.
   * It can be either JS object (already parsed string) or string value.
   * If the passed object is a string then JSON.parse function will be
   * used to parse string.
   */
  json: string|null|undefined;

  /**
   * If it's possible, set this property to the JSON string.
   * It will help to handle big numbers that are not parsed correctly by
   * the JSON.parse function. The parser will try to locate the number
   * in the source string and display it in the correct form.
   *
   * P.S.
   * Calling JSON.stringify on a JS won't help here :) Must be source
   * string.
   */
  raw: string|null|undefined;

  /**
   * True if error ocurred when parsing the `json` data.
   * An error message will be displayed.
   */
  readonly isError: boolean|null|undefined;

  /**
   * True when JSON is beeing parsed.
   */
  readonly working: boolean|null|undefined;

  /**
   * True when output should be shown (JSON has been parsed without errors)
   */
  readonly showOutput: boolean|null|undefined;

  /**
   * A reference to the web worker object.
   */
  _worker: object|null|undefined;

  /**
   * If true then it prints the execution time to the console.
   */
  debug: boolean|null|undefined;
  ready(): void;
  detached(): void;
  _removeWorker(): void;
  _clearOutput(): void;
  _writeOutput(text: any): void;

  /**
   * Called when `json` property changed. It starts parsing the data.
   */
  _changed(json: any): void;

  /**
   * Called when worker data received.
   */
  _workerData(e: any): void;

  /**
   * Called when workr error received.
   */
  _workerError(): void;

  /**
   * Compute if output should be shown.
   */
  _computeShowOutput(working: any, isError: any, json: any): any;

  /**
   * Called when the user click on the display area. It will handle view toggle and links clicks.
   */
  _handleDisplayClick(e: any): void;

  /**
   * Computes CSS class for the actions pane.
   *
   * @param showOutput The `showOutput` propety value of the element.
   * @returns CSS class names for the panel depending on state of the
   * `showOutput`property.
   */
  _computeActionsPanelClass(showOutput: Boolean|null): String|null;
}

interface HTMLElementTagNameMap {
  "json-viewer": JsonViewer;
}
