/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   multipart-payload-editor.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-repeat.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../iron-form/iron-form.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../paper-spinner/paper-spinner.d.ts" />
/// <reference path="../paper-toast/paper-toast.d.ts" />
/// <reference path="../api-form-mixin/api-form-mixin.d.ts" />
/// <reference path="../api-form-mixin/api-form-styles.d.ts" />
/// <reference path="../multipart-payload-transformer/multipart-payload-transformer.d.ts" />
/// <reference path="../iron-validatable-behavior/iron-validatable-behavior.d.ts" />
/// <reference path="../clipboard-copy/clipboard-copy.d.ts" />
/// <reference path="../prism-element/prism-highlighter.d.ts" />
/// <reference path="../prism-element/prism-theme-default.d.ts" />
/// <reference path="../prism-common/prism-http-import.d.ts" />
/// <reference path="multipart-text-form-item.d.ts" />
/// <reference path="multipart-file-form-item.d.ts" />

declare namespace ApiComponents {

  /**
   * Multipart payload editor for ARC/API Console body editor.
   *
   * On supported browsers (full support for FormData, Iterator and ArrayBuffer) it will render a
   * UI controls to generate payload message preview.
   *
   * It produces a FormData object that can be used in XHR / Fetch or transformed to ArrayBuffer to be
   * used in socket connection.
   *
   * ### Example
   * ```html
   * <multipart-payload-editor value="{{form}}"></multipart-payload-editor>
   * ```
   *
   * ## Data model from FormData
   *
   * The element creates a data model for the form view from FormData object.
   * The limitation of this solution is that the information about initial part type
   * is lost. In case when the user specified the part as a text part but also added
   * part content type it will be recognized as the file part.
   *
   * Note: this only works in browsers that support full FormData spec which rules
   * out any Microsoft product. **You have to include polyfills for the FormData.**
   *
   * ### Styling
   *
   * `<multipart-payload-editor>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--multipart-payload-editor` | Mixin applied to the element | `{}`
   * `--multipart-payload-editor-code-preview` | Mixin applied to a code preview element | `{}`
   * `--view-action-bar` | Theme mixin, applied to the content action bar | `{}`
   * `--multipart-payload-editor-action-bar` | Mixin applied to the content action bar | `{}`
   * `--body-editor-panel-button-active-background-color` | Background color of the active content action button | `#e0e0e0`
   * `--body-editor-panel-button-active` | Mixin applied to active content action button | `{}`
   * `--content-action-icon-color` | Color of the content action icon | `rgba(0, 0, 0, 0.74)`
   * `--content-action-icon-color-hover` | Color of the content action icon when hovered | `--accent-color` or `rgba(0, 0, 0, 0.74)`
   * `--inline-documentation-color` | Color of the description text from a RAML type. | `rgba(0, 0, 0, 0.87)`
   * `--from-row-action-icon-color` | Color of the icon buttons next to the input fields | `--icon-button-color` or `rgba(0, 0, 0, 0.74)`
   * `--from-row-action-icon-color-hover` | Color of the icon buttons next to the input fields when hovering | `--accent-color` or `rgba(0, 0, 0, 0.74)`,
   * `--multipart-payload-editor-file-trigger-color` | Color of the file dialog trigger button. | `--accent-color` or `#FF5722`
   *
   * This element also inherits styles from
   * `advanced-rest-client/api-form-mixin/api-form-styles.html` element to
   * style form controls.
   */
  class MultipartPayloadEditor extends
    Polymer.IronValidatableBehavior(
    ArcBehaviors.ApiFormMixin(
    Object)) {

    /**
     * Value of this form
     */
    value: FormData|null;

    /**
     * True if the browser has native FormData support.
     */
    hasFormDataSupport: boolean|null|undefined;

    /**
     * true if the message preview is opened
     */
    previewOpened: boolean|null|undefined;

    /**
     * true if the transformer is generating the message
     */
    generatingPreview: boolean|null|undefined;

    /**
     * Generated body message preview
     */
    messagePreview: string|null|undefined;
    ready(): void;

    /**
     * Appends new file form row.
     * This changes `model`.
     */
    addFile(): void;

    /**
     * Appends empty text field to the form.
     * This changes `model`.
     */
    addText(): void;

    /**
     * Handler for value change.
     * If the element is opened then it will fire change event.
     */
    _valueChanged(value: any): void;

    /**
     * Transforms FormData into the data model.
     * Sets new model data.
     *
     * @param data Form data to be restored.
     */
    _restoreFormData(data: FormData|null): any;
    _modelForParts(entries: Iterator|null, textParts: any[]|null, result: any[]|null): Promise<any[]|null>;

    /**
     * It dispatches `api-property-model-build` custom event that is handled by
     * `api-view-model-transformer` to build model item.
     * This assumes that the transformer element is already in the DOM.
     *
     * @param defs Defaults for model
     * @returns Tranformed object.
     */
    _createModelObject(defs: object|null): object|null;

    /**
     * Transforms `Blob` to string.
     *
     * @param blob A blob to read.
     * @returns Read content.
     */
    _blobToString(blob: Blob|null): Promise<String|null>;

    /**
     * Tests if current model and FormData object represent the same form data.
     *
     * @param model Model to test
     * @param value Form data with values
     * @returns True if model represents data in FormData object
     */
    _modelAndValueMatch(model: any[]|null, value: FormData|null): Boolean|null;

    /**
     * Generates a message and displays highlighted content of the message.
     */
    _previewOpenedChanged(opened: any): void;
    _computeToggleIcon(previewOpened: any): any;

    /**
     * Called when the model chage. Regenerates the FormData object.
     *
     * @param record Polymer change record
     */
    _modelChanged(record: object|null): void;

    /**
     * Generates FormData from the model.
     * For the browsers with full FormData support it will generate Form data object from form
     * element. It means that it will have only basic support.
     * For browsers with full FormData support it will contain all properties (including
     * mime types).
     *
     * @param model View data model.
     */
    createFormData(model: any[]|null): any;

    /**
     * Generates the FormData object from the model instead of the form.
     *
     * @param model The model to generate form data from.
     * @returns Form data from model or undefined if model is empty.
     */
    _getFormData(model: any[]|null): FormData|null|undefined;

    /**
     * Returns a FormData object depending if current form has any value.
     * Text items can be empty.
     *
     * @param model The model to generate form data from.
     * @returns Form data from model or undefined if model
     * is empty.
     */
    _getLegacyFormData(model: any[]|null): FormData|null|undefined;

    /**
     * Generates a preview message from the FormData object.
     *
     * @returns A promise fulfilled with the content. Content can be undefined
     * if message couldn't be generated because of lack of support.
     */
    _generatePreview(): Promise<any>|null;

    /**
     * Handler for copy to clipboard click.
     */
    _copyToClipboard(): void;
  }
}

interface HTMLElementTagNameMap {
  "multipart-payload-editor": ApiComponents.MultipartPayloadEditor;
}
