/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   multipart-payload-transformer.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />

declare namespace ApiElements {

  /**
   * An element that contains methods to transform FormData object
   * into Multipart message and ArrayBuffer
   *
   * ## Example
   *
   * ```html
   * <multipart-payload-transformer form-data="[[formData]]"></multipart-payload-transformer>
   * ```
   *
   * ## Changes in version 2.0
   * - The element does not includes polyfill by default. Use
   * `advanced-rest-client/fetch-polyfill` and `advanced-rest-client/arc-polyfills`
   * if targeting browsers that does not support Fetch API.
   */
  class MultipartPayloadTransformer extends Polymer.Element {

    /**
     * A form data object to transform.
     */
    formData: FormData|null;

    /**
     * Latest generated boundary value for the multipart forms.
     * Each call to `generateMessage()` or `generatePreview()` will
     * generate new content type and therefore boundary value.
     */
    boundary: string|null|undefined;

    /**
     * Latest generated content-type value for the multipart forms.
     * Each call to `generateMessage()` or `generatePreview()` will
     * generate new content type value.
     */
    contentType: string|null|undefined;

    /**
     * Generates an ArrayBuffer instance from the FormData object.
     *
     * @returns A resolved promise when produces ArrayBuffer.
     */
    generateMessage(): Promise<String|null>;

    /**
     * Informs other ARC elements about content type change.
     * If boundary is added to the content type string then it is reported in
     * a separate event.
     *
     * @param contentType New cintent type.
     */
    _processContentType(contentType: String|null): void;

    /**
     * Generates a preview of the multipart messgae.
     *
     * @returns A promise resolved to a string message.
     */
    generatePreview(): Promise<String|null>;

    /**
     * Convert ArrayBuffer to readable form
     *
     * @returns Converted string
     */
    arrayBufferToString(buffer: any): String|null;
  }
}

interface HTMLElementTagNameMap {
  "multipart-payload-transformer": ApiElements.MultipartPayloadTransformer;
}
