/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   oauth2-authorization.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />

/**
 * The `<outh2-authorization>` performs an OAuth2 requests to get a token for given settings.
 *
 * There are 4 basic token requests flows:
 * - Authorization Code for apps running on a web server (`authorization_code` type)
 * - Implicit for browser-based or mobile apps (`implicit` type)
 * - Password for logging in with a username and password (`password` type)
 * - Client credentials for application access (`client_credentials` type)
 *
 * This element uses them all.
 *
 * Main function is the `authorize()` function that can be also used via event system.
 * This function accepts different set of parameters depending on request type. However it will
 * not perform a validation on the settings. It will try to perform the request for given set of
 * parameters. If it fails, than it fail on the server side.
 *
 * ### Example
 *
 * ```
 * <outh2-authorization></outh2-authorization>
 * ```
 * ```
 * const settings = {
 *   type: 'implicit',
 *   clientId: 'CLIENT ID',
 *   redirectUri: 'https://example.com/auth-popup.html',
 *   authorizationUri: 'https://auth.example.com/token'
 *   scopes: ['email'],
 *   state: 'Optional string'
 * };
 * const factory = document.querySelector('outh2-authorization');
 * factory.authorize(settings)
 *
 * // or event based
 * const event = new CustomEvent('oauth2-token-requested', { 'detail': settings, bubbles: true });
 * document.dispatchEvent(event);
 * ```
 *
 * There is one difference for from using event based approach. When the token has been received
 * this will set `tokenValue` property on the target of the event.
 * The event will be canceled one it reach this element so other elements will not double the action.
 *
 * An element or app that requesting the token should observe the `oauth2-token-response` and
 * `oauth2-error` events to get back the response.
 *
 * ## Popup in authorization flow
 *
 * This element conatin a `oauth-popup.html` that can be used to exchange token / code data with
 * hosting page. Other page can be used as well. But in must `window.postMessage` back to the
 * `window.opener`. The structure of the message if the parsed query or has string to the map
 * of parameters. Furthermore it must camel case the parameters. Example script is source code
 * of the `oauth-popup.html` page.
 * Popup should be served over the SSL.
 *
 * ## The state parameter and security
 *
 * This element is intened to be used in debug applications where confidentialy is already
 * compromised because users may be asked to provide client secret parameter (depending on the flow).
 * *It should not be used in client applications** that don't serve debugging purposes.
 * Client secret should never be used on the client side.
 *
 * To have at least minimum of protection (in already compromised environment) this library generates
 * a `state` parameter as a series of alphanumeric characters and append them to the request.
 * It is expected to return the same string in the response (as defined in rfc6749). Though this
 * parameter is optional, it will reject the response if the `state` parameter is not the same as the
 * one generated before the request.
 *
 * The state parameter is generated automatically by the element if non provided in
 * settings. It is a good idea to use this property to check if the event response
 * (either token or error) are comming from your request for token. The app can
 * support different oauth clients so you can check later with the token response if
 * this is a response for the same client.
 *
 * ## Non-interactive authorization (experimental)
 *
 * For `implicit` and `code` token requests you can set `interactive` property
 * of the settings object to `false` to request the token in the background without
 * displaying any UI related to authorization to the user.
 * It can be used to request an access token after the user authorized the application.
 * Server should return the token which will be passed back to the application.
 *
 * When using `interactive = false` mode then the response event is always
 * `oauth2-token-response`, even when there was authorization error or user never
 * authorized the application. In this case the response object will not carry
 * `accessToken` property and always have `interactive` set to `false` and `code`
 * to determine cause of unsuccesful request.
 *
 * ### Example
 *
 * ```
 * const settings = {
 *   interactive: false,
 *   type: 'implicit',
 *   clientId: 'CLIENT ID',
 *   redirectUri: 'https://example.com/auth-popup.html',
 *   authorizationUri: 'https://auth.example.com/token'
 *   state: '1234'
 * };
 * const event = new CustomEvent('oauth2-token-requested', { 'detail': settings, bubbles: true });
 * document.dispatchEvent(event);
 *
 * document.body.addEventListener('oauth2-token-response', (e) => {
 *   let info = e.detail;
 *   if (info.state !== '1234') {
 *     return;
 *   }
 *   if (info.interactive === false && info.code) {
 *     // unsuccesful request
 *     return;
 *   }
 *   let token = info.accessToken;
 * });
 * ```
 *
 * ## Demo
 * See `auth-methods` > `auth-method-oauth2` element for the demo.
 *
 * ## Changes in version 2
 *
 * - event source is no longer processed. The component will not set `tokenValue`
 * on the event source.
 * - client credentials, password and custom grant types returns `Promise` with
 * token info. It also dispatches response or error events.
 * - replaced `redirectUrl` property with `redirectUri`
 * - replaced `authorizationUrl` property with `authorizationUri`
 * - replaced `accessTokenUrl` property with `accessTokenUri`
 */
declare class OAuth2Authorization extends Polymer.Element {

  /**
   * A full data returned by the authorization endpoint.
   */
  readonly tokenInfo: object|null|undefined;
  connectedCallback(): void;
  disconnectedCallback(): void;

  /**
   * Clears the state of the element.
   */
  clear(): void;

  /**
   * Clean up popup reference and closes the window if not yet closed.
   */
  _cleanupPopup(): void;

  /**
   * Handler for the `oauth2-token-requested` custom event.
   */
  _tokenRequestedHandler(e: CustomEvent|null): void;

  /**
   * Authorize the user using provided settings.
   *
   * @param settings Map of authorization settings.
   * - type {String} Authorization grant type. Can be `implicit`,
   * `authorization_code`, `client_credentials`, `password` or custom value
   * as OAuth 2.0 allows extensions to grant type.
   */
  authorize(settings: {[key: String|null]: String|null}): void;

  /**
   * Authorizes the user in the OAuth authorization endpoint.
   * By default it authorizes the user using a popup that displays
   * authorization screen. When `interactive` property is set to `false`
   * on the `settings` object then it will quietly create an iframe
   * and try to receive the token.
   *
   * @param authUrl Complete authorization url
   * @param settings Passed user settings
   */
  _authorize(authUrl: String|null, settings: object|null): void;

  /**
   * Creates and opens auth popup.
   */
  _authorizePopup(url: any): void;

  /**
   * Tries to Authorize the user in a non interactive way.
   * This method always result in a success response. When there's an error or
   * user is not logged in then the response won't contain auth token info.
   */
  _authorizeTokenNonInteractive(url: any): void;

  /**
   * Removes the frame and any event listeners attached to it.
   */
  _cleanupFrame(): void;

  /**
   * Handler for `error` event dispatched by oauth iframe.
   */
  _frameLoadErrorHandler(): void;

  /**
   * Handler for iframe `load` event.
   */
  _frameLoadHandler(): void;

  /**
   * Observer if the popup has been closed befor the data has been received.
   */
  _observePopupState(): void;

  /**
   * Function called in the interval.
   * Observer popup state and calls `_beforePopupUnloadHandler()`
   * when popup is no longer opened.
   */
  _popupObserver(): void;

  /**
   * Browser or server flow: open the initial popup.
   *
   * @param settings Settings passed to the authorize function.
   * @param type `token` or `code`
   * @returns Full URL for the endpoint.
   */
  _constructPopupUrl(settings: object|null, type: String|null): String|null;

  /**
   * Computes `scope` URL parameter from scopes array.
   *
   * @param scopes List of scopes to use with the request.
   * @returns Computed scope value.
   */
  _computeScope(scopes: Array<String|null>|null): String|null;

  /**
   * Listen for a message from the popup.
   *
   * Token will be extracted and `oauth2-token-response` will be fired. Also, if the initial
   * request came from an event, a `tokenValue` property fill be set on the event target.
   */
  _popupMessageHandler(e: any): void;

  /**
   * http://stackoverflow.com/a/10727155/1127848
   */
  randomString(len: any): any;

  /**
   * Popup is closed by this element so if data is not yet set it means that the
   * user closed the window - probably some error.
   * The UI state is reset if needed.
   */
  _beforePopupUnloadHandler(): void;

  /**
   * Exchange code for token.
   * One note here. This element is intened to use with applications that test endpoints.
   * It asks user to provide `client_secret` parameter and it is not a security concern to him.
   * However, this method **can't be used in regular web applications** because it is a
   * security risk and whole OAuth token exchange can be compromised. Secrets should never be
   * present on client side.
   *
   * @param code Returned code from the authorization endpoint.
   * @returns Promise with token information.
   */
  _exchangeCode(code: String|null): Promise<any>|null;

  /**
   * Returns a body value for the code exchange request.
   *
   * @param settings Initial settings object.
   * @param code Authorization code value returned by the authorization
   * server.
   * @returns Request body.
   */
  _getCodeEchangeBody(settings: object|null, code: String|null): String|null;

  /**
   * Requests for token from the authorization server for `code`, `password`,
   * `client_credentials` and custom grant types.
   *
   * @param url Base URI of the endpoint. Custom properties will be
   * applied to the final URL.
   * @param body Generated body for given type. Custom properties will
   * be applied to the final body.
   * @param settings Settings object passed to the `authorize()` function
   * @returns Promise resolved to the response string.
   */
  _requestToken(url: String|null, body: String|null, settings: object|null): Promise<any>|null;

  /**
   * Handler for the code request load event.
   * Processes the response and either rejects the promise with an error
   * or resolves it to token info object.
   *
   * @param e XHR load event.
   * @param resolve Resolve function
   * @param reject Reject function
   */
  _processTokenResponseHandler(e: Event|null, resolve: Function|null, reject: Function|null): void;

  /**
   * Handler for the code request error event.
   * Rejects the promise with error description.
   *
   * @param e XHR error event
   * @param reject Promise's reject function.
   */
  _processTokenResponseErrorHandler(e: Event|null, reject: Function|null): void;

  /**
   * Processes token request body and produces map of values.
   *
   * @param body Body received in the response.
   * @param contentType Response content type.
   * @returns Response as an object.
   */
  _processCodeResponse(body: String|null, contentType: String|null): object|null;

  /**
   * Processes token info object when it's ready.
   * Sets `tokenInfo` property, notifies listeners about the response
   * and cleans up.
   *
   * @param tokenInfo Token info returned from the server.
   * @returns The same tokenInfo, used for Promise return value.
   */
  _handleTokenInfo(tokenInfo: object|null): object|null;

  /**
   * Handler fore an error that happened during code exchange.
   */
  _handleTokenCodeError(e: Error|null): void;

  /**
   * Replaces `-` or `_` with camel case.
   *
   * @param name The string to process
   * @returns Camel cased string or `undefined` if not
   * transformed.
   */
  _camel(name: String|null): String|null|undefined;

  /**
   * Requests a token for `password` request type.
   *
   * @param settings The same settings as passed to `authorize()`
   * function.
   * @returns Promise resolved to token info.
   */
  authorizePassword(settings: object|null): Promise<any>|null;

  /**
   * Generates a payload message for password authorization.
   *
   * @param settings Settings object passed to the `authorize()`
   * function
   * @returns Message body as defined in OAuth2 spec.
   */
  _getPasswordBody(settings: object|null): String|null;

  /**
   * Requests a token for `client_credentials` request type.
   *
   * @param settings The same settings as passed to `authorize()`
   * function.
   * @returns Promise resolved to a token info object.
   */
  authorizeClientCredentials(settings: object|null): Promise<any>|null;

  /**
   * Generates a payload message for client credentials.
   *
   * @param settings Settings object passed to the `authorize()`
   * function
   * @returns Message body as defined in OAuth2 spec.
   */
  _getClientCredentialsBody(settings: object|null): String|null;

  /**
   * Performs authorization on custom grant type.
   * This extension is described in OAuth 2.0 spec.
   *
   * @param settings Settings object as for `authorize()` function.
   * @returns Promise resolved to a token info object.
   */
  authorizeCustomGrant(settings: object|null): Promise<any>|null;

  /**
   * Creates a body for custom gran type.
   * It does not assume any parameter to be required.
   * It applies all known OAuth 2.0 parameters and then custom parameters
   *
   * @returns Request body.
   */
  _getCustomGrantBody(settings: object|null): String|null;

  /**
   * Applies custom properties defined in the OAuth settings object to the URL.
   *
   * @param url Generated URL for an endpoint.
   * @param data `customData.[type]` property from the settings object.
   * The type is either `auth` or `token`.
   */
  _applyCustomSettingsQuery(url: String|null, data: object|null): String|null;

  /**
   * Applies custom headers from the settings object
   *
   * @param xhr Instance of the request object.
   * @param data Value of settings' `customData` property
   */
  _applyCustomSettingsHeaders(xhr: XMLHttpRequest|null, data: object|null): void;

  /**
   * Applies custom body properties from the settings to the body value.
   *
   * @param body Already computed body for OAuth request. Custom
   * properties are appended at the end of OAuth string.
   * @param data Value of settings' `customData` property
   * @returns Request body
   */
  _applyCustomSettingsBody(body: String|null, data: object|null): String|null;

  /**
   * Dispatches an error event that propagates through the DOM.
   *
   * @param detail The detail object.
   */
  _dispatchError(detail: object|null): void;

  /**
   * Dispatches an error event that propagates through the DOM.
   *
   * @param detail The detail object.
   */
  _dispatchResponse(detail: object|null): void;
}

interface HTMLElementTagNameMap {
  "oauth2-authorization": OAuth2Authorization;
}
