/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   paper-autocomplete.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />
/// <reference path="../paper-item/paper-item.d.ts" />
/// <reference path="../paper-ripple/paper-ripple.d.ts" />
/// <reference path="../paper-styles/shadow.d.ts" />
/// <reference path="../iron-overlay-behavior/iron-overlay-behavior.d.ts" />
/// <reference path="../iron-selector/iron-selector.d.ts" />
/// <reference path="../iron-a11y-keys/iron-a11y-keys.d.ts" />
/// <reference path="../iron-scroll-target-behavior/iron-scroll-target-behavior.d.ts" />
/// <reference path="../paper-progress/paper-progress.d.ts" />

declare namespace UiElements {

  /**
   * # `<paper-autocomplete>`
   *
   * Use `paper-autocomplete` to add autocomplete functionality to the input elements.
   * It also works wilt polymer inputs.
   *
   * The element works with static list of suggestions or with dynamic (asynchronous)
   * operation that require calling te backend or local datastore.
   * In second case you should set `loader` property which will display a loader animation
   * while results are loaded.
   *
   * You must associate suggestions with the input field. This can be done by passing
   * an element reference to the `target` property.
   *
   * ## Example:
   *
   * ### Static suggestions
   *
   * ```html
   * <paper-input label="Enter fruit name" id="fruits"></paper-input>
   * <paper-autocomplete
   *  id="fruitsSuggestions"
   *  target="[[fruits]]"
   *  on-selected="_fruitSelected"></paper-input-autocomplete>
   *
   * <script>
   * document.querySelector('#fruitsSuggestions').source = ['Apple', 'Orange', 'Bananas'];
   * < /script>
   * ```
   *
   * ### Dynamic suggestions
   *
   * ```html
   * <paper-input-container>
   *  <label>Enter friut name</label>
   *  <input is="iron-input" type="text" value="{{async::input}}" id="asyncField" />
   * </paper-input-container>
   * <paper-autocomplete loader id="fruitAsync" on-query="_asyncSuggestions"></paper-input-autocomplete>
   *
   * <script>
   *  document.querySelector('#fruitAsync').target = document.querySelector('#asyncField');
   *  document.querySelector('#fruitAsync').addEventListener('query', (e) => {
   *    const query = e.detail.value;
   *    asyncQuery(query, (suggestions) => {
   *      document.querySelector('#fruitAsync').source = suggestions;
   *    });
   *  });
   * < /script>
   * ```
   *
   * ## Displaying the suggestions
   *
   * Suggestions array can be either an array of strings or objects.
   * For strings, displayed in the list and inserted to the input field value is the same item.
   *
   * You can set different list item display value and value inserted into the field when the array contains
   * onject. Each object must contain `value` and `display` properties where `value` property
   * will be inserted into the text field and `display` will be used to display description inside the list.
   *
   * ## Query event
   *
   * The `query` event is fired when the user query change in the way so the element is
   * not able to display suggestions properly.
   * This means if the user add a letter to previously entered value the query event will not
   * fire since it already have list of suggestion that should be used to filter suggestions from.
   * And again when the user will delete a letter the element will still have list of
   * source suggestions to filter suggestions from.
   * However, if the user change the query entirely it will fire `query` event
   * and the app will expect to `source` to change. Setting source is not mandatory.
   *
   * ## Preventing from changing the input value
   *
   * To prevent the element to update the value of the target input, listent for
   * `selected` event and cancel it by calling `event.preventDefault()` function.
   *
   * ## Styling
   *
   * Suggestions are positioned absolutely! You must include relative positioned parent to contain the suggestion
   * display in the same area.
   * Use CSS properties to position the display in the left bottom corner of the input field.
   *
   * `<paper-autocomplete>` provides the following custom properties and mixins
   * for styling:
   *
   * | Custom property | Description | Default |
   * ----------------|-------------|----------
   * | `--paper-autocomplete` | Mixin applied to the display | `{}` |
   * | `--paper-autocomplete-background-color` | Background color of suggestions | `{}` |
   */
  class PaperAutocomplete extends
    Polymer.IronOverlayBehavior(
    Polymer.IronScrollTargetBehavior(
    Object)) {

    /**
     * List of suggestions to display.
     * If the array items are strings they will be used for display a suggestions and
     * to insert a value.
     * If the list is an object the each object must contain `value` and `display`
     * properties.
     * The `display` property will be used in the suggestions list and the
     * `value` property will be used to insert the value to the referenced text field.
     */
    source: Array<object|null>|Array<String|null>|null;

    /**
     * `value` Selected object from the suggestions
     */
    value: object|null|undefined;

    /**
     * List of suggestion that are displayed.
     */
    readonly suggestions: any[]|null|undefined;

    /**
     * A target input field to observe.
     */
    target: HTMLElement|null;

    /**
     * Currently selected item on a suggestions list.
     */
    selectedItem: Number|null;

    /**
     * Scroll target element
     */
    scrollTarget: HTMLElement|null|undefined;

    /**
     * Sizing target element.
     */
    sizingTarget: HTMLElement|null|undefined;

    /**
     * True when user query changed and waiting for `source` property update
     */
    readonly loading: boolean|null|undefined;

    /**
     * Set this to true if you use async operation in response for query event.
     * This will display a loader when querying for more suggestions.
     * Do not use it it you do not handle suggestions asynchronously.
     */
    loader: boolean|null|undefined;
    readonly _showLoader: boolean|null|undefined;
    isAttached: boolean|null|undefined;

    /**
     * If true it will opend suggestions on input field focus.
     */
    openOnFocus: boolean|null|undefined;

    /**
     * listeners.
     */
    _oldTarget: HTMLElement|null|undefined;

    /**
     * An event target for key down event.
     */
    _keyTarget: HTMLElement|null|undefined;
    connectedCallback(): void;
    disconnectedCallback(): void;
    ready(): void;

    /**
     * Handler for target property change.
     *
     * @param target Target input element
     * @param isAttached True if this element is attached to the DOM.
     */
    _targetChanged(target: HTMLElement|null, isAttached: Boolean|null): void;

    /**
     * Handler for target input change.
     */
    _valueChanged(): void;

    /**
     * Disaptches query event and returns it.
     *
     * @param value Current input value.
     */
    _disaptchQuery(value: String|null): CustomEvent|null;

    /**
     * Filter `source` array for current value.
     */
    _filterSuggestions(): void;

    /**
     * Compute suggestion display value
     */
    _suggestionDisplay(item: any): any;

    /**
     * Highlight previous suggestion
     */
    selectPrevious(): void;

    /**
     * Highlight next suggestion
     */
    selectNext(): void;

    /**
     * Accepts currently selected suggestion and enters it into a text field.
     */
    acceptSelection(): void;

    /**
     * Dispatches `selected` event with new value.
     *
     * @param value Selected value.
     */
    _inform(value: String|null): void;

    /**
     * Ensure that the selected item is visible in the scroller.
     * When there is more elements to show than space available (height)
     * then some elements will be hidden. When the user use arrows to navigate
     * the selection may get out from the screen. This function ensures that
     * currently selected element is visible.
     *
     * @param bottom If trully it will ensure that the element is
     * visible at the bottom of the container. On the top otherwise.
     */
    ensureItemVisible(bottom: Boolean|null): void;

    /**
     * Computes value for `_showLoader` property.
     *
     * @returns True if the loader should be rendered.
     */
    _computeShowLoader(loader: Boolean|null, loading: Boolean|null): Boolean|null;

    /**
     * Handler for target element focus event.
     * Opens the autocomplete if `openOnFocus` is set.
     */
    _targetFocus(): void;

    /**
     * Prohibits click event propagation when the overlay is opened so
     * the overlay manager won't close it immidietly after focusing (with click
     * event included) in the target field.
     */
    _targetClick(e: ClickEvent|null): void;

    /**
     * Selects a first available item after filtering results and missing
     * selection.
     */
    _ensureSelection(): void;
  }
}

interface HTMLElementTagNameMap {
  "paper-autocomplete": UiElements.PaperAutocomplete;
}
