/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   raw-payload-editor.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../paper-button/paper-button.d.ts" />
/// <reference path="../iron-resizable-behavior/iron-resizable-behavior.d.ts" />
/// <reference path="../paper-toast/paper-toast.d.ts" />
/// <reference path="../events-target-behavior/events-target-behavior.d.ts" />
/// <reference path="../payload-parser-behavior/payload-parser-behavior.d.ts" />
/// <reference path="../code-mirror/code-mirror.d.ts" />
/// <reference path="../code-mirror-linter/code-mirror-linter-json.d.ts" />

declare namespace UiElements {

  /**
   * A raw payload input editor based on CodeMirror.
   *
   * The element additionally shows Encode / Decode buttons if current content type value contains
   * "x-www-form-urlencoded".
   *
   * The element listens for `content-type-changed` custom event and updates the `contentType` property
   * automatically. This event is commonly used in ARC elements.
   *
   * ### Example
   * ```
   * <raw-payload-editor content-type="application/json"></raw-payload-editor>
   * ```
   *
   * ### Styling
   * `<raw-payload-editor>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--raw-payload-editor` | Mixin applied to the element | `{}`
   * `--raw-payload-editor-encode-buttons` | Mixin applied to encode / decode buttons container | `{}`
   */
  class RawPayloadEditor extends
    Polymer.IronResizableBehavior(
    ArcBehaviors.EventsTargetBehavior(
    ArcBehaviors.PayloadParserBehavior(
    Polymer.Element))) {

    /**
     * Raw payload value
     */
    value: string|null|undefined;

    /**
     * Content-Type header value. Determines current code mirror mode.
     */
    contentType: string|null|undefined;

    /**
     * Computed value, true if `contentType` contains `x-www-form-urlencoded`
     */
    readonly encodeEnabled: boolean|null|undefined;

    /**
     * Computed value, true if `contentType` contains `/json`
     */
    readonly isJson: boolean|null|undefined;
    _cmGutters: any[]|null|undefined;
    _lintObject: object|null|undefined;
    _customStylesList: any[]|null|undefined;
    _attachListeners(node: any): void;
    _detachListeners(node: any): void;
    ready(): void;

    /**
     * Forces render code-mirror content.
     * Should be used to when the element becomes visible after being hidden.
     */
    refresh(): void;

    /**
     * Changes CodeMirror mode when the content type value is updated.
     */
    _onContentTypeChanged(ct: any): void;

    /**
     * Computes `encodeEnabled` based on content type.
     */
    _computeEncodeEnabled(ct: any): any;
    _computeIsJson(ct: any): any;

    /**
     * Handler for the `content-type-changed` event. Sets the `contentType` property.
     */
    _contentTypeHandler(e: CustomEvent|null): void;

    /**
     * Handler for value change.
     * If the element is opened then it will fire change event.
     */
    _valueChanged(value: any): void;

    /**
     * Called when the editor fires change event
     */
    _editorValueChanged(e: CustomEvent|null): void;

    /**
     * Formats JSON data on paste.
     * It only formats the input if no selection is applied, whole value
     * is selcted or input is empty.
     */
    _onPaste(e: any): void;

    /**
     * Tests if text formatting on paste is allowed
     *
     * @param inputSize Size of current value
     * @returns True to disallow altering the value on paste.
     */
    _cancelPaste(inputSize: Number|null): Boolean|null;
    _setupLinter(ct: any): void;

    /**
     * Formats current value as it is a JSON object.
     */
    formatValue(): void;

    /**
     * Minifies JSON value by removing whitespaces.
     */
    minifyValue(): void;
    _resizeHandler(): void;

    /**
     * URL encodes payload value and resets the same value property.
     * This should be used only for payloads with x-www-form-urlencoded content-type.
     */
    encodeValue(): void;

    /**
     * URL decodes payload value and resets the same value property.
     * This should be used only for payloads with x-www-form-urlencoded content-type.
     */
    decodeValue(): void;
  }
}

interface HTMLElementTagNameMap {
  "raw-payload-editor": UiElements.RawPayloadEditor;
}
