/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   request-timings.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../paper-progress/paper-progress.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../date-time/date-time.d.ts" />

declare namespace UiElements {

  /**
   * An element to display request timings information as a timeline according to the HAR 1.2 spec.
   *
   * The `timings` property should contain timings object as defined in [HAR 1.2 spec](https://dvcs.w3.org/hg/webperf/raw-file/tip/specs/HAR/Overview.html#sec-object-types-timings).
   *
   * The timings object is consisted of:
   * - **blocked** [number, optional] - Time spent in a queue waiting for a network connection. Use -1 if the timing does not apply to the current request.
   * - **dns** [number, optional] - DNS resolution time. The time required to resolve a host name. Use -1 if the timing does not apply to the current request.
   * - **connect** [number, optional] - Time required to create TCP connection. Use -1 if the timing does not apply to the current request.
   * - **send** [number] - Time required to send HTTP request to the server.
   * - **wait** [number] - Waiting for a response from the server.
   * - **receive** [number] - Time required to read entire response from the server (or cache).
   * - **ssl** [number, optional] - Time required for SSL/TLS negotiation. If this field is defined then the time is also included in the connect field (to ensure backward compatibility with HAR 1.1). Use -1 if the timing does not apply to the current request.
   *
   * Additionally the object can contain the `startTime` property that indicates
   * the request start time. If can be Date object, timestamp or formatted string
   * representing a date.
   *
   * The timeline for `connect`, `send`, `wait` and `receive` are always shown.
   * `blocked`, `dns` and `ssl` are visible only if values for it was set and value
   * was > 0.
   *
   * ### Example
   *
   * ```html
   * <request-timings timings="[[requestTimings]]"></request-timings>
   * ```
   *
   * ### Styling
   * `<request-timings>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--request-timings` | Mixin applied to the element | `{}`
   * `--select-text` | Mixin applied to the text elements that should have text selection enabled (in some platforms text selection is disabled by default) | `{}`
   * `--form-label` | Mixin applied to labels elements | `{}`
   * `--request-timings-progress-height` | The height of the progress bar | `12px`
   * `--request-timings-progress-background` | Background color of the progress bar. | `#F5F5F5`
   * `--request-timings-progress-color` | Color of the progress bar. | `#4a4`
   * `--request-timings-label-width` | Width of the label | `160px`
   * `--request-timings-value-width` | Width of the value column | `120px`
   */
  class RequestTimings extends Polymer.Element {

    /**
     * A timings object as described in HAR 1.2 spec.
     */
    timings: object|null|undefined;

    /**
     * Request stat time. It can be either Date object,
     * timestamp or a string representing the date.
     *
     * If the `timings` property contains the `startTime` property it
     * will be overwritten.
     */
    startTime: string|null|undefined;

    /**
     * Computed value. Calculated full time of the request and response
     */
    readonly fullTime: number|null|undefined;

    /**
     * Computed value. Time required to establish the connection
     */
    readonly connect: number|null|undefined;

    /**
     * Computed value. Time of receiving data from the remote machine.
     */
    readonly receive: number|null|undefined;

    /**
     * Computed value. Time to send data to the remote machine.
     */
    readonly send: number|null|undefined;

    /**
     * Computed value. Wait time for the first byte to arrive.
     */
    readonly wait: number|null|undefined;

    /**
     * Computed value. Time spent in a queue waiting for a network connection
     */
    readonly blocked: number|null|undefined;

    /**
     * Computed value. DNS resolution time.
     */
    readonly dns: number|null|undefined;

    /**
     * Computed value. Time required for SSL/TLS negotiation.
     */
    readonly ssl: number|null|undefined;
    ready(): void;
    detached(): void;

    /**
     * Resets the timeline.
     */
    reset(): void;

    /**
     * Updates the view after `timings` change.
     */
    _update(): void;

    /**
     * Round numeric value to presision defined in the `power` argument.
     *
     * @param value The value to round
     * @param power The precision. 0 for integers. Default 4.
     * @returns Rounded value.
     */
    _round(value: Number|null, power: Number|null): Number|null;

    /**
     * Computes sum of the arguments.
     */
    _computeSum(): any;
    _hasValue(num: any): any;
  }
}

interface HTMLElementTagNameMap {
  "request-timings": UiElements.RequestTimings;
}
