/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   response-body-view.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../iron-pages/iron-pages.d.ts" />
/// <reference path="../response-raw-viewer/response-raw-viewer.d.ts" />
/// <reference path="../xml-viewer/xml-viewer.d.ts" />
/// <reference path="../json-viewer/json-viewer.d.ts" />
/// <reference path="../response-highlighter/response-highlighter.d.ts" />
/// <reference path="../clipboard-copy/clipboard-copy.d.ts" />
/// <reference path="../paper-dialog/paper-dialog.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../paper-toast/paper-toast.d.ts" />
/// <reference path="../json-table/json-table.d.ts" />

declare namespace UiElements {

  /**
   * An element to display a HTTP response body.
   *
   * The element will try to select best view for given `contentType`. It will
   * choose the JSON viewer for JSON response and XML viewer for XML responses.
   * Otherise it will display a syntax hagligter.
   *
   * Note that the `contentType` property **must** be set in order to display any
   * view.
   *
   * ### Save content to file
   *
   * The element uses the web way of file saving. However, it sends the
   * `export-data` custom event first to check if hosting application implements
   * other save functionality. See event description for more information.
   *
   * ## Changes in version 2
   *
   * - Text search library is no longer included
   *
   * ### Styling
   *
   * `<response-body-view>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--response-body-view` | Mixin applied to the element | `{}`
   * `--response-body-view-dialog-title` | Mixin applied to dialog title | `{}`
   * `--response-body-view-preview-close` | Mixin applied to the response preview close button | `{}`
   * `--response-body-view-content-actions` | Mixin applied to the content actions container | `{}`
   * `--response-body-view-dialog-buttons` | Mixin applied to the dialog buttons container | `{}`
   * `--response-body-view-dialog-close` | Mixin applied to dialog's close button | `{}`
   * `--response-body-view-dialog-close-hover` | Mixin for dialog's close button when hovering | `{}`
   * `--response-body-view-dialog-download` | Mixin applies to dialog's download button | `{}`
   * `--response-body-view-dialog-download-hover` | Mixin for dialog's download when hovering | `{}`
   */
  class ResponseBodyView extends Polymer.Element {

    /**
     * Raw response as a response text.
     */
    responseText: string|null|undefined;

    /**
     * A variable to be set after the `responseText` change
     */
    _raw: string|null|undefined;

    /**
     * The response content type.
     */
    contentType: string|null|undefined;

    /**
     * If true then the conent preview will be visible instead of the code view
     */
    contentPreview: boolean|null|undefined;

    /**
     * Computed value, true if the parsed view can be displayed.
     * If false then the syntax highligter will be removed from the DOM
     * so it will not try to do the parsing job if it is not necessary.
     */
    readonly isParsed: boolean|null|undefined;

    /**
     * Computed value, true if the JSON view can be displayed.
     * If false then the syntax highligter will be removed from the DOM
     * so it will not try to do the parsing job if it is not necessary.
     */
    readonly isJson: boolean|null|undefined;

    /**
     * Computed value, true if the XML view can be displayed.
     * If false then the syntax highligter will be removed from the DOM
     */
    readonly isXml: boolean|null|undefined;

    /**
     * Selected view.
     */
    activeView: number|null|undefined;

    /**
     * When saving a file this will be the download URL created by the
     * `URL.createObjectURL` function.
     */
    readonly downloadFileUrl: string|null|undefined;

    /**
     * Autogenerated file name for the download file.
     */
    readonly downloadFileName: string|null|undefined;

    /**
     * Is true then the text in "raw" preview will be wrapped.
     */
    rawTextWrap: boolean|null|undefined;

    /**
     * If set it opens the "raw" view.
     */
    rawView: boolean|null|undefined;

    /**
     * If set it opens the JSON table view.
     */
    jsonTableView: boolean|null|undefined;

    /**
     * Computed value, true if `contentType` and `_raw` are set
     */
    readonly hasData: boolean|null|undefined;
    prismTimeout: boolean|null|undefined;
    connectedCallback(): void;
    disconnectedCallback(): void;

    /**
     * Handler for `prismTimeout` property change.
     * Displays "raw" view instead of syntax highlighting.
     */
    _onPrismHighlightTimeout(state: Boolean|null): void;

    /**
     * Set's `_raw` property that it propagated to current viewer.
     * The operation is async for performance reasons.
     */
    _responseTextChanged(payload: String|null): void;

    /**
     * Computes value for `hasData` property
     */
    _computeHasData(contentType: any, _raw: any): any;

    /**
     * Updates `activeView` property based on `contentType` value.
     *
     * @param contentType Current content type of the response
     */
    _contentTypeChanged(contentType: String|null): void;

    /**
     * When response's content type is JSON the view renders the
     * JSON table element. This function reads current state for the table
     * (if it is turned on) and handles view change if needed.
     */
    _ensureJsonTable(): void;

    /**
     * Handler for `this.contentPreview` change.
     */
    _contentPreviewChanged(val: any): void;

    /**
     * The component may work in Electron app where Buffer can be returned from
     * the transport library. This ensures that string is always returned.
     *
     * @returns String value of `_raw` property
     */
    _getRawContent(): String|null;

    /**
     * Opens response preview in new layer
     */
    _openResponsePreview(): void;

    /**
     * Closes response preview
     */
    _closeResponsePreview(): void;

    /**
     * Sets height for the preview iframe
     */
    _resizePreviewWindow(height: Number|null): void;

    /**
     * Coppies current response text value to clipboard.
     */
    _copyToClipboard(e: CustomEvent|null): void;
    _resetCopyButtonState(button: any): void;

    /**
     * Fires the `export-data` custom event. If the event is not canceled
     * then it will use default web implementation for file saving.
     */
    _saveFile(): void;

    /**
     * Creates a file object form current response text and opens a dialog
     * with the link to a file.
     */
    saveToFile(): void;

    /**
     * Handler for download link click to prevent default and close the dialog.
     */
    _downloadIconTap(): void;

    /**
     * Handler for file download dialog close.
     */
    _downloadDialogClose(): void;

    /**
     * Toggles "view source" or raw message view.
     */
    _toggleViewSource(opened: Boolean|null): void;

    /**
     * Handler for the `jsonTableView` property change.
     */
    _jsonTableViewChanged(state: any): void;

    /**
     * Updates the value of the `jsonTableView` property when the
     * corresponding localStorage property change.
     */
    _onStorageChanged(e: StorageEvent|null): void;

    /**
     * Reads the local value (always a string) as a boolean value.
     *
     * @param value The value read from the local storage.
     * @returns Boolean value read from the value.
     */
    _localStorageValueToBoolean(value: String|null): Boolean|null;
    _onJsonTableStateChanged(e: any): void;
    closePreview(): void;
    _computeRenderWithRaw(activeView: any): any;
    _computeRenderShowRaw(activeView: any): any;
    _computeRenderPreviewResponse(activeView: any): any;
    _computeRenderToggleTable(activeView: any): any;

    /**
     * Computes boolean value whether to render the JSON table element.
     */
    _computeRenderJsonTable(isJson: Boolean|null, jsonTableView: Boolean|null): Boolean|null;
  }
}

interface HTMLElementTagNameMap {
  "response-body-view": UiElements.ResponseBodyView;
}
