/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   response-highlighter.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../prism-highlight/prism-highlight.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />

declare namespace UiElements {

  /**
   * An element that parses the HTTP response and displays highlighted result.
   *
   * It splits the response by line (by default it's 500) and if the response has
   * more than that it shows only first 500 lines and the user can request to
   * display the rest or next 500 lines. This is to make the element work faster.
   * If the response is very long it may take some time to parse and tokenize it.
   * Control number of lines by setting the maxRead attribute.
   *
   * ### Example
   *
   * ```html
   * <response-highlighter></response-highlighter>
   * ```
   * ```javascript
   * const display = document.querySelector('response-highlighter');
   * display.responseText = someJsonResponse;
   * display.contentType = 'application/json';
   * ```
   *
   * ## Content actions
   *
   * Child elements added to light DOM with slot name `content-action` are rendered
   * in actions container. It is a way to render additional actions related to
   * the response text.
   *
   * ### Example
   *
   * ```html
   * <response-highlighter>
   *  <paper-icon-button title="Additional action" icon="arc:cached"></paper-icon-button>
   *  <paper-icon-button title="Clear the code" icon="arc:clear"></paper-icon-button>
   * </response-highlighter>
   * ```
   *
   * See demo for more information.
   *
   * ## Changes in version 2
   *
   * - Custom search has been removed from the element.
   *
   * ### Styling
   *
   * `<response-highlighter>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--response-highlighter` | Mixin applied to the element | `{}`
   * `--response-highlighter-action-bar` | Mixin applied to the action bar above the highlighted code | `{}`
   * `--no-info-message` | Mixin applied to the "nothing to display" message (theme variable) | `{}`
   *
   * See prism-highlight element for more styling options.
   */
  class ResponseHighlighter extends Polymer.Element {

    /**
     * The response text to display.
     */
    responseText: string|null|undefined;

    /**
     * Computed value, true if the responseText has text.
     */
    readonly hasResponse: boolean|null|undefined;

    /**
     * Response content type.
     * It will be used to determine which syntaxt highlighter to use.
     */
    contentType: string|null|undefined;

    /**
     * Attribute binded to the prism-highlight element.
     */
    maxRead: number|null|undefined;

    /**
     * The lang property for the Prism.
     */
    readonly lang: string|null|undefined;

    /**
     * Set to `true` when `prism-highlight` dispatches `prism-highlight-timeout`
     * event. It informs application that there was a timeout.
     * It is cleared when `lang` or `hasResponse` changes
     */
    readonly isTimeout: boolean|null|undefined;

    /**
     * Computes if the element has the response data.
     */
    _computeHasResponse(responseText: any): any;

    /**
     * Computes CSS class for the content actions pane.
     */
    _computeActionsPanelClass(hasResponse: any): any;

    /**
     * Computes a `lang` property for the Prism from the response content-type
     */
    _computeLang(contentType: any): any;

    /**
     * Handler for `prism-highlight-timeout` custom event.
     * Sets `isTimeout` property to `true`.
     */
    _prismTimeout(): void;

    /**
     * Clears `isTimeout` flag if set to true.
     */
    _clearTimeout(): void;
  }
}

interface HTMLElementTagNameMap {
  "response-highlighter": UiElements.ResponseHighlighter;
}
