/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   url-parser.html
 *   url-parser.js
 */

/**
 * Implements logic for parsing URL string.
 */
declare class UrlValueParser {
  opts: object|null;

  /**
   * Returns protocol value in format `protocol` + ':'
   *
   * @param value URL to parse.
   * @returns Value of the protocol or undefined if
   * value not set
   */
  _parseProtocol(value: String|null): String|null|undefined;

  /**
   * Gets a host value from the url.
   * It reads the whole authority value of given `value`. It doesn't parses it
   * to host, port and
   * credentials parts. For URL panel it's enough.
   *
   * @param value The URL to parse
   * @returns Value of the host or undefined.
   */
  _parseHost(value: String|null): String|null|undefined;

  /**
   * Parses the path part of the URL.
   *
   * @param value URL value
   * @returns Path part of the URL
   */
  _parsePath(value: String|null): String|null|undefined;

  /**
   * Returns query parameters string (without the '?' sign) as a whole.
   *
   * @param value The URL to parse
   * @returns Value of the search string or undefined.
   */
  _parseSearch(value: String|null): String|null|undefined;

  /**
   * Reads a value of the anchor (or hash) parameter without the `#` sign.
   *
   * @param value The URL to parse
   * @returns Value of the anchor (hash) or undefined.
   */
  _parseAnchor(value: String|null): String|null|undefined;

  /**
   * Returns an array of items where each item is an array where first
   * item is param name and second is it's value. Both always strings.
   *
   * @param search Parsed search parameter
   * @returns Always returns an array.
   */
  _parseSearchParams(search: String|null): any[]|null;
}

/**
 * A class to parse URL string.
 */
declare class UrlParser {

  /**
   * Returns protocol value in format `protocol` + ':'
   */
  protocol: String|null|undefined;

  /**
   * It reads the authority part of the URL value. It doesn't parses it
   * to host, port and credentials parts.
   */
  host: String|null|undefined;

  /**
   * Returns path part of the URL.
   */
  path: String|null|undefined;

  /**
   * Returns anchor part of the URL.
   */
  anchor: String|null|undefined;

  /**
   * Returns search part of the URL.
   */
  search: String|null|undefined;

  /**
   * The URL value. It is the same as calling `toStirng()`.
   */
  value: String|null;

  /**
   * Returns an array of search params.
   */
  searchParams: Array<any[]|null>|null;

  /**
   * Returns the URL for current settings.
   *
   * @returns URL value.
   */
  toString(): String|null;
}
