/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   xml-viewer.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../paper-spinner/paper-spinner.d.ts" />
/// <reference path="../iron-icon/iron-icon.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../error-message/error-message.d.ts" />

declare namespace UiElements {

  /**
   * `<xml-viewer>` An XML payload viewer for the XML response
   *
   * ### Example
   * ```
   * <xml-viewer xml="&lt;tag&gt;&lt;/tag&gt;"></xml-viewer>
   * ```
   *
   * **Note** This element uses web workers with dependencies. It expect to find
   * workers files in current directory in the `workers` folder.
   * Your build process has to ensure that this files are avaiable.
   *
   * ## Content actions
   *
   * You can add action items in the actions bar by adding elements as a children
   * of this element with slot set to `content-action`.
   *
   * ### Example
   * ```
   * <xml-viewer>
   *  <paper-icon-button title="Additional action" icon="arc:cached" slot="content-action"></paper-icon-button>
   *  <paper-icon-button title="Clear the code" icon="arc:clear" slot="content-action"></paper-icon-button>
   * </xml-viewer>
   * ```
   *
   * ## Changes in version 2
   *
   * - The element doesn't mixin text search behavior. This service is deprecated.
   * - It uses worker files instead of compiled worker data in elements body
   *
   * ### Styling
   *
   * `<xml-viewer>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--xml-viewer` | Mixin applied to the element | `{}`
   * `--xml-viewer-comment-color` | Color of the comment section. | `#236E25`
   * `--xml-viewer-punctuation-color` | Color of the punctuation signs | `black`
   * `--xml-viewer-tag-name-color` | Color of the XML tag name | `#881280`
   * `--xml-viewer-attribute-name-color` | Color of the XML attribute. | `#994500`
   * `--xml-viewer-attribute-value-color` | Color of the attribute's value. | `#1A1AA6`
   * `--xml-viewer-cdata-color` | CDATA section color. | `#48A`
   * `--xml-viewer-document-declaration-color` | XML document declaration (header) color. | `#999`
   * `--xml-viewer-constant-color` | Constant (boolean, null, number) color. | `#283593`
   */
  class XmlViewer extends Polymer.Element {

    /**
     * XML data to parse and display
     */
    xml: object|null|undefined;

    /**
     * True if error ocurred when parsing data
     */
    readonly isError: boolean|null|undefined;

    /**
     * True when XML is parsing
     */
    readonly working: boolean|null|undefined;

    /**
     * True when output should be shown.
     */
    readonly showOutput: boolean|null|undefined;

    /**
     * An error message to display.
     */
    readonly errorMessage: string|null|undefined;

    /**
     * A reference to the web worker object.
     */
    _worker: object|null|undefined;
    disconnectedCallback(): void;

    /**
     * Handler for the xml attribute change.
     *
     * @param xml Changed value.
     */
    _changed(xml: String|null): void;

    /**
     * Resets the state of the component.
     */
    reset(): void;

    /**
     * Parses and renders XML data.
     *
     * @param xml XML string to parse and render.
     */
    render(xml: String|null): void;

    /**
     * Creates a worker and references it as `_worker` property.
     */
    _ensureWorker(): void;

    /**
     * Handler for worker `message` event.
     * Renders output
     */
    _workerData(e: Event|null): void;

    /**
     * Handles error events from the web worker.
     */
    _workerError(e: Event|null): void;

    /**
     * Computes value for `showOutput` property
     *
     * @returns `true` if the output can be displayed.
     */
    _computeShowOutput(working: Boolean|null, isError: Boolean|null, xml: String|null): Boolean|null;

    /**
     * Handles clicks on the rendered items.
     * Provides support for expand / collapse functions.
     */
    _handleDisplayClick(e: Event|null): void;

    /**
     * Computes CSS class for the content actions pane.
     */
    _computeActionsPanelClass(showOutput: any): any;
  }
}

interface HTMLElementTagNameMap {
  "xml-viewer": UiElements.XmlViewer;
}
