/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.10-master-f8f13a8
 */
goog.provide("ngmaterial.components.input"),goog.require("ngmaterial.core"),mdInputContainerDirective.$inject=["$mdTheming","$parse"],inputTextareaDirective.$inject=["$mdUtil","$window","$mdAria","$timeout","$mdGesture"],mdMaxlengthDirective.$inject=["$animate","$mdUtil"],placeholderDirective.$inject=["$compile"],ngMessageDirective.$inject=["$mdUtil"],mdSelectOnFocusDirective.$inject=["$document","$timeout"],mdInputInvalidMessagesAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil","$log"],ngMessagesAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil","$log"],ngMessageAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil","$log"];var inputModule=angular.module("material.components.input",["material.core"]).directive("mdInputContainer",mdInputContainerDirective).directive("label",labelDirective).directive("input",inputTextareaDirective).directive("textarea",inputTextareaDirective).directive("mdMaxlength",mdMaxlengthDirective).directive("placeholder",placeholderDirective).directive("ngMessages",ngMessagesDirective).directive("ngMessage",ngMessageDirective).directive("ngMessageExp",ngMessageDirective).directive("mdSelectOnFocus",mdSelectOnFocusDirective).animation(".md-input-invalid",mdInputInvalidMessagesAnimation).animation(".md-input-messages-animation",ngMessagesAnimation).animation(".md-input-message-animation",ngMessageAnimation);function mdInputContainerDirective(i,r){n.$inject=["$scope","$element","$attrs","$animate"];var e=["INPUT","TEXTAREA","SELECT","MD-SELECT"],a=e.reduce(function(e,n){return e.concat(["md-icon ~ "+n,".md-icon ~ "+n])},[]).join(","),s=e.reduce(function(e,n){return e.concat([n+" ~ md-icon",n+" ~ .md-icon"])},[]).join(",");return{restrict:"E",compile:function(e){var n=e[0].querySelector(a),t=e[0].querySelector(s);n&&e.addClass("md-icon-left");t&&e.addClass("md-icon-right");return function(e,n){i(n)}},controller:n};function n(e,n,t,i){var a=this;a.isErrorGetter=t.mdIsError&&r(t.mdIsError),a.delegateClick=function(){a.input.focus()},a.element=n,a.setFocused=function(e){n.toggleClass("md-input-focused",!!e)},a.setHasValue=function(e){n.toggleClass("md-input-has-value",!!e)},a.setHasPlaceholder=function(e){n.toggleClass("md-input-has-placeholder",!!e)},a.setInvalid=function(e){e?i.addClass(n,"md-input-invalid"):i.removeClass(n,"md-input-invalid")},e.$watch(function(){return a.label&&a.input},function(e){e&&!a.label.attr("for")&&a.label.attr("for",a.input.attr("id"))})}}function labelDirective(){return{restrict:"E",require:"^?mdInputContainer",link:function(e,n,t,i){!i||t.mdNoFloat||n.hasClass("md-container-ignore")||(i.label=n,e.$on("$destroy",function(){i.label=null}))}}}function inputTextareaDirective(h,$,d,M,C){return{restrict:"E",require:["^?mdInputContainer","?ngModel","?^form"],link:function(c,m,g,e){var p=e[0],f=!!e[1],v=e[1]||h.fakeNgModel(),n=e[2],t=angular.isDefined(g.readonly),i=h.parseAttributeBoolean(g.mdNoAsterisk),a=m[0].tagName.toLowerCase();if(!p)return;{if("hidden"===g.type)return void m.attr("aria-hidden","true");if(p.input){if(p.input[0].contains(m[0]))return;throw new Error("<md-input-container> can only have *one* <input>, <textarea> or <md-select> child element!")}}p.input=m,p.label&&g.$observe("required",function(e){p.label.toggleClass("md-required",e&&!i)});var r=angular.element('<div class="md-errors-spacer">');m.after(r);var s=angular.isString(g.placeholder)?g.placeholder.trim():"";p.label||s.length||d.expect(m,"aria-label");m.addClass("md-input"),m.attr("id")||m.attr("id","input_"+h.nextUid());"input"===a&&"number"===g.type&&g.min&&g.max&&!g.step?m.attr("step","any"):"textarea"===a&&function(){var n=!g.hasOwnProperty("mdNoAutogrow");if(function(){if(!g.hasOwnProperty("mdNoResize")){var e=angular.element('<div class="md-resize-handle"></div>'),n=!1,t=0,i=p.element,a=C.register(e,"drag",{horizontal:!1});m.wrap('<div class="md-resize-wrapper">').after(e),e.on("mousedown",r),i.on("$md.dragstart",s).on("$md.drag",o).on("$md.dragend",u),c.$on("$destroy",function(){e.off("mousedown",r).remove(),i.off("$md.dragstart",s).off("$md.drag",o).off("$md.dragend",u),a(),a=i=e=null})}function r(e){e.preventDefault(),n=!0,e.clientY,t=parseFloat(m.css("height"))||m.prop("offsetHeight")}function s(e){n&&(e.preventDefault(),l(),i.addClass("md-input-resized"))}function o(e){n&&m.css("height",t+e.pointer.distanceY+"px")}function u(e){n&&(n=!1,i.removeClass("md-input-resized"))}}(),!n)return;var r=g.hasOwnProperty("rows")?parseInt(g.rows):NaN,s=g.hasOwnProperty("maxRows")?parseInt(g.maxRows):NaN,t=c.$on("md-resize-textarea",i),o=null,u=m[0];M(function(){h.nextTick(i)},10,!1),m.on("input",i),f&&v.$formatters.push(a);r||m.attr("rows",1);function i(){m.attr("rows",1).css("height","auto").addClass("md-no-flex");var e,n,t=(e=u.offsetHeight,n=u.scrollHeight-e,e+Math.max(n,0));if(!o){var i=m[0].style.padding||"";o=m.css("padding",0).prop("offsetHeight"),m[0].style.padding=i}if(r&&o&&(t=Math.max(t,o*r)),s&&o){var a=o*s;a<t?(m.attr("md-no-autogrow",""),t=a):m.removeAttr("md-no-autogrow")}o&&m.attr("rows",Math.round(t/o)),m.css("height",t+"px").removeClass("md-no-flex")}function a(e){return h.nextTick(i),e}function l(){if(n&&(n=!1,angular.element($).off("resize",i),t&&t(),m.attr("md-no-autogrow","").off("input",i),f)){var e=v.$formatters.indexOf(a);-1<e&&v.$formatters.splice(e,1)}}if(angular.element($).on("resize",i),c.$on("$destroy",l),g.hasOwnProperty("mdDetectHidden")){var e=(d=!1,function(){var e=0===u.offsetHeight;!1===e&&!0===d&&i(),d=e});c.$watch(function(){return h.nextTick(e,!1),!0})}var d}();f||l();var o=p.isErrorGetter||function(){return v.$invalid&&(v.$touched||n&&n.$submitted)};c.$watch(o,p.setInvalid),g.ngValue&&g.$observe("value",l);v.$parsers.push(u),v.$formatters.push(u),m.on("input",l),t||m.on("focus",function(e){h.nextTick(function(){p.setFocused(!0)})}).on("blur",function(e){h.nextTick(function(){p.setFocused(!1),l()})});function u(e){return p.setHasValue(!v.$isEmpty(e)),e}function l(){p.setHasValue(0<m.val().length||(m[0].validity||{}).badInput)}c.$on("$destroy",function(){p.setFocused(!1),p.setHasValue(!1),p.input=null})}}}function mdMaxlengthDirective(g,p){return{restrict:"A",require:["ngModel","^mdInputContainer"],link:function(e,i,n,t){var a=parseInt(n.mdMaxlength);isNaN(a)&&(a=-1);var r,s,o=t[0],u=t[1],l=!angular.isDefined(n.ngTrim)||p.parseAttributeBoolean(n.ngTrim),d="password"===n.type;function c(e){return null==(e=l&&!d&&angular.isString(e)?e.trim():e)&&(e=""),String(e).length}function m(){r&&r.parent()&&r.text(c(i.val())+" / "+a)}e.$watch(n.mdMaxlength,function(e){a=e}),o.$validators["md-maxlength"]=function(e,n){if(!angular.isNumber(a)||a<0)return!0;m();var t=i.val()||n;return null==t&&(t=""),t=l&&!d&&angular.isString(t)?t.trim():t,String(t).length<=a},o.$isEmpty=function(e){return 0===c(e)},p.nextTick(function(){s=angular.element(u.element[0].querySelector(".md-errors-spacer")),r=angular.element('<div class="md-char-counter">'),s.append(r),n.$observe("ngTrim",function(e){l=!angular.isDefined(e)||p.parseAttributeBoolean(e)}),e.$watch(n.mdMaxlength,function(e){angular.isNumber(e)&&0<e?(r.parent().length||g.enter(r,s),m()):g.leave(r)})})}}}function placeholderDirective(o){return{restrict:"A",require:"^^?mdInputContainer",priority:200,link:{pre:function(e,n,t,i){if(!i)return;var a=i.element.find("label"),r=i.element.attr("md-no-float");if(a&&a.length||""===r||e.$eval(r))return void i.setHasPlaceholder(!0);if("MD-SELECT"!=n[0].nodeName){var s=angular.element('<label ng-click="delegateClick()" tabindex="-1">'+t.placeholder+"</label>");t.$set("placeholder",null),i.element.addClass("md-icon-float").prepend(s),o(s)(e)}}}}}function mdSelectOnFocusDirective(s,o){return{restrict:"A",link:function(e,n,t){if("INPUT"!==n[0].nodeName&&"TEXTAREA"!==n[0].nodeName)return;var i=!1;function a(){o(function(){s[0].activeElement===n[0]&&n[0].select(),i=!1},1,!(i=!0))}function r(e){i&&e.preventDefault()}n.on("focus",a).on("mouseup",r),e.$on("$destroy",function(){n.off("focus",a).off("mouseup",r)})}}}window._mdMocksIncluded&&inputModule.service("$$mdInput",function(){return{messages:{show:showInputMessages,hide:hideInputMessages,getElement:getMessagesElement}}}).service("mdInputInvalidAnimation",mdInputInvalidMessagesAnimation).service("mdInputMessagesAnimation",ngMessagesAnimation).service("mdInputMessageAnimation",ngMessageAnimation);var $$AnimateRunner,$animateCss,$mdUtil,$log,visibilityDirectives=["ngIf","ngShow","ngHide","ngSwitchWhen","ngSwitchDefault"];function ngMessagesDirective(){return{restrict:"EA",link:function(e,n,t,i){if(!i)return;n.toggleClass("md-input-messages-animation",!0),n.toggleClass("md-auto-hide",!0),("false"==t.mdAutoHide||(a=t,visibilityDirectives.some(function(e){return a[e]})))&&n.toggleClass("md-auto-hide",!1);var a},require:"^^?mdInputContainer"}}function ngMessageDirective(n){return{restrict:"EA",compile:function(t){if(i(t))a(t);else if(function(){var e=t[0];for(;e=e.parentNode;)if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)return!0;return!1}())return function(e,n){i(n)&&a(t)};function i(e){return!!n.getClosest(e,"md-input-container")}function a(e){e.toggleClass("md-input-message-animation",!0)}},priority:100}}function mdInputInvalidMessagesAnimation(e,n,t,i){return saveSharedServices(e,n,t,i),{addClass:function(e,n,t){showInputMessages(e,t)}}}function ngMessagesAnimation(e,n,t,i){return saveSharedServices(e,n,t,i),{enter:function(e,n){showInputMessages(e,n)},leave:function(e,n){hideInputMessages(e,n)},addClass:function(e,n,t){"ng-hide"==n?hideInputMessages(e,t):t()},removeClass:function(e,n,t){"ng-hide"==n?showInputMessages(e,t):t()}}}function ngMessageAnimation(e,n,t,i){return saveSharedServices(e,n,t,i),{enter:function(e,n){showMessage(e).start().done(n)},leave:function(e,n){hideMessage(e).start().done(n)}}}function showInputMessages(e,n){var t,i=[],a=getMessagesElement(e),r=a.children();if(0==a.length||0==r.length)return $log.warn("mdInput messages show animation called on invalid messages element: ",e),void n();angular.forEach(r,function(e){t=showMessage(angular.element(e)),i.push(t.start())}),$$AnimateRunner.all(i,n)}function hideInputMessages(e,n){var t,i=[],a=getMessagesElement(e),r=a.children();if(0==a.length||0==r.length)return $log.warn("mdInput messages hide animation called on invalid messages element: ",e),void n();angular.forEach(r,function(e){t=hideMessage(angular.element(e)),i.push(t.start())}),$$AnimateRunner.all(i,n)}function showMessage(e){var n=parseInt(window.getComputedStyle(e[0]).height),t=parseInt(window.getComputedStyle(e[0]).marginTop),i=getMessagesElement(e),a=getInputElement(e);return-n<t||i.hasClass("md-auto-hide")&&!a.hasClass("md-input-invalid")?$animateCss(e,{}):$animateCss(e,{event:"enter",structural:!0,from:{opacity:0,"margin-top":-n+"px"},to:{opacity:1,"margin-top":"0"},duration:.3})}function hideMessage(e){var n=e[0].offsetHeight,t=window.getComputedStyle(e[0]);return 0===parseInt(t.opacity)?$animateCss(e,{}):$animateCss(e,{event:"leave",structural:!0,from:{opacity:1,"margin-top":0},to:{opacity:0,"margin-top":-n+"px"},duration:.3})}function getInputElement(e){return e.controller("mdInputContainer").element}function getMessagesElement(e){return e.hasClass("md-input-messages-animation")?e:e.hasClass("md-input-message-animation")?angular.element($mdUtil.getClosest(e,function(e){return e.classList.contains("md-input-messages-animation")})):angular.element(e[0].querySelector(".md-input-messages-animation"))}function saveSharedServices(e,n,t,i){$$AnimateRunner=e,$animateCss=n,$mdUtil=t,$log=i}ngmaterial.components.input=angular.module("material.components.input");