/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.10-master-f8f13a8
 */
!function(n,l,t){"use strict";function e(t,e,i,n,s){this.$scope=t,this.$element=e,this.$mdConstant=i,this.$timeout=n,this.$mdUtil=s,this.isEditing=!1,this.parentController=void 0,this.enableChipEdit=!1}function i(p,t,e,h){return{restrict:"E",require:["^?mdChips","mdChip"],link:function(t,e,i,n){var s=n.shift(),o=n.shift(),r=l.element(e[0].querySelector(".md-chip-content"));p(e),s&&(o.init(s),r.on("blur",function(){s.resetSelectedChip(),s.$scope.$applyAsync()}));h(function(){s&&s.shouldFocusLastChip&&s.focusLastChipThenInput()})},controller:"MdChipCtrl"}}function s(s){return{restrict:"A",require:"^mdChips",scope:!1,link:function(e,t,i,n){t.on("click",function(t){e.$apply(function(){n.removeChip(e.$$replacedScope.$index)})}),s(function(){t.attr({tabindex:-1,"aria-hidden":!0}),t.find("button").attr("tabindex","-1")})}}}function o(r){return{restrict:"EA",terminal:!0,link:function(t,e,i){var n=t.$parent.$mdChipsCtrl,s=n.parent.$new(!1,n.parent);s.$$replacedScope=t,s.$chip=t.$chip,s.$index=t.$index;var o=(s.$mdChipsCtrl=n).$scope.$eval(i.mdChipTransclude);e.html(o),r(e.contents())(s)},scope:!1}}l.module("material.components.chips",["material.core","material.components.autocomplete"]),e.$inject=["$scope","$element","$mdConstant","$timeout","$mdUtil"],l.module("material.components.chips").controller("MdChipCtrl",e),e.prototype.init=function(t){this.parentController=t,this.enableChipEdit=this.parentController.enableChipEdit,this.enableChipEdit&&(this.$element.on("keydown",this.chipKeyDown.bind(this)),this.$element.on("dblclick",this.chipMouseDoubleClick.bind(this)),this.getChipContent().addClass("_md-chip-content-edit-is-enabled"))},e.prototype.getChipContent=function(){var t=this.$element[0].getElementsByClassName("md-chip-content");return l.element(t[0])},e.prototype.getContentElement=function(){var t=l.element(this.getChipContent().children()[0]);return t&&0!==t.length||(t=l.element(this.getChipContent().contents()[0])),t},e.prototype.getChipIndex=function(){return parseInt(this.$element.attr("index"))},e.prototype.goOutOfEditMode=function(){if(this.isEditing){this.isEditing=!1,this.$element.removeClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="false";var t=this.getChipIndex(),e=this.getContentElement().text();e?(this.parentController.updateChipContents(t,e),this.$mdUtil.nextTick(function(){this.parentController.selectedChip===t&&this.parentController.focusChip(t)}.bind(this))):this.parentController.removeChipAndFocusInput(t)}},e.prototype.selectNodeContents=function(t){var e,i;document.body.createTextRange?((e=document.body.createTextRange()).moveToElementText(t),e.select()):n.getSelection&&(i=n.getSelection(),(e=document.createRange()).selectNodeContents(t),i.removeAllRanges(),i.addRange(e))},e.prototype.goInEditMode=function(){this.isEditing=!0,this.$element.addClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="true",this.getChipContent().on("blur",function(){this.goOutOfEditMode()}.bind(this)),this.selectNodeContents(this.getChipContent()[0])},e.prototype.chipKeyDown=function(t){this.isEditing||t.keyCode!==this.$mdConstant.KEY_CODE.ENTER&&t.keyCode!==this.$mdConstant.KEY_CODE.SPACE?this.isEditing&&t.keyCode===this.$mdConstant.KEY_CODE.ENTER&&(t.preventDefault(),this.goOutOfEditMode()):(t.preventDefault(),this.goInEditMode())},e.prototype.chipMouseDoubleClick=function(){this.enableChipEdit&&!this.isEditing&&this.goInEditMode()},i.$inject=["$mdTheming","$mdUtil","$compile","$timeout"],l.module("material.components.chips").directive("mdChip",i),s.$inject=["$timeout"],l.module("material.components.chips").directive("mdChipRemove",s),o.$inject=["$compile"],l.module("material.components.chips").directive("mdChipTransclude",o),r.$inject=["$scope","$attrs","$mdConstant","$log","$element","$timeout","$mdUtil","$exceptionHandler"];var h=300;function r(t,e,i,n,s,o,r,p){this.$timeout=o,this.$mdConstant=i,this.$scope=t,this.parent=t.$parent,this.$mdUtil=r,this.$log=n,this.$exceptionHandler=p,this.$element=s,this.$attrs=e,this.ngModelCtrl=null,this.userInputNgModelCtrl=null,this.autocompleteCtrl=null,this.userInputElement=null,this.items=[],this.selectedChip=-1,this.enableChipEdit=r.parseAttributeBoolean(e.mdEnableChipEdit),this.addOnBlur=r.parseAttributeBoolean(e.mdAddOnBlur),this.inputAriaLabel="Chips input.",this.containerHint="Chips container. Use arrow keys to select chips.",this.deleteHint="Press delete to remove this chip.",this.deleteButtonLabel="Remove",this.chipBuffer="",this.useTransformChip=!1,this.useOnAdd=!1,this.useOnRemove=!1,this.wrapperId="",this.contentIds=[],this.ariaTabIndex=null,this.chipAppendDelay=h,this.deRegister=[],this.init()}l.module("material.components.chips").controller("MdChipsCtrl",r),r.prototype.init=function(){var e=this;this.wrapperId="_md-chips-wrapper-"+this.$mdUtil.nextUid(),this.deRegister.push(this.$scope.$watchCollection("$mdChipsCtrl.items",function(){e.setupInputAria(),e.setupWrapperAria()})),this.deRegister.push(this.$attrs.$observe("mdChipAppendDelay",function(t){e.chipAppendDelay=parseInt(t)||h}))},r.prototype.$onDestroy=function(){for(var t;t=this.deRegister.pop();)t.call(this)},r.prototype.setupInputAria=function(){var t=this.$element.find("input");t&&(t.attr("role","textbox"),t.attr("aria-multiline",!0))},r.prototype.setupWrapperAria=function(){var t=this,e=this.$element.find("md-chips-wrap");this.items&&this.items.length?(e.attr("role","listbox"),this.contentIds=this.items.map(function(){return t.wrapperId+"-chip-"+t.$mdUtil.nextUid()}),e.attr("aria-owns",this.contentIds.join(" "))):(e.removeAttr("role"),e.removeAttr("aria-owns"))},r.prototype.inputKeydown=function(t){var e=this.getChipBuffer();if(!(this.autocompleteCtrl&&t.isDefaultPrevented&&t.isDefaultPrevented())){if(t.keyCode===this.$mdConstant.KEY_CODE.BACKSPACE){if(0!==this.getCursorPosition(t.target))return;return t.preventDefault(),t.stopPropagation(),void(this.items.length&&this.selectAndFocusChipSafe(this.items.length-1))}if((!this.separatorKeys||this.separatorKeys.length<1)&&(this.separatorKeys=[this.$mdConstant.KEY_CODE.ENTER]),-1!==this.separatorKeys.indexOf(t.keyCode)){if(this.autocompleteCtrl&&this.requireMatch||!e)return;if(t.preventDefault(),this.hasMaxChipsReached())return;return this.appendChip(e.trim()),this.resetChipBuffer(),!1}}},r.prototype.getCursorPosition=function(e){try{if(e.selectionStart===e.selectionEnd)return e.selectionStart}catch(t){if(!e.value)return 0}},r.prototype.updateChipContents=function(t,e){0<=t&&t<this.items.length&&(this.items[t]=e,this.updateNgModel(!0))},r.prototype.isEditingChip=function(){return!!this.$element[0].querySelector("._md-chip-editing")},r.prototype.isRemovable=function(){return!!this.ngModelCtrl&&(this.readonly?this.removable:!l.isDefined(this.removable)||this.removable)},r.prototype.chipKeydown=function(t){if(!this.getChipBuffer()&&!this.isEditingChip())switch(t.keyCode){case this.$mdConstant.KEY_CODE.BACKSPACE:case this.$mdConstant.KEY_CODE.DELETE:if(this.selectedChip<0)return;if(t.preventDefault(),!this.isRemovable())return;this.removeAndSelectAdjacentChip(this.selectedChip,t);break;case this.$mdConstant.KEY_CODE.LEFT_ARROW:t.preventDefault(),(this.selectedChip<0||this.readonly&&0===this.selectedChip)&&(this.selectedChip=this.items.length),this.items.length&&this.selectAndFocusChipSafe(this.selectedChip-1);break;case this.$mdConstant.KEY_CODE.RIGHT_ARROW:t.preventDefault(),this.selectAndFocusChipSafe(this.selectedChip+1);break;case this.$mdConstant.KEY_CODE.ESCAPE:case this.$mdConstant.KEY_CODE.TAB:if(this.selectedChip<0)return;t.preventDefault(),this.onFocus()}},r.prototype.getPlaceholder=function(){return this.items&&this.items.length&&(""===this.secondaryPlaceholder||this.secondaryPlaceholder)?this.secondaryPlaceholder:this.placeholder},r.prototype.removeAndSelectAdjacentChip=function(t,e){var i=this,n=i.getAdjacentChipIndex(t);this.$element[0].querySelector("md-chips-wrap"),this.$element[0].querySelector('md-chip[index="'+t+'"]');i.removeChip(t,e),i.$timeout(function(){i.$timeout(function(){i.selectAndFocusChipSafe(n)})})},r.prototype.resetSelectedChip=function(){this.selectedChip=-1,this.ariaTabIndex=null},r.prototype.getAdjacentChipIndex=function(t){var e=this.items.length-1;return 0===e?-1:t===e?t-1:t},r.prototype.appendChip=function(e){if(this.shouldFocusLastChip=!this.addOnBlur,this.useTransformChip&&this.transformChip){var t=this.transformChip({$chip:e});l.isDefined(t)&&(e=t)}if(l.isObject(e)&&this.items.some(function(t){return l.equals(e,t)}))return;if(!(null==e||this.items.indexOf(e)+1)){var i=this.items.push(e)-1;this.updateNgModel(),this.useOnAdd&&this.onAdd&&this.onAdd({$chip:e,$index:i})}},r.prototype.useTransformChipExpression=function(){this.useTransformChip=!0},r.prototype.useOnAddExpression=function(){this.useOnAdd=!0},r.prototype.useOnRemoveExpression=function(){this.useOnRemove=!0},r.prototype.useOnSelectExpression=function(){this.useOnSelect=!0},r.prototype.getChipBuffer=function(){var t=this.userInputElement?this.userInputNgModelCtrl?this.userInputNgModelCtrl.$viewValue:this.userInputElement[0].value:this.chipBuffer;return l.isString(t)?t:""},r.prototype.resetChipBuffer=function(){this.userInputElement?this.userInputNgModelCtrl?(this.userInputNgModelCtrl.$setViewValue(""),this.userInputNgModelCtrl.$render()):this.userInputElement[0].value="":this.chipBuffer=""},r.prototype.hasMaxChipsReached=function(){return l.isString(this.maxChips)&&(this.maxChips=parseInt(this.maxChips,10)||0),0<this.maxChips&&this.items.length>=this.maxChips},r.prototype.validateModel=function(){this.ngModelCtrl.$setValidity("md-max-chips",!this.hasMaxChipsReached()),this.ngModelCtrl.$validate()},r.prototype.updateNgModel=function(t){t||this.validateModel(),l.forEach(this.ngModelCtrl.$viewChangeListeners,function(t){try{t()}catch(t){this.$exceptionHandler(t)}})},r.prototype.removeChip=function(t,e){var i=this.items.splice(t,1);this.updateNgModel(),this.ngModelCtrl.$setDirty(),i&&i.length&&this.useOnRemove&&this.onRemove&&this.onRemove({$chip:i[0],$index:t,$event:e})},r.prototype.removeChipAndFocusInput=function(t,e){this.removeChip(t,e),this.autocompleteCtrl?(this.autocompleteCtrl.hidden=!0,this.$mdUtil.nextTick(this.onFocus.bind(this))):this.onFocus()},r.prototype.selectAndFocusChipSafe=function(t){if(!this.items.length||-1===t)return this.focusInput();if(t>=this.items.length){if(!this.readonly)return this.onFocus();t=0}t=Math.max(t,0),t=Math.min(t,this.items.length-1),this.selectChip(t),this.focusChip(t)},r.prototype.focusLastChipThenInput=function(){var t=this;t.shouldFocusLastChip=!1,t.focusChip(this.items.length-1),t.$timeout(function(){t.focusInput()},t.chipAppendDelay)},r.prototype.focusInput=function(){this.selectChip(-1),this.onFocus()},r.prototype.selectChip=function(t){-1<=t&&t<=this.items.length?(this.selectedChip=t,this.useOnSelect&&this.onSelect&&this.onSelect({$chip:this.items[t]})):this.$log.warn("Selected Chip index out of bounds; ignoring.")},r.prototype.selectAndFocusChip=function(t){this.selectChip(t),-1!==t&&this.focusChip(t)},r.prototype.focusChip=function(t){var e=this.$element[0].querySelector('md-chip[index="'+t+'"] .md-chip-content');this.ariaTabIndex=t,e.focus()},r.prototype.configureNgModel=function(t){this.ngModelCtrl=t;var e=this;t.$isEmpty=function(t){return!t||0===t.length},t.$render=function(){e.items=e.ngModelCtrl.$viewValue}},r.prototype.onFocus=function(){var t=this.$element[0].querySelector("input");t&&t.focus(),this.resetSelectedChip()},r.prototype.onInputFocus=function(){this.inputHasFocus=!0,this.setupInputAria(),this.resetSelectedChip()},r.prototype.onInputBlur=function(){this.inputHasFocus=!1,this.shouldAddOnBlur()&&(this.appendChip(this.getChipBuffer().trim()),this.resetChipBuffer())},r.prototype.configureInput=function(t){var e=t.controller("ngModel"),i=this;e&&(this.deRegister.push(this.$scope.$watch(function(){return e.$touched},function(t){t&&i.ngModelCtrl.$setTouched()})),this.deRegister.push(this.$scope.$watch(function(){return e.$dirty},function(t){t&&i.ngModelCtrl.$setDirty()})))},r.prototype.configureUserInput=function(t){var e=(this.userInputElement=t).controller("ngModel");e!==this.ngModelCtrl&&(this.userInputNgModelCtrl=e);var i=this.$scope,n=this,s=function(t,e){i.$evalAsync(l.bind(n,e,t))};t.attr({tabindex:0}).on("keydown",function(t){s(t,n.inputKeydown)}).on("focus",function(t){s(t,n.onInputFocus)}).on("blur",function(t){s(t,n.onInputBlur)})},r.prototype.configureAutocomplete=function(t){t&&((this.autocompleteCtrl=t).registerSelectedItemWatcher(l.bind(this,function(t){if(t){if(this.hasMaxChipsReached())return;this.appendChip(t),this.resetChipBuffer()}})),this.$element.find("input").on("focus",l.bind(this,this.onInputFocus)).on("blur",l.bind(this,this.onInputBlur)))},r.prototype.shouldAddOnBlur=function(){this.validateModel();var t=this.getChipBuffer().trim(),e=this.ngModelCtrl.$isEmpty(this.ngModelCtrl.$modelValue)||this.ngModelCtrl.$valid,i=this.autocompleteCtrl&&!this.autocompleteCtrl.hidden;return this.userInputNgModelCtrl&&(e=e&&this.userInputNgModelCtrl.$valid),this.addOnBlur&&!this.requireMatch&&t&&e&&!i},r.prototype.hasFocus=function(){return this.inputHasFocus||0<=this.selectedChip},r.prototype.contentIdFor=function(t){return this.contentIds[t]},a.$inject=["$mdTheming","$mdUtil","$compile","$log","$timeout","$$mdSvgRegistry"],l.module("material.components.chips").directive("mdChips",a);var p='      <md-chips-wrap          id="{{$mdChipsCtrl.wrapperId}}"          tabindex="{{$mdChipsCtrl.readonly ? 0 : -1}}"          ng-keydown="$mdChipsCtrl.chipKeydown($event)"          ng-class="{ \'md-focused\': $mdChipsCtrl.hasFocus(),                       \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly,                      \'md-removable\': $mdChipsCtrl.isRemovable() }"          aria-setsize="{{$mdChipsCtrl.items.length}}"          class="md-chips">        <span ng-if="$mdChipsCtrl.readonly" class="md-visually-hidden">          {{$mdChipsCtrl.containerHint}}        </span>        <md-chip ng-repeat="$chip in $mdChipsCtrl.items"            index="{{$index}}" aria-label="{{$mdChipsCtrl.deleteHint}}"            ng-class="{\'md-focused\': $mdChipsCtrl.selectedChip == $index, \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly}">          <div class="md-chip-content"              tabindex="{{$mdChipsCtrl.ariaTabIndex == $index ? 0 : -1}}"              id="{{$mdChipsCtrl.contentIdFor($index)}}"              role="option"              aria-selected="{{$mdChipsCtrl.selectedChip === $index}}"              aria-posinset="{{$index}}"              ng-click="!$mdChipsCtrl.readonly && $mdChipsCtrl.focusChip($index)"              ng-focus="!$mdChipsCtrl.readonly && $mdChipsCtrl.selectChip($index)"              md-chip-transclude="$mdChipsCtrl.chipContentsTemplate"></div>          <div ng-if="$mdChipsCtrl.isRemovable()"               class="md-chip-remove-container"               tabindex="-1"               md-chip-transclude="$mdChipsCtrl.chipRemoveTemplate"></div>        </md-chip>        <div class="md-chip-input-container" ng-if="!$mdChipsCtrl.readonly && $mdChipsCtrl.ngModelCtrl">          <div md-chip-transclude="$mdChipsCtrl.chipInputTemplate"></div>        </div>      </md-chips-wrap>',d='        <input            class="md-input"            tabindex="0"            aria-label="{{$mdChipsCtrl.inputAriaLabel}}"             placeholder="{{$mdChipsCtrl.getPlaceholder()}}"            ng-model="$mdChipsCtrl.chipBuffer"            ng-focus="$mdChipsCtrl.onInputFocus()"            ng-blur="$mdChipsCtrl.onInputBlur()"            ng-keydown="$mdChipsCtrl.inputKeydown($event)">',c="      <span>{{$chip}}</span>",g='      <button          class="md-chip-remove"          ng-if="$mdChipsCtrl.isRemovable()"          ng-click="$mdChipsCtrl.removeChipAndFocusInput($$replacedScope.$index, $event)"          type="button"          tabindex="-1">        <md-icon md-svg-src="{{ $mdChipsCtrl.mdCloseIcon }}"></md-icon>        <span class="md-visually-hidden">          {{$mdChipsCtrl.deleteButtonLabel}}        </span>      </button>';function a(a,m,u,n,C,f){var $={chips:m.processTemplate(p),input:m.processTemplate(d),default:m.processTemplate(c),remove:m.processTemplate(g)};return{template:function(t,e){return e.$mdUserTemplate=t.clone(),$.chips},require:["mdChips"],restrict:"E",controller:"MdChipsCtrl",controllerAs:"$mdChipsCtrl",bindToController:!0,compile:function(t,r){var i=r.$mdUserTemplate;r.$mdUserTemplate=null;var p=e("md-chips>md-chip-template"),h=e(m.prefixer().buildList("md-chip-remove").map(function(t){return"md-chips>*["+t+"]"}).join(","))||$.remove,l=p||$.default,d=e("md-chips>md-autocomplete")||e("md-chips>input")||$.input,c=i.find("md-chip");i[0].querySelector("md-chip-template>*[md-chip-remove]")&&n.warn("invalid placement of md-chip-remove within md-chip-template.");function e(t){if(r.ngModel){var e=i[0].querySelector(t);return e&&e.outerHTML}}return function(t,e,i,n){m.initOptionalProperties(t,r),a(e);var s=n[0];if(p&&(s.enableChipEdit=!1),s.chipContentsTemplate=l,s.chipRemoveTemplate=h,s.chipInputTemplate=d,s.mdCloseIcon=f.mdClose,e.attr({tabindex:-1}).on("focus",function(){s.onFocus()}).on("click",function(){s.readonly||-1!==s.selectedChip||s.onFocus()}),r.ngModel&&(s.configureNgModel(e.controller("ngModel")),i.mdTransformChip&&s.useTransformChipExpression(),i.mdOnAppend&&s.useOnAppendExpression(),i.mdOnAdd&&s.useOnAddExpression(),i.mdOnRemove&&s.useOnRemoveExpression(),i.mdOnSelect&&s.useOnSelectExpression(),d!=$.input&&t.$watch("$mdChipsCtrl.readonly",function(t){t||m.nextTick(function(){if(0===d.indexOf("<md-autocomplete")){var t=e.find("md-autocomplete");s.configureAutocomplete(t.controller("mdAutocomplete"))}s.configureUserInput(e.find("input"))})}),m.nextTick(function(){var t=e.find("input");t&&(s.configureInput(t),t.toggleClass("md-input",!0))})),0<c.length){var o=u(c.clone())(t.$parent);C(function(){e.find("md-chips-wrap").prepend(o)})}}},scope:{readonly:"=?readonly",removable:"=?mdRemovable",placeholder:"@?",secondaryPlaceholder:"@?",maxChips:"@?mdMaxChips",transformChip:"&mdTransformChip",onAppend:"&?mdOnAppend",onAdd:"&?mdOnAdd",onRemove:"&?mdOnRemove",onSelect:"&?mdOnSelect",inputAriaLabel:"@?",containerHint:"@?",deleteHint:"@?",deleteButtonLabel:"@?",separatorKeys:"=?mdSeparatorKeys",requireMatch:"=?mdRequireMatch",chipAppendDelayString:"@?mdChipAppendDelay",ngChange:"&?"}}}function m(){this.selectedItem=null,this.searchText=""}l.module("material.components.chips").controller("MdContactChipsCtrl",m),m.prototype.queryContact=function(t){return this.contactQuery({$query:t})},m.prototype.inputKeydown=function(t){if(this.separatorKeys&&!(this.separatorKeys.indexOf(t.keyCode)<0)){t.stopPropagation(),t.preventDefault();var e=l.element(t.target).controller("mdAutocomplete");e.select(e.index)}},m.prototype.itemName=function(t){return t[this.contactName]},C.$inject=["$mdTheming","$mdUtil"],l.module("material.components.chips").directive("mdContactChips",C);var u='      <md-chips class="md-contact-chips"          ng-model="$mdContactChipsCtrl.contacts"          ng-change="$mdContactChipsCtrl.ngChange($mdContactChipsCtrl.contacts)"          md-require-match="$mdContactChipsCtrl.requireMatch"          md-chip-append-delay="{{$mdContactChipsCtrl.chipAppendDelay}}"          md-separator-keys="$mdContactChipsCtrl.separatorKeys"          md-autocomplete-snap>          <md-autocomplete              md-menu-class="md-contact-chips-suggestions"              md-selected-item="$mdContactChipsCtrl.selectedItem"              md-search-text="$mdContactChipsCtrl.searchText"              md-items="item in $mdContactChipsCtrl.queryContact($mdContactChipsCtrl.searchText)"              md-item-text="$mdContactChipsCtrl.itemName(item)"              md-no-cache="true"              md-min-length="$mdContactChipsCtrl.minLength"              md-autoselect              ng-keydown="$mdContactChipsCtrl.inputKeydown($event)"              placeholder="{{$mdContactChipsCtrl.contacts.length == 0 ?                  $mdContactChipsCtrl.placeholder : $mdContactChipsCtrl.secondaryPlaceholder}}">            <div class="md-contact-suggestion">              <img                   ng-src="{{item[$mdContactChipsCtrl.contactImage]}}"                  alt="{{item[$mdContactChipsCtrl.contactName]}}"                  ng-if="item[$mdContactChipsCtrl.contactImage]" />              <span class="md-contact-name" md-highlight-text="$mdContactChipsCtrl.searchText"                    md-highlight-flags="{{$mdContactChipsCtrl.highlightFlags}}">                {{item[$mdContactChipsCtrl.contactName]}}              </span>              <span class="md-contact-email" >{{item[$mdContactChipsCtrl.contactEmail]}}</span>            </div>          </md-autocomplete>          <md-chip-template>            <div class="md-contact-avatar">              <img                   ng-src="{{$chip[$mdContactChipsCtrl.contactImage]}}"                  alt="{{$chip[$mdContactChipsCtrl.contactName]}}"                  ng-if="$chip[$mdContactChipsCtrl.contactImage]" />            </div>            <div class="md-contact-name">              {{$chip[$mdContactChipsCtrl.contactName]}}            </div>          </md-chip-template>      </md-chips>';function C(r,p){return{template:function(t,e){return u},restrict:"E",controller:"MdContactChipsCtrl",controllerAs:"$mdContactChipsCtrl",bindToController:!0,compile:function(t,o){return function(t,e,i,n){var s=n;p.initOptionalProperties(t,o),r(e),e.attr("tabindex","-1"),i.$observe("mdChipAppendDelay",function(t){s.chipAppendDelay=t})}},scope:{contactQuery:"&mdContacts",placeholder:"@",secondaryPlaceholder:"@",contactName:"@mdContactName",contactImage:"@mdContactImage",contactEmail:"@mdContactEmail",contacts:"=ngModel",ngChange:"&",requireMatch:"=?mdRequireMatch",minLength:"=?mdMinLength",highlightFlags:"@?mdHighlightFlags",chipAppendDelay:"@?mdChipAppendDelay",separatorKeys:"=?mdSeparatorKeys"}}}}(window,window.angular);