/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.20-master-595fefe
 */
function MdNavBar(n,o){return{restrict:"E",transclude:!0,controller:MdNavBarController,controllerAs:"ctrl",bindToController:!0,scope:{mdSelectedNavItem:"=?",mdNoInkBar:"=?",navBarAriaLabel:"@?"},template:'<div class="md-nav-bar"><nav role="navigation"><ul class="_md-nav-bar-list" ng-transclude role="tablist" ng-focus="ctrl.onFocus()" aria-label="{{ctrl.navBarAriaLabel}}"></ul></nav><md-nav-ink-bar ng-hide="ctrl.mdNoInkBar"></md-nav-ink-bar></div>',link:function(t,e,r,a){o(e),a.navBarAriaLabel||n.expectAsync(e,"aria-label",angular.noop)}}}function MdNavBarController(t,e,r,a){this._$timeout=r,this._$scope=e,this._$mdConstant=a,this.mdSelectedNavItem,this.navBarAriaLabel,this._navBarEl=t[0],this._inkbar;var n=this,o=this._$scope.$watch(function(){return n._navBarEl.querySelectorAll("._md-nav-button").length},function(t){0<t&&(n._initTabs(),o())})}function MdNavItem(d,t,u,v){return{restrict:"E",require:["mdNavItem","^mdNavBar"],controller:MdNavItemController,bindToController:!0,controllerAs:"ctrl",replace:!0,transclude:!0,template:function(t,e){var r,a,n=e.mdNavClick,o=e.mdNavHref,i=e.mdNavSref,l=e.srefOpts;if(1<(n?1:0)+(o?1:0)+(i?1:0))throw Error("Please do not specify more than one of the md-nav-click, md-nav-href, or md-nav-sref attributes per nav-item directive.");if(null!=n)r='ng-click="ctrl.mdNavClick()"';else if(null!=o)r='ng-href="{{ctrl.mdNavHref}}"';else{if(null==i)throw Error("Please specify at least one of the md-nav-click, md-nav-href, or md-nav-sref attributes per nav-item directive.");r='ui-sref="{{ctrl.mdNavSref}}"'}return r&&(a='<md-button class="_md-nav-button md-accent" ng-class="ctrl.getNgClassMap()" ng-blur="ctrl.setFocused(false)" ng-disabled="ctrl.disabled" tabindex="-1" role="tab" ng-attr-aria-label="{{ctrl.navItemAriaLabel ? ctrl.navItemAriaLabel : undefined}}" aria-selected="{{ctrl.isSelected()}}" '+(l?'ui-sref-opts="{{ctrl.srefOpts}}" ':"")+r+'><span ng-transclude class="_md-nav-button-text"></span></md-button>'),'<li class="md-nav-item" role="presentation">'+(a||"")+"</li>"},scope:{mdNavClick:"&?",mdNavHref:"@?",mdNavSref:"@?",srefOpts:"=?",name:"@",navItemAriaLabel:"@?"},link:function(r,a,n,o){var i,l,s,c;t(function(){if(l=o[0],s=o[1],c=angular.element(a[0].querySelector("._md-nav-button")),l.name||(l.name=angular.element(a[0].querySelector("._md-nav-button-text")).text().trim()),c.on("keydown",function(t){s.onKeydown(t)}),c.on("focus",function(){s.getFocusedTab()||s.onFocus()}),c.on("click",function(){s.mdSelectedNavItem=l.name,r.$apply()}),l.disabled=u.parseAttributeBoolean(n.disabled,!1),"MutationObserver"in v){var t=a[0],e=new MutationObserver(function(t){u.nextTick(function(){l.disabled=u.parseAttributeBoolean(n[t[0].attributeName],!1)})});e.observe(t,{attributes:!0,attributeFilter:["disabled"]}),i=e.disconnect.bind(e)}else n.$observe("disabled",function(t){l.disabled=u.parseAttributeBoolean(t,!1)});l.navItemAriaLabel||d.expectWithText(c,"aria-label")}),r.$on("destroy",function(){c.off("keydown"),c.off("focus"),c.off("click"),i()})}}}function MdNavItemController(t){this._$element=t,this.mdNavClick,this.mdNavHref,this.mdNavSref,this.srefOpts,this.name,this.navItemAriaLabel,this._selected=!1,this._focused=!1}goog.provide("ngmaterial.components.navBar"),goog.require("ngmaterial.core"),MdNavBar.$inject=["$mdAria","$mdTheming"],MdNavBarController.$inject=["$element","$scope","$timeout","$mdConstant"],MdNavItem.$inject=["$mdAria","$$rAF","$mdUtil","$window"],MdNavItemController.$inject=["$element"],angular.module("material.components.navBar",["material.core"]).controller("MdNavBarController",MdNavBarController).directive("mdNavBar",MdNavBar).controller("MdNavItemController",MdNavItemController).directive("mdNavItem",MdNavItem),MdNavBarController.prototype._initTabs=function(){this._inkbar=angular.element(this._navBarEl.querySelector("md-nav-ink-bar"));var r=this;this._$timeout(function(){r._updateTabs(r.mdSelectedNavItem,void 0)}),this._$scope.$watch("ctrl.mdSelectedNavItem",function(t,e){r._$timeout(function(){r._updateTabs(t,e)})})},MdNavBarController.prototype._updateTabs=function(t,e){var r=this,a=this._getTabs(),n=t===e;if(a){var o=-1,i=-1,l=this._getTabByName(t),s=this._getTabByName(e);s&&(s.setSelected(!1),o=a.indexOf(s)),l&&(l.setSelected(!0),i=a.indexOf(l)),this._$timeout(function(){r._updateInkBarStyles(l,i,o),l&&s&&!n&&r._moveFocus(s,l)})}},MdNavBarController.prototype._updateInkBarStyles=function(t,e,r){if(this._inkbar.toggleClass("_md-left",e<r).toggleClass("_md-right",r<e),this._inkbar.css({display:e<0?"none":""}),t){var a=t.getButtonEl(),n=a.offsetLeft;this._inkbar.css({left:n+"px",width:a.offsetWidth+"px"})}},MdNavBarController.prototype._getTabs=function(){var t=Array.prototype.slice.call(this._navBarEl.querySelectorAll(".md-nav-item")).map(function(t){return angular.element(t).controller("mdNavItem")});return t.indexOf(void 0)?t:null},MdNavBarController.prototype._getTabByName=function(e){return this._findTab(function(t){return t.getName()===e})},MdNavBarController.prototype._getSelectedTab=function(){return this._findTab(function(t){return t.isSelected()})},MdNavBarController.prototype.getFocusedTab=function(){return this._findTab(function(t){return t.hasFocus()})},MdNavBarController.prototype._findTab=function(t,e){var r=this._getTabs();null==e&&(e=0);for(var a=e;a<r.length;a++)if(t(r[a]))return r[a];return null},MdNavBarController.prototype._findTabReverse=function(t,e){var r=this._getTabs();null==e&&(e=r.length-1);for(var a=e;0<=a;a--)if(t(r[a]))return r[a];return null},MdNavBarController.prototype.onFocus=function(){var t=this._getSelectedTab();t&&t.setFocused(!0)},MdNavBarController.prototype._moveFocus=function(t,e){t.setFocused(!1),e.setFocused(!0)},MdNavBarController.prototype._focusFirstTab=function(){if(this._getTabs()){var t=this._findTab(function(t){return t._isEnabled()});t&&this._moveFocus(this.getFocusedTab(),t)}},MdNavBarController.prototype._focusLastTab=function(){if(this._getTabs()){var t=this._findTabReverse(function(t){return t._isEnabled()});t&&this._moveFocus(this.getFocusedTab(),t)}},MdNavBarController.prototype._focusNextTab=function(t){if(this._getTabs()){var e=this._findTab(function(t){return t._isEnabled()},t+1);e?this._moveFocus(this.getFocusedTab(),e):this._focusFirstTab()}},MdNavBarController.prototype._focusPreviousTab=function(t){if(this._getTabs()){var e=this._findTabReverse(function(t){return t._isEnabled()},t-1);e?this._moveFocus(this.getFocusedTab(),e):this._focusLastTab()}},MdNavBarController.prototype.onKeydown=function(t){var e=this._$mdConstant.KEY_CODE,r=this._getTabs(),a=this.getFocusedTab();if(a&&r){var n=r.indexOf(a);switch(t.keyCode){case e.UP_ARROW:case e.LEFT_ARROW:t.preventDefault(),this._focusPreviousTab(n);break;case e.DOWN_ARROW:case e.RIGHT_ARROW:t.preventDefault(),this._focusNextTab(n);break;case e.SPACE:case e.ENTER:this._$timeout(function(){a.getButtonEl().click()});break;case e.HOME:t.preventDefault(),this._focusFirstTab();break;case e.END:t.preventDefault(),this._focusLastTab()}}},MdNavItemController.prototype.getNgClassMap=function(){return{"md-active":this._selected,"md-primary":this._selected,"md-unselected":!this._selected,"md-focused":this._focused}},MdNavItemController.prototype.getName=function(){return this.name},MdNavItemController.prototype.getButtonEl=function(){return this._$element[0].querySelector("._md-nav-button")},MdNavItemController.prototype.setSelected=function(t){(this._selected=t)?this.getButtonEl().setAttribute("tabindex","0"):this.getButtonEl().setAttribute("tabindex","-1")},MdNavItemController.prototype.isSelected=function(){return this._selected},MdNavItemController.prototype.setFocused=function(t){(this._focused=t)&&this.getButtonEl().focus()},MdNavItemController.prototype.hasFocus=function(){return this._focused},MdNavItemController.prototype._isEnabled=function(){return!this._$element.attr("disabled")},ngmaterial.components.navBar=angular.module("material.components.navBar");