/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.1-master-41c71ed
 */
goog.provide("ngmaterial.components.panel"),goog.require("ngmaterial.components.backdrop"),goog.require("ngmaterial.core"),MdPanelService.$inject=["presets","$rootElement","$rootScope","$injector","$window"],angular.module("material.components.panel",["material.core","material.components.backdrop"]).provider("$mdPanel",MdPanelProvider);var MD_PANEL_Z_INDEX=80,MD_PANEL_HIDDEN="_md-panel-hidden",FOCUS_TRAP_TEMPLATE=angular.element('<div class="_md-panel-focus-trap" tabindex="0"></div>'),_presets={};function MdPanelProvider(){return{definePreset:definePreset,getAllPresets:getAllPresets,clearPresets:clearPresets,$get:$getProvider()}}function definePreset(t,e){if(!t||!e)throw new Error("mdPanelProvider: The panel preset definition is malformed. The name and preset object are required.");if(_presets.hasOwnProperty(t))throw new Error("mdPanelProvider: The panel preset you have requested has already been defined.");delete e.id,delete e.position,delete e.animation,_presets[t]=e}function getAllPresets(){return angular.copy(_presets)}function clearPresets(){_presets={}}function $getProvider(){return["$rootElement","$rootScope","$injector","$window",function(t,e,n,o){return new MdPanelService(_presets,t,e,n,o)}]}function coerceToArray(t){return angular.isString(t)&&(t=[t]),t}function MdPanelService(t,e,n,o,i){this._defaultConfigOptions={bindToController:!0,clickOutsideToClose:!1,disableParentScroll:!1,escapeToClose:!1,focusOnOpen:!0,fullscreen:!1,hasBackdrop:!1,propagateContainerEvents:!1,transformTemplate:angular.bind(this,this._wrapTemplate),trapFocus:!1,zIndex:MD_PANEL_Z_INDEX},this._config={},this._presets=t,this._$rootElement=e,this._$rootScope=n,this._$injector=o,this._$window=i,this._$mdUtil=this._$injector.get("$mdUtil"),this._trackedPanels={},this._groups=Object.create(null),this.animation=MdPanelAnimation.animation,this.xPosition=MdPanelPosition.xPosition,this.yPosition=MdPanelPosition.yPosition,this.interceptorTypes=MdPanelRef.interceptorTypes,this.closeReasons=MdPanelRef.closeReasons,this.absPosition=MdPanelPosition.absPosition}function MdPanelRef(t,e){this._$q=e.get("$q"),this._$mdCompiler=e.get("$mdCompiler"),this._$mdConstant=e.get("$mdConstant"),this._$mdUtil=e.get("$mdUtil"),this._$mdTheming=e.get("$mdTheming"),this._$rootScope=e.get("$rootScope"),this._$animate=e.get("$animate"),this._$mdPanel=e.get("$mdPanel"),this._$log=e.get("$log"),this._$window=e.get("$window"),this._$$rAF=e.get("$$rAF"),this.id=t.id,this.config=t,this.panelContainer=void 0,this.panelEl=void 0,this.innerWrapper=void 0,this.isAttached=!1,this._removeListeners=[],this._topFocusTrap=void 0,this._bottomFocusTrap=void 0,this._backdropRef=void 0,this._restoreScroll=null,this._interceptors=Object.create(null),this._compilerCleanup=null,this._restoreCache={styles:"",classes:""}}function MdPanelPosition(t){this._$window=t.get("$window"),this._isRTL=t.get("$mdUtil").isRtl(),this._$mdConstant=t.get("$mdConstant"),this._absolute=!1,this._relativeToEl=void 0,this._top="",this._bottom="",this._left="",this._right="",this._translateX=[],this._translateY=[],this._positions=[],this._actualPosition=void 0}function MdPanelAnimation(t){this._$mdUtil=t.get("$mdUtil"),this._openFrom,this._closeTo,this._animationClass="",this._openDuration,this._closeDuration,this._rawDuration}function getElement(t){var e=angular.isString(t)?document.querySelector(t):t;return angular.element(e)}function getComputedTranslations(t,e){var n=getComputedStyle(t[0]||t)[e],o=n.indexOf("("),i=n.lastIndexOf(")"),a={x:0,y:0};if(-1<o&&-1<i){var s=n.substring(o+1,i).split(", ").slice(-2);a.x=parseInt(s[0]),a.y=parseInt(s[1])}return a}function validatePosition(t,e){if(null!==e&&!angular.isUndefined(e)){for(var n,o=Object.keys(t),i=[],a=0;n=o[a];a++){var s=t[n];if(i.push(s),s===e)return}throw new Error("Panel position only accepts the following values:\n"+i.join(" | "))}}function addUnits(t){return angular.isNumber(t)?t+"px":t}MdPanelService.prototype.create=function(t,e){if("string"==typeof t?t=this._getPresetByName(t):"object"!=typeof t||!angular.isUndefined(e)&&e||(e=t,t={}),t=t||{},e=e||{},angular.isDefined(e.id)&&this._trackedPanels[e.id]){var n=this._trackedPanels[e.id];return angular.extend(n.config,e),n}this._config=angular.extend({id:e.id||"panel_"+this._$mdUtil.nextUid(),scope:this._$rootScope.$new(!0),attachTo:this._$rootElement},this._defaultConfigOptions,e,t);var o=new MdPanelRef(this._config,this._$injector);return this._trackedPanels[this._config.id]=o,this._config.groupName&&(this._config.groupName=coerceToArray(this._config.groupName),angular.forEach(this._config.groupName,function(t){o.addToGroup(t)})),this._config.scope.$on("$destroy",angular.bind(o,o.detach)),o},MdPanelService.prototype.open=function(t,e){var n=this.create(t,e);return n.open().then(function(){return n})},MdPanelService.prototype._getPresetByName=function(t){if(!this._presets[t])throw new Error("mdPanel: The panel preset configuration that you requested does not exist. Use the $mdPanelProvider to create a preset before requesting one.");return this._presets[t]},MdPanelService.prototype.newPanelPosition=function(){return new MdPanelPosition(this._$injector)},MdPanelService.prototype.newPanelAnimation=function(){return new MdPanelAnimation(this._$injector)},MdPanelService.prototype.newPanelGroup=function(t,e){return this._groups[t]||(e=e||{},this._groups[t]={panels:[],openPanels:[],maxOpen:0<e.maxOpen?e.maxOpen:1/0}),this._groups[t]},MdPanelService.prototype.setGroupMaxOpen=function(t,e){if(!this._groups[t])throw new Error("mdPanel: Group does not exist yet. Call newPanelGroup().");this._groups[t].maxOpen=e},MdPanelService.prototype._openCountExceedsMaxOpen=function(t){if(this._groups[t]){var e=this._groups[t];return 0<e.maxOpen&&e.openPanels.length>e.maxOpen}return!1},MdPanelService.prototype._closeFirstOpenedPanel=function(t){var e=this._groups[t];e&&e.openPanels.length&&e.openPanels[0].close()},MdPanelService.prototype._wrapTemplate=function(t){return'<div class="md-panel-outer-wrapper"><div class="md-panel-inner-wrapper _md-panel-offscreen"><div class="md-panel _md-panel-offscreen">'+(t||"")+"</div></div></div>"},MdPanelService.prototype._wrapContentElement=function(t){var e=angular.element('<div class="md-panel-outer-wrapper"><div class="md-panel-inner-wrapper _md-panel-offscreen"></div></div>');return t.addClass("md-panel _md-panel-offscreen"),e.children().eq(0).append(t),e},MdPanelRef.interceptorTypes={CLOSE:"onClose"},MdPanelRef.prototype.open=function(){var i=this;return this._$q(function(t,e){var n=i._done(t,i),o=i._simpleBind(i.show,i);i.attach().then(o).then(function(){i.config.groupName&&(i.config.groupName=coerceToArray(i.config.groupName),angular.forEach(i.config.groupName,function(t){i._$mdPanel._openCountExceedsMaxOpen(t)&&i._$mdPanel._closeFirstOpenedPanel(t)}))}).then(n).catch(e)})},MdPanelRef.prototype.close=function(a){var s=this;return this._$q(function(o,i){s._callInterceptors(MdPanelRef.interceptorTypes.CLOSE).then(function(){var t=s._done(o,s),e=s._simpleBind(s.detach,s),n=s.config.onCloseSuccess||angular.noop;n=angular.bind(s,n,s,a),s.hide().then(e).then(t).then(n).catch(i)},i)})},MdPanelRef.prototype.attach=function(){if(this.isAttached&&this.panelEl)return this._$q.when(this);var i=this;return this._$q(function(t,e){var n=i._done(t,i),o=i.config.onDomAdded||angular.noop;i._$q.all([i._createBackdrop(),i._createPanel().then(function(t){return i.isAttached=!0,i._addEventListeners(),t}).catch(e)]).then(o).then(n).catch(e)})},MdPanelRef.prototype.detach=function(){if(!this.isAttached)return this._$q.when(this);var o=this,i=o.config.onDomRemoved||angular.noop;return this._restoreScroll&&(this._restoreScroll(),this._restoreScroll=null),this._$q(function(t,e){var n=o._done(t,o);o._$q.all([(o._removeEventListeners(),o._topFocusTrap&&o._topFocusTrap.parentNode&&o._topFocusTrap.parentNode.removeChild(o._topFocusTrap),o._bottomFocusTrap&&o._bottomFocusTrap.parentNode&&o._bottomFocusTrap.parentNode.removeChild(o._bottomFocusTrap),o._restoreCache.classes&&(o.panelEl[0].className=o._restoreCache.classes),o.panelEl[0].style.cssText=o._restoreCache.styles||"",o._compilerCleanup(),o.panelContainer.remove(),o.isAttached=!1,o._$q.when(o)),!o._backdropRef||o._backdropRef.detach()]).then(i).then(n).catch(e)})},MdPanelRef.prototype.destroy=function(){var e=this;this.config.groupName&&(this.config.groupName=coerceToArray(this.config.groupName),angular.forEach(this.config.groupName,function(t){e.removeFromGroup(t)})),this.config.scope.$destroy(),this.config.locals=null,this.config.onDomAdded=null,this.config.onDomRemoved=null,this.config.onRemoving=null,this.config.onOpenComplete=null,this._interceptors=void 0},MdPanelRef.prototype.show=function(){if(!this.panelContainer)return this._$q(function(t,e){e("mdPanel: Panel does not exist yet. Call open() or attach().")});if(!this.panelContainer.hasClass(MD_PANEL_HIDDEN))return this._$q.when(this);var i=this;return this._$q(function(t,e){var n=i._done(t,i),o=i.config.onOpenComplete||angular.noop;i._$q.all([i._backdropRef?i._backdropRef.show():i,(i.panelContainer.removeClass(MD_PANEL_HIDDEN),i._animateOpen()).then(function(){i._focusOnOpen()},e)]).then(o).then(function(){i.config.groupName&&(i.config.groupName=coerceToArray(i.config.groupName),angular.forEach(i.config.groupName,function(t){(t=i._$mdPanel._groups[t])&&t.openPanels.push(i)}))}).then(n).catch(e)})},MdPanelRef.prototype.hide=function(){if(!this.panelContainer)return this._$q(function(t,e){e("mdPanel: Panel does not exist yet. Call open() or attach().")});if(this.panelContainer.hasClass(MD_PANEL_HIDDEN))return this._$q.when(this);var i=this;return this._$q(function(t,e){var n=i._done(t,i),o=i.config.onRemoving||angular.noop;i._$q.all([i._backdropRef?i._backdropRef.hide():i,i._animateClose().then(o).then(function(){i.panelContainer.addClass(MD_PANEL_HIDDEN)}).then(function(){var e;i.config.groupName&&(i.config.groupName=coerceToArray(i.config.groupName),angular.forEach(i.config.groupName,function(t){t=i._$mdPanel._groups[t],-1<(e=t.openPanels.indexOf(i))&&t.openPanels.splice(e,1)}))}).then(function(){var t=i.config.origin;t&&getElement(t).focus()}).catch(e)]).then(n,e)})},MdPanelRef.prototype._compile=function(){var o=this;return o._$mdCompiler.compile(o.config).then(function(t){var e=o.config;if(e.contentElement){var n=t.element;o._restoreCache.styles=n[0].style.cssText,o._restoreCache.classes=n[0].className,o.panelContainer=o._$mdPanel._wrapContentElement(n),o.panelEl=n}else o.panelContainer=t.link(e.scope),o.panelEl=angular.element(o.panelContainer[0].querySelector(".md-panel"));return o.innerWrapper=angular.element(o.panelContainer[0].querySelector(".md-panel-inner-wrapper")),o._compilerCleanup=t.cleanup,getElement(o.config.attachTo).append(o.panelContainer),o})},MdPanelRef.prototype._createPanel=function(){var n=this;return this._$q(function(t,e){n.config.locals||(n.config.locals={}),(n.config.locals.mdPanelRef=n)._compile().then(function(){n.config.disableParentScroll&&(n._restoreScroll=n._$mdUtil.disableScrollAround(null,n.panelContainer,{disableScrollMask:!0})),n.config.panelClass&&n.panelEl.addClass(n.config.panelClass),n.config.propagateContainerEvents&&(n.panelContainer.css("pointer-events","none"),n.panelEl.css("pointer-events","all")),n._$animate.pin&&n._$animate.pin(n.panelContainer,getElement(n.config.attachTo)),n._configureTrapFocus(),n._addStyles().then(function(){t(n)},e)},e)})},MdPanelRef.prototype._addStyles=function(){var n=this;return this._$q(function(t){n.panelContainer.css("z-index",n.config.zIndex),n.innerWrapper.css("z-index",n.config.zIndex+1);function e(){n._setTheming(),n.panelEl.removeClass("_md-panel-offscreen"),n.innerWrapper.removeClass("_md-panel-offscreen"),n.panelContainer.addClass(MD_PANEL_HIDDEN),t(n)}if(n.config.fullscreen)return n.panelEl.addClass("_md-panel-fullscreen"),void e();n.config.position?n._$rootScope.$$postDigest(function(){n._updatePosition(!0),n._setTheming(),t(n)}):e()})},MdPanelRef.prototype._setTheming=function(){this._$mdTheming(this.panelEl),this._$mdTheming(this.panelContainer)},MdPanelRef.prototype.updatePosition=function(t){if(!this.panelContainer)throw new Error("mdPanel: Panel does not exist yet. Call open() or attach().");this.config.position=t,this._updatePosition()},MdPanelRef.prototype._updatePosition=function(t){var e=this.config.position;e&&(e._setPanelPosition(this.innerWrapper),t&&(this.panelEl.removeClass("_md-panel-offscreen"),this.innerWrapper.removeClass("_md-panel-offscreen"),this.panelContainer.addClass(MD_PANEL_HIDDEN)),this.innerWrapper.css(MdPanelPosition.absPosition.TOP,e.getTop()),this.innerWrapper.css(MdPanelPosition.absPosition.BOTTOM,e.getBottom()),this.innerWrapper.css(MdPanelPosition.absPosition.LEFT,e.getLeft()),this.innerWrapper.css(MdPanelPosition.absPosition.RIGHT,e.getRight()))},MdPanelRef.prototype._focusOnOpen=function(){if(this.config.focusOnOpen){var t=this;this._$rootScope.$$postDigest(function(){(t._$mdUtil.findFocusTarget(t.panelEl)||t.panelEl).focus()})}},MdPanelRef.prototype._createBackdrop=function(){if(this.config.hasBackdrop){if(!this._backdropRef){var t=this._$mdPanel.newPanelAnimation().openFrom(this.config.attachTo).withAnimation({open:"_md-opaque-enter",close:"_md-opaque-leave"});this.config.animation&&t.duration(this.config.animation._rawDuration);var e={animation:t,attachTo:this.config.attachTo,focusOnOpen:!1,panelClass:"_md-panel-backdrop",zIndex:this.config.zIndex-1};this._backdropRef=this._$mdPanel.create(e)}if(!this._backdropRef.isAttached)return this._backdropRef.attach()}},MdPanelRef.prototype._addEventListeners=function(){this._configureEscapeToClose(),this._configureClickOutsideToClose(),this._configureScrollListener()},MdPanelRef.prototype._removeEventListeners=function(){this._removeListeners&&this._removeListeners.forEach(function(t){t()}),this._removeListeners=[]},MdPanelRef.prototype._configureEscapeToClose=function(){if(this.config.escapeToClose){function t(t){t.keyCode===n._$mdConstant.KEY_CODE.ESCAPE&&(t.stopPropagation(),t.preventDefault(),n.close(MdPanelRef.closeReasons.ESCAPE))}var e=getElement(this.config.attachTo),n=this;this.panelContainer.on("keydown",t),e.on("keydown",t),this._removeListeners.push(function(){n.panelContainer.off("keydown",t),e.off("keydown",t)})}},MdPanelRef.prototype._configureClickOutsideToClose=function(){if(this.config.clickOutsideToClose){function t(t){n=t.target}function e(t){i.config.propagateContainerEvents?n===i.panelEl[0]||i.panelEl[0].contains(n)||i.close():n===o[0]&&t.target===o[0]&&(t.stopPropagation(),t.preventDefault(),i.close(MdPanelRef.closeReasons.CLICK_OUTSIDE))}var n,o=this.config.propagateContainerEvents?angular.element(document.body):this.panelContainer,i=this;o.on("mousedown",t),o.on("mouseup",e),this._removeListeners.push(function(){o.off("mousedown",t),o.off("mouseup",e)})}},MdPanelRef.prototype._configureScrollListener=function(){if(!this.config.disableParentScroll){function t(){n()}var e=angular.bind(this,this._updatePosition),n=this._$$rAF.throttle(e),o=this;this._$window.addEventListener("scroll",t,!0),this._removeListeners.push(function(){o._$window.removeEventListener("scroll",t,!0)})}},MdPanelRef.prototype._configureTrapFocus=function(){if(this.panelEl.attr("tabIndex","-1"),this.config.trapFocus){var t=this.panelEl;this._topFocusTrap=FOCUS_TRAP_TEMPLATE.clone()[0],this._bottomFocusTrap=FOCUS_TRAP_TEMPLATE.clone()[0];function e(){t.focus()}this._topFocusTrap.addEventListener("focus",e),this._bottomFocusTrap.addEventListener("focus",e),this._removeListeners.push(this._simpleBind(function(){this._topFocusTrap.removeEventListener("focus",e),this._bottomFocusTrap.removeEventListener("focus",e)},this)),t[0].parentNode.insertBefore(this._topFocusTrap,t[0]),t.after(this._bottomFocusTrap)}},MdPanelRef.prototype.updateAnimation=function(t){this.config.animation=t,this._backdropRef&&this._backdropRef.config.animation.duration(t._rawDuration)},MdPanelRef.prototype._animateOpen=function(){this.panelContainer.addClass("md-panel-is-showing");var n=this.config.animation;if(!n)return this.panelContainer.addClass("_md-panel-shown"),this._$q.when(this);var o=this;return this._$q(function(t){var e=o._done(t,o);n.animateOpen(o.panelEl).then(e,function(){o._$log.warn("mdPanel: MdPanel Animations failed. Showing panel without animating."),e()})})},MdPanelRef.prototype._animateClose=function(){var n=this,o=this.config.animation;return o?this._$q(function(t){function e(){n.panelContainer.removeClass("md-panel-is-showing"),n.panelEl.css("transform",""),t(n)}o.animateClose(n.panelEl).then(e,function(){n._$log.warn("mdPanel: MdPanel Animations failed. Hiding panel without animating."),e()})}):(this.panelContainer.removeClass("md-panel-is-showing"),this.panelContainer.removeClass("_md-panel-shown"),this._$q.when(this))},MdPanelRef.prototype.registerInterceptor=function(t,e){var n=null;if(angular.isString(t)?angular.isFunction(e)||(n="Interceptor callback must be a function, instead got "+typeof e):n="Interceptor type must be a string, instead got "+typeof t,n)throw new Error("MdPanel: "+n);var o=this._interceptors[t]=this._interceptors[t]||[];return-1===o.indexOf(e)&&o.push(e),this},MdPanelRef.prototype.removeInterceptor=function(t,e){var n=this._interceptors[t]?this._interceptors[t].indexOf(e):-1;return-1<n&&this._interceptors[t].splice(n,1),this},MdPanelRef.prototype.removeAllInterceptors=function(t){return t?this._interceptors[t]=[]:this._interceptors=Object.create(null),this},MdPanelRef.prototype._callInterceptors=function(t){var o=this,i=o._$q;return(o._interceptors&&o._interceptors[t]||[]).reduceRight(function(t,e){var n=e&&angular.isFunction(e.then)?e:null;return t.then(function(){if(!n)try{n=e(o)}catch(t){n=i.reject(t)}return n})},i.resolve(o))},MdPanelRef.prototype._simpleBind=function(e,n){return function(t){return e.apply(n,t)}},MdPanelRef.prototype._done=function(t,e){return function(){t(e)}},MdPanelRef.prototype.addToGroup=function(t){this._$mdPanel._groups[t]||this._$mdPanel.newPanelGroup(t);var e=this._$mdPanel._groups[t];e.panels.indexOf(this)<0&&e.panels.push(this)},MdPanelRef.prototype.removeFromGroup=function(t){if(!this._$mdPanel._groups[t])throw new Error("mdPanel: The group "+t+" does not exist.");var e=this._$mdPanel._groups[t],n=e.panels.indexOf(this);-1<n&&e.panels.splice(n,1)},MdPanelRef.closeReasons={CLICK_OUTSIDE:"clickOutsideToClose",ESCAPE:"escapeToClose"},MdPanelPosition.xPosition={CENTER:"center",ALIGN_START:"align-start",ALIGN_END:"align-end",OFFSET_START:"offset-start",OFFSET_END:"offset-end"},MdPanelPosition.yPosition={CENTER:"center",ALIGN_TOPS:"align-tops",ALIGN_BOTTOMS:"align-bottoms",ABOVE:"above",BELOW:"below"},MdPanelPosition.absPosition={TOP:"top",RIGHT:"right",BOTTOM:"bottom",LEFT:"left"},MdPanelPosition.viewportMargin=8,MdPanelPosition.prototype.absolute=function(){return this._absolute=!0,this},MdPanelPosition.prototype._setPosition=function(t,e){if(t===MdPanelPosition.absPosition.RIGHT||t===MdPanelPosition.absPosition.LEFT)this._left=this._right="";else{if(t!==MdPanelPosition.absPosition.BOTTOM&&t!==MdPanelPosition.absPosition.TOP){var n=Object.keys(MdPanelPosition.absPosition).join().toLowerCase();throw new Error("mdPanel: Position must be one of "+n+".")}this._top=this._bottom=""}return this["_"+t]=angular.isString(e)?e:"0",this},MdPanelPosition.prototype.top=function(t){return this._setPosition(MdPanelPosition.absPosition.TOP,t)},MdPanelPosition.prototype.bottom=function(t){return this._setPosition(MdPanelPosition.absPosition.BOTTOM,t)},MdPanelPosition.prototype.start=function(t){var e=this._isRTL?MdPanelPosition.absPosition.RIGHT:MdPanelPosition.absPosition.LEFT;return this._setPosition(e,t)},MdPanelPosition.prototype.end=function(t){var e=this._isRTL?MdPanelPosition.absPosition.LEFT:MdPanelPosition.absPosition.RIGHT;return this._setPosition(e,t)},MdPanelPosition.prototype.left=function(t){return this._setPosition(MdPanelPosition.absPosition.LEFT,t)},MdPanelPosition.prototype.right=function(t){return this._setPosition(MdPanelPosition.absPosition.RIGHT,t)},MdPanelPosition.prototype.centerHorizontally=function(){return this._left="50%",this._right="",this._translateX=["-50%"],this},MdPanelPosition.prototype.centerVertically=function(){return this._top="50%",this._bottom="",this._translateY=["-50%"],this},MdPanelPosition.prototype.center=function(){return this.centerHorizontally().centerVertically()},MdPanelPosition.prototype.relativeTo=function(t){return this._absolute=!1,this._relativeToEl=getElement(t),this},MdPanelPosition.prototype.addPanelPosition=function(t,e){if(!this._relativeToEl)throw new Error("mdPanel: addPanelPosition can only be used with relative positioning. Set relativeTo first.");return validatePosition(MdPanelPosition.xPosition,t),validatePosition(MdPanelPosition.yPosition,e),this._positions.push({x:t,y:e}),this},MdPanelPosition.prototype.withOffsetX=function(t){return this._translateX.push(addUnits(t)),this},MdPanelPosition.prototype.withOffsetY=function(t){return this._translateY.push(addUnits(t)),this},MdPanelPosition.prototype.getTop=function(){return this._top},MdPanelPosition.prototype.getBottom=function(){return this._bottom},MdPanelPosition.prototype.getLeft=function(){return this._left},MdPanelPosition.prototype.getRight=function(){return this._right},MdPanelPosition.prototype.getTransform=function(){return(this._reduceTranslateValues("translateX",this._translateX)+" "+this._reduceTranslateValues("translateY",this._translateY)).trim()},MdPanelPosition.prototype._setTransform=function(t){return t.css(this._$mdConstant.CSS.TRANSFORM,this.getTransform())},MdPanelPosition.prototype._isOnscreen=function(t){var e=parseInt(this.getLeft()),n=parseInt(this.getTop());if(this._translateX.length||this._translateY.length){var o=getComputedTranslations(t,this._$mdConstant.CSS.TRANSFORM);e+=o.x,n+=o.y}var i=e+t[0].offsetWidth,a=n+t[0].offsetHeight;return 0<=e&&0<=n&&a<=this._$window.innerHeight&&i<=this._$window.innerWidth},MdPanelPosition.prototype.getActualPosition=function(){return this._actualPosition},MdPanelPosition.prototype._reduceTranslateValues=function(n,t){return t.map(function(t){var e=angular.isFunction(t)?addUnits(t(this)):t;return n+"("+e+")"},this).join(" ")},MdPanelPosition.prototype._setPanelPosition=function(t){if(t.removeClass("_md-panel-position-adjusted"),this._absolute)this._setTransform(t);else{if(this._actualPosition)return this._calculatePanelPosition(t,this._actualPosition),this._setTransform(t),void this._constrainToViewport(t);for(var e=0;e<this._positions.length;e++)if(this._actualPosition=this._positions[e],this._calculatePanelPosition(t,this._actualPosition),this._setTransform(t),this._isOnscreen(t))return;this._constrainToViewport(t)}},MdPanelPosition.prototype._constrainToViewport=function(t){var e=MdPanelPosition.viewportMargin,n=this._top,o=this._left;if(this.getTop()){var i=parseInt(this.getTop()),a=t[0].offsetHeight+i,s=this._$window.innerHeight;i<e?this._top=e+"px":s<a&&(this._top=i-(a-s+e)+"px")}if(this.getLeft()){var r=parseInt(this.getLeft()),l=t[0].offsetWidth+r,p=this._$window.innerWidth;r<e?this._left=e+"px":p<l&&(this._left=r-(l-p+e)+"px")}t.toggleClass("_md-panel-position-adjusted",this._top!==n||this._left!==o)},MdPanelPosition.prototype._reverseXPosition=function(t){if(t===MdPanelPosition.xPosition.CENTER)return t;var e="start";return-1<t.indexOf(e)?t.replace(e,"end"):t.replace("end",e)},MdPanelPosition.prototype._bidi=function(t){return this._isRTL?this._reverseXPosition(t):t},MdPanelPosition.prototype._calculatePanelPosition=function(t,e){var n=t[0].getBoundingClientRect(),o=Math.max(n.width,t[0].clientWidth),i=Math.max(n.height,t[0].clientHeight),a=this._relativeToEl[0].getBoundingClientRect(),s=a.left,r=a.right,l=a.width;switch(this._bidi(e.x)){case MdPanelPosition.xPosition.OFFSET_START:this._left=s-o+"px";break;case MdPanelPosition.xPosition.ALIGN_END:this._left=r-o+"px";break;case MdPanelPosition.xPosition.CENTER:var p=s+.5*l-.5*o;this._left=p+"px";break;case MdPanelPosition.xPosition.ALIGN_START:this._left=s+"px";break;case MdPanelPosition.xPosition.OFFSET_END:this._left=r+"px"}var c=a.top,h=a.bottom,d=a.height;switch(e.y){case MdPanelPosition.yPosition.ABOVE:this._top=c-i+"px";break;case MdPanelPosition.yPosition.ALIGN_BOTTOMS:this._top=h-i+"px";break;case MdPanelPosition.yPosition.CENTER:var u=c+.5*d-.5*i;this._top=u+"px";break;case MdPanelPosition.yPosition.ALIGN_TOPS:this._top=c+"px";break;case MdPanelPosition.yPosition.BELOW:this._top=h+"px"}},MdPanelAnimation.animation={SLIDE:"md-panel-animate-slide",SCALE:"md-panel-animate-scale",FADE:"md-panel-animate-fade"},MdPanelAnimation.prototype.openFrom=function(t){return t=t.target?t.target:t,this._openFrom=this._getPanelAnimationTarget(t),this._closeTo||(this._closeTo=this._openFrom),this},MdPanelAnimation.prototype.closeTo=function(t){return this._closeTo=this._getPanelAnimationTarget(t),this},MdPanelAnimation.prototype.duration=function(t){return t&&(angular.isNumber(t)?this._openDuration=this._closeDuration=e(t):angular.isObject(t)&&(this._openDuration=e(t.open),this._closeDuration=e(t.close))),this._rawDuration=t,this;function e(t){if(angular.isNumber(t))return t/1e3}},MdPanelAnimation.prototype._getPanelAnimationTarget=function(t){return angular.isDefined(t.top)||angular.isDefined(t.left)?{element:void 0,bounds:{top:t.top||0,left:t.left||0}}:this._getBoundingClientRect(getElement(t))},MdPanelAnimation.prototype.withAnimation=function(t){return this._animationClass=t,this},MdPanelAnimation.prototype.animateOpen=function(t){var e=this._$mdUtil.dom.animator;this._fixBounds(t);var n={},o=t[0].style.transform||"",i=e.toTransformCss(o),a=e.toTransformCss(o);switch(this._animationClass){case MdPanelAnimation.animation.SLIDE:t.css("opacity","1"),n={transitionInClass:"_md-panel-animate-enter",transitionOutClass:"_md-panel-animate-leave"};var s=e.calculateSlideToOrigin(t,this._openFrom)||"";i=e.toTransformCss(s+" "+o);break;case MdPanelAnimation.animation.SCALE:n={transitionInClass:"_md-panel-animate-enter"};var r=e.calculateZoomToOrigin(t,this._openFrom)||"";i=e.toTransformCss(o+" "+r);break;case MdPanelAnimation.animation.FADE:n={transitionInClass:"_md-panel-animate-enter"};break;default:n=angular.isString(this._animationClass)?{transitionInClass:this._animationClass}:{transitionInClass:this._animationClass.open,transitionOutClass:this._animationClass.close}}return n.duration=this._openDuration,e.translate3d(t,i,a,n)},MdPanelAnimation.prototype.animateClose=function(t){var e=this._$mdUtil.dom.animator,n={},o=t[0].style.transform||"",i=e.toTransformCss(o),a=e.toTransformCss(o);switch(this._animationClass){case MdPanelAnimation.animation.SLIDE:t.css("opacity","1"),n={transitionInClass:"_md-panel-animate-leave",transitionOutClass:"_md-panel-animate-enter _md-panel-animate-leave"};var s=e.calculateSlideToOrigin(t,this._closeTo)||"";a=e.toTransformCss(s+" "+o);break;case MdPanelAnimation.animation.SCALE:n={transitionInClass:"_md-panel-animate-scale-out _md-panel-animate-leave",transitionOutClass:"_md-panel-animate-scale-out _md-panel-animate-enter _md-panel-animate-leave"};var r=e.calculateZoomToOrigin(t,this._closeTo)||"";a=e.toTransformCss(o+" "+r);break;case MdPanelAnimation.animation.FADE:n={transitionInClass:"_md-panel-animate-fade-out _md-panel-animate-leave",transitionOutClass:"_md-panel-animate-fade-out _md-panel-animate-enter _md-panel-animate-leave"};break;default:n=angular.isString(this._animationClass)?{transitionOutClass:this._animationClass}:{transitionInClass:this._animationClass.close,transitionOutClass:this._animationClass.open}}return n.duration=this._closeDuration,e.translate3d(t,i,a,n)},MdPanelAnimation.prototype._fixBounds=function(t){var e=t[0].offsetWidth,n=t[0].offsetHeight;this._openFrom&&null==this._openFrom.bounds.height&&(this._openFrom.bounds.height=n),this._openFrom&&null==this._openFrom.bounds.width&&(this._openFrom.bounds.width=e),this._closeTo&&null==this._closeTo.bounds.height&&(this._closeTo.bounds.height=n),this._closeTo&&null==this._closeTo.bounds.width&&(this._closeTo.bounds.width=e)},MdPanelAnimation.prototype._getBoundingClientRect=function(t){if(t instanceof angular.element)return{element:t,bounds:t[0].getBoundingClientRect()}},ngmaterial.components.panel=angular.module("material.components.panel");