/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.3-master-625adc5
 */
!function(g,D,C){"use strict";function t(t,e){var s=t('<md-icon md-svg-src="'+e.mdTabsArrow+'"></md-icon>')({})[0];return{require:["^^mdCalendar","^^mdCalendarMonth","mdCalendarMonthBody"],scope:{offset:"=mdMonthOffset"},controller:a,controllerAs:"mdMonthBodyCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.monthCtrl=r,l.arrowIcon=s.cloneNode(!0),t.$watch(function(){return l.offset},function(t){D.isNumber(t)&&l.generateContent()})}}}function a(t,e,a){this.$element=t,this.dateUtil=e,this.dateLocale=a,this.monthCtrl=null,this.calendarCtrl=null,this.offset=null,this.focusAfterAppend=null}function e(t,e,a){this.$element=t,this.dateUtil=e,this.dateLocale=a,this.calendarCtrl=null,this.yearCtrl=null,this.offset=null,this.focusAfterAppend=null}D.module("material.components.datepicker",["material.core","material.components.icon","material.components.virtualRepeat"]),function(){function t(r){return{template:function(t,e){return'<div ng-switch="calendarCtrl.currentView" '+(e.hasOwnProperty("ngIf")?"":'ng-if="calendarCtrl.isInitialized"')+'><md-calendar-year ng-switch-when="year"></md-calendar-year><md-calendar-month ng-switch-default></md-calendar-month></div>'},scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",dateFilter:"=mdDateFilter",monthFilter:"=mdMonthFilter",_mode:"@mdMode",_currentView:"@mdCurrentView"},require:["ngModel","mdCalendar"],controller:a,controllerAs:"calendarCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0];n[1].configureNgModel(i,r)}}}a.$inject=["$element","$scope","$$mdDateUtil","$mdUtil","$mdConstant","$mdTheming","$$rAF","$attrs","$mdDateLocale","$filter","$document"],t.$inject=["inputDirective"],D.module("material.components.datepicker").directive("mdCalendar",t);var m=0,e={day:"month",month:"year"};function a(t,e,a,n,i,r,l,s,d,o,c){r(t),this.$element=t,this.$scope=e,this.$attrs=s,this.dateUtil=a,this.$mdUtil=n,this.keyCode=i.KEY_CODE,this.$$rAF=l,this.$mdDateLocale=d,this.ngDateFilter=o("date"),this.today=this.dateUtil.createDateAtMidnight(),this.ngModelCtrl=C,this.SELECTED_DATE_CLASS="md-calendar-selected-date",this.TODAY_CLASS="md-calendar-date-today",this.FOCUSED_DATE_CLASS="md-focus",this.id=m++,this.displayDate=null,this.mode=null,this.selectedDate=null,this.firstRenderableDate=null,this.lastRenderableDate=null,this.isInitialized=!1,this.width=0,this.scrollbarWidth=0,this.standaloneMode=!1,s.tabindex||t.attr("tabindex","-1");var h,u=D.bind(this,this.handleKeyEvent);(h=t.parent().hasClass("md-datepicker-calendar")?D.element(c[0].body):(this.standaloneMode=!0,t)).on("keydown",u),e.$on("$destroy",function(){h.off("keydown",u)}),1===D.version.major&&D.version.minor<=4&&this.$onInit()}a.prototype.$onInit=function(){this._mode&&e.hasOwnProperty(this._mode)?(this.currentView=e[this._mode],this.mode=this._mode):(this.currentView=this._currentView||"month",this.mode=null),this.minDate&&this.minDate>this.$mdDateLocale.firstRenderableDate?this.firstRenderableDate=this.minDate:this.firstRenderableDate=this.$mdDateLocale.firstRenderableDate,this.maxDate&&this.maxDate<this.$mdDateLocale.lastRenderableDate?this.lastRenderableDate=this.maxDate:this.lastRenderableDate=this.$mdDateLocale.lastRenderableDate},a.prototype.configureNgModel=function(t,e){var a=this;a.ngModelCtrl=t,this.$attrs.$set("type","date"),e[0].link.pre(this.$scope,{on:D.noop,val:D.noop,0:{}},this.$attrs,[t]),t.$render=function(){var t,e=this.$viewValue;a.dateUtil.isValidDate(e)||(t=a.dateUtil.removeLocalTzAndReparseDate(new Date(e)),a.dateUtil.isValidDate(t)&&(e=t)),a.$scope.$broadcast("md-calendar-parent-changed",e),a.selectedDate||(a.selectedDate=e),a.displayDate||(a.displayDate=a.selectedDate||a.today)},a.$mdUtil.nextTick(function(){a.isInitialized=!0})},a.prototype.setNgModelValue=function(t){var e=this.$mdUtil.getModelOption(this.ngModelCtrl,"timezone"),a=this.dateUtil.createDateAtMidnight(t);return this.focusDate(a),this.$scope.$emit("md-calendar-change",a),null==e||a.getTimezoneOffset()<0?this.ngModelCtrl.$setViewValue(this.ngDateFilter(a,"yyyy-MM-dd"),"default"):this.ngModelCtrl.$setViewValue(this.ngDateFilter(a,"yyyy-MM-dd",e),"default"),this.ngModelCtrl.$render(),a},a.prototype.setCurrentView=function(t,e){var a=this;a.$mdUtil.nextTick(function(){a.currentView=t,e&&(a.displayDate=D.isDate(e)?e:new Date(e))})},a.prototype.focusDate=function(t){if(this.dateUtil.isValidDate(t)){var e=this.$element[0].querySelector("."+this.FOCUSED_DATE_CLASS);e&&e.classList.remove(this.FOCUSED_DATE_CLASS);var a=this.getDateId(t,this.currentView),n=document.getElementById(a);n&&(n.classList.add(this.FOCUSED_DATE_CLASS),n.focus(),this.displayDate=t)}else{var i=this.$element[0].querySelector("[ng-switch]");i&&i.focus()}},a.prototype.changeSelectedDate=function(t){var e=this.SELECTED_DATE_CLASS,a=this.$element[0].querySelector("."+e);if(a&&(a.classList.remove(e),a.setAttribute("aria-selected","false")),t){var n=document.getElementById(this.getDateId(t,this.currentView));n&&(n.classList.add(e),n.setAttribute("aria-selected","true"))}this.selectedDate=t},a.prototype.getActionFromKeyEvent=function(t){var e=this.keyCode;switch(t.which){case e.ENTER:return"select";case e.RIGHT_ARROW:return"move-right";case e.LEFT_ARROW:return"move-left";case e.DOWN_ARROW:return t.metaKey?"move-page-down":"move-row-down";case e.UP_ARROW:return t.metaKey?"move-page-up":"move-row-up";case e.PAGE_DOWN:return"move-page-down";case e.PAGE_UP:return"move-page-up";case e.HOME:return"start";case e.END:return"end";default:return null}},a.prototype.handleKeyEvent=function(e){var a=this;this.$scope.$apply(function(){if(e.which===a.keyCode.ESCAPE||e.which===a.keyCode.TAB&&!a.standaloneMode)return a.$scope.$emit("md-calendar-close"),void(e.which===a.keyCode.TAB&&e.preventDefault());if(e.which!==a.keyCode.TAB||!a.standaloneMode){var t=a.getActionFromKeyEvent(e);t&&(e.preventDefault(),e.stopPropagation(),a.$scope.$broadcast("md-calendar-parent-action",t))}})},a.prototype.hideVerticalScrollbar=function(n){var i=this,e=n.$element[0],r=e.querySelector(".md-calendar-scroll-mask");function a(){var t=i.width||340,e=i.scrollbarWidth,a=n.calendarScroller;r.style.width=t+"px",a.style.width=t+e+"px",a.style.paddingRight=e+"px"}0<i.width?a():i.$$rAF(function(){var t=n.calendarScroller;i.scrollbarWidth=t.offsetWidth-t.clientWidth,i.width=e.querySelector("table").offsetWidth,a()})},a.prototype.getDateId=function(t,e){if(!e)throw new Error("A namespace for the date id has to be specified.");return["md",this.id,e,t.getFullYear(),t.getMonth(),t.getDate()].join("-")},a.prototype.updateVirtualRepeat=function(){var t=this.$scope,e=t.$on("$md-resize-enable",function(){t.$$phase||t.$apply(),e()})}}(),function(){e.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$mdDateLocale"],D.module("material.components.datepicker").directive("mdCalendarMonth",function(){return{template:'<table aria-hidden="true" class="md-calendar-day-header"><thead></thead></table><div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container" md-offset-size="'+(t-a)+'"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-month-body role="rowgroup" md-virtual-repeat="i in monthCtrl.items" md-month-offset="$index" class="md-calendar-month" md-start-index="monthCtrl.getSelectedMonthIndex()" md-item-size="'+a+'"><tr aria-hidden="true" md-force-height="\''+a+"px'\"></tr></tbody></table></md-virtual-repeat-container></div>",require:["^^mdCalendar","mdCalendarMonth"],controller:e,controllerAs:"monthCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0];n[1].initialize(i)}}});var a=265,t=45;function e(t,e,a,n,i,r){this.$element=t,this.$scope=e,this.$animate=a,this.$q=n,this.dateUtil=i,this.dateLocale=r,this.calendarScroller=t[0].querySelector(".md-virtual-repeat-scroller"),this.isInitialized=!1,this.isMonthTransitionInProgress=!1;var l=this;this.cellClickHandler=function(){var t=i.getTimestampFromNode(this);l.$scope.$apply(function(){l.calendarCtrl.setNgModelValue(new Date(t))})},this.headerClickHandler=function(){l.calendarCtrl.setCurrentView("year",i.getTimestampFromNode(this))}}e.prototype.initialize=function(t){this.items={length:this.dateUtil.getMonthDistance(t.firstRenderableDate,t.lastRenderableDate)+2},this.calendarCtrl=t,this.attachScopeListeners(),t.updateVirtualRepeat(),t.ngModelCtrl&&t.ngModelCtrl.$render()},e.prototype.getSelectedMonthIndex=function(){var t=this.calendarCtrl;return this.dateUtil.getMonthDistance(t.firstRenderableDate,t.displayDate||t.selectedDate||t.today)},e.prototype.changeDisplayDate=function(t){if(!this.isInitialized)return this.buildWeekHeader(),this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(!this.dateUtil.isValidDate(t)||this.isMonthTransitionInProgress)return this.$q.when();this.isMonthTransitionInProgress=!0;var e=this.animateDateChange(t);this.calendarCtrl.displayDate=t;var a=this;return e.then(function(){a.isMonthTransitionInProgress=!1}),e},e.prototype.animateDateChange=function(t){if(this.dateUtil.isValidDate(t)){var e=this.dateUtil.getMonthDistance(this.calendarCtrl.firstRenderableDate,t);this.calendarScroller.scrollTop=e*a}return this.$q.when()},e.prototype.buildWeekHeader=function(){for(var t=this.dateLocale.firstDayOfWeek,e=this.dateLocale.shortDays,a=document.createElement("tr"),n=0;n<7;n++){var i=document.createElement("th");i.textContent=e[(n+t)%7],a.appendChild(i)}this.$element.find("thead").append(a)},e.prototype.attachScopeListeners=function(){var a=this;a.$scope.$on("md-calendar-parent-changed",function(t,e){a.calendarCtrl.changeSelectedDate(e),a.changeDisplayDate(e)}),a.$scope.$on("md-calendar-parent-action",D.bind(this,this.handleKeyEvent))},e.prototype.handleKeyEvent=function(t,e){var a=this.calendarCtrl,n=a.displayDate;if("select"===e)a.setNgModelValue(n);else{var i=null,r=this.dateUtil;switch(e){case"move-right":i=r.incrementDays(n,1);break;case"move-left":i=r.incrementDays(n,-1);break;case"move-page-down":i=r.incrementMonths(n,1);break;case"move-page-up":i=r.incrementMonths(n,-1);break;case"move-row-down":i=r.incrementDays(n,7);break;case"move-row-up":i=r.incrementDays(n,-7);break;case"start":i=r.getFirstDateOfMonth(n);break;case"end":i=r.getLastDateOfMonth(n)}i&&(i=this.dateUtil.clampDate(i,a.minDate,a.maxDate),this.changeDisplayDate(i).then(function(){a.focusDate(i)}))}}}(),t.$inject=["$compile","$$mdSvgRegistry"],a.$inject=["$element","$$mdDateUtil","$mdDateLocale"],D.module("material.components.datepicker").directive("mdCalendarMonthBody",t),a.prototype.generateContent=function(){var t=this.dateUtil.incrementMonths(this.calendarCtrl.firstRenderableDate,this.offset);this.$element.empty().append(this.buildCalendarForMonth(t)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend=null)},a.prototype.buildDateCell=function(t){var e=this.monthCtrl,a=this.calendarCtrl,n=document.createElement("td");if(n.tabIndex=-1,n.classList.add("md-calendar-date"),n.setAttribute("role","gridcell"),t){n.setAttribute("tabindex","-1"),n.setAttribute("aria-label",this.dateLocale.longDateFormatter(t)),n.id=a.getDateId(t,"month"),n.setAttribute("data-timestamp",t.getTime()),this.dateUtil.isSameDay(t,a.today)&&n.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameDay(t,a.selectedDate)&&(n.classList.add(a.SELECTED_DATE_CLASS),n.setAttribute("aria-selected","true"));var i=this.dateLocale.dates[t.getDate()];if(this.isDateEnabled(t)){var r=document.createElement("span");r.classList.add("md-calendar-date-selection-indicator"),r.textContent=i,n.appendChild(r),n.addEventListener("click",e.cellClickHandler),a.displayDate&&this.dateUtil.isSameDay(t,a.displayDate)&&(this.focusAfterAppend=n)}else n.classList.add("md-calendar-date-disabled"),n.textContent=i}return n},a.prototype.isDateEnabled=function(t){return this.dateUtil.isDateWithinRange(t,this.calendarCtrl.minDate,this.calendarCtrl.maxDate)&&(!D.isFunction(this.calendarCtrl.dateFilter)||this.calendarCtrl.dateFilter(t))},a.prototype.buildDateRow=function(t){var e=document.createElement("tr");return e.setAttribute("role","row"),e.setAttribute("aria-label",this.dateLocale.weekNumberFormatter(t)),e},a.prototype.buildCalendarForMonth=function(t){var e=this.dateUtil.isValidDate(t)?t:new Date,a=this.dateUtil.getFirstDateOfMonth(e),n=this.getLocaleDay_(a),i=this.dateUtil.getNumberOfDaysInMonth(e),r=document.createDocumentFragment(),l=1,s=this.buildDateRow(l);r.appendChild(s);var d=this.offset===this.monthCtrl.items.length-1,o=0,c=document.createElement("td"),h=document.createElement("span"),u=this.calendarCtrl;if(h.textContent=this.dateLocale.monthHeaderFormatter(e),c.appendChild(h),c.classList.add("md-calendar-month-label"),u.maxDate&&a>u.maxDate?c.classList.add("md-calendar-month-label-disabled"):u.mode||(c.addEventListener("click",this.monthCtrl.headerClickHandler),c.setAttribute("data-timestamp",a.getTime()),c.setAttribute("aria-label",this.dateLocale.monthFormatter(e)),c.classList.add("md-calendar-label-clickable"),c.appendChild(this.arrowIcon.cloneNode(!0))),n<=2){c.setAttribute("colspan","7");var m=this.buildDateRow();if(m.appendChild(c),r.insertBefore(m,s),d)return r}else o=3,c.setAttribute("colspan","3"),s.appendChild(c);for(var p=o;p<n;p++)s.appendChild(this.buildDateCell());for(var f=n,g=a,D=1;D<=i;D++){if(7===f){if(d)return r;f=0,l++,s=this.buildDateRow(l),r.appendChild(s)}g.setDate(D);var C=this.buildDateCell(g);s.appendChild(C),f++}for(;s.childNodes.length<7;)s.appendChild(this.buildDateCell());for(;r.childNodes.length<6;){for(var y=this.buildDateRow(),$=0;$<7;$++)y.appendChild(this.buildDateCell());r.appendChild(y)}return r},a.prototype.getLocaleDay_=function(t){return(t.getDay()+(7-this.dateLocale.firstDayOfWeek))%7},function(){t.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$mdUtil"],D.module("material.components.datepicker").directive("mdCalendarYear",function(){return{template:'<div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-year-body role="rowgroup" md-virtual-repeat="i in yearCtrl.items" md-year-offset="$index" class="md-calendar-year" md-start-index="yearCtrl.getFocusedYearIndex()" md-item-size="'+a+'"><tr aria-hidden="true" md-force-height="\''+a+"px'\"></tr></tbody></table></md-virtual-repeat-container></div>",require:["^^mdCalendar","mdCalendarYear"],controller:t,controllerAs:"yearCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0];n[1].initialize(i)}}});var a=88;function t(t,e,a,n,i,r){this.$element=t,this.$scope=e,this.$animate=a,this.$q=n,this.dateUtil=i,this.calendarScroller=t[0].querySelector(".md-virtual-repeat-scroller"),this.isInitialized=!1,this.isMonthTransitionInProgress=!1,this.$mdUtil=r;var l=this;this.cellClickHandler=function(){l.onTimestampSelected(i.getTimestampFromNode(this))}}t.prototype.initialize=function(t){this.items={length:this.dateUtil.getYearDistance(t.firstRenderableDate,t.lastRenderableDate)+1},this.calendarCtrl=t,this.attachScopeListeners(),t.updateVirtualRepeat(),t.ngModelCtrl&&t.ngModelCtrl.$render()},t.prototype.getFocusedYearIndex=function(){var t=this.calendarCtrl;return this.dateUtil.getYearDistance(t.firstRenderableDate,t.displayDate||t.selectedDate||t.today)},t.prototype.changeDate=function(t){if(!this.isInitialized)return this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(this.dateUtil.isValidDate(t)&&!this.isMonthTransitionInProgress){var e=this,a=this.animateDateChange(t);return e.isMonthTransitionInProgress=!0,e.calendarCtrl.displayDate=t,a.then(function(){e.isMonthTransitionInProgress=!1})}},t.prototype.animateDateChange=function(t){if(this.dateUtil.isValidDate(t)){var e=this.dateUtil.getYearDistance(this.calendarCtrl.firstRenderableDate,t);this.calendarScroller.scrollTop=e*a}return this.$q.when()},t.prototype.handleKeyEvent=function(t,e){var a=this,n=a.calendarCtrl,i=n.displayDate;if("select"===e)a.changeDate(i).then(function(){a.onTimestampSelected(i)});else{var r=null,l=a.dateUtil;switch(e){case"move-right":r=l.incrementMonths(i,1);break;case"move-left":r=l.incrementMonths(i,-1);break;case"move-row-down":r=l.incrementMonths(i,6);break;case"move-row-up":r=l.incrementMonths(i,-6)}if(r){var s=n.minDate?l.getFirstDateOfMonth(n.minDate):null,d=n.maxDate?l.getFirstDateOfMonth(n.maxDate):null;r=l.getFirstDateOfMonth(a.dateUtil.clampDate(r,s,d)),a.changeDate(r).then(function(){n.focusDate(r)})}}},t.prototype.attachScopeListeners=function(){var a=this;a.$scope.$on("md-calendar-parent-changed",function(t,e){a.calendarCtrl.changeSelectedDate(e?a.dateUtil.getFirstDateOfMonth(e):e),a.changeDate(e)}),a.$scope.$on("md-calendar-parent-action",D.bind(a,a.handleKeyEvent))},t.prototype.onTimestampSelected=function(t){var e=this.calendarCtrl;e.mode?this.$mdUtil.nextTick(function(){e.setNgModelValue(new Date(t))}):e.setCurrentView("month",t)}}(),e.$inject=["$element","$$mdDateUtil","$mdDateLocale"],D.module("material.components.datepicker").directive("mdCalendarYearBody",function(){return{require:["^^mdCalendar","^^mdCalendarYear","mdCalendarYearBody"],scope:{offset:"=mdYearOffset"},controller:e,controllerAs:"mdYearBodyCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.yearCtrl=r,t.$watch(function(){return l.offset},function(t){D.isNumber(t)&&l.generateContent()})}}}),e.prototype.generateContent=function(){var t=this.dateUtil.incrementYears(this.calendarCtrl.firstRenderableDate,this.offset);this.$element.empty().append(this.buildCalendarForYear(t)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend=null)},e.prototype.buildMonthCell=function(t,e){var a=this.calendarCtrl,n=this.yearCtrl,i=this.buildBlankCell(),r=new Date(t,e,1);i.setAttribute("aria-label",this.dateLocale.monthFormatter(r)),i.id=a.getDateId(r,"year"),i.setAttribute("data-timestamp",String(r.getTime())),this.dateUtil.isSameMonthAndYear(r,a.today)&&i.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameMonthAndYear(r,a.selectedDate)&&(i.classList.add(a.SELECTED_DATE_CLASS),i.setAttribute("aria-selected","true"));var l=this.dateLocale.shortMonths[e];if(!this.dateUtil.isMonthWithinRange(r,a.minDate,a.maxDate)||D.isFunction(a.monthFilter)&&!a.monthFilter(r))i.classList.add("md-calendar-date-disabled"),i.textContent=l;else{var s=document.createElement("span");s.classList.add("md-calendar-date-selection-indicator"),s.textContent=l,i.appendChild(s),i.addEventListener("click",n.cellClickHandler),a.displayDate&&this.dateUtil.isSameMonthAndYear(r,a.displayDate)&&(this.focusAfterAppend=i)}return i},e.prototype.buildBlankCell=function(){var t=document.createElement("td");return t.tabIndex=-1,t.classList.add("md-calendar-date"),t.setAttribute("role","gridcell"),t.setAttribute("tabindex","-1"),t},e.prototype.buildCalendarForYear=function(t){var e,a=t.getFullYear(),n=document.createDocumentFragment(),i=document.createElement("tr"),r=document.createElement("td");for(r.className="md-calendar-month-label",r.textContent=String(a),i.appendChild(r),e=0;e<6;e++)i.appendChild(this.buildMonthCell(a,e));n.appendChild(i);var l=document.createElement("tr");for(l.appendChild(this.buildBlankCell()),e=6;e<12;e++)l.appendChild(this.buildMonthCell(a,e));return n.appendChild(l),n},D.module("material.components.datepicker").config(["$provide",function(t){function e(){this.months=null,this.shortMonths=null,this.days=null,this.shortDays=null,this.dates=null,this.firstDayOfWeek=0,this.formatDate=null,this.parseDate=null,this.monthHeaderFormatter=null,this.weekNumberFormatter=null,this.longDateFormatter=null,this.isDateComplete=null,this.msgCalendar="",this.msgOpenCalendar=""}(e.prototype.$get=function(t,i){for(var e=t.DATETIME_FORMATS.SHORTDAY.map(function(t){return t.substring(0,1)}),a=Array(32),n=1;n<=31;n++)a[n]=n;var r=new Date(1880,0,1),l=new Date(r.getFullYear()+250,0,1),s={months:this.months||t.DATETIME_FORMATS.MONTH,shortMonths:this.shortMonths||t.DATETIME_FORMATS.SHORTMONTH,days:this.days||t.DATETIME_FORMATS.DAY,shortDays:this.shortDays||e,dates:this.dates||a,firstDayOfWeek:this.firstDayOfWeek||0,formatDate:this.formatDate||function(t,e){if(!t)return"";var a=t.toLocaleTimeString(),n=t;return 0!==t.getHours()||-1===a.indexOf("11:")&&-1===a.indexOf("23:")||(n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),1,0,0)),i("date")(n,"M/d/yyyy",e)},parseDate:this.parseDate||function(t){return new Date(t)},isDateComplete:this.isDateComplete||function(t){return t=t.trim(),/^(([a-zA-Z]{3,}|[0-9]{1,4})([ .,]+|[/-])){2}([a-zA-Z]{3,}|[0-9]{1,4})$/.test(t)},monthHeaderFormatter:this.monthHeaderFormatter||function(t){return s.shortMonths[t.getMonth()]+" "+t.getFullYear()},monthFormatter:this.monthFormatter||function(t){return s.months[t.getMonth()]+" "+t.getFullYear()},weekNumberFormatter:this.weekNumberFormatter||function(t){return"Week "+t},longDateFormatter:this.longDateFormatter||function(t){return[s.days[t.getDay()],s.months[t.getMonth()],s.dates[t.getDate()],t.getFullYear()].join(" ")},msgCalendar:this.msgCalendar||"Calendar",msgOpenCalendar:this.msgOpenCalendar||"Open calendar",firstRenderableDate:this.firstRenderableDate||r,lastRenderableDate:this.lastRenderableDate||l};return s}).$inject=["$locale","$filter"],t.provider("$mdDateLocale",new e)}]),D.module("material.components.datepicker").factory("$$mdDateUtil",["$mdDateLocale",function(n){return{getFirstDateOfMonth:a,getNumberOfDaysInMonth:i,getDateInNextMonth:r,getDateInPreviousMonth:l,isInNextMonth:function(t,e){return s(r(t),e)},isInPreviousMonth:function(t,e){var a=l(t);return s(e,a)},getDateMidpoint:function(t,e){return h((t.getTime()+e.getTime())/2)},isSameMonthAndYear:s,getWeekOfMonth:function(t){var e=a(t);return Math.floor((e.getDay()+t.getDate()-1)/7)},incrementDays:function(t,e){return new Date(t.getFullYear(),t.getMonth(),t.getDate()+e)},incrementMonths:d,getLastDateOfMonth:function(t){return new Date(t.getFullYear(),t.getMonth(),i(t))},isSameDay:function(t,e){return t.getDate()==e.getDate()&&s(t,e)},getMonthDistance:function(t,e){return 12*(e.getFullYear()-t.getFullYear())+(e.getMonth()-t.getMonth())},isValidDate:o,setDateTimeToMidnight:c,createDateAtMidnight:h,isDateWithinRange:function(t,e,a){var n=h(t),i=o(e)?h(e):null,r=o(a)?h(a):null;return(!i||i<=n)&&(!r||n<=r)},incrementYears:function(t,e){return d(t,12*e)},getYearDistance:function(t,e){return e.getFullYear()-t.getFullYear()},clampDate:function(t,e,a){var n=t;return e&&t<e&&(n=new Date(e.getTime())),a&&a<t&&(n=new Date(a.getTime())),n},getTimestampFromNode:function(t){if(t&&t.hasAttribute("data-timestamp"))return Number(t.getAttribute("data-timestamp"))},isMonthWithinRange:function(t,e,a){var n=t.getMonth(),i=t.getFullYear();return(!e||e.getFullYear()<i||e.getMonth()<=n)&&(!a||a.getFullYear()>i||a.getMonth()>=n)},removeLocalTzAndReparseDate:function(t){var e,a;return e=new Date(t.getTime()+6e4*t.getTimezoneOffset()),a=n.formatDate(e),n.parseDate(a)}};function a(t){return new Date(t.getFullYear(),t.getMonth(),1)}function i(t){return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()}function r(t){return new Date(t.getFullYear(),t.getMonth()+1,1)}function l(t){return new Date(t.getFullYear(),t.getMonth()-1,1)}function s(t,e){return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth()}function d(t,e){var a=new Date(t.getFullYear(),t.getMonth()+e,1),n=i(a);return n<t.getDate()?a.setDate(n):a.setDate(t.getDate()),a}function o(t){return t&&t.getTime&&!isNaN(t.getTime())}function c(t){o(t)&&t.setHours(0,0,0,0)}function h(t){var e;return c(e=D.isDate(t)?t:D.isNumber(t)?new Date(t):new Date),e}}]),function(){function t(o,h,u,m){return{template:function(t,e){var a=e.mdHideIcons,n=e.inputAriaDescribedby,i=e.inputAriaLabelledby,r=e.ariaLabel||e.mdPlaceholder,l=e.ngModelOptions,s="all"===a||"calendar"===a?"":'<md-button class="md-datepicker-button md-icon-button" type="button" tabindex="-1" aria-hidden="true" ng-click="ctrl.openCalendarPane($event)"><md-icon class="md-datepicker-calendar-icon" aria-label="md-calendar" md-svg-src="'+o.mdCalendar+'"></md-icon></md-button>',d="";return"all"!==a&&"triangle"!==a&&(d='<md-button type="button" md-no-ink class="md-datepicker-triangle-button md-icon-button" ng-click="ctrl.openCalendarPane($event)" aria-label="{{::ctrl.locale.msgOpenCalendar}}"><div class="md-datepicker-expand-triangle"></div></md-button>',t.addClass(c)),s+'<div class="md-datepicker-input-container" ng-class="{\'md-datepicker-focused\': ctrl.isFocused}"><input '+(r?'aria-label="'+r+'" ':"")+(n?'aria-describedby="'+n+'" ':"")+(i?'aria-labelledby="'+i+'" ':"")+'class="md-datepicker-input" aria-haspopup="dialog" ng-focus="ctrl.setFocused(true)" ng-blur="ctrl.setFocused(false)"> '+d+'</div><div class="md-datepicker-calendar-pane md-whiteframe-z1" id="{{::ctrl.calendarPaneId}}"><div class="md-datepicker-input-mask"><div class="md-datepicker-input-mask-opaque"></div></div><div class="md-datepicker-calendar"><md-calendar role="dialog" aria-label="{{::ctrl.locale.msgCalendar}}" md-current-view="{{::ctrl.currentView}}" md-mode="{{::ctrl.mode}}" md-min-date="ctrl.minDate" md-max-date="ctrl.maxDate" md-date-filter="ctrl.dateFilter" md-month-filter="ctrl.monthFilter" '+(l?'ng-model-options="'+l+'" ':"")+'ng-model="ctrl.date" ng-if="ctrl.isCalendarOpen"></md-calendar></div></div>'},require:["ngModel","mdDatepicker","?^mdInputContainer","?^form"],scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",placeholder:"@mdPlaceholder",currentView:"@mdCurrentView",mode:"@mdMode",dateFilter:"=mdDateFilter",monthFilter:"=mdMonthFilter",isOpen:"=?mdIsOpen",debounceInterval:"=mdDebounceInterval",dateLocale:"=mdDateLocale"},controller:e,controllerAs:"ctrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2],s=n[3],d=h.parseAttributeBoolean(a.mdNoAsterisk);if(r.configureNgModel(i,l,m),l){var o=e[0].querySelector(".md-errors-spacer");o&&e.after(D.element("<div>").append(o)),l.setHasPlaceholder(a.mdPlaceholder),l.input=e,l.element.addClass(p).toggleClass(f,"calendar"!==a.mdHideIcons&&"all"!==a.mdHideIcons),l.label?d||a.$observe("required",function(t){l.label.toggleClass("md-required",!!t)}):u.expect(e,"aria-label",a.mdPlaceholder),t.$watch(l.isErrorGetter||function(){return i.$invalid&&(i.$touched||s&&s.$submitted)},l.setInvalid)}else if(s)var c=t.$watch(function(){return s.$submitted},function(t){t&&(r.updateErrorState(),c())})}}}e.$inject=["$scope","$element","$attrs","$window","$mdConstant","$mdTheming","$mdUtil","$mdDateLocale","$$mdDateUtil","$$rAF","$filter","$timeout"],t.$inject=["$$mdSvgRegistry","$mdUtil","$mdAria","inputDirective"],D.module("material.components.datepicker").directive("mdDatepicker",t);var l="md-datepicker-invalid",h="md-datepicker-open",p="_md-datepicker-floating-label",f="_md-datepicker-has-calendar-icon",c="_md-datepicker-has-triangle-icon",m=/ipad|iphone|ipod|android/i;function e(t,e,a,n,i,r,l,s,d,o,c,h){this.$window=n,this.dateUtil=d,this.$mdConstant=i,this.$mdUtil=l,this.$$rAF=o,this.$mdDateLocale=s,this.$timeout=h,this.documentElement=D.element(document.documentElement),this.ngModelCtrl=null,this.inputElement=e[0].querySelector("input"),this.ngInputElement=D.element(this.inputElement),this.inputContainer=e[0].querySelector(".md-datepicker-input-container"),this.calendarPane=e[0].querySelector(".md-datepicker-calendar-pane"),this.calendarButton=e[0].querySelector(".md-datepicker-button"),this.inputMask=D.element(e[0].querySelector(".md-datepicker-input-mask-opaque")),this.$element=e,this.$attrs=a,this.$scope=t,this.date=null,this.isFocused=!1,this.isDisabled=C,this.setDisabled(e[0].disabled||D.isString(a.disabled)),this.isCalendarOpen=!1,this.openOnFocus=a.hasOwnProperty("mdOpenOnFocus"),this.mdInputContainer=null,this.calendarPaneOpenedFrom=null,this.calendarPaneId="md-date-pane-"+l.nextUid(),this.bodyClickHandler=D.bind(this,this.handleBodyClick),this.windowEventName=m.test(navigator.userAgent||navigator.vendor||g.opera)?"orientationchange":"resize",this.windowEventHandler=l.debounce(D.bind(this,this.closeCalendarPane),100),this.windowBlurHandler=D.bind(this,this.handleWindowBlur),this.ngDateFilter=c("date"),this.leftMargin=20,this.topMargin=null,a.tabindex?(this.ngInputElement.attr("tabindex",a.tabindex),a.$set("tabindex",null)):a.$set("tabindex","-1"),a.$set("aria-owns",this.calendarPaneId),r(e),r(D.element(this.calendarPane));var u=this;t.$on("$destroy",function(){u.detachCalendarPane()}),a.mdIsOpen&&t.$watch("ctrl.isOpen",function(t){t?u.openCalendarPane({target:u.inputElement}):u.closeCalendarPane()}),1===D.version.major&&D.version.minor<=4&&this.$onInit()}e.prototype.$onInit=function(){this.locale=this.dateLocale?D.extend({},this.$mdDateLocale,this.dateLocale):this.$mdDateLocale,this.installPropertyInterceptors(),this.attachChangeListeners(),this.attachInteractionListeners()},e.prototype.configureNgModel=function(t,e,a){this.ngModelCtrl=t,this.mdInputContainer=e,this.$attrs.$set("type","date"),a[0].link.pre(this.$scope,{on:D.noop,val:D.noop,0:{}},this.$attrs,[t]);var n=this;n.ngModelCtrl.$formatters.push(function(t){var e=D.isDefined(t)?t:null;if(!(t instanceof Date)&&(e=Date.parse(t),!isNaN(e)&&D.isNumber(e)&&(t=new Date(e)),t&&!(t instanceof Date)))throw Error("The ng-model for md-datepicker must be a Date instance or a value that can be parsed into a date. Currently the model is of type: "+typeof t);return n.onExternalChange(t),t}),t.$viewChangeListeners.unshift(D.bind(this,this.updateErrorState));var i=n.$mdUtil.getModelOption(t,"updateOn");i&&this.ngInputElement.on(i,D.bind(this.$element,this.$element.triggerHandler,i))},e.prototype.attachChangeListeners=function(){var a=this;a.$scope.$on("md-calendar-change",function(t,e){a.setModelValue(e),a.onExternalChange(e),a.closeCalendarPane()}),a.ngInputElement.on("input",D.bind(a,a.resizeInputElement));var t=D.isDefined(this.debounceInterval)?this.debounceInterval:500;a.ngInputElement.on("input",a.$mdUtil.debounce(a.handleInputEvent,t,a))},e.prototype.attachInteractionListeners=function(){var e=this,a=this.$scope,n=this.$mdConstant.KEY_CODE;e.ngInputElement.on("keydown",function(t){t.altKey&&t.keyCode===n.DOWN_ARROW&&(e.openCalendarPane(t),a.$digest())}),e.openOnFocus&&(e.ngInputElement.on("focus",D.bind(e,e.openCalendarPane)),e.ngInputElement.on("click",function(t){t.stopPropagation()}),e.ngInputElement.on("pointerdown",function(t){t.target&&t.target.setPointerCapture&&t.target.setPointerCapture(t.pointerId)}),D.element(e.$window).on("blur",e.windowBlurHandler),a.$on("$destroy",function(){D.element(e.$window).off("blur",e.windowBlurHandler)})),a.$on("md-calendar-close",function(){e.closeCalendarPane()})},e.prototype.installPropertyInterceptors=function(){var e=this;if(this.$attrs.ngDisabled){var t=this.$scope.$parent;t&&t.$watch(this.$attrs.ngDisabled,function(t){e.setDisabled(t)})}Object.defineProperty(this,"placeholder",{get:function(){return e.inputElement.placeholder},set:function(t){e.inputElement.placeholder=t||""}})},e.prototype.setDisabled=function(t){this.isDisabled=t,this.inputElement.disabled=t,this.calendarButton&&(this.calendarButton.disabled=t)},e.prototype.updateErrorState=function(t){var e;if(e=t?new Date(t.valueOf()):D.isString(this.ngModelCtrl.$modelValue)?new Date(this.ngModelCtrl.$modelValue):D.copy(this.ngModelCtrl.$modelValue),this.clearErrorState(),this.dateUtil.isValidDate(e)){if(e=this.dateUtil.createDateAtMidnight(e),this.dateUtil.isValidDate(this.minDate)){var a=this.dateUtil.createDateAtMidnight(this.minDate);this.ngModelCtrl.$setValidity("mindate",a<=e)}if(this.dateUtil.isValidDate(this.maxDate)){var n=this.dateUtil.createDateAtMidnight(this.maxDate);this.ngModelCtrl.$setValidity("maxdate",e<=n)}D.isFunction(this.dateFilter)&&this.ngModelCtrl.$setValidity("filtered",this.dateFilter(e)),D.isFunction(this.monthFilter)&&this.ngModelCtrl.$setValidity("filtered",this.monthFilter(e))}else this.ngModelCtrl.$setValidity("valid",null==e);var i=this.inputElement.value,r=this.locale.parseDate(i);!this.isInputValid(i,r)&&this.ngModelCtrl.$valid&&this.ngModelCtrl.$setValidity("valid",null==e),D.element(this.inputContainer).toggleClass(l,this.ngModelCtrl.$invalid&&(this.ngModelCtrl.$touched||this.ngModelCtrl.$submitted))},e.prototype.isInputValid=function(t,e){return""===t||this.dateUtil.isValidDate(e)&&this.locale.isDateComplete(t)&&this.isDateEnabled(e)},e.prototype.clearErrorState=function(){this.inputContainer.classList.remove(l),["mindate","maxdate","filtered","valid"].forEach(function(t){this.ngModelCtrl.$setValidity(t,!0)},this)},e.prototype.resizeInputElement=function(){this.inputElement.size=this.inputElement.value.length+3},e.prototype.handleInputEvent=function(){var t=this.inputElement.value,e=t?this.locale.parseDate(t):null;this.dateUtil.setDateTimeToMidnight(e),this.isInputValid(t,e)&&(this.setModelValue(e),this.date=e),this.updateErrorState(e)},e.prototype.isDateEnabled=function(t){return this.dateUtil.isDateWithinRange(t,this.minDate,this.maxDate)&&(!D.isFunction(this.dateFilter)||this.dateFilter(t))&&(!D.isFunction(this.monthFilter)||this.monthFilter(t))},e.prototype.attachCalendarPane=function(){var t=this.calendarPane,e=document.body;t.style.transform="",this.$element.addClass(h),this.mdInputContainer&&this.mdInputContainer.element.addClass(h),D.element(e).addClass("md-datepicker-is-showing");var a=this.inputContainer.getBoundingClientRect(),n=e.getBoundingClientRect();(!this.topMargin||this.topMargin<0)&&(this.topMargin=(this.inputMask.parent().prop("clientHeight")-this.ngInputElement.prop("clientHeight"))/2);var i=a.top-n.top-this.topMargin,r=a.left-n.left-this.leftMargin,l=n.top<0&&0===document.body.scrollTop?-n.top:document.body.scrollTop,s=n.left<0&&0===document.body.scrollLeft?-n.left:document.body.scrollLeft,d=l+this.$window.innerHeight,o=s+this.$window.innerWidth;if(this.inputMask.css({position:"absolute",left:this.leftMargin+"px",top:this.topMargin+"px",width:a.width-1+"px",height:a.height-2+"px"}),o<r+360){if(0<o-360)r=o-360;else{r=s;var c=this.$window.innerWidth/360;t.style.transform="scale("+c+")"}t.classList.add("md-datepicker-pos-adjusted")}d<i+368&&l<d-368&&(i=d-368,t.classList.add("md-datepicker-pos-adjusted")),t.style.left=r+"px",t.style.top=i+"px",document.body.appendChild(t),this.$$rAF(function(){t.classList.add("md-pane-open")})},e.prototype.detachCalendarPane=function(){this.$element.removeClass(h),this.mdInputContainer&&this.mdInputContainer.element.removeClass(h),D.element(document.body).removeClass("md-datepicker-is-showing"),this.calendarPane.classList.remove("md-pane-open"),this.calendarPane.classList.remove("md-datepicker-pos-adjusted"),this.isCalendarOpen&&this.$mdUtil.enableScrolling(),this.calendarPane.parentNode&&this.calendarPane.parentNode.removeChild(this.calendarPane)},e.prototype.openCalendarPane=function(t){if(this.isCalendarOpen||this.isDisabled||this.inputFocusedOnWindowBlur)this.inputFocusedOnWindowBlur&&this.resetInputFocused();else{this.isCalendarOpen=this.isOpen=!0,this.calendarPaneOpenedFrom=t.target,this.$mdUtil.disableScrollAround(this.calendarPane),this.attachCalendarPane(),this.focusCalendar(),this.evalAttr("ngFocus");var e=this;this.$mdUtil.nextTick(function(){e.documentElement.on("click touchstart",e.bodyClickHandler)},!1),g.addEventListener(this.windowEventName,this.windowEventHandler)}},e.prototype.closeCalendarPane=function(){if(this.isCalendarOpen){var t=this;t.detachCalendarPane(),t.ngModelCtrl.$setTouched(),t.evalAttr("ngBlur"),t.documentElement.off("click touchstart",t.bodyClickHandler),g.removeEventListener(t.windowEventName,t.windowEventHandler),t.calendarPaneOpenedFrom.focus(),t.calendarPaneOpenedFrom=null,t.openOnFocus?t.$timeout(e):e()}function e(){t.isCalendarOpen=t.isOpen=!1}},e.prototype.getCalendarCtrl=function(){return D.element(this.calendarPane.querySelector("md-calendar")).controller("mdCalendar")},e.prototype.focusCalendar=function(){var t=this;this.$mdUtil.nextTick(function(){t.getCalendarCtrl().focusDate(t.date)},!1)},e.prototype.setFocused=function(t){t||this.ngModelCtrl.$setTouched(),this.openOnFocus||this.evalAttr(t?"ngFocus":"ngBlur"),this.isFocused=t},e.prototype.handleBodyClick=function(t){this.isCalendarOpen&&(this.$mdUtil.getClosest(t.target,"md-calendar")||this.closeCalendarPane(),this.$scope.$digest())},e.prototype.handleWindowBlur=function(){this.inputFocusedOnWindowBlur=document.activeElement===this.inputElement},e.prototype.resetInputFocused=function(){this.inputFocusedOnWindowBlur=!1},e.prototype.evalAttr=function(t){this.$attrs[t]&&this.$scope.$parent.$eval(this.$attrs[t])},e.prototype.setModelValue=function(t){var e=this.$mdUtil.getModelOption(this.ngModelCtrl,"timezone");null==e||null==t||t.getTimezoneOffset()<0?this.ngModelCtrl.$setViewValue(this.ngDateFilter(t,"yyyy-MM-dd"),"default"):this.ngModelCtrl.$setViewValue(this.ngDateFilter(t,"yyyy-MM-dd",e),"default")},e.prototype.onExternalChange=function(t){var e=this,a=this.$mdUtil.getModelOption(this.ngModelCtrl,"timezone");this.dateUtil.isValidDate(t)&&null!=a&&0<=t.getTimezoneOffset()?this.date=this.dateUtil.removeLocalTzAndReparseDate(t):this.date=t,null==a||null==t||t.getTimezoneOffset()<0?this.inputElement.value=this.locale.formatDate(t):this.inputElement.value=this.locale.formatDate(t,a),this.mdInputContainer&&this.mdInputContainer.setHasValue(!!t),this.resizeInputElement(),this.$mdUtil.nextTick(function(){e.updateErrorState()},!1,e.$scope)}}()}(window,window.angular);