(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('湖南', {"type":"FeatureCollection","features":[{"id":"430100","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@J^ABICEBCD@DKBADFJTNHJBDCDCJMLGHADGF}ICACGOODMHM@GCAC@CBCD@DFFIFEAA@@CFG@AEGEAMAGGIEMNIHeXSPC@IFGJGPEHKHA@KGFMAMCEIKBALBF@DEBE@CACCAAJA@ACMACCBAFAAEMCCDKBOMC@ELEDI@ECCEE@CDAFRTBF@HG@ECKABDFDADCFKFC@ACEAAADAFADAAGCEEEGAI@CBDRAPGJGTEHKCI@KHAFDRAFABKHGPKP@FFL@DEBECEAEBI@WBIDIBCC@GCI@CFGFGFEH@JCLGROAGGMMAIACB@NEFIAKFG@AA@IPKBCAASIAUCCECDK@ICIGK@GCIBCAI]eBOCMACECI@CBAACI@AHE@ACCSAK@EBMNGAaCE@BDJFADOFKHMDCBGJK@EECIKKEK@CJGD@DFBADSBIFG@CGGAUCE]ACDERILKHQBAB@FFFABGDAPCBEAEF@JGJAH@HJRAJSLE@G@IBCD@LOHCPCDCAEKGCGBIDK@EHE\\EDU@IAE@ETAPFLJB@BYPMNUNMdCDG@IAQMCACBGHMBKEM@QG@AAI@AEDA@IIGQFEAMHMAAGKAIACC@MBA@ACBGTAFGH@AIEO@IBEAE@IAAALCDA@ACDIC@CDABKEMCCFG@CHOAEFcIAA@EMGG@E@CBGJEBIASIEBCDERABCBUCUK@CDG@KD_CADCJGFCAAADGACCAIOEACBEHKB@DCDBLCBII@IGOKKAQGBIDAA@MGDCAOKCG@CHG@CMEAGCAGAI@ICAD@HCBGBECKQEIOCOCK@C@CDELAJCDoREFICCBCBEKEACAQBEIC@BHADCAECC@GAAACEAACBADGAMBEAAF@LADIVCXIRGJMDILKFO^MPSHGAQSKGQEG@MJCD@FNZDHABQHEFBFDJBHJHLDFFCHEHAJ@FDFBJNLDHNHBBMFEJ@FEDABDB@BKLOJENHDL\\JHZRLLBRCLFTATDDH@FDFNADIF@FL@LLL@JJALDJTJHLLDJF\\@NDBBADEH@FBHFHTFJBLHTBFAJDJCLFLADDPBPJBB@JBBTEFBDFDBJARFH@NKXBHAHEDMBC`MPCDAJOJCLAHBJCFDLHDBNAPGHEDI@KDCDEHAFIHFDHPNBHDHBDJBDBF@HLFBHJJBAB@DFDDDHADCFIB@NLBJFFTBJ@D@BF@FGNCPBDLALBF@\\SH@NFDJ@BSCADBBGJDDL@ZIFCD@FBFFHNDABGHANBFHJ@FHD@BGD@JLPH@BCJ@FF@DED@DBJPBA@KBAD@FBFJPBLGHBJCDBFHD@HIHAHED@LHJ@HADD@HGRBBDAFKVHTBNJHDFA@CGG@ARCFCJCHDHJFBF@JCDB@BCDMJ@HCNDDPHFJB\\JHAXFR@LBDBDLBFDBDBNBDFDZLZlFnR@HBVXLLFPZnLHFHHBVGJCVOFCL@HCPATDJBAHBFNBBLFLTRLPpXXDBAACIK[[AEBMHKFCFAR@HDHNNBBCBECQ@CBCF@LBNC^DNGHA@GJCFABHCRAHBDDBXBLHNMHAV@NFH@LEPOFAPLPDTJR@JF@SGM@EDIBCEGIEEMKIACTSNEL@DEFAH@rVFDDHFHPJJ@JAFDFFPTNHHNDRHJF@HCLMBE@GDCDAFBHD@@LCBEDCNCFAJDNAHABG@KCQ@OFATBTCDBJDDFRHDFALBHHBDLB@BBLFBDEJFfFJLPAJ@HLHBBKXC@KBCDADLR@DM^@DFFRDFJLBJJNJ@JETBDFD`LFDA`HALIBKHIEILK@IJAHADDDDVBJLHBHATGZAJEDCAODGFAF@VHLARCHBLLBD@LDDPNTJJ@PEJENILCH@XHBC@AEY@AG@AAAEFMGGC[@EBAFDBAJSDBBLFJX@HHHEFADBJLD@VSFIAEBAbOLIFMF_DGDEH@H@F@TQT@VEHDDHFDT@THJIHKZ[RQVSNEJON@HILGHGHOJEFE@CII@ABAZENEPGLIJIRKZDDBDNLNJF|TNAL@LFJHJ@PALBXPFDNbPJ@TLXL\\XPH@ROPIRGHBRRJHVEH@dLJIBAHFRTRHPbHJDBPCH@PDNEHEJCDEBCBMJEL@NJPHFAPKD@RDHBFHJHP@JBLODCFGHCLCX@FADED@BBJBD@HABCDUFEHCPUJAJIHCLCLAJBPDB@HCFEHCLINCBABK@K@ECGQKKAGOMGCMCCICO@CACABCL@NCHBJADCNIDER]BGPALMJHFCbAFCBC@SFG@EAEOIACDENIFKCCGBCAAEGIAGPW@EAEGEMCGGIACGGC@ECAGCGGGAI@KEE@C@CACKBEDC@AACBG@EECMAGBCMBICG@CCAOHI@WIIBKCAABI@CACMKOGAIKKAG]SAGDIAKBIAACCG@K@EAQAEG]GSAEBIJOEQBIC]FAAGOMCI@CAAC@EFKHKNC@IDEAWDCFBFADEAEBYBIHADIFCDOC@EDCCEBLIFBDCNABE@@BCAAHGBAHSBAC@@C@COCEAEKCCCA@MAEAAKFIFIBKBGDUC[DMBKCKIAG@CNKFGACICSAM@MHCBAAGE@GIMICCCCGAGAA_GI@MDCDI@C@MVCDIBIGAEACIMA[ACECE@K@MAG@EFANEBE@QKMCKGGK@CDI@COAU@KCSYOIMYEOIIGM@IGSAGQBSOKCGGICIBKF[FWRCAECAIMBEBCLKJEJCDWJKHGDIHGDIACA@CDE@GGUCAABKHMFKX@DDH@DELAJFPLFAP@JCNIHEBWE[BQGC@KBA@ACBUEIcG]BEAECCOAC_MGEEQ@EBIIEQAaDI@EIKGAIDWCKBKCEICQEYD_CIAOG_VWCC@[PMBOFAB@PEBEAK@AADM@II@SCABBLDNJL@XGTIDADFDNBLAF@@BCJCDMDKACBAPEJQTBHFHD@JEBB@VBFLN@DQPFVADGFFFEJD@@FIPCECMAKBCEABF@PDL@FABCCAB@DAHIBGIEICAGHK@GBALKAE@GLCC@GGOSBICE@GDO@CFMAGECIBCJG@ACA@CCAEBCBDBABABCEUIDICMFCBIHCDE@C@AKECGEIAASCAAFIAAAAIACC@CFE@KLECKAM@AKAODEFEJIJELMBCBMLKLAF"],"encodeOffsets":[[115801,28621]]},"properties":{"cp":[112.982279,28.19409],"name":"长沙市","childNum":1}},{"id":"430200","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HIF@LBBKHAL@HGDBFJHJJABG@CBADDBA@ECK@OAEFBADBLDNDFJO@EC@FIEEHEBCEURO@CKMAE@UAAIFC@EGAGRSFIBODALBNCDCDI@AE@KBMAECBCJCHS@WIKCMAKBATDJ@@JCNBBL@FBFA@OBAPENA\\OD@XD`UPHJB`DZCRFJDDFALDLCXBJLHFJJ@bCRBJFAJ@FFRHF`NBDDPFDFB^AdHFJAVBDB@LAD@RH\\AXFFAHCBCDIB]KEEQBIFI@CCIHUFELCLGDAJX@HCHDDJBHCJGHCLG\\KFKLIDKFANABJFDDBXQ\\ELEJAJDHHLDTPRA@GCGHOFAHBHEREJEFINmD_AQGQWOiakoOMEGDSGWIIc]IISmOQ]WcSOQIOCWBSGcSiMQMW@OBKHMHEVEJEPCFBFHHNDBBA@KBAF@BI@CECEMHGBCMGEKGG@CBIEAOAAAEGQEDGFIHOCkFIBGJETBNAFC@GEEREEIG@KCQKOMAQDWPWDIFGRC\\NL@ZE^[NCjBTHRLJNJBH@FCLAFDLL\\LLBJATBJFNBRDNBXGH@FDPJlN\\NDADCC]CiK_M]IW@EFGVCFEBGAICGKIGMESGqKYgkIOOeKO{{EIAG@CACAG@YCK@KFIJGHAJ@JFLNHFJADODQBUHqHQFC^AJCDGBI@IDC`BFCFOBIB[HGHEJIHIDIDGfEPCFB@KLKACOOOIMKCCBI@CCCDMACCAEMKEAC@KBKEGFKBGAGDKM@QAGGAEKMOYAMieEGDOFEBCLEFUJQCKFKCMBQFKCQDI@ODKFEBK@OCMB]AKHOFGTHDADABGF]^MBCFQFERCRDVEH@^BDBJFDBDCL@FGFBBDPAXBDCNIJIFCF@DCEK@EDEFAZCNGFCfBRIF@BBJCDDHBdCHBDA@A@CBA@CCG@GACSWBMOYEEBICGAG@OCKIOCCGCBOBAHBRCHFDALHXA@EWWCMKK@C@OGKFICI@ECGHIAI@CEIECIBACILG@GCKQOOI@CAAGCEGKKA@GBEFGHCBCCODI@GPOCEMICEAEDK@EBEFA@COIMKACAGEGAKFULKYMKAKEEGKEOCGGKIDKAKQMDUEMIEWEGEIWCCOEIG[A@KCMWUCECKEGOIyUSWESCCiWUAEFI\\EDGDO@AAIGIKAKF[@ECIgcUMMCGBEBOJQTGDMPCL[hAJJXD\\FFVLRFJHDDPjD\\@TCRKXATCNEHaTaPQDIHMRMJGJCHA@CBKEK@kPGBGD@LDHBJAJBNAFEHMFMRAFChEFCVELKJAH@FDLCRBFLLLJZ\\DN@JERGRSVGJ@FDHLHCJBJPnMJC@MA@FFH@FG@OEI@CBCFADEREJAHGPAPHT@PMVGFSHcF]EQGIGIQEIUOECMCQFG@]EMAGBCBCHGVMZOJGBGHAHDHRDFFBF@PLR@JANCJORMHCFBJGFEJABQ^CH@FBDFFRDNFHLZvTtBLWPGJGRGLGDMLOMCAWBQDsTK@KEKGKMGOCMEOEGGCI@UFKN@FBFHDFH@L@HSTCH@JBDJHBDABC@SAUFEDCRQXEDKJCFAH@HGJAFBDDBH@JCDDDTEJDDNBLFDLCPBDDDRBBBNNJD@FHL@BCDIBgAOCG@MREJGFIDALBLADEDADFTBPDFCJIFCBHHBFDDXF@JCBG@GHM@GBFHEL@JMCQBEBDV@BEDFFCFAJEJ@NKHKLMDIVC@GD@FBTFJCJBFNDJHJ@JFH@BB@HDDRGJGNEF@LLHDFDH@@HD@B@FIF@BXJFBJDBJ@CTDFD@RITCDBFN@HEZGHIVKNEJOL@LOXI@UEKDIAc@K@]DMKKCMHMPKHEFGCUgKmCCEAM@CPKPFDEFMHGFE@EBGFBBF@BB@DKPGLFD@BEB@BFH@HCDE@MLINQDIFGDABEN@RGLFBDF@PKJSFBHAVPHDHKHGLOLELAFBDDJ@F[LMLGHALAZDT@F@FGD@HCFIDAHAL@XADMEEBCDBDGDDFBHFFPJFR@BKFK@GHELL^BbANCLCNBNRPH@FBJNLDHPJDBD@DADEDGBCB@LAJBFHDHBLKNGF@JLXFDB@D@HEHMLMLDLDBHB@DCFGFOB[OE@AB@JMRBPBDLJNFDD`rX@NBLALNFR@BEBEHQLYHEDAHDHFHDNAPELO^IJE@GCQJAHBNTZNL^VJHPFGT@LEBAHDHLLD^JRPVDZDNHRVPFAHHBELKNKDANAFKJIFIFEPCLB@BBNDLKF@LEF@DDDJBBBBBEJBBTDBBFJDHLF@B@DCFGDAJEDDNCJVJDFBABACADAFADB@DDB@BIHADDJHFNBDEP@HCF@JDRADBFNBJB@"],"encodeOffsets":[[115932,28697]]},"properties":{"cp":[113.151737,27.835806],"name":"株洲市","childNum":1}},{"id":"430300","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@FBNAHBBCDABBDFBBHBD@FDDBBCAGD@FJRADBFBFLDADAJDFEpQDCFSFEP@PDPDFJPTBBJABC@EBCJDP@FDBHNF@DGH@DDHPLDBHC@NBBJCHABRLLHP@JJJDCAIDC@CLAFGDAFBJPDBBDCHBBDBHEDIBC`DLCH@DCL@VVDDABAFQDCFATJJBFAHIDAF@H@NH@FBBdJFEPBDGH@DENDLFBADCD@CJBDB@DCBKBB@JBFAF@JFPBJG@EHSBAHBDB@NAD@BDBJHLBBGNBNEFHRJJB@FC@BBJ@BRHN@LFNAHGDADBRNJBH@DCNcVMNMZO@AIAEKBOFSF@JBV@FCF[FGL@JCHAHDFLDBDCDOPG@KDCJAH@F@TKBIIQ@GBGHI@IFEFBDABOHCBAEE@EBARALGJKFQDC^BDFBVHH@DEHAJCTABCEC@IH@DFLLLDJFFL@HIDANCLGPEBCIEACF@bDHBNMFAL@TBDD@BGF@BDJBBDAJ@FDBDDNAP^fBJADDJ@HHLDJ@JCLFDDDBVTJBBADOL@JBBH@LEJBFE@MDAJBNBHNBHQPKHIDG@EFKPBHBH@FBBFBXEPAJ@FAFBFDFA@CEK@ELOHOLGBABECQBELGJ@LDFGHSHIBOCQDAJ@HBFFDFBHCBEBCBBBFBBDD@LEDEBCECACLBFDH@@GAEQSBEDCF@DFFDJ@FCFKD@PNLADCNDBFEBABDDNBBDB@BIDBBD@DAFCFE@KAABJLDFBNENLHB@LGFGHOHIJED@TOfWJGNMJFHHNBFBFH@BEH@DB@FBJEEE@CDCDAD@DB@HGNCNPPDHDBvHHBFALONKDIDCACGISMEIBCLA@CDCFALD@EGUIKEBUOGQCMCYOUIQC]KKCE@CBEFA@KHSOEIG]UMKQUCG@IBGRIHDF@JIP]FKBOCMEGCGBGFCZGRKFGFA@AEQKMKBMAW@_qCCMEKIACAONQ@IBAF@\\PL@FCDADEBEGACACKNKNKDEBG@ECAWEIKE@MHKLGAGCAEBI@KDAHAFCBC@CACICGOKCIMEAG@QOAMDMDKBMAaK]FKHGL@LE@AEQOIEEAGCEHCACDCFAFBHDBABCAUBKBGDAD@DCBE@EODSAmQ_GQEKIEEAKFk@UBUCGEKiHcIY@IIA@[HKAOBEAEKAEFK@AU@C@EJABECGEEAIHADJDBFCZOFKEIJGLOHBNCPGHMHCJC@GGEAE@ODIBCCEGGAABGJMFQHOAGBOCC@AL@BKH@BADDNAFPLBDJ^AFM@QAAFC@G@GGGAGFIHCFBBEDC@A@GGCAEHG@CFQ@EDA@CCGOGEMAMDAAAADKKEAG@ICCECIBA@INIB]UDKE@E@CCGIGCCBAJGDALQAQLILOJUJQDOLEHE^M\\GDADIACAGAEHGAEFIBABJHCJBJDBDEBBKVIFMDE@MEI@DGACCGEAAEA@DEBECCM@CC@CDC@GIEI@CAACEAI@CCEGE@MFCBBFADCCEBGACRCBIGKDMMC@ADFFBBIDEAMGE@CBCB@HAHADE@@@@FDF@NBD@HDFAHFLLFDH@FTXJPDLDXETBNCJEDOHkXONMLCJ@JDDJDlDHDBF@VJLBJCJELMJINQNIBUGKAK@IHGAEBGBGJG@ACAMCK@ICEEBGAAC@CAIQQE@CLCCOI@ABCCSBG@AMDYEUAABBDADEBEBEFABGECMACC@GDCFAJEJEFG@C@GI@ADEACWUG@GBADALA@GCEDC@QOGG[HAHEHCDIDHR@FCDIAAD@LE@CDAAACGAAFA@AA@GA@ABBDAH@JBDJH@BGD@BBJABG@ABBHPPfLNAFADEJ@HB@DABODCBBHFF@F@BNDN@DCBA@KAG@CDEF@DFBFD`HF\\HDB@BILODEFCHMDOBAFDTHLHNETENIHGFI@UOMCE@UPIDIFKfC^EDECCUAEEAGDIJEJCNA\\DFAJAFQdAHCFAJ"],"encodeOffsets":[[114688,28578]]},"properties":{"cp":[112.944052,27.82973],"name":"湘潭市","childNum":1}},{"id":"430400","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HC@E@ECSBYBKHGNK\\K@ECIACBEFKPKHKLGCGOGBUAGTELI@OCEEAHK@QFMBAHCJERCJMNKF@DC@GEG@AFA@AECHKLO@CAAE@AAHEFAF@HENGFEECLODON@FBDDLnVhFDB@FELGNONGLDNL^CL@d@JBLC\\FFANU@KNIHKLMJUHGFY@GCIAEWDQJEAACDSI@CAAIIEAWE@EJA@C@@GG@ECGCKKE@MFIHQHCC@GAAG@IEI@IGMCAEDIEIASBGFAD@BABEFMNCLKLG@MFIBIDEEEFC@ACUFARAND@IFKEGHAN@HGH@DA@IWECCAEGGDAJEDICEAOESBCFCBCAKBKJCHEFINQH@PDhBJADC@AGK@EICMMAAQACCACDOCKKEMACCFICSCCIDG@CAACBEHI@GBGDELIFCRWDQFCFABECGAIGEWGEA@CCAEBEJMF@JADMBKFIBABDFCBECW@MES@[DENADGBI@EAACAO@[DGAGBELI@ECCSCKEMBUGM@OEG@AKBICUDGBCHANDFADGDMDAD@TBD@BA@EACMEEGCKFCVAJCBCCEEABCBCHGPEHEBEFEJMDAF@RFH@JCAMFG@MDKBC@CAEAKM[@K@CJUAEACBEHG@GEAAYAKEK@]IMSOGIAE@I@CDCNIDIBCPCDABEDCJCBIBCHAL@RDJE\\_DICYACCCOEMFEAECSUEI@AFCPKJCHEDEAIkgKCKBONEBC@EE@GCE@MCKBCJMDI@CSKAKBGJIHCDE@CEAACFOLMACAAK@CAAAGDCCICSFGASQACBEDC@EGK@EDGACE@IDCGACE@SFGACAKSIIAE@IDC@IFQACQBOACBCDCBK@SGMLKBOEKMAEBGLKBGBIBEJOGEAGFUCIDWEMC@CDAAGOECMEGIG@OLKBC@OKSEM@SLSBADAHGHYNO@AE@WAISMGEEBQJEFEBUMEAAB@FIDWCKDKFOEE@GHEBKCEBADBH@\\ALGJIDG@GCCIIICAGBDZAHI@ECMUAGDEJCN@DCFCECBEOCACAI@WCAM@IBCBAJC@ICAC@EHSACCCECMBAD@PAHCBEBCCISKCIKGACNCBEBCAACAKCEQIIAIEED@L@DGHIBAC@QEMOAEKOEOFIDBHFFRBHBXZ@DEAEFCCE@KBGBCDG@ABCA@DAFEBENGH@JFRCTEHEZCDMBEDIHGT@JCHEFWBMCAK@GO[@CBE@GHI@CAE@QJQBECCCAE@CDAD@DG@CAWWE@ADE@SCKBG@AC@IACCCWCIR@BDJETA@ICE@GIGAGAABCDCJFRGNIHG@OAC@KFGBOIKLCBMB@BAJC@QGE@CDE@IEE@CBK@EFCTCJCDEBGCCECUMKKKACCUEIEAEBOHKDQECGE@GBG@KEAEFMEKCMEEGACBCB@HA@EGA@@RABG@OGWQQAA@@MOA@HCBIIMEECAFBHATG@GJCXABCCA@KB@DBLHNCDC@GCE@MFKJGNGL@FHDFFDL@NENCVBBJJDTB`DNCLARNRHLDTDHAJEHGBECCIEAABCFABE@ICGKCAABAjJXANGJIBGEAJIDG@EEEAADAFEF@DDF@RAD@BFN@DCDOFABABBN@RADBDFADEHEFBBB@BEFDHEJBBHB@DCFBJADMDBHEBAB@D@DFDRBNLBDBDADID@NABID@BNLPD@HMJAJ@DBBHDN@HHBBDATQJCBAAGFGBNBFJLTNHDF@RCJBJDFFHLBR@RCFMNOJKDQ@mWaYKKMMQQODBHDF@HBJCJ@FNJBFLAB@BD@FCDSFCHJDFJBBFEBDHAFBBFA@@DLF@DCBDJMH@BHD@JAFKFGBCFW@EBEF@L@BFBBBBDCLBDJDDJ@FABGBIHCBEAGH@DMA@BKFIHBJD@@BADEBCCABCFGBGEAE@GA@GBCAACBOCCA@CFGBQNiHQIC@UJEFEBECGBECY@IEICAC@EFGLIBKDAJHD@CEBAJADEI]EICCCCCBQPCPGFCTIBMDIFGLOPADBLCHIHEH@REPCJEHGTYXGRMX@DD^YDMHADAHQRCLKLEDCDCNCJGHG@KAEEEIGEMCM@E@GKC@GDIBDNHBBN@JEBM@WEEMCCICUACHONBLAFM@ABABCAEEI@EBABIFABAJBLBDJDFF@BGDA@@DHFCFE@ECIMCAKBIHAJEHEDIDC@GGMAAA@GDCAAGAGDIGCAUJKJIBGCI@KACCAOGI@ICGBUBEKAAAFC@AMCCCCIG@MDE@SKI@EFOHCJSBADCREBE@WAI@EF@HABBDGFAHHNGHCJHBFJDJCDBPFFNBHHBTDHFBNCBBDJFBDHHH@DKTCH@FDP@DQFGHGFBDHFJJFRDRRLDIFCHAJCF@FDD@PKD@JBHDFHDDDBFCDBDBH@DAAHHNJZ@BKLDFGJAFFHJDFDFPCHDBFDAF@BBBF@BBLADBD@NADADLPFDNHBFFF@FDBFPN@FHHAFB@BCLEBCHABCL@DCB@DBJ@HDBAIE@CJBJAJDF@FGFQBALCFGNAFEN@FEFDBFCL@DFBJAPSK[@CJ@FGB@FBDAVOD@JDLBNCJFFBDGFAFEAIBGDBDDB@@CPEPO@CGMHQBQAMBMAEBG@KCIDEJED@DBHLLJJBFADBFFFRFJRDHAJDPIHBHBFLD@P@FABGBGMIAETBJDJAD@JJDHLBFDFHBLDBJADBDDHHD@D@DAD@BBHJ@VGJ@FKB@BF@NDBJDDJJFBDBNELBPEDBHHFN@F@DEDAFBH@BGDEDCFDFHD@DABI@ABCVEHkLGH@BBDNDDD@D@HGLAN@FJN@J@DMNEJ@HLVEH@FFXL\\LLJHAF@BFDJECCFAPDNADBAB@DEBEC@DJD@BBBABEA@DDJBABDD@CB@DDFB@DA@BBBBED@@DJJBBFEHABDCBADBPD@@AHBPED@DDEHBDHDFLFB\\DDBFHFF@BGBEHCDAJBNNHJN@PADEHITBDFBFD@F@BIEC@A@BHLLALFDDBDATGHGHMRF@GHG@AEE@AJGPBFICI@EBADADGLC@AE@@GBEBCJCFEF@JFBB@HHH@DAFDFAHBDLFJHJBDDBNEDDJBBBAPID@BHBBHDPBADBJLJBFCLEHBDFHLLHJDFBDDBHAFBBDAFFDB@TEHHLFHCHEZ@NEDBADBBNBDABEEK@C`FtF`MPAJSHBVJFEBBBDCLD@FADBBDFH@FBDBDHHFIH@@CD@BGDBDED@DBBFANBBLFJBBFCJ@DEDDHAFEBCF@DDBFEB@FDHBAFRA@FKLAHDDHBTDDD@HCFRBBKHCBIDAHDHJDDF@F@CL^VJAJMB@L@DBDD@JBHLFCLBBBBNCNBHFHPDDB@FCR@DEH@FGDBHHB@D@FCAADEJGHEHBHHH@D@BERBN@BEI]ACOKBECMBC@ALG@ABKD@PDHAPBRGNEHIBAHBFHDDJAPCF@FBHHD@DINGHGDOAMPGHKJILFPEDYAEICBCJGFBHFFDBAFID@V@@BELBFFLFBPALB\\GB@JJZ@dJjGFLDHAV@VElBLFFLJRF`HnRTBPC"],"encodeOffsets":[[115708,28097]]},"properties":{"cp":[112.607693,26.900358],"name":"衡阳市","childNum":1}},{"id":"430500","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@DCXEL@zLXATCN@XDTBPFR@LEJGH[IQFGXA^VLALAFCZBTCVUDOBOCK@IDENEZBLBP@JKBKHANBNFJ@JEJABBDFDBPG@AEC@CFEHDDHD@DABDBBBCECCGFIDGHCPH@IDEFCNCHEPHNAN@FADCBECQBAjWFDBHHB@NFABB@H@BJAJBHCLRFLbTHBD@`[JMdORADALQ@AA@EHA@A@@CHGHC@FDBFCJ@DBBFJDBDDLABEFBDBBHADBLAHLFDRJVf`^XNPDPGHEHSFEH@PDDLFHJFhNRDHFJABDCBDBDEB@\\JBDHFJXDBJDF@DED@BIAKFIFG`ABI@OFIDDBCCIBGFABEDABADDHABGFCAEBEFBFJFFGBKJ@DD@FATIDB@FBBHBAEHBBDAHD@FOAAG@ACDAJDBCCGIMI@AAACCCAADEF@LDAJDBDABA@GFABC@CCEFAHGHCAGCEGFE@CDA@CADIFGAIDC@CJCFGDBZbFLHBDANOHEDGDCBFAPBBDBPIbYF@F@JDF@FCFOHKFEJAL@`ERANBHACK@GF]DCH@NNJAFEBWDILIHCPEHBBDLVJDPBFELMLCLIdcXSPMBOEGCCAC@EDEJGHCXMVMNGL@JGXGLMRKLGIQDKBIDIHCLHdADIJSNOLGHCTFPEFGDcBS@ODODMASBOJMFC@CF@@ALEBDFADDBA@@@CDAC@ACABCI@CH@ACIC@CFDDABCBACAAAKDMCGBDDIFECBGIGKKGOIc@CFG@CKS@A@EBCNMDI@IIM@EBMHO@GCCMCAC@AHGlKDCDKBMBAJ@BA@CGCCEDEFCDADCAGBEFC@CCOCGIEOFKAMFCAEAIICCAIMCE@@ALA@EHI@M@KIGC@CBC@C@GGCCCAIBCAAKEGECKACGIIC@IBICSABFNJAHAHEBO@C@EKGAGAMJMCEBSEIYEECAEBIAKIGKCAC@IFCFDJ@LAHBFANBNARGRHN@DOPOF@DA@CCCAAHBJEFEBCHEAIEMDKAICC@UPCBEAA@EHI@@DL\\OTIBEA@CDKAEECEFM@EFMBEHKDABEREHE@ICIBIA@DJFABGCI@CAA@CDK@ADGBADKFADA@BEGG@EOMAEECE@EEGACMOECKCBMBC@CAKBAAE@AA@ABEECCADGEOECICEGBEHICELK@AIYGMBGCBG@CACAEDCACCEGGCIAC@OLC@ECE@IDGBEDCJQKCQEQIIGEACHEHGRE@CCO@EDGLS@CGGCGEACIAAMDEACGASGGMAEEAODCCIEIGAADQHCXAHEDABSAQIYBIAICEAKBKHKAE@AJABcBECCIA@EDGJQ@C@AAGMGCG@SJE@QCSEE@KNCBKCKACAAC@I@Gi]OaBMMOAERY@ACKBIBCHCDCEMFOG[AGACKCAE@OHGBA@KCCEAEAIBEGCKACwU@CHGBIDCPCJGHS@GBIBOHEJAFACKFCBEACKGCEC_@EFIEGBGAIMMBMACKEEI@EJqFMB[CKGCACAOACIEK@ABCFELG@A@GKCI@E@KSHUCOBECEEIGQIIIIAAIAAODQBEBADHJ@DKDEDABICA@KLMDAD@JFJ@DGNTHBDBDAFABIFCBGTW^aZ@J@TDRLZBVFPGXKFCAI@GEIAEA@EHGBCAMK_GAaHICO@EAACEMEgFa@OACEI@CHEB]ACAAECASAAGCAEHM@KOaQKAE@CFE@C@AKGOICEAIEIEWGMAOBCLM@AACIGAQCEOMWFIDOP@NGDGJC@KCSASGEGAEHKBO@CEE@[EYACEA]G@AHGFMHEBIAKHIAIQiAIBGAAG@GBBDDFBDKLCFAJC@]AoIiCSOIEIAY@QDu@KAMGOEMAKBED_ZIH@H`bFHAPGRGHIAGAWcMEE@GFEJCJIJaL[FOIQEMCQDSLE\\CFEBI@MIUSGOGIEQQGKG]ECEAIES@IEMBcAKGYSSQ_GGEISUMMKEGAGDEFCLGHG@ECEEKMKGeUU_GIQO]QmmGI@UU]MIEIDIFEAMEECKEIIYGIMkGKGIYKE@CEA@EB@BBDCDCIED@A@ECAG@IDuKOBIFEF@NDPBPFL@NCPGVINMHkVEFCLALCHGHGDK@IGGGQ]IaEISKCBKAODIHKJSJGBE@OUGGEAEFEPGLIFUDIFENDNJNDNBZJR@DFDCB@DJLFH@DJP@FFH@DDDFCBF@DCBK\\@VJXGBWBC@CCUAUBM@GCKIC@SHW`GFQBQIWAOJMTGBLZDTJL\\^EHAFBHLVIJBJADKHAFZdVLDDBJ@PFfHJ@FBHCJEJCPBPMJWFWJEFAL@LBPTnCD]GI@]LCFHTGJUDIFALBJAJCHGBQCGEIKOIKCK@SLKFI@IIE@MDDVJVBDFDRFDHDAANDJFD@D@BEDADHD@HBBPB@B@BCJIAKHGBEFGAC@GBAZDJBJ@DNL@DILINC@EEOLQPOJKNBVFJHBL@HEPDF\\FPHD^LRFVBFBBD@NBHRLHDL@RALCPJDJDFHFJBRDXCDA@EL@JAHEHCDE@EBAHAJB@CCCEA@CFCL@NCD@BFBFNNPNDFJZD@JALBLEFBHFFBBPADGD@BAL@BCBCEC@MFEFGDBLDJDDHB@BCFIJ@BBBRCHDBB@FCN@BLCDDCHGJBLHRCFCBEJAPIP@JDPSFGLCJ@BHLDfP`FHJDJATB^RHJBFAPMRKJMFGJCHHT\\NVAFBDFNhJNPLPFFAHDPAHPDDBD@VENANDPFNRRXLPF^HHFNhGVQLELP^LHXHPH\\TLPHFdFjNJFB@FCB@PLBABCHIFCLBP@HE@GPCFBFFBNT^BLAFGX@FFNFFLDHNPLF@JCHCJIJCXK`MV@PDPJLNF`@VFPJJbTxXTRLNEHXRJFTFH@JQFERWFGJCN@\\FNLFBBH@HGLDFDF@BGPAFDBPFNNBFLJHJHVRPHN@JDBHLJbB`FPV\\\\THHBJ@FIPEJAhGR_LAJDNFHDJ^TAHDLFCJA@BIJBJJDBFFJF@JNLFL@P@XDJDFHBJBBf@@BAD@HDDDDHCBIDC@AKOAG@IB@JFH@DANKX_TOT[NAL@JDJDHLXTdTVHBDBPEHGFCH@JCFBBD@CFJ@NEJD@BSHDDBPAHDJLHNDBF"],"encodeOffsets":[[113531,28320]]},"properties":{"cp":[111.46923,27.237842],"name":"邵阳市","childNum":1}},{"id":"430600","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@OLm\\YFFFXHR@TG^SHKDGAWACQP"],["@@LCn]FCFKDMDYA[Gc@aBEFGHEDAD@LDZVDFL^NZFRHJ\\RVRRZNHFBH@FEDE@IK[GgKeIQIOSQgYIKKOIG]MqkMMEG@QFKT{F_T{LH[FMLGRAJBHFR`RTzf`PTB\\EHEFMP{FFYDGLEH@NFHHDJAPCRNBNGD@XBDBFARMHAVPvz¶pVPJL@HJVlfz``RL`^rfZRdPxttrRJNJJFBGPOBIKMDI@CKGIACADGB@JBFA@AAAICCGCCGO@AHCDCIAEEGMIO@AJGCC@EHKDGBSAKCKSaOUC_RQjCPDRA`EHGJABBHFHATBD@H@HAHFJ@BBCD@BNNJALDD@@ACEBEJKBCCKHIFSJGDECAM@AA@CLED@FBHHDBFEJ@EIFBFAJBBAAEDCECDEAGFEAGFGB@FDH@HBD@N[HGLADC@E@ACAAABICGOCEBEA@CCAGAKAACDCEGDECA@EAAECEBADCACCKE@CCBGAIBCC@EBCBCOCECSDIAAA@IMAGAGEMEC@@IFE@EBCPCXB@BBBJCBDJAJDDCJHHED@FADABCLG@ILQJC@CF@BCD@HGD@BCB@BEFCH@DAPCJCCC@AFEDGFAFKFEBC@GCEQIOQ@AJO@IKMGUECKGCBOF[AOBKAWGGGEEEIGODI@UFKI[KEOCGCSOWyKYCKEAGE@]FCJA\\@HBFAFEDMFEFMNKH@J@BB@HFDNATFLCDAFIAMDcCIUYACE@IEOOEGDONGCK@KDIDEZI@CAIBEHGDEAOACAUEOBGFGJAF@TJDHBLJLRNNBDABEKWAMDKHGDQLKDAF@JFJNTVDL@JNJFBJAHFHDDCD@LFdJTCDALOFEBIEUEG@CZKFGLAJBNJHB\\@@CKMCGBIFKCGBEHCNANEPBNADBFLHDFBJDNJHBL@FEDGACBMAIAMBGBCHEJOJG@EKY@IVRKLNLJHDN@RJBAD@@WG_ACBORAJEJMDMBMDELRPPP@TIFEDGDQ@EMIEIAGFQFICI@CBGD@LBDMFGFCHAT@HAXJfLJC@KFKDED@D@JBPRDCBICOFIE_EIOKCKCIHEPGD@FCFM@EI]@GIM@ADGBEAGAGIICSAEK@ECE@EEEOBC@K@CFENKAECEAEFG@ICEAG@AHGAEGGAIGEAGBILEFQMOEQGGA@MAGAGECKKK@G@CACKCCC@CIAO@IGEGGAUCOLEBOGKGGAE@GDABANADCFIDGFMFOCG@ODCAGIOaQGQSGEABIJcKG@UFIGSSE@IDWNQPG@WOK[KW@SOIMaECWOKAOBI@IGKEK@MB{SIEKMCMCAYCQLIJKJOHMFYFAB@BJJ@DEFIFGPGHKHGJM@IPMFUTQRY\\GLIJSGS@ECCGGCUFS@SRE@G@G@CFCHE`ENKJaPABBFEJUTC@IKCAEBGFGGW@EIAKCAITABECAB@FD\\HHENBFBBH@@BFX@FCBUGG@KDMJYLE@KCSKKK@KACKKGAQDKBUGI@EH@FBLCDIFYBSHGBGAIKUACCCCGBIB@JKLFJGJALKJGBB_EC_KECACFS@IMIIIKAEIQCEE@CN]@CKQBCDCLAD@LWAAKG@GBIKOEIEeFIACKEAAA@CKGAAGBKCEQGCEICCASDSAEB@PDR@LAHGBMBICEBMDCDAFKD@@GCEACBCD@HAFKNGDE@GICQGMMGOSEEECIBI@OIEGCGECqUG@EBCFK@MFSTBDLJFNJFFHADCJ@FHN@TIEQ@SIOCOKEBOPKFG@MEU@GBMNKGWACAACBGDQAGEBID@HGBMH]CMDKAE@AD@DDRAFADMAGMGCQ@EBEDGLANBF\\\\JLBDABWCoWKOSQEKAKMAAABK]EOBGDK@MHML_LFPCLDJJFJDHFP@JHLALDJJBDHD@DGPKLA@ICG@ERLB@LCBKAKHM@MEQ@M]C@MFMECASaG@EEMC@ECKCCKE_IOAQDABERGHGD[HKF@BDLLRJLHFHDBHFBBFFF@BABGDFJEJBRFJCBM@GIEAQJABCLKJCHC@EEICUBADIB@FMFEFE@IFPNFHHZ@`DRDFLH\\FHFHHADEN@DNDHCJBZRFBF@FBPFD@FED@BBAP@HDHDDTTBF@LPDDBDFNDDBBBDBLAD@BDFBD@HED@XHDJGFBDBHANCHEDEDAH@JGJ@H@FFFLLBPP\\PPfDZDN@XFbR^HNHDHBBJFPDRB^PvPTLJPXTPVHjHJVV\\T`PPLL^`pQDCF@NQrEXArAR@NABoJgPËSIBSLFJX\\@D@FEDULK@QOA@ABMOIC[GQCM@CDG@EB@FCBMDCLKHICC@GBYNK@IAGHAN@FHN@DGLAJLJBL@BCBE@BN\\PDJADSNCLBFBBTHLPGBMNA@GCEDMVA@MKEBUjKLKJQHS@UEcYGEQYCCIAG@YFGAGEA@mTMB_AIFEFIXARCFMJcPcNMBWPYTMHEF[VGHCLDbCJGFUNEBADAFA`GAUIMGCGK@OJAFGrF^Jf@@WLCFCJBRFPZH\\@VCXADBT^LJJLB@@ABGF@JZPF^dDF@XDLLLJTDBDAF@VHJCLED@RDnGDCBC@QBEDEJCF@DCNC\\ILBFHFBRPTNJDBBdENGREDCBGB@JDNJHDD@FAHGNGLQFMD@TNZBDCHQDADBHFFLAHDAFBANF@FDBDCJBDNVJFFDBN@JFJPFH@DCCG@CBAHAXRFBFHB@DAF@JFDHAPFFFDH@JDPAFD@BELANFDPDBJCLEJBDJFNHDHABGBKJCFRFZPzrfXPFVBRAJC"]],"encodeOffsets":[[[115640,30489]],[[115604,30499]]]},"properties":{"cp":[113.132855,29.37029],"name":"岳阳市","childNum":2}},{"id":"430700","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@FGB@J@HCJSHUDCNBFCRBXMBECKBKLMJAHCLOB@BBDF@B@BF@NOCINC@IDGJSHEB@DDBPL@FATHL@DGLA@GIQ@CBAD@DBNFAIIIAINONEPCNFLBFFJLXNLGNEHBDHNAFAFGHCHCJ@NBVJP@PFPBHADCFOFEDEBKDAPADCDIBCDADBJFLBD@@AJAJEBDDBBAFDFC@EB@HBDED@DCPBF@HDNADHD@D@@ABBBCDBBDFCD@BADDFCHB@BFCF@BCACDAF@BABBBAB@FABBBAFBDDBAAABAF@BBD@LED@BBF@BDDDFAAAD@DBF@@@B@BBFBBB@DBA@BBBADA@@BHBDA@BBB@@B@@BBBB@BBFC@BDDBDDBABBBADB@AFDD@BDBBC@DB@@BDBBABDDA@BBBBAFAFD@CBB@BFA@DB@BCRBHC@ADBDADCFBBCF@DCBBBAB@@AD@FB@ANEHEHAJ@LCDCAMBANCNEJBBA@G@ICC@GD@LFF@LCPKLSFCD@\\FDLB@@KHAJ@HCF@FAH@LCLADEHQHCDEJCLC\\JP@JADC@EY[AGH[AGBAFBNGXCHHJ@B@JWFCJ@DEFAHDBANIVKHITCHAFEFMLAHGFCDB@DEJOPDHDDHDDHFQAOHKLEBCEOAWBG@EGGKEAGDIACEAACFKFO@ALCJDHAF@HDFFDBHIVQHUDEDBHFDADGDALB\\@NEPFLJF@JCLGHKDED]FEDKPM@BBVFJHBPCFBFF@HCHBDRNHDHFJBH@EOCGOOGQBKFGFKPKJDNATMdOLALBDCPQAGDMAOWqGGKCACAKCeH[BCBBHQHQDkDEHGBEKgAUDO@CCAG@GAISQMIKIMEUMYEc@SDKDKV]AAIIGAYDOJIEGAQFEAFKLEBC@eFQFMASC[DWJAHCY]OGOOMOKU@I@GJ[E@GBIE@EAMFCbIBAAGBELGDADBJFJCFCH@JOLGAECGBECY@YDKTWBCCQCcAMDGAUEG@IAUDGNGDGDDIBSGMADGNIVYxcDIASBO@EMYACGCUGCEBMBSAKBSAI@QGAKGOGQCUEKBGCGAAADEAAEGCACCKEGIOCCIGICMACI@GEMAGDWRC@GGAECICAADABGKOAAA@CDAHCDACEOGFCAIOIACDMRCDI@ABCFCVEFK@KEEBEDKAEBIAODGCCC@ALMHCF@DCIYAIEAU@MDSJKBERCDC@MIEACH@FJJGDiJKFACCFA@I@GBSAQFYKAKLEFMMWOAEOE@GDG@eMGDKHGBE@IGEOEQMCGBI@EHKFCDEJEVOBGDOAEJCDA@CACEESGAGDMNKVCBKFGCCECAY@MGCEFAF@@CECIEAAACDWJKCMQOAAAIAAEAABIHKMGCIAODM@GFCHGTDNANCFCBEBUEC@GJI@IEGKEAgLMHKHKFWHK@C@KOKG_cUMCEOISSSGI@AE@GCEQGIMSGq@KEAGECOAKBO@GCIGICC@IDONUFCEOSIEICGIUCIOK@IAOLMGU@UGG@EBMJM@EHK@EJC@OGSEECGAOL@B@JGFC@GGEAECKEAAAEGEGAI@KIG@OHMEO@AQFI@GMS@GCGAKKBICKCCAIEACGAOHMCIEGMCAOCMBQGKBGDIHEBGBMGIAMGEEEC]@KKQDYCUQ]EM@ECIIQ@IEOCWKYEIEQHICUBGC@PBJRJHLXNDF@JBHXJJFNPJLJFBBDPDFFBDAJGJADADBJNRNDFFRFNFBL@L@@FXNDJFHHNTPD@HCHCLDD@LEHADE@CPDLEL@NGL@HDDJCFQZGFKRGBAD@DBDNHFJ@FUR@FFDCH@DDLGBE@AE@CDCACA@IFA@EGBGAACDCBAIAAGFC@EGKAGJ@JEBGAACDM@ECCECIFOBWAEAIKWMEEMCA@AF@NKX@DDTAFEJIDAFAHDDNDD@LCH@LFTCN@RCHBB@FP@TDBVJHHHFXDL@LAZB\\PBDGF@HEHGDORADDJFD^JTIL@HHVJ@RJHBTHFEJ@FTPDDKNCTKHCHAFDFDF@BABQFGDSTAHFJ@DADMHCNMNIBUBOECBIJCL@HABQPKDEDAHGHGPABE@@BFHADS\\ERED[JQ@KFAHJNCHIJ@HKNBJLN@DCTHFNDRXJ@H@HLAFDDG@EFCBAA@EA@ADE@KCC@@BHDBDABG@ADEFIAGBEEADDHHB@BCFE@IJODQLE@MHAHGFBJ@DGHBJCFSFICEBAFGDEBEAKLADCHE@DCAGCB@FCBCB@EEBAF@JELEDAFCFBJADBBFBFFHJDJDBDAFEDKFAF@F@HFFH@JDBD@LCHDF@P@HFDDLFDFAHHJDBHCB@BDB@FEDADH@BIH@BBBJ@XGZSDID@RABAAAECCCBAD@L@\\LjFDF@NDPJDZAFBJHHPTZNJRfLRNPfVTFhZCBCNEFGBGDAZG\\APDRJRPBPAFIBCHIT@FDLRLHDRRNVBLBHGNEVGLKFAFBFJJFTHPXnTLLDXBJHRFBBGLIDAFBFJH\\J@DBDLJDHDDHBBDFNEDCNKNANHTNTNJDFADIFCJ@H@FQVARAHABCBMAE@IF@FHLAFSPA@MCABI\\MVOAGLODFTEFU@UFM@OEIAIDOCK@eDOCSIE@IF@JCDGFOD_AGFMFcDaHiCEDAHATEJMHQBCBBFLHDHAJGPEDWBkEEBKLGDeBC@KEQCGGG@WFE@AD@FCDiLGBUD]CG@IFCHOHKAKEEAYI]KQDKB[CID_E@L@PAV@JCJADUKIIKOEAKMMEGBkX{PKLGLALDRELCDGFYDEBEDEPHFNTBLENU`@NSfEJGFIDAB@FE@CACB@DCBMCQGEBADEPC@GB_@EBABGbU\\@DFJBH@JCFUPE@IEC@KJEDQ@AB@FFDJJDD@NAVBJJJBRBDDDZPLLDB\\HJLBDADGFINKDk@_PQLGJFHJFBD@DGLAHHP@DEF@BJBBAFEFARFFDBHH@NDhKPDF@FEF@FHFBbENCH@ZJJFPDJHPJXJD@JCDIJCTIRCFEAEECBCHENOJENGHCF@ZPLBJCLDNHPR@FCNBXBNIFEF@HJRAHMJBFbLNDfA^IRNBHBBR@^G\\HFCHKJAPGdADAHCH@RD^BD@BCASDMEaFM@EJILBJEPA^DPEN@JA`BJADGD@RA`GALANDT@fCbETBlERB^EB@BHB@fGP@LBVCfBBA"],"encodeOffsets":[[113914,30761]]},"properties":{"cp":[111.691347,29.040225],"name":"常德市","childNum":1}},{"id":"430800","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@FOFCFAZCHEDCFKCQBKHKFGJExMlWJALFLNFBLPHHNJJDBCDI@IBU@O@K`FJC\\DLARC^LZJFBLFLBPGDGJEH@^DVCHAjKDC@EBCF@XEH@HHRDLFD@fAHCLKFAlFXAFCHOBICGKGAEDARANGFIBSBGFCjDbGdCNEHE`BPCHEDC@IJEF@TJPDfCL@PDJCJBPFN@VEV@FEESPCHKPBNUJ[BANDB@TOBEGK@EJEF@NBDABABGBQRU@E@GDIJEBCCEMIMSGSBMLMDMFCEMACGACCCGKIAC@C[IIGAEBEJCHKAAQEIGWAKCSKWmGOESIIAEBELEHKFUHMAGAKMUQQGCQKCK@EJSDGH@DCASQOQIOC[BYHCBAHEHMFADYDgSEeUMOKQQeMISYGOIGEAYBICCO@MCEiE[KK@C@ABDDFDBBABQBC@CJYTWHI@AA@AJG@ACGCBEFA@ACA@GDCAGIBGCEKECCGEO@E@GCKDC@CA@IEGGEK@EBCLEFCBCACIGIEEEAACBAAIDEBEFCFK@IBEFA@FDADA@EDABHCDF@DGBCLKFBFAHCBEFAJDRCDABEAIHIK@IAA[DGVQ@AEEGACMCAG@CLC@EG@EICUDSHO@[EMEAIFMPYDW@IEIKEMC[NWNIDIBEE@gEYMSKGMGKAMBIFe`IDI@MQKGOBKFGJMFCABKAUEAGAK@IFED@LGNSXYTOJ_`KBOAQDIDELIJMZKPG@aOUUHOPUBGAGCCcOWMAG@CHM\\cFGDMBQEMIGKGMXKLUNQPKFGDIAOUNI@GECMAGMEA_F@JCD_BSTEBC@MGWCKGCCAEAKKHsL@NLTBZCHEFIHeRMBOAICE@MLAHAVFDTL@NNFNL@DI@NRDNTXBH@HKP@HFLGJE@IEKFG@QKG@IFEHBDEFAF@NFXBPDFAXIAMGG@GAICEEIOOEG@GHMFAF@FF\\DDJDBDJPETADGBc@CDODOAGDADHJHD@FE@GEA@AJSVBFELIHGAIAIOAAI@ONMJM@CCGIEGCAKCCCBIKMKCEBKHKDKAE@CCEAIDCFGNBP@RETENIJEXIJCLBPDNPNBD@BCTDJLBFAL@PFPfDNAVSZKNaTMD@BIDKA[OuCAGBQNEBWBWDOJOPOLUFID@DbRPP@LCLGJOHCH@HP\\@HOVIrGXKPIFS@MEãËO^KHWZQNBLPPFBDB@BANIJ@BBH@D]dOVAFARADCBIBITYRGRQbCFGF@DHJFDN@DHTRn^@BEJOFGD@DEN@FHJBFCFAFKD_BGAUKGAG@EDIFFDAFAFKRQJ@DTPHLFL@FIXBFVDXFpVJLBH@HEHGD@FDFVNBB@DGHUHABDBABCCEBANFDR@JD@FFHHHHDXL|N`@dFR@NDRGJGJALDFDFBDALKJ@\\LHBJJLCLJDEAADChANGNBPFVAHCJB\\@LDfL`JRBNDRBZDZBdQ\\SPOJKFGTA\\BHBVA`KLAVO^MLGRQRKRGXYDO@OBSDIFCJEPALBJFPDVDHA@EBCPODCCOFINITCXNpTDDJDBNBBl@TFDF@R@LBRFJNPDNHFHAHGjOVKFEPALBVHTNHFLDXJFDRRNLRJbVPFRRDBL@"],"encodeOffsets":[[113287,30472]]},"properties":{"cp":[110.479921,29.127401],"name":"张家界市","childNum":1}},{"id":"430900","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@DEXK@@IeE]HqBEPIL@DHNHVJHBB_BEBCFAVMHEDICaDKHG\\UFENGZSXONAdMdONIDEBQJWFEJE`BNAnSB@HFHBZEH@JBDDRZHFdZVFT@RGLILKViFANLB@NUFCHDB@NMHAKOSGAAAEDKTMBCCI[OAMF@DA@AAKKIBIHK@CGM@EBMHGJBL@ZMHAD@JDLGDKNCDA@EFAH@DCN@RD\\HJDNPBAB@RPL@VKFC@E@CW[EITKJAÌThOpIBA@MBQBqFWRq@MDERC_oK]OK_O[SUUGIGiOUWSIOSKuO]OQAOCIEAACGMG]GaQWEM@YCeCOOO[AOKKEE@E@GHI@IBGFCFCDGBMAGACHECIWGC@GFC@EAACC@KBCAAACAMCCECAOC@KAESSCCCG@GBOAAC@EFC@OEEAE@EAYQIAGDMC@CFMBCGGGE[EKGCECQ@_CQCGEGOMJEF@FENE@EJABCVAJDFFD@DGLIDKBARIFBHJN@DAEIAQFIEIHCBA@AEEAEEAAGGCGEIKKQCK@ALE\\GHCHGFQBARCPBhNHFDL@FNDFFH@TbHDJDPEDBL\\R@RHLAJGLBDA@KKAFQH@JDB@LKHO@CGCACIIKCKBIGO@GEICIECIDKEOGAEGKGYmEOKKUWGAQ@EmYkYKECACAMACECKACG@KEQBWIGA[EIOGCCDM@GNIDC@ACAIDE@EAGIGCIDEDQD@BHH@DEBGCMISAUGELCBAAHQ@GCCGBI@KGC@GFGBGJC@EGCAIDGAKHOAEIEAC@AB@LABIOCAC@CFE@@EDI@AOGIKC@AHC@EGI@EGMAGBAHCBGMEEEAC@EDYJK@CCHIAABCTD@ACIMEG@[TE@KAKBACDOHM@EAEC@I@SAEEAIMKA@EJCDGBCCEC@CBAIAGIEAGKE@CAIAACCGAGOMCGGEEJGBCFCD@LCJGFOHMBCAKGECIDGAKBIDIPCBOD_NADCNGFGBWAMLG@QEIBCACEEASFAA@IAASKK@ECIBKEIDICEBSAKGIAQEGGAG@EFGBCAAMC[@IEKCGKSICIBKIIK@KKK@@EJEBCEMECG@CCBSESDKAQKKYQIGK[GCFMPILK@ACABAFC@EFINEAAMGCGIGCCAICE@E@GDCDEDE@CUKYLOAO@G@EDEAMFGAI@IKKGQFEBEAEIECIAQKMCACBYCCCAGBMDGHBVEDEBaKMBECGQKEGGG@EGCACBCBMRMEE@CFEBC@OGE@CF@TNJADOH@XF\\ABA@IEEBEAAECIIIAOCEGBI@CDAFDDF@JCDB@HGDMAKGYMA@IHMEMPIFINCBIIMCEGDIBCRCBC@GEAICGIKQ_K_WSHMHE@CD@DRNH@HCJ@JTDF@DAF@BPPDBR@@@@DERE@EFIEMCQOE@CJAVBFHJCHKJEDA@IICBCDIVGDE@ECCGCIBAREJGDIAOFE@AEAEBWTIDOGELFLEdDPd`@BGBGAEBADBLABcjBNCPDJNNBF@HGFAFFJBF@J@FBDHDBTOPCLCBA@KIMGWGSIEBAFHXADGDQDQO_YYOMEEBABAD@TAFCF{FCAUKE@G@CB@DBJHHALGFCNCDEHIDMLgSOOCIAUIS]_GECGSOEAOIKAEBCDAHGDMEQ@GBQAGDE@DG@GY_WQGMEAGBE@CKEKACGKAOCGBCAEUWGKSI@GJO@CIACAACCQACEEWMDGAQHOAEECQ@GIEAM@ABEJEFCHCDIHIBEHMHCDCNADGBEAIGEAG@IB@DBFHHHF@BWFSHMLSAWBAD@TCBKGAKEAIBCA@CFC@C[YAICI@GAKA@IDMB@CFCAAIA@AFSC@IFA@@CJICCY@IBGAG@EDEBEHOPC@EAGAEDAFBJAHNXTTDJLHHBDFMRY\\CBE@IIOAIBULSHS@@BPXZbEFOABNIDEHOL@FVXNLLNLLBF@HFJDRNPBJEDOAEBCDDLGDE@KKK@E@EKEDKBIJKDCDCPOJEBCDBFdd@DCH@LUZKFGAUIEDK@]LSBKFELSVFJFFLDHF@D@HDDJLPJDLHFRDHDrRdR\\RJJDH@NBFDHFDPFP@HFFHHDVAJDRGJFZFXLPDJFR@JJFDN@^FVRZDRCLL^@FDFFNHJBJFL@FAPKNARHNAPDDBHNJFNDPGHBBDJFDBLDJDLABLDH@HNT@HEJBRP@NFPGH@LJJ@HBHFBFBBLFFDFBHHD@HE@I@APKHBFDTFPHD@FIL@FGN@NIFAH@VHV@NHPKJBL@JPVDHJJDJFPTDFVEPMJCD@JDJHHDP@LAPBFDBHLFr@THJNRHDF@HBFJ@THTTPJDFVN`dLHLPD@L@XGLELGNGhKFBHLJFJ@HID@VFFADADEBMCMHSDGHEN@PCJBHDLNJGBAFBBBBJBBRPDNILCXBDBBJFFD@DE@EBDFNHZ@DBDFHDLEDALUNMHCHBFTDFDBB@DCFIPBHCPAFUFIDCLEFGJ@HANDFRFPJHF@HALGHCfNH@HCF@FPPBNXENKFBLZLRETBHAJ@B@DEBDLEjIHCII@EDGFBNJD@DCFQLATIdCFBBB@HJZCDIBMLAFDDHDPCJBFAHBD@FCFALFL@FEDUDEBAJ@DCPUH@DBJPDBEPDFDBDBDKDCB@DBBPBHLBABCDBDJBFHHD@XQHCNBHFJ@BDDNHJDJPDHJLFDDDBFHBBCFBBHBHDLAVFRDPHLHHB@RBJATBLATANDFVHHDJTFPAPBXCFwdUZMJCHBHNATCJC CHMHCHBV@JFHBVCHBNDdDRADSXCL@ZDZAFDHBFKHIPG@EDIDIECACBKHAFBHABaJEDBN@FJFHAF@I\\@H@JLVNPPPPHZ^GDIBCXD\\BTENER@fADKFELFBREHBJFPIZCHBDBHJU^CLCL@TFdNZFVJNJLRNJTHBH@DB@DCPBVLhAFGHCFClOdDNBLHPDDLAdNDI"],"encodeOffsets":[[115014,30228]]},"properties":{"cp":[112.355042,28.570066],"name":"益阳市","childNum":1}},{"id":"431000","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@AEKCKDKFI@MBA@BECAQDQEOACCACBGBEEC@CBCLEDE@CCCMAAAACFM@CAEKMBI@CCAQGGKEA[CGCGCCIGIASIKIMCAKCKBM@KDM@IDIBQGOAI@ABADDBL@@JKL@LIZCDGBGCEGEIBKCACBMJEJA@GBA@@CCAIFKB@CHCBA@CGAGBECWBCAEKBKIKA@GDC@ABI@ACEDEABECEABACA@ACE@@AM@AFC@@CC@AB@DEA@AAAABCACFICCABACCADCACBEBECCDCKOAKGGEIMGACFBNCBH^ARADIFOFKBQFENG@ABCNABIBE@EKIIGGCAGHEH@DHL@DQBIFA@KCG@GBMFGAIOCCG@GHE@QOGCG@GBKPIDEFELA\\KLMDIBUICBCFEFA@OAGCC@ELIrMNMAYZOAEDGAEACGECG@@TBXBFGLEP@JBFBDEBERIDGLFDND@@@DEDW@CGAEFI@GCGG@ACA@C@GFDFABGBKFC@AAAECCC@IFEHGPGDC@]IOIKIIIAOEGKKUESIE@IJEXEFGBUBCEFWECKDEEAEBAH@LDF@@EAAEASAK@GAEEIOACBCDADD@FDBBCAIGCK@@CBCNKBCFQ@GBQAAC@[NIAGDE@UGAA@CBAHABCMGCSEGICACBE@EIAUAKCEIIAMKECEDE@AA@GAAGAAIECAMAAK@CBCHIDIEA@GBGCIBEHA@SGQ@GOACEAOACAEQECM@ICACBKIM@SCECAUHYVE`EVADEBCCGKOBEICAG@GHOJEBCA@EDI@CDCFIAGCCACFU@GAMJEDCFQFCBBD@DCEE@GEECG@ABAACAEBCDEHAHBJBFCPAJMJCFB@FLH\\FDIHCDBBBALDBTALGD@BDDJHDPID@FDD@HKFAZFJCBC@MFCDAFCBEHKHSFCFCRBJQ@GGEIEIAYACAEGIGMGcQEIAIBACMAQ@EJMRMJKBGFE@ERMJ[DCFAPCBAKIIGIGEG@IFGGG@CAEKCACA@@CC@EE@CACC@@CEA@IACBAD@BAJIJCBMEIACBGDACE@AF@D@DGLAAGFAAEHADCBECI@SKIDELIDE@AGCGCQAGE@@DGBCAGBACAABA@AEKE@@E@ABKGKBSHcOEDAFCBE@QEcHECEESGUKKUCAG@QDM@SAQGE@KDQEMBIESBKBIFEDLX@FIVFR@PCHGHIFQBKHUBGDCH@`FH@DGX@HG@EDANQHILIRHn@JATE`CHAB[JADEJSRILEDEBI@ABARGNGFKDO@GHWFCAGKWAKEE@ECAAGAQBIEQBCAQ@SFIFWHU@GF]@CBAJGFI@ICIJMDU@SBCJGF@BDZMVEDC@WUCGBKEMU]IGG@I@EBOHINLPAFGDILQLGVGHEBBPEP@F@DDDHRBHALSXALFLBDCFGFBLDJ@DCDEDOHADBFPFRLXDBBXXDBLBRJNLV\\RhDFHBTCHBPRDJ@FEF[@GAG@KLMP@BJH`B@B@HCHY^INCJQLQVELChGNCNglIP@VAFGDUDQ@ICGEQCYHGFQNKNIFGDS@KAS@QHIL@FFDPFHHALUDEDKNCN@Hf~DRAPYlAPCJNBDBADB@GBADE@@DAHDHFDHBvNFJRN@FFDJDR@JALKBQ@OHO^OHBFDHVJPTPLDPJPHRT@DCBYN@B@RT|CHFRAFC@OCGFMFEACB@DHD@BABG@GFAFHFBDADCDAFE@EDBDTCFBDADFL@L@JNDF@DCFFJ@DIDKAADEFEH@HCLMVCJBP@HGFE@GCEGAKEEMQC@E@SFSDG@gGa@GDCDAH@FFFPPjpHFLDR@DDBFAFCDEHAREDMCGN@HDLNPR^nFRDfFNAH[dMHEBC@GCMMGBCHCJGDG@A@CISOGBGFA@UGIFKBKJCFEL@PFHTHJJDA@GPB@NB@RBXRPHH@BA@QB@FHB@@GDADAHBFFDNFLENBFLFH@HAF@DHRFLCPGFAFBFJDVBDLLNLDVDFHDFADCDIDSFEL@DAF@JFF@DCF@RHD@BI@ANADALKPJHALED@PBH@JGHMEQDIDCBAHBHBHJF@JDB@FSCI@AJQXDDDBD@JBDH@LATDF@BCF@XXDBH@@CBCDCF@DBDDAFIR@RBF@DGJ@HAF@DP\\@HBLNDXAFEDG@IHSJGFCNADCFYFGDSEQ@IHGFMFABE@CDBBAH@DCHALAF@DDFEFB@CWYGAQAEEAGJCPEPFFLPBFN@RBDJAHG@C@KFCJFJBRJDFBLBDDBFADADMHBJLLDJTDDFADABG@OBCNAFDDDBDGT@FBDJDD@BIDAJAN@DB@XBJBDPDAFFDEDCDM@IDCFBHNVFDJ@BGCYHADBJJDJHDH@JCHIBK@[AGBCFALDFAHGF@PFLELCXDJC@EBAFBVNFAFERIFAHFTNBJ@XBFP@ZMHGBGBCTATKN@TFPLD@LAPKH@HJNFFDHPBBDCD@FNCXDJEVBHHFIPAFAJAHKLAHBFLNPFLANKTHL@DADCDAPBRABDER@JCD@JBFJJLTDBHBTEF@BDDHJCF@BDCH@FHL@FCDAFBDTRHBTEJDDDHCBBDBL@BBBDKNEPBDFB@DCFGDIJAHBLTL@DCJINADDL@NDF@HFFD@FAPMLALDlhBJCFGFIDOLED@BFJTVFDFBNETJF^CJ_bEDQCE@MBADAJIDCDAFCBODADCJQN@NBFHJTPJN@^FLBLBZFB@HGHAFBDBFIV@D@LN\\BLBF@DADCL@NEHBNIDG@QEE@CBINEFAFGFOFGHADADFBDFADIDUBEDDLFHNFBD@FABC@SAC@CBCNCHEBMCGBADCHDVAJBLH@PFN@VHNALFTDDD@FKJAFBHCH@\\BPBDLBLABCFM\\CT@NFX@FDDACEBAJALENABC@INEFIFADB@DFBXHHFBJDHAFPCXBBAACIGAC@IDGTS@G@KEGGCAE@ELMVEJ@HDFHFPDNHPLNLHLFL@tSRCXADBPNNKHCHKHQHIXOAKSsYuGKMEQCEEAC@EDGR]BAFIHEAIDENGPQDIBM@IKQ@OAEEEQCCGBGHGHAPINYHUDGDAHANB^FH@RENDFDVPFJJRJHRH^FdEFAVKNU@OGSBOHOBGFIFQBCDEDAJ@PFH@@EEG@ENBD@NIOmAIDIKGCG@EHITUHQFQ@ICMY[KIKKAEDQCK@IBCDCHEFKDUFEDgBENQNEFGBEAMBIAICG@KHCHAlOL@LFDAB@DGHININQJGRCbObSFGDMBSLWDQ@SC[OiCCIGQEUKEEC[IWBI\\gDKNOHCRSPIFAHANDVNVTNLDDDJEbBLJLJHBBP@HCFCJ[FEVBjXDDFTTXzVPJFHDLDFXVDN@L\\BJHPFDDBFHEDE@KAEAAIC@EVODGFAD@HFFBF@DBJHHJFDLBNLHDDHBDFCHDBFXGF@HHFHDBLKCK^HBABEDI@KBAVLH@LEP@LPLD@H@FFFDBXFHDPFPDLJN@HBZJ`JFO@KFGJ@JD^HJBHK@KBCFCNEBG@A[W@CFGHEPBFABE@IWGSUGAMESMKIM@UDQEKIIAME_KiKEEDCVIDC@E@AGECIIEACCCMDOEGEE@KFSTI@MEGFC@K@ECFKGGIECIBIAEBIACAAEEGQQMMKGE@QBEPOACDCL@FAAEDG@GEECAAAEQBCFG@CCIBEDCH@BCCC@CHABA@ECEGQGG@GFOCIACDCBIFI[OG]C@IAKOKAKQGECEEMKEAE@IDICGBICIIK@EGI@ICK@GFI]_SIMOSOAACIEK@GHOCOEK@IDEJALSFMF[BAJADEBIDI@MRK@GCOBGFEBGFEPEZEJG@EEWA[DEVIDEAEGE@KIYHOCCW@C@IDIECGAI@CKWOKAC@@FALHFAAEGK@GLADACIKQGGICEG@CDIAMHK"],"encodeOffsets":[[116680,26053]]},"properties":{"cp":[113.032067,25.793589],"name":"郴州市","childNum":1}},{"id":"431100","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@JHHCHBBBCD@HBBNBHHJAJEFGBIDCNED@DBDHLJF@DEGE@CB@HC@AEEICACAMDIJEBAFAJ@FFDBBABAN@BEAKPMDGVBJDDDFNFBRDN@D@BG@IAGGACMJAHCD@HLF@N@NDHFFJFFLBF@FCJQBIDCFCLKDKRQBGBCNGZCC]@CNWHQZWHSFGDIFO@QFGJGDGAKBCPOHKJENCJADSHEDORODADDDDFJJ^CFIBABDFC@IGCBALKJEH@FBDJDJFZ@FDHAFDFAFEVID@RJjGRMHADEB@DDAPBDDBHAB@@HBFHFHAFGDDFABC@AC@AIJGLE@ANB@CHGFBDAJGHABA@ECIICACDKACAAEA@A@KFEFAX@DEHALEBE@IGC@ANGCIDA@CKE@CB@AEEAGBACEFAAEIICDGTEDC@EACA@KBAEMI@EDIAI@GCEAGPCRRNNLLbZnXR@LCPINMDE@QAQGKEEICIAQDE@GCSMIKAEAMEHBHABIDSRCBAAGGQ@EEBMNI@GOCMK@AJCBA@MJCBCCGMKM@CAEC@GHCAGNCBCAIDE@CIAFKCGFEACEAGFCFG@BSAQDCPEDC@CEM@ABC@QCE@CFEDG@AFBFFH@JCBIHFJAHIBMIWBiBADBHLJDF@BADEBAFBDJFDHAFGBICGCSGKMQBQDKCMA_CSIIAADUFM@MCKEEGC@EHKHMLINEF@HDD@DCGMAK@CLAB@DDBADWHIH@BWACBEEE@E@IFKDELILAJEVHB@LGD@TPDJB@H@HCFOBADAD@NNHDJANG\\cBGEMCeEQ]mOQMCK@GHMNDFCBQFGDCBEAECCQ@KCGEioOOEE@EBGDCHCb@hHH@TCTEF@D@NRFFBLFHHDF@HE@GAODINUDK@GFGFEBCLBJC@CEIDE@CCEIMK@K@CECBEASDACFCF@BEDCBCACGEBEHEH@BA@AGC@CDAFBNEHEPDD@BEEQDGS{@Q@AZMDA@CQSOGOIKCSOIOGUECGA]PGP@PARKLIBQ@ICEC@EQMEIuMGAECCGBG@CF@BCHAA@BCCAMADIBOZkBOCQe}@GDMLMFCVCBKGGOEEC@EJKZGL@LBT@RILMZSZGRDHFJDR@VCHCBE@UJOhkDMHMDgFKRURKDIJMZ]DG@G@A_AIG@ANOLKH@HB\\@FE@ECIOQGASDGACEQgU[MKQIKACAWWAAWCQKOEAEBCPGFCDC@CCIAKHEDEACEKBKTWBKAGGQCC@C@EFOAOIAKEOKYOQAQDOUAADGAACAEA_DCBEJE@ICGD[IAB@R@HGDITMDAK@GBMCGC@CLQEOEE@IGOBMIMIKFG@CAOBQIMM]@OCOCEICIQDUIK@E@ANQgyCEWIAKB[EK@CJCDMDGTIHOF@HCDEN@PGTC@CAWCEEWCIBEAECIDQEKLGBCIGBEACAECAEADECCGCEIG@QNABOGO@GIGEiOACBG@EYWYCWGACAEDGICCCKGKMMIBWAKGSKGKFSTUNWFQ@MDGDEHCBM@GAKSCCIAQAIB_LI@[C]IKDADBPAHY@OHYB]KMAKB[FUXGBI@GAIKGC]GKAI@GDWDQBCBADGDCICAGAGFG@QGGIUQ]iSUEIASJ[BIAQAEEEEAaFGB[NGDIAGCKQSuCQACUKMNEFG@EAACICAMCAI@EDIHE@@HIRQNAFIFMFMFQ@KBACCKCA[AAFATCJC@KCE@EBEFADJTNPLTJHDNDFHDFJAHETBFLPF`LTF\\CVKZepEN@LNRHNBJCJGFIBEHAFNXDDRDBBHR@NBHCBKBEBCFGFOBKLINGP@P@JDPJHdNJDNTDVALAFCDIBO@[F_PILCLDf`tFNEHIBaCIDIJCJAXIHODWCCAGQCSMKKCO@sHEJOLOFMFEJELATCFEBIHEDCAWMACFEAKCCGEQ@CAaWIKGGAQCGYOKQ@CECE@wW]UGIQEc@eICCLuKwGIACDQ@KB]EIU@QGK@SEWKI@MBIDEBOAIAGMICK@GJCBIGEGMIE@ABDJFHP@FL@DK@CN@HDPFRKNYDCBCF@FHFDF@NAD[XADALEP@FDJCNGT@DDTFLHLHJDF@DA@EBADLLZZHL@BADGDAD@FJLBFALXhLHBDETHHXHjTJ@JAFBDJDFHBX@B@DJPPRHLHVFLDHHBFALJN@NOZ@DBH@HOf@HVNLAFHXLHFdlPdLH@JDFNNHLFBtGdXNDDBJTTLLD@XBFJP@JBBDBF@F@JEB@BBBJBDPDHHPZBDBNCHBRHNRXDA@DDB@HBBFBABDFAD@@BDLbAbGX@NBPXNN@DAFEJILKHURKRCJ@ZF^BVELCFAvBDLFHNRFF@PGH@jLPADBHF^FRHVdLLPBHCJ@NFDD@LE`EjEJKFCJDRHRDDpDRPFBPATFLTABODWHGAGCGCE@CD@JBDJLADEBC@ECGAM@QDEAGCOOC@MRCBoGA@@BDF@DKNBPADABC@OEEGCMCCC@GDQ^C@E@YICMA@OEYQIGEIAMCOEKA@EBOJgBQHEHAFATCHCF_XGLADDDPBBBCJSLGHAFJL@B]HABAHBJAFADWECB@BFFFHBVBDJFHL@NLZ@DCHJJ@DCHBDDDJDTVDJBJFJZFHJH@NAD@BB@DABOHKHCHIHADNRNJLFDHBBA@MEADFHPJ@F@JDJCD@PMNETALDHBHPRBD@PBDFDBDCDEBGL@HJH@DCP@HFFL@\\HDB@D@LDP@FGHBPKRCDEPCB[BECUCAAAGAAUHEAGGGACFAJADC@EGE@GDOPCDBDJT@PBLEFGBYCWBMFE@UE[@KAGBKDMAIBMAEGE@GBODYVG@ECEHIACD@HABICGGC@KFGAA@@DDJBHABQCCBGHID]AKFAFBLLTPNDFBRJHBD@BKNADBPHNFXFJBJDFPJLH@B@DEF@DBFRLPb@LGNBFHDBBBTFDBBBDA^GF@DFJBD@PEbFhFNHFP@JDbGHBNf@HADGH@FBBNBHFNBLEBEFQEOAUKYCQ@S@IbYX]HSDAJEBABEACACSGHM@CEI@IBCNCLKB@JDBAFCLC@CGIBCFARAPCBBBJJBJJRJJHFFFDPAVDTG@L@FDJHLB@H@FKDEBAL@JFBDBPBDHDDLA\\ENIr@FFJLFBDANNNBJAHFHEJ@FD`DFLHBDAFEDDLEBIBGFAPAJ@HGTIHODCDAJGH@DxVBDDLFHJAFBFBDD@LABGH@PBFLDBDBHH\\EPFNCDGDADAJDL@BEJEJCDAFPRANPbj^@H@JBD\\HDALMF@TFRD^IHBDBHNBBD@R@HIFCB@DJFDdABABIF@LBLGLAFBJDJBZARJLBJAFCBGDWRGNUGM@EBABCFAACBA@GBCDAJ@XBF@FADQBCTADIPGHELBPJF@NCH@DJDDND@BEDBBLBAFAVDH@JHJBPDDLBJ@HDJALIRGDADB"],"encodeOffsets":[[114370,27478]]},"properties":{"cp":[111.608019,26.434516],"name":"永州市","childNum":1}},{"id":"431200","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@JDLHFBBA@GEEWGEBCDBDH@"],["@@GEAG@MACEAUAQE]KGCEOE[OCGFK@GAEIAULMPIROPKFFD@JMJK@CMK@CAICIBYHAD@HBFEHALGJBDI@A@AOAAA@GGCBCFC@A@CECCIBMCBCGQEECACIUCUNCF@JJJ@LETKL@LDPJJLHFRDHADGBIAIBKJEVCHIGSDE^KJ@^HDCSmAO@KBKFEXIXENIAODOFIDIAMGIEe@OAICCUKYcBELGBCAIJIKUAGBEFG[]IKCSKYKISYWUOKaMOSE]IkBUAECCC@MIEIEO@SCQEMEQGOCEIEOC_F]NKHIBQEGEUcESKS@K@EDELIVGJGBEAOBODGBIJMHGFIFMDMAISiEWCCWKUGQCIJIHGBABDVBFABEAaAsKEBQFQIC@G@ICK@@LFBBBOLABBBHJD@JEBB@JBBBDCFIDGFCJED@DDJBJFFJD@H@FHHALBJF@HGTCBD@LFDHPJHDFAD@DLP@DIJ@FAFMDCBGNEBGCEE@ABGCEICM@BR@BOBMLG@MCYBEFAF@dCHKHIDQCMEMKQSKGSEY@_BQCKII[CCSEUBIDEFBFCJOJIRKHOFCVCN_DKDGHARIPFJ@F@LAT@NDATQHCBBCFBDHAJFDBX@HCFBJ@D@DAB@@DDLBHBFJHBR@HABOHEHERGNCGBGCAEDBBEB@AADKGIFALCHKJBFFH@JELIHCPCDDDF@LB@HCFSFKFIPOl@JLNJNFNFFAFFN@NJHJNHFJDOVCHGBEA_UCCBAHGEAC@EC@CF@@CM@KEQD_EGCUME@]BGAKGKEGIKAQ@@HGPWN@BDF@Hg@QNOECBC@OZENERAHBLDFFHZFFDDFBDBPFVPZN`LlFJHJn^XLZBHDHFBHAFMDMAEBCF@LBHldDHAFI\\@HDHNBLFJBFFFFDHATCRCJEHEDEBHHGDKCG@HLBJCFAHFFBRGFEDALGJANAFGHQHGJAF@PCLAFCBGAQQOEOFQJMHMLcvERLFF@DEHCF@NFVDT@NChMNDFBFJJHVHFHENEHBHFBH@DETCNEL@BDBXFLLJLFRPTHLDPBNC|@FADCDYHAHFTFFEHE@C@AAWCCYKACBCBATEVBJCRCNC`SJIJEVIHHHAJBFAHED@DBAFCF@DFFHFP@RGLJLFH@TJBF@JGHKHILGN@HP^BLTXPDxDdK`OZIRIF@FBTXBFZZB@DCBGBATB@@@HBHNBVMD@JDB@BAEG@CHGBOBCBIHI\\Q@CIGAK@ENCCIBALBHEJABCN@D@AJLDTJD@RGLBDCHMJER@NNJ@DOESFGVODECECIOIKD]BQI"],["@@AKHEDGLGF@RKNALKFAFEIACGBCFFHAJBFEBCH@BAACGC@AD@LDF@BCB@@FBBDAFEH@CCBEGKG@I@QWMCGEDS@CKMAILM@GJIDGIMBGLER@\\IFCFQT[BCEG@AF@BAHOHGBGFCLCROBA@GDKJIDAPFVAJANMDMNGBC@CEIBGTSHCREBA@ACECEBEDGLGDSLMCCSO@EFIGEASIG@QUIGGK@SJ]IECCIBCPQHCFG@GHEAC[OYAKBK@WCGEGGUICA@SEOA@GAQDM@SDKEG@KDC@OEAABKBAJCHOCSBGJSBQBANDFFXNJLFBPBP@HAJEFDDD@FCNBDHBFA@IHILBFHD@HEBBBJDADCBBAHFHB@JEB@BDCF@DBDF@HACK@CDGEC@EVQ@EEIMGAC@CBCHALQHEHKNSCICCG@G@OJIAIFQC@DCFGBKFC@KCGDGDC@SOGMEGCIWM@EK@K@EAEMEQCEQMIMCACBIBIHCBEACECOAAIEIKMOIEWIAG@ICEWMGKQIAIAQGKC@O@OEECCGAE@MCGII[QcQqQGCQCGECKOIIKCC@G@CGEKCEEEITUFKLETA^KL@FCVJHBLEVY@KDG@CccAEDCFAPIDODCLCJILAFCFLF@L@LLF@HCCKDCFAPBFCAIMOCQEI@GAEKKKMMKUW@EPKFGJCAMPBFEYaOW@AT@TGVKJAPBJJF@DAZ[NQCEGAKGCISSMWBGAIBEFCHBFBD@POFGFAFCH@HBJAZ@DDIJ@DB@JED@ET@BJBBBED@DNAJCB@BL@HDJBJ\\Z@DED@DDBJAFBBLLHDA@SBCXATBNKTGXE@AGEGGAE@CcBaAAEE[KK@CDCVGJGFAV@@AIG@CCGCCGOIKOKOSACDODE@G@IAC@ADCRC@EEO[OIACGCCEAG@GCCE@CIEIKCA@IFA@@KCEAAABGAEA@IDE@CCEIKEEACBCICAEDECM@MGC@IDEAMDk@SHMJQJKBKAICGIKoQiQW@ILKNCJIHOBODKFEJCLDJAJEDI@KZyDUD]FQJENCVBJAHEF]CEAEMCKGCIBGAOCCTG@AICMFI@@ADCC@AADE@IDGHEFGAOACUGcSWSGKICICK@MBS\\SPW`MLCBG@IEA@@JBHLP@BCDAJGDCCCC@GBC@Ae@AAAIEGICWCO@K@KEIME@EIAEICAIJICAKFCKBG]SCIEGCMBI`KHQBgFIJO@EAIGG[SU[EOA_IaGKCA@IGMQOGUGIKIAEMMOECABEHO@ACECEHKAOEAMK[EM@IDEHQXEFIRG@SEIEWQFGKMSQwWaSIIEO@UE_KMOIOCU@_NWLIDIJGDIDE@OKGMKCEEEM@EHWBEAKS]AMEEEAOD@HGFO@KAEDGJADABOKA@EDA@IEiMcEGEKO[SOGWGKGO]FKRKHUMgGE]GOEWKQQEMCOBMFM@UACCCGOOBGCEBOEOKIMMgCEEAUB[MGSDGHINELINQBOAEGI]QSAIBICEGO_CeGK@ADIHKTECO@IJOBOFIDADEGQAKHIDGCCKD@ADM@EAAGCQDAA@AJIDE@AGACCCIAKHCFENED@DFDA@ABK@AHCBCAOEAGEEAKFKAIBC@K]QOMMAEAEG@IDK@ED@DFBDD@DIAGBAB@FCFGDGFIBK@@FCBWDQCIAGECFUPEHFTCPC@E@MMQ@IFGNCDKAQHC@SIKCBIC@M@ADIBGFKAABDJMD@FBLJH@D[RGJAJADAPGH@DFHABA@ICC@UNMAAG@G@@SAABAHCDA@YYAESWEAE@QJYJ_PcLwCOCSWAKO]@GHMJKLGHG@IAESIG@KEKIQHO@GEEE@CDEBECAC@GFEBIAGBGGUJIFIJ_TMDQDIDUASFABADBDZLDDBXTMPEDC@AECAEBEDCD@DDDF^FPNF@@FADBFHDHFDLRJBDCDGDYRE@@EBIFG@GEGECGAKDGDCDAAACFELG@EACCEUAGDIFQHKAMLBDAHABG@@FBN@NANEPM\\S\\AJBFDHPNLNBHEVAVFLBFCDEDS@KFEDGXIDMCCK@GIEEGQIBSSGS@CBBDNNBDMNCX@FPDFJNFJAJDLHHJVBTPdRFBFABCRCFBFFADDNDBFDVBHDDDCRCHE^CHCBQIKFCA@BBFDFCL@FFDNAHH@FELFH@DADWRGJ@LAJMLALDLBHQLAFT@DBAFEBIBOAABCBCHEBGAE@IM@EDCNEDCAAGCGIUNQHYBAHDBN@JCHDPABBBDBNADM@IAG@IBCFBHDDJ@BDAFG@GCCFBDBDHBGN@DJDJHBJFL@J@HKBKAGCGGIQOCEBSNEFAJMZ@HCFC@WCCBBNKACE@KAEBECBMAABBHADGDAFCCAICAI@SJI@QEU@AA@CBMBAUCM@eCOGUGO@IDGFGNEXIDGBSIGIWkU[kmKGMBEHAAMU@ICGCAMBCDAFIAMFKEI@BEDAGCGBA@]HICCBE@@FBFJPDH@LTZZJBHBDBDEHEBKBS@A@GGK@IGUDKAAAACAAEAQOC@CNGOGIMCWDELKAOMBEECAE@CGEIEcMi[IKUGE@IECBECACDIBCBAN@@CAGFMAISI@@@BDDIAAEAAI@GAMCCFDLDD@H@DCHMGHI@CCCC@CFKEM@EEIKMKSEE@@DDFHDARENBLA@CGGNABDM@CC@CBBHADKFIAAFEDCFCFBFGFFD@DCLCFCDGIK@EDDHKAGDADKFIHE@AB@FAB[LFFNFLLBDJAH@FKLCF@HDLDHHFBD@NCD@DDEH@DJTDDNBFALIDINFFJAPHHNFNNFHDPBBDBDD@FCBBFLCFFH@BDA^HJIFINAHHDDHABKACFODCDBBDDJ@BFADHFTJVFPFJPT@JBDH@D@FLHPHFFCVFFJBFAHMDB@FLBJDHJLFFB@FBBZGHCB@DHFPJHD@BDAPBHMZ@FET@DDBHDF@HODCTGFBBLJJF@D@DEF@NHTBEV@HHJB@NGB@DDFL@DGHAFBFFPNR@BGDAHGJXJHNNFFFBBBLGFAFE@CEGCAGEKKEG@GBCFADFJFDJMH@@L@HDFH@BHLLDHFFFBL@HB@GDCHCAABG@KIS@EBCH@PBHJHF^XRTFFLBL@LOFGJEJCPABAFE@ODENAPHHDXBJALBPALBFDFHBHAdG\\BVFJLJ\\RXTj^XTTNt^JBLBZILBRTFHRAJAFLABELGREJLZHFDLLZBPG\\CTOdAFFDVHBD[\\]JC@IHIBENOFAB@D@JJNDPBFJFDFHBLHLZDFVP@JCNCFGF@BBFNRDBXBFABICI@KBALAHFJLJFTJDEF@DDBJDFHFLEHDD@BE@IAK@EJCFMFCD@HDJFHLFJJ@BBBHLHHAFCDBDABABCBAB@FFD@FADGDCF@FDDFLZD@DEDALHBB@DIDAB@DDDFBXBTPBF@JCHGFAFAFFL@DADGHAD@JYBCBADBZDNHB@JFJRGJ@JEJ@BBAJ@DJNVFFHLHFNDBNBJAHJNFJJPFBHADKR@DBJLPJ@PL@DE\\BDHJBDCFGD@FDHFBNEJBLCdJX@RHD@ACKGAEAQBKEEKGAKLADCP_DALJdDNHVBJ@HABCKODCP@LAHANMVKDCLSTADCFEPEJABBBLDBFD@BCD@DFFFDLAPHF@NEH@B@BC@I@AD@LFBDCHDHFBDADEJCBCBEAO@E@CFATPDBFALMNEBCBEGOBGNGJGHEDAJ@lVHJBLJH@BENAJEHBHDBNBFDDDLPDBPDHAFJL@PDBBJLJHBD@HBZHJDJBBJ@DBFDBF@FITCD@FB@H@H@DLJBAJDJADEDSLOTGTALFDR@vARHHFJLBDADAD]TCD@FFHDBpHJFBD@HCFYTAHLLVHRHJFBFDRAFEFKDABBJBBH@Z@NDNMPAF@DBNTDLAJKT@BFDCFYNGAC@GFK@CDCJAFG@EBYLGLDFMPCJ@DDDP@BF@DIPEJ@`FBBBBDDXFFHBRBDBTT@FEDCNCDUAIBMRCHABSDQPOJG@CCEMGB_hKFOTATH^AFMPGDDFBNFBLARAFADE@CCI@CRCFBDNDD`JLLADIDEDKVFAHDFFDRBFB@PC^@NDVJTFBD@REFOB@LBJAJBDAHOBCXCTJFL@DGPEHBH@DGJEX@DLDBB@BQJQFADJZBLJPFBF@DAJKHCHB@JAFBJLBDBLZFBLCH@BLFXCXDPBNFDBTHHFZEV@JFLFDD@DALGRIH@N@ZFTTDXChFPDXjtNBBBHDLNXHBFCJGLBFAHBLBFDDLHXDNHD@FATS`ADC@IDAXCH@DFDHBBNBFD@HMJPVJBHCLEROVMLKNWLHJHFNARCNEH[dGN@DBHXNdPDDBHAHOVGPVVbPH@LONYJIFKJCRCPBLA`_PIZSTWHM@KFCJEL@HBFBBVALDBNEHILEPALHNRJ@JCNMXQJENALBNHLHNTFZ@hFFJAJCXM\\MNDLFFJ@JCXOZENBJNF\\FP@TGVCJD@F@BHFFKH@BBFNHBFF@BURCHB\\JBL@"]],"encodeOffsets":[[[112095,27476]],[[112543,27312]],[[113577,29733]]]},"properties":{"cp":[109.97824,27.550082],"name":"怀化市","childNum":3}},{"id":"431300","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HGFODCDAJJB@FCLIDGGIAEBUDIF@RPNDHFD@DEF@BADO@CEAMBQQ@ABE@CCEISA@ODEBECOMFEF@NGRGD@PNDBJH`LLRHJJDFB@HADQDADCJFHNDJJDAJMJENONFJGB@ZNLHNBHC@GCAIDE@CCBEDCJ@HADFBPJJDJBFFBFALFBAAECU@WPGBCMI@QBEHAPHD@FADEF@NFNQFCFBFHH@HHLFHRFDNAbLFAFCAUHGNCHADBDDAZBDNDRLJBFDFJFBFARELHJLJ@HBNEFBFCH@P@PBZKECAGCIAEFERGBACGMYBGHGHCH@RFLHRTHBXIJMN[NGLKPEDGJQF]JS@KDG@GZwBICEB[DMFIJIHCFBBFDVFDFCD]LeJEJCVOF@NDVPJ@HEJGFMFSGMGKCSBEPANCDGFEPCJK@ACA[GGEC_AECEE@CF@DBH@LABCDI@I@GC@A@EEEAGDAPCBA@CGAI@CFEBMBG@AC[GCCKKAEBCH@BAAI@AHC@AIGAC@IBGAC@AD@@HBBB@BEHBBDBBDCF@@KBCJBDC@EGQJCDCFGBGZGDBFFNLHDFCJDBKFEH@FBVTBDCF@BHJD@H@FEFIBIDEHCD@BDDNHFBAFEFAFABCACBAVBZFNC@BAHDTAD@BPJDDDKF@RRBJ@DBDHBFADF@JDLBRB@H@HIHAFAHBJGL@LBVHJARMJMNIFKDIAIIK@UAEGCkCICCC@IDINKPMlWJCLGDIAMFSCWCKIOSW@ECGKEEKBGCE@GAC@MCI@AD@DCBG@GDAFAJBJHFAHAAAEEBCD@NNLCJHDADQHBFADDBCAEDANEF@FHDDJ@FBBDDBJ@JF@HCD@DDDN@DDAFCFB@BFFBDHBDCH^FREHEJSAACFCAAIDIIGBAJAFEHBFGHBDBJBBCHCN[F]FGPKRCVIPIJKPIFG@GCCSCGACCBGLK@EQBBEGAECA@EFCA@CDEFABECGFC@CDIAEIAKEAABMAECAC@CFCAAHC@@DG@EJGGACAC@EEGACCAEBC@DKACAAEF[KCBCNCDOB_NsE_E@DFLAFCBMAAABCCAMFY@GFGDKEGGSFA@ECBEACEAGBCAACCEGIKKEGACFGDKAEKIAIBCOAGCAAAGC@OJABAACIFCAMCCIAIGKEACBGCEBE@CGG@GAAIEE@EFIDADAF@HF@@BKDCHCBAB@FDJEJOAIH@BFF@BGH@HQEGNGHSHCBCAECBKKKAGB@D@JF@A@EECEAACJSFGBC@OIMMGAMBIDCFGHA@AEEEGCA[CEAEKGCACFGCCC@OFGA@BC@AOBCDAACGBCDABKK@CA@CFACCBEEABCCEBACQJ@BEDINAPBTCNCP@PATCdEHOFSEGDKHMPITCJcBKGGDCJAJCLJRKHQLKNWHIHK@MHUNWNGDIHCF@FBDDDFHAPONWTcdKJKDKNEFOAICKUACGAMDIFKJCJAXEFIBMMG@CDE^@HDLGBMAQB_FK@IBEFGLEPEDE@ICE@E@aZOJCAAABOAECDCHGFMPCBGAEKYaCAEHID@DCDBJEHCJDBB@DCF@HEDFBHGDGHEBDF@DADEB@HABCBCABIKCE@CFBBDDBDBBJ@JNDHADICCBBDH@BBEPC@BGACGABFGAAA@ECASJEBC@@CLIHAEEEIEAAFBFEDAHGBCCABCBAFEBAHDJADCCEJ@PAJ_BEHEJBLAJC@GFIAECIWGEAC[IA@CFCADAACIBGEQCgMIEEGCKOCG@EFGTGFOHOCWM_]UeQIECGKKBCAGBAAACFEBACKACICAECAI@EDCA@EGDGH@DB@B@FGB@@BKRCBQBcPIN_\\C@GAaSEKKQGDIAIB@A@GAAEB@MGAAGECiXABDRAFCDEBM@MBOGGFMDEDCF@JOGGDCHEJDHFDADAAACCBC@CGGCEF@DFD@BOHCACEAAIBIFI@MEMAGBALILO@KAYAMFCF@JDLAPCPUVSDYAEDKBKB]UWBEHJRG\\IHKFQ@OESAWCM@SDWByKK@WFCDDFCTAJGFIBUAMDIFERC^CVYz@LCJIFIBKCIDEFCLAPGPIJMDKL@JRXRjLpHJJDLBLARINITGl@NCFBJCD@NHN@FDFCDBDJDAFBLFFJDDF@JCDBALBBFBLD@@EB@JDBJLJF@DDFHDH@FBDDDHJB\\PFP@DCDMBCD@BBD@J@HCFCPBDPTPLJLHPDDDH@DJH@BU@EBIHUHCD@DLLF\\BFbBZ@XEJDJHJBFEDMDCNGFGJAJGDCDGFEFIBAN@FBHJR@FDBFGPBRCHXNFFBDDRBDDBJB@DIP@HTJHLVXBFADDHBPHLBDFLDLF@HAFBHNXRZ`@HCHF@HCRBHAR@NFHCBGDCFALBPJFBTPDHHF^`JTBVDJPPhTNKJCFGDCDMHEBKGGAI@CDAH@F@VLDB|EDEBE@SBCBAFANFZP`ZRPRCHCBCGWBEFATJXHNHLJDAFKPOASGCAC@E@IAEEIBEHE@GAEMMCIDOAMdiBAAKBCFAHBHA@Ac_COFcEKFKPHJCXSFAFB@BEFBPCJIHQFABDJHJFBFA"],"encodeOffsets":[[114195,28738]]},"properties":{"cp":[112.008497,27.728136],"name":"娄底市","childNum":1}},{"id":"433100","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@JEFCH@HBVLHB`ALCBEDEAEGI@EFM@CHCPEFI@Am]SQCGM@ECGI@CHEDERaHQZQJSJADABCBQBEPU^c@CAG@AJIBM@ACAEAOOAKRMXYLGP]äÌNFT@JELOHWJqPU@GO[@GDGPGHIDK@KOOaQ@CJCVEPKPOPIXCXAFARMHADBv\\PLBJC@ANCbSLMTYBUCMOeOEK@EBKACIDS@AACOMCMAODKJIFWJIFMFS@QAOHMDEJCFBDDF@LBLCLGFALDLNAJDDLDDBFHHJDDN@NIPMJ@BBJPJBHBJGFKAETUBIB@HFF@@EGCGIBCHCPBPCDCd@HABCFSIOACICCCE[@EBENEHGH@PFJPFFJDHBH@NHJBBWCEAOEW@MBEFEACFGJEH@RLH@LEJFF@HIEK@GLO@GAGSWCMMQJ@@CMKME@MSKECBUBGHGHCTFJ@NAfQJGFEDGAYKS@MtKLGBGAEHKDIAEWGKMGCAAMAisCWEODgCWMOECYEM@ODUNGBECEK@IFUEYGGASECAMCODWEWAKG@KDEAKYCAKAAIBE@IGAGDILCBE@EAIOAKIYBCRERI@AAAKC@CFWHI@CAGFGHO@CEKSIWDADGPCBIAIBKAA@EPQFC@EAISCU@MD]@OEAQAECCEBGELUFCJCBCAAII_ICCCMEAQD@DDJ@DCFEBQBKBEAAMCEHCNOBEG]BSPSLE`gHAFNDDH@PIROTCBADGNQJAVBDCDMFC@ESSCAQAGAEECWACAAEA@_FIJO@CAEO@CC@CDINOCEHKZKFAH@BEDIDCL@HED@HBZMDEEC@ALSBICKMSCAE@OBMNMCY@G@AAAIBALCFEBECQAEIEQGUGKKBGZSDE@GACIEoGCAEG@EDC^SBCBCACIKGEQGuBQ@ECBKHSPSTKFCBCCIBIIACKG@G@A@@EDCJS@EAEECCAI@AACIGIAY@GACIGIKAAOCK@EIGBOCCAKOCCECMACAAGFGBIFM@AIGAKGIkUI@CBGFIHMHAHHPAFADMFKNEBCASOEB@D@FBPAFADIDCFCBEACGDGACKEC@@B@JADA@G@MFE@OGKBECEE@CDC@AECCAAKAAIBOFEFCDSBKTCDULMNGBKBO@CDLPADGBI@UAMGcCKICBO`CDKBBLLHFFALBRBFLHBDC@QGW@cIKDIAIDE@ECAGBCFADEACGIACF[@COKI@KOAI@CLQBCAGOEIIMEGIIBMACAEMKGEGUEIM@CBIAAI@IFI@QHEI@IGACMAYBCDAZA@IBCHGBC@CEKBEBEHEDG@IAESOWAEACC@CBAJC@CAAKGCBCFC@KYCEECE@CDCHEBC@EEA@ABADABCBCAEDGBKGAGAAI@EIGKIEGCC@EDENID@FBL@JAFC@GCKFGECEAICCE@CFSIIEIKGEKBAB@LDJAJEBWACAGGGO@AHEDEDM@IUOCEKYKGGACEIEAECOIMGHC@QCCEE@GDEHECKBaEAD@DNHFHDF@FGFUDHJCF@PCBIDOPAHGBM@ABBD@@KDBDPPABS@LNNFEBCDBFHH@FEH@HBHLV@DEHUTMNBHDBPFBDABM@QCBJGHAL@FDNBHEJKN@DFRAHCJDLEJCDANIPAHBJHJN@FFH@@FDFEXDFXPRLDBdBFDBFFHBHFH@DHHBDDB@DEFGFCLQJCFMBEBEHQFGAEGCKGSCAYGIOI@C@ANBJDbDN@NDJNNBFAPBPBDXVDL@LFJNNBHE\\@FNHBVEb@HDLHNVVFFBF@FADCDAHB@FBHDFDJTBBAFID@BLD^VXB@JC@OA[HE@ECG@CEIKCAE@C@AFXbABC@GDQDMHE@I@GMWQQEI@QHAFDFDHAHGHIDCHEFIBKFDJADAHHFEBC@AFCJALJJBHHHDHFDDDBFDHBREFQ@ADDB@BCFI@CBCDENDHEFBHEH@PCDBFCRDFCDAFBH@JDLDFFBAFGABFAHHNDVDDDBJADBEHBNCNBBCT@BLDFHABCBEFAP@L^NHVDBBTBDHFBJJFP@FDFCBBAFBB@DEBE@EJ@DEJEBCDDJFBAPEFBDADC@BBA@EFCAABEAEDG@QU@GQAUKM@EFIJKHEDG@CCGGIEGEIAUQAHWNED@BFF@BK@EHBDRLBJFJHBJ@JFXNlPjTJDJH@FILGDGBCBEH@HHHPHFAH@BDADBFJ@@DLJBBLDDHD@@FGDCFBFTNBF@JEHIDW@CBBD@FE@@DEDE@CDMBKDADBBHA@HABDD@BIBGAECA@GBGFAJBHBPJPAL@LEH@LELBFDFCJDX@HEHKJBDF@ED@HBTFNDBAFJDFFBPDDFBH@@VCP@FBFDPFNBLRdJBL@FBDDL\\@`FNAJHFNFN\\LJDF@HENEDCVCDGBIDMCEBcREBCAC@CFOJIBOAO@ABAB@RILCPCFBDJ@BHJCJCFAJFLLNCVBFD@F@NCDQJCFGP@JBHJNPH@BEJ@FJjADWZGFAH@FFFr\\|VDDTLZXDBFJHDHHALDDBJCHBHABOBABDPAPG\\Fb@LBVFHFDNDXLFADAFIPCLCB@BDKPIBBDFJ@HQXIHED@DDJ@BDDBHZPDHFDHBDAJCFED@APED@DRJF@DEDB@DAHQPGNBBJLDH@JELLLDBD@`QFBDDBBAHKJEH@TBHCFAF@DDDFDD@DARABC@KBALEHGHADBBHCHITBZDVFHHDBADCHCFCX@DPLNNjAJ@JA@K@ABBHJDJAPGD@FFBJH@BB@BABIBIL@L@BDDRCDBDBDIDACIBAbARKDATNNLAJBFBBDBZFhDRGhKJ@LDD@@EAU@ENOLCFBRLHBt@HBNH"],"encodeOffsets":[[112349,30324]]},"properties":{"cp":[109.739735,28.314296],"name":"湘西土家族苗族自治州","childNum":1}}],"UTF8Encoding":true});
}));