/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/

(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('吉林', {"type":"FeatureCollection","features":[{"id":"220100","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@B@ACAB@AEBBB@@AAABDBFA"],["@@BAIFBBFE"],["@@AA@@BBFACGAB@DGBDBBBBA"],["@@GBEDE@EFCNSJUFKDE@KFADOFE@ABMFMRKHSFMBEBGH]VORIFKDIDAJILIFCFBBHBDHDBF@LD@DDBH@JDNFNH@FGBBF@NCDDDFBCLGFK@KCK@QGEDCDDF@BO@KACBGBECK@GACBILCDKAGHCBHL`P@BGDFFADSDAFDBAFOFIACBBTLN@DG@GJMFEH@HADSDOL@DHDAFBJIN@JKFIJBHLD@DBB@BDJCD@FDBBDCHFH@B@BCB@B@LEFCDDDAD@FCFB^C@BBA@GJCC@A@@BCA@@@GADCCAQIBCMEABGCABHDCBEAEEQFFCKAAECCQBC@@CIAFABCDBAAFAECCBC@ACFBBEB@@AD@AAD@AA@CDA@AAGA@@A@A@CB@@CI@EAKBEA@AE@@AD@BCB@DGEADGPFBCB@FGAABEEA@EGAA@G@SECCAEKK@GJ@DABECABCDBAEB@DCBABA@DDADC@ABC@CBCEAPID@EABGAAADAABAC@@CAGEAAFQDB@EB@FMAACEA@AEA@CACCB@BCCADA@GCBCKBCABA@CA@@CI@@AAAEB@ACABEECE@AEC@ABG@BBKCDEEEC@@A@AIDAAABACCDFFECABBDA@EECB@K@BAJA@@EG@@AJAI@@GIBCLG@DEGCGB@HC@ABAA@DKCBEQPBB@N@@C@AJGDADDBC@@BFB@BC@CB@DFBAFH@CDFBBDFBCBDDHBHADBABBBDCD@B@CB@DF@DBF@@FFCBBENE@@BBBCJ@BB@JDADEBM@C@@FJDABBBEFBFIJ@DB@J@PDDAB@@EFBF@PF@BG@ABADBBABD@ABE@@DABBFEFAFA@ABA@FD@LJBDFCBBDAF@BAFI@@DLDFFDBDID@AJABJ@ADCA@BFBBBDBEBGJDBEBFBBBF@BBF@@BFBBFFF@BD@@BAFDBADGACCA@@HBDA@AHC@AD@FA@@BB@@BDBC@CHKFBD@DA@BDEBBBBB@DxPADIFBFIBIFEFI@CVFBALB@HGNHBBQJ]NSPWFWNICEBCCAAEFE@OLIAGFC@INQJFH@BmTeJEHHB@DQACBECABCFDDCDQRGN]dMJ_P@DCDADBBCDJHAJFBADDHADDFFDDJANADCFMFCJAJ^FKRQC@FFDJBOXEBMCOJ@FABO@BDK@A@@BJ@@BM@@BN@@D]@Y\\EACFEC@CCACBACFE@CA@FICBINA@JOEACHAABCIABCC@CFBEA@ADAAABEABCECEFGBG@FG@AIJEA@@FEAAAB@CA@GDGEEBICA@CAB@CA@AEA@BIADGOAIVFBFFBFFFCFBBABEH@DB@ANEFI@AFCAGACDG@ABADABCBE@ADCB@BF@AD@BC@@BC@ADGDCLBNDBADF@@DE@AD@B@DCACD@DC@HDCBDFF@DDRJFFBFMBcNsJADDBCNE@AEQAQCBFCDAHABDBADCDGAIJFDKLBDEBQ@UCE@ICIIGAK@AD@DOHCF@AABAAMHIJ@AA@MHI@AHIAGE@LABAFBB@BB@BHADDDGHCFD@JK@BEHB@FG@@KRE@GJBDLFBFJD@DNJ@DFLEB@CE@@HEHBDGBC@AJG@CAEAA@BBC@AABACAABGECBNJ@BABB@CB@FD@BDJDJHCDMHC@GFCACBAAGL@BDBEDAPGBABDBAFNHDE^bBCRLFJBLAPAFE@MI@GBGACGCCEWGCBICADA@BGAD@C@COGIPIBCFAABEIN@ABCA@ADA@BECACFI@@CCC@HC@BIA@AJ@@@IA@@FC@AGDGAACJBHA@AGA@@HA@CGIAALB@CJUIAJCA@ASACHA@FMG@CFGBCHCAHME@CHKB@FCDCJA@BKGAGHAHE@ABFF@BADCH@F@HABEAI`DFCPCBPHCHXPF@ABB@ADFBIFDBIBPHPJAPBBGJ@DADKPFBQPDBMLHDGH`JDTCFKHIHMCGH@B@HD@BCDAHDS\\G@ADC@AABCEACNE@AFUECJELDB@DE@GLOCKP@FBDLDDAHFLPNEDDPM`LFERNJGPHFELAJHHVE@IH[LYTGDEBC@IGCDGHEAIJD@EHDBCDDBDCH@CHFB@BFDGLICKHYRCAA@CCGBIFKLFDCHHDDDFANDAFBDDAFDDABDHCBJGLHJKNBBCD@B_\\n\\DBF@FRHLVHJCBBHF@BJDbZIFKLbXHEHH\\HXFJ@TFNBVHfFL@TEPIJCjTXTBDCNHDVSF@PM`RHIDBDEDLEJFDBJKJab¾zFALIRFLAJE¾zJGlRT@DFFDJPNLADbPJUBAJDBBHOxLBEF@BCTBH@bc@@SZD@DCF@CHBBFGFCLBJD@DFBD@HEFAGFJFDDJFGLBBRJVNB@DCAEBCJ@FAL@DCLFJ@@DHFF@RDHDH@@DBBFCHBDD@DD@LJDAGEHBFEHBHHFBDCBEDCD@LABADABAACDADBH@tPRHLBTJ@DE@MPIDKBCBADELCDCBAAGIE@EDGBCAAEEAEHCABA@AIBIFMFGJE@@DE@@RJDNDFDH@BEB@^BNGREP@LDNLRJVBNFJRFDFB\\BRFNB\\@PC@A@EIACC@CDCJ@TBL@LDBDBJNRHHPFH@FADCDMDAHCh@FADEFKHCRBFBFNLDHB`AJ@LBDDVHtBPFRGHIHAF@HBBLNHHL|d@DCPBDFJFDHDF@NCRAZDfA^DJ@HCFCLQFADCFGDMNMBG@KBERKZADCRGDCDE@CKO@CBCRGN@FATK@CIGEIC@LSJAJBDDFFDDBFDBJBNABC@AXANDJ@JALCBAAKDKBGFGHCVCREHAFE@C@EDAJGEIEAFUDEJIVCjOTFNFFD@DNFFCH@ZHZPDBLER@nJ@FCHBBIJBBKFADHJHAB@ABFJEDHTABIDFLJCBLHRI@CGA@BJC@AECAKFF^RAJPBLJ@BH@HC@@CCAA@@DBPFZVA^GTGDCJbBJAHHB@JBB\\@tFAcAMBAFDDBFBHENABDAB@FDB@BBFXGJ@BBABLFFFALBBBHA@ACC@@FC@@FADGBAB@FC@O@CBADBRABI@CDC@I@BBIH@BIHCJBB@DA@AF@PBBRHD@HBBAXPLB@FTFBDADBFABBHD@DFEF@BCDBBAD@BBBAFB@@BBD@BYLBDAFADCF@DB@BHDBCDBDA@DBCBFDA@BBADBB@BB@@DDBA@ABB@GD@F@BCJDBABD@@BABADCBZPD@BBFHHB@BEDEJE@@DED@FDDEHGCED@ACBAHINDDBDEJ@DDBD@JAH@HNJHDC@EBCH@JHDBDAFIDAHADBBBFJHBJEDEBCAGBCF@LHPADD@DED@DBBBBRAF@DDADGDAD@HFFHDJANGPAJBDBBDABUJ@DBBRBFD@DIJ@FBDFDJ@FCDCAMFEF@NHDALCD@DJNFLLD@D@BADIDCL@FBHDDDDLDFXFDJTNNHFFHD\\JHLJDFBHADKLIZ@HHHNDBD@HCL@TFVDBDDBJ@JCL@BBBHDDJDFA`QDALDRX`BLCLAJCVEJKFA`CDIFADGFADATBDABCAAMG@CBCRCJGJADCDILGD@LBDADCBCHGH@FAJBDALANDL@TBHCBAAMBCNCbFRENS^MDO@MBCBGDEH@LHF@JCFAHDJPHDLCBA@QDEDAF@FDHFFBHNFBLIJAPEDBRHF@TCJ@XFJ@LEFQDAD@LFBBBDHFbCFEBCKICI@CJCJAHCEMHKDKEI@IEE@CFMCAFGHCP@JEJMLGDMBCHCHA@IBAJE@CAG@CNGXGFEBG@EBCT@DABCKEMI@A@GD@H@DHB@DCDANABEAA@ALCFIDAFGAIBCNCBABCGG@CFAJDF@BCBIJK@AA@MA@CHWAKCECKA@C@C@EHE@@ABCCKBECAQA@BM@U@QEACGCSAAA@EGAKGGGGSGGDEBG@OBEOKCQ@GIEIQDGBYFM@EJ]AGHIAMBEJEFI\\]@GDANMDGNIHMBEIS@YCG@EAGEE@CDEDCAGBCF@AGFCHEBGAMEGBQDGCKBQAAEAIEAABGKA@EBCBAH@@CJEF@@EDC@GDI@KHIB@@E]KgGKCUiGGG@YDg@KCIEE@GDUHUDKCGKGAGBBIAGEA_AGCEBEFGHMFEJ@NGB@BaCKB[GQAABKGGAAAE@BCAAA@C@@FECCBCBAAC@QBGA@@EBAAACEB@BACCB@CABAGOBODACABA@CBIIEDE@AD@BJHABDBCBDFEFWDAAODEGHDFCEECDC@IHAACB@DADCC@CE@@FAG@HKBEABJG@AEABBBMADFE@CEMBCDC@CCCDQAABCDBDCH@DHDEBI@AFCAIB@FBDAB@@FBDDGDAC@BEJgAFIBGD@LEFECCKD@DE@AAID@@BDCDG@AAC@@BCACFGBBAC@CBGBCAAB@E[CE@BBKBIIJABIGA@CC@G@AFECBEACBCAEEAEHEAKD@EGCFAIA@CA@CFA@CAAAMEA@GJWDGACBYDYAIFE@ABABBJA@C@OQEAEIBIFCMCG@@BC@KBMIGADQDEJGbKNI@IEGICSAGEBQEI@QXUFCHIDKAEAC[OEIHGLCrHRDJ@PEJI@I@GI_BERCDCDGAEQOIAIE_ECAEGDIFETMHOAK@_HIBA\\GHEBE@AEGUGIGCG@MAGS]@KFIJGNCbADANIBC@EAEEIKE[EOKEEGO@GHKCKKKMECDQCW@CABAE@GAEDEABFCCA@AFEHAA@CCACBIAABBDAFIAEBG@AAEEM@ACECG@KFaEUJGJGFOBEBGBS@QFCABMCCBEFCCCQDAAGKCAAICE@GAFCB@DCF@DDD@JELQEIBC@O@C@EECDM@AABCCAQBCCGE@CCEAGICCGG@GHOAODGDEACDAAAEA@WE@ADGGCEAAIFCFGMCK@GEWEACDGHADGACEBEKG@ABEB@DGDCFI@IHG@AIGCECKECEBCCGAECCGAKG@KCEKEIEAE@CCKDGOAIDAEOE@KEIEAOAGMCAI@IK@GOI@ABAAABACC@ECCFEAGAABACC@ECE@EHEBCJCB@BAH@CEBALKH@AILU@SJIFQACEAGCCDIGD@BCFAFGHCDAHCD@D@CCBCACDCAECACECC@CA@@EACBABALFAIGCBCB@BOQ@IEKAC@OAO@ECK@CDCCE@EIB@CGB@@A@IGADGE@EBKCDAAAKA@AMCWBGDBDMDCDCB[BCBEBOESI@BDBEFKE@DDFADEBK@OEMKKACDCJUAECADC@@FeBGWGOGKGMOG@AJ@DC@ACCAEFADEDCA@EBGC@ABAEC@CCEDEHCCE@ECCRKDBB@BCE@AADEFBBCF@ACDCGEADE@@A@ACCACHADDBAAADAAA@CC@BCACD@ABBBDCHBD@BEECBCDA@DBBF@BABEG@JEAACADKCA@CFC@CBCAGB@BDD@BGFABIFCEC@AFE@GHADG@CG@DGLIDBBDB@BCLIHDDA@AECDCEAAADGFCBCFAFEACE@AAHC@CAA@CBCHCACGEDCJDJEBACCDCCEBECGLGDMKB@GCC@CDC@GDE@CBCFABACAACEEEG@ABMAG@@GACADE@ECCKABCL@EEBCECG@GCACBC@AGGLEAACGSGECBCBEL@@A@CBAPCBCG@AAAYIEGIGAAA@GDCJAHEH@DAEC@GBAFDDAFIAEBCDCFC@IDA@ECGBABAFDD@JILCR@HCDDD@EGBALGFADIJDFCHCD@FDB@CC@IJC@AEGJG@CBEB@HEAGBA@CBCFCDCLDJEDBDBBHDBF@LAJAHE@AAC@CHCBA@KBABEDCCIFAL@PG@C@ELGEI@CBCCACAA@EEABE@AGE@IC_ICAEECHMHCBCAMIA@DGEE@EIACESCSGC@EDGCOA@ADG@CIASCSKeEQ@OGEBEAI@GHQDGJIDGJED@DG@YKQMCAGKGGIAGEE@GCQEOEMAECICCAG@GBKACOSASE"]],"encodeOffsets":[[[129762,45603]],[[129749,45600]],[[129758,45602]],[[128715,44302]]]},"properties":{"cp":[125.3245,43.886841],"name":"长春市","childNum":4}},{"id":"220200","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@EBECC@BBEDGCFHVC@C"],["@@FCFACAGF@B"],["@@AA@@DD@@AA"],["@@TFTBDPLBHAH@DBJDFDNBPFRFHDF@HFJBHHHLDBRNZLH@@CFCHIJCHIRCHGJ@FBFAPHR@fFTLTDJB@DCH@BPBHDFCD@THTDDFJB@FFFCHB@NJDBDANGDGFFDB`JJDF@BHF@BAFFB@DBDBAD@DFJKH@F@DOHK@EBDJCDAFAB@LABGD@DBD@BGFIBKBE@CAAGCACAIFKCCDEDAD@DABBHGFA@AF@DIHFH@BID@JDDA@ECC@GDEDICCJEBKHABFHC@CCGDQ@KDIJC@ECABABDH@FCB@JEDCDADBFEJCBECAB@HFDCBG@GFIBCD@HBBHBHJJFBZBBH@ADODAB@D@BK@AFADFDTHDHBBKFHH@BADBDHDH@FDADFFK@ADLBDD@FCFDBHB@@BHAN@BFHFFBDDBABEBAD@DCF@HCD@DDD@HLACNKHDHAFDFCDDDABIFICCDHFBDGDAD@DBB@DGDBBF@BDEFEBADEDCHBBFBCDFD@BCBGCKJADA@ACCAKJCHH@@DCHGB@HEF@BFDEDAJEBAHC@ACA@BHAD@DED@DDBCLDBBBIFH@AFABE@AA@CCBADFDAFC@GACDAABAC@BDADD@@DBBCBBBABCCGBBDDD@B@BF@BCHFCDBDE@ADEACFBBF@ADA@CAQLDD@FDFGDCFDF@DFDAB@BHDFAB@CDCFEBBFDD@BCDI@@BPHHNHLHPHXfA@ED@BCFDVBDIDCLBNLPFL@FABCCE@CLFFECA@ATJPFFADA\\ADADCNCACHCXAND@BLBBBCBLDFAF@CHHB@J@BA@DHA@FJF@DDDCL@FDP@PBD@LBJFR@APA@ADHDBJKEABABBD@FB@@DDDDFDBBFCDBDADDDC@C@GDCBGDEHEBADC@JHDCHDFBBDERIJ@TKVBJG@KLABDFG@ABA@IDADGF@FDF@FDDABBBBHEFDD@FDDABBBAB@BPJ@HJLJ@DBHNPBFBFJ@LPFBFJCPBCHDL@DBFJFLFDF@LLHHBDDBFDHADDFLFFDHDBJH@JGJ@DEHC@CFABAH@FLFABDCHGBCHBDXFHFL@NDEHEDBJFBHDCH@BXFB@BFBBDCFBHCPCPBHGH@DHJDBHDF@DHFDDRADBADBBN@DCFFD@P@D@JARFFK@ICC@CDE@CDABE@HDFBJDBHLBBRCDDEDAFDDANDBRET@HAFAPAHEHIVIbFLEH@FDBDN@FFBBH@FAJBBEACBAJBDADB@DBBFGBEB@DDAEFBFCHBF@ABDBX@RDDCNFLLDLGL@HHPFFPL\\FLFFJBF@FADMJCBaBMDIHEJ@LT^BH@NDHJHVHFH@BAFGF[HABGJ@`BLGPSNEFCJFHDB`FJFJBRPBFCHCDQDAFJ`@H@JIJOFI@QCqGKDGHFJ\\PBDBFCLGJEDWV@RFJARHFTBJDFH@JMJaLIHCFCRHBNJLAD@@AH@NDEDAJFJFBPRF@AIBABAF@JEZBZCDAHBXCHIB@NFBBDBB@DEB@@DJBEBHD@FLCFBFGFBBFADBDAFFDBEH@D@@DHBAJIBJJLAAAF@\\D@FBADBHADAD@ABHADEDB@AD@BBH@DCAC@@JCBBF@@CLCDDEFKFC@AHEJhBFI@ABDHCCCEA@@BAAC@EJADBBEJ@FAGC@CDGACDCBARBDCDDD@DCNADFF@CENBAABABFH@AIFBLA@GBH@EF@@DDDDCACDABBDCBEFC@BDBBADDHC@CBADJBABDA@@DB@RAFECEDACABAIG@ABCF@FCJJDAB@BABDPCPABHBA@DDABD@AFABDBBFA@@HBRAD@BBDADAFD@ED@B@BBADF@BBHBLHBARB\\HLAbD@AHA@MFINEHGFEFAHD`BFBBHAJHAHBHLLDVCVGHCF@JFLDh@ZCJBFFVjLDhH^L@@@FH@LHLNHFPNLHLD@HBJCD@DLTT@LBDAL@RKNCN@DDC@ABJD@BABLBF@BBCBHBBFJD@HBFD@FAJHBHCBEBAD@BFBNELHHBBANBP@HFJ@D@FEHELDFADABCMII@@EGCAI@AREPDLIJBF@DCF@BCDDHELCHFHPDHAFBF@DFFBDHBJArALAL@BCJAÆEJDH@HEBCCAHGHCJ@FCL@JCHCAADCP@FDF@HALE@CF@JCPBB@BEHC@EB@H@FDDAHCF@B@ACTGDCAC@CFGFCNCFBHCJFDA@CJEJBHA@B@BD@BEHABBB@LUJC@EB@AGDABIICEEG@CEMEEABICAEIBCI@CGK@OBQ@EFCF@DIEGBKCEBCBG@CACCGAACBEAAECQAFSHCFKUW@IDGH@AC@EHKFGF@@KDAJ@^KHMFEBEACA@GKBIACOKACECIIAI@AAABCFCJ@DAD@DAD@FCHABGD@DCPMBEDCBECEBEAKNDLEDKJIF@@ADCTKFIFCFGNABGAEHCBIFA@GLGL@FGAAHEXGHEBGPI@CDEEEKIFGBEDAFG@ECAIBEAACQMBCEKC@CCEIIEPGDCDMHE@CDEDCDEBCPGDGHINABAFBBBFLJIPENMNCBA@GNGLCRLLDFDJL@LDBBFFFHJFBFDJKBIAC@KCO@UCEDQFIHCCIBAFEBCAEHECIDK@CBGCA@IIQHCFABEDAPEFCJADEJ@LAHGNELGPDLFNJBDFB@DH@BCRGFDVALDJC@EDGJCBEJGLGDEFE@CICGEOACKAA]G@KICCEACKGMCMAACGEEIWK@CIGDG@EEM@E@APEFEOBICCCHOFEBEICEIAOCIOBKAPGVEFGDAHEJCBAACJEJAFCH@HEFAFCZGHCBCBAXADGCE@CDALADA@CAECMJA@AEEECEOCFIFSFAEACKBEAUQCIAICCDEHCQM@ANE@EFC@CCC@CEE\\CHEBEFABCNBDCECAEHIIE@QHQLCBA@G@AJIFGBECEBALEBCPGFCXCLGJDLEHHPCFE@CCCHA@CEE@AJI@EDA@CCAK@OED@@GFC@CEEI@EEFABCFCEEBECCBABGCA@@HCBAFCACFCAADGECAECAGGI@CAAEAA@EC@FCECBA@ED@@GEEGACBCEGAIBMDMBC@CEEAGGCKEECKKEAGKBIDMAAEKGFGAGICE@IGKACGBE@GMAAQCCA@EDQ@KI@@BEEKFECC@E@ADEFGKCK@CAEIGA@ECA@EAGMEUBWHCDEOGCBA@AMGCGEAIINGBCBIAKBEAEGG@CII@]DGFER@BA@AIQASMOJKEMEGEMMECKBCKECABC@CFAAGOCCEMCWCK@OKS@KBGGEA@APIPMBEAGEA@EGEI@KIDI^ELEJCNGBEFCBIJICGBKECBCSOIOAEGGAC@KCM]UIAEIGCGEOGQCEEAGCAQ@ICACECCEASEAIGGCCCBEACKCGCC@EKMC_EiAGAKBBGPG@EXKFGCCAEDEIADKGIEQCAHADCAKDCDKDE@IKAWIAG@GEE@CGGKKAEDACCBEFGFAHCZBJ@D@BCAEFEBCBA@EB@H@JEFEBGJGDKJIL@HARKTBHEHA@CB@LBFOJEBGHGF@PDJCDCLBFADC@GFCPAPIFCFCBECC@AJIAGP@HEDAZUHCHCHAFBF@FAF@JCNEJGHCJ@F@FBHBXAFEHDBBHHDFFFJBDELC@ANCFE@GBCLILEFGN@D@HHD@REH@BGHEKMACBCACBEGGBCBCAG@ABAFAJEJABE@GDE@CDCBCN@DGHAHECAAEKAHIGI@EGECCQHQBKDIJ@NQLM@MBQBe@OBYL[@GAGGM[DCF@RFFABCEEGEIEIDCE@GJKCIAAGAUBCACGCAWGKKEIG@CFEDIBIMIE@CHI@CCEMCCEBETEDCAICGECGC]@OEg_CEAWCGKKGCQBGAMYCAEBG@KQQKCAMBGCUEOGCBCFCBEICAQBIAAACKBYFCLDHABEECBIWGSAOBGCAC@CNO@CCEAEBQQKE@OHIDQJQ@OAWEEBDHABO@IFM@]N]BCBCB@DDP@FCDUDCDCLIHOZCTADGAMGKEa@ICGGBOAEAAWCIGWGQIG@YLIAQEE@EDAHDNJPNHDF@FCD@PHLFPPNLNPRJZBRBRCJIHEBQDABCDALEHCLYPCD@LQPCD@JD`AHAHGHGNAD@PDTPXCLIHEAGGEA@AGKBCAA@GIGICEKMCEKBAKEA@@FEBGCSCGHADA@ICC@[CK@IAGEIFIDGHG@IJEBECGIK@ECEAK@GDKACCACCAEGKAAEIGIDI@EFG@EJKHAFG@ACCBEAOJK@IDUDEKIAS@MBMCKBKHMC@CGE@ODOGEUAKEEBGFE@CAE@SDIAGEO@CCGCSBESKCDGCQEC@CCCAEEACCAEAC@GDCBGHIH@@SBEAGGEK@GAIGICEI@GAGEACECA@CCEACOEKACBIHE@CDQZIH@J_BKFODIJSBIAEFBFAJIFC@GCCDGBILCBGAE@ED@DACMIICCGIECCE@CBICQMG@CAEKIEYBCAOGCA@GIA@AAEBGEI@CAAK@EAI@QAOHINEAIDKBABCDGDICEBACEAAACAG@GJKA[CGCACK@E@GCGBCAG@CCKJS@KHA@@BE@CBADEDAHSJCAGBBBAB@DCB@DCB@DCBBBDHBBAFHD@DABBBABDN@BRFDFCBCFBBADADAB@BEDBDAFBBHFBDEFEBAFCDBDABAJADDFB@BBAD@DLL@JANCFEHQHO@KAGEGKICM@GBaTWBGAKEGQEECASEQBC@MECCCGGGSCM@CCBEAAOEIBEACDGBEDDDCBCHM@ADKBI@ADA@C@CCCAM@@BCAE@AAIEE@@BCBCACDBBCBEAABEBACC@CDA@CFA@CAG@AAEBAA@CABAE@DA@ACA@@AKBOACB@ABAAACBC@@BE@C@EEEBEA@BA@@DAAEB@FC@CBACE@AAA@@DA@ACC@@AC@CBCBB@ABEACBAAA@@A@ACBCAAAABAECDE@BDCBIAED@@C@A@@@EAODBDECC@AACDOFBBAB@BABCCEDIAA@BBADAB@BC@BBCB@@CDBBABA@EDBBADCBABADC@AAC@AAKBACEB@BABACGBADAAAB@AA@@BC@ADGA@BABCA@BABE@BBC@@BC@@B@@BBABCAADAAABA@EDAC@BABBD@ACB@AA@@BA@@@CABFC@@B@BCF@BCDE@DDABA@ADEB@DEBBBA@A@ABBBEF@DCFEB@DBBAD@BBB@BAB@JADO@@FEDD@BHABBBBHCDC@FDALBBCD@BLAEDDAOLMFK@iNMH[@KBD@LH@BADHJPNPHGBG@OJDDJAP@@B@DBBABEBUCGDAFE@ADODAJEL@FBBIL@JCDCBADIDEACHE@GDJBABG@ADCB_LKBOHMCYGG@ECI@CA@EECKHGB@FBBAD@HCFGDODKL[FSJODIHCHCFOHDLBRADGFH@FCFEDEHGBELEPAHDJAJGD@hNVDBB@FHHBFGBEDADGH@FFFFBFADBBCFABCBCLAVFHDRD\\NFDGFKBI@@NCBCDE@CLIJ@FEFKBC@CCIBECSAECGAGBEAKBCJGD@NCBAHC@ABBFCFABGCCCA@CJBDAB@BAHQV@FDHBDGHAFABEACFCHCDAHABK@C@GBAFCFCHCBCLDJXJAHDDHHHDBDBBTLJJZV"]],"encodeOffsets":[[[129762,45603]],[[129745,45604]],[[129758,45602]],[[128715,44302]]]},"properties":{"cp":[126.55302,43.843577],"name":"吉林市","childNum":4}},{"id":"220300","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@BBDADBHED@NGDCIGICACC@@EDAA@BA@AMIDAHFBADBABBBD@AAB@FBDBH@BID@HAACFG@GF@@DFAEK@CMI@CICAEKEACHIF@LQ@@EHA@FG@AILC@DEHGCCBCAGA@@AAABEBA@KHFJBBGJ@NGB@@BJINGBBBA@BDEPG@CBCL@HBJJJDF@VDR@FAACLKECJIHBDCBCCABABGDCAERDRBBFF@DMCABCtIdMNAAEEEQICCE@CEDAGCD@@CDCDB@C@ABCF@@CE@BCCAAMDKHCBCD@@AD@@ABCE@@ADABCF@DABABCBAH@DCHBDBBEJ@FEBMA@@CFGBAAADEEEAEEEEAJUPBCHJB@AFB@BDBA@DBB@JDFAHFHCB@@DBABBEF@@FBJI@BEHH@HAFEFDADFBBABBBCB@AFDED@ADJBADBBDGFBIPB@JMDAEJB@@DEFBDDADB@DFDDEFBZ[^@@CM@@AN@@AI@@AB@L@ACP@BA@EPINDFAPWIAEC@ERDLQ]EBIDINEDEBCBMCIECCEBCCGBCEABIIGDCAABCDC@C`ONI^cHMRQDCCCDEBAFDDARB@CGAFGfInS@AEGRIJMD@HEJBPKF@FEBBDDFAJDXMXETO^MRIAAMGGHA@BKEADUJ@FEJEJAAEJEBCwO@CAAAAFAACB@@CACLEDGD@CA@AA@@AB@@EBCD@BGB@AC@GB@DDHBBCCABE@AC@@AEEAEEA@AE@AAE@AAEAFACAHIFACAAAEA@ADBBCI@BABIC@CJCAEEKC@CJ@BE@ABEACDACEIA@KECB@BAB@BEFEAEBA@CF@BAC@BAAABCBAH@@AOEE@EA@FA@CBOCI@A@@CJIAEFEAABAIC@ED@N@FABCICA@@ADIAA@AF@FMAAED@EE@CAE@@CDAA@C@CDAABACAGBGACCDAEAACEADCG@BEEA@CDAD@@AEA@AD@CABCHCBID@@@@MAAROAFLD@CBBBAD@@GHAHDCFH@DKJA@HJ@IB@BH@@FB@BI@A@LDAFFB@ACBAFDEEDCBDBABBJC@B@BD@FFCFLDAAH@BAD@BFF@FDAFDB@BFABB@BJ@@DB@@DABDBLAADHDB@BCDD@ADABD@DFB@BFBBDNB@EFAA@RCBEFBBH@DD@ABBBBCBBAHFBC@OJFBAD@DAD@BCDCB@CABABCDA@BFCAADDBAFCBI@@HLLBFDDTFH@B@HB@FFBAFBBEHA@ADOECHFBCHA@ADC@@BF@@BFBLAFBJ@@DA@@D@B@BB@BH@BCB@DBBC@BBC@@BA@AFEABDD@DAFDEBBBCAADEBJB@DD@RADDBFLBEDREFFFBDAGCBAHDBANFADRJDBCDHB@@B@AD@@@BDDHIB@AAD@A]DE@EBCCCDCFE@K@ADA@A@AEGDGACCA@EDCCI@AAA@CKCAGJILE@IJMAIBEGC@CPKTCBC@GFGNEHIH@@CKMASDAJBPEBECABETCBCEEHC@A_OGKDAHGLBDCJKDAHBL@FDHADALBP@@ACEDCFCRHL@LDL@JGBIEACCDC@MAEHA@EMGMEICG@CA@CKCE@CACGGAAABCLGJKBIJCLCJEPQ^UHGFANATELGNQNEBAF@PEBCLEF@LCVETIDMFEF@FCHAYUIISKAAACGCGGCCBGWICIDKDADGDEBEHAD@L@BABGDCDGDEFBBABEHGACCG@ERUBG@ABAACDIB@DDHDBADEAEBAD@BGDA@MHCDILAFBHAHBFDTBFDJADDD@LAFE@EJIDKF@DCDA@MJ@LAFC@ACC[MQCGCUEKBADADEBADCAEBEAEE@EHGBCFCHAAEGG@EAAUCgMC@IHIBGCOBKFAFGHCFEFIDC@HEBEAOCKgVGBW@[EQDO@ODEBCDEJMFWTIDSFUDUCSDeDCHAFAHCLBHAHKL@HBF@HIRDHCL@FRZFLAJGJELGJG@GDG@EBCBENCFEFI@CDBDADC@OACBCJ@BMBIFWOAEAEM@KAK@EBMBMHIIEA@EDEAEHKH@@GGCBECEBE@KOKCEBKIIAGHED@DEHEBCDBN@PA\\CDCDIAKCAIMGECE@CBEGEDE@EKEQDGFIBud]JSBULMDYNMDMFADCJKHILSJCJCBKLAHCDIDMLGJEDIHCBDFABEDANIHuCeBKIS@GBUEeAE@CAEBEEICE@KD[CECG@SNIAIFSKQCACKGBGCEKEMEOFYGOBUMFYICMGECABOGWQSIAEIBCEGCQAEKQIEBI@YSKGMAC@IHQHWGMBGGMEK@MJCAECE@KCAC@SCCKKKE[QCI@EAIGCCCSCQDY@WKGCACQGMKMW@ICACCAGDG@MDEAK@IKMAGBCG@BCOGDECMAAMFIBIAOEAEAABKAGBADCF@@AIECEEAM@AGBEAA[GKKFGCIMKEIABEECAAGMCAEGBC@AC@CMGCGOBWGCEBGGKDCACACE@GHOAE@ADE@EBACE@IGGEAADEECE@BDCDCBOGIACEGAGEACGGDEACFI@EFCAGAAGCCCOBE@EFBD@FDFADBBCD@BDL@LCBELDDABIHGBE@ABFL@FADKFECGIC@A@CFG@GDK@GBECGDuBEDDLEBADDPEDBBLDBDLHBDD@BAJCHHLDBBAFDBBDDADAHDJ@BHJBFDJ@JDDLPJAJBFCDBFDDAFQNG@EJEB@FABI@CB[KcAE@E@@BOBEFC@CBE@@BCB@BGB@DMJADIDGHIFNNn°¦A@ADEDABBBOD_PKHORSPQRQDQBOHKNIPKHGBUNKKOJAACDPHaPDBGDDDIDHHI@GDJJDBBD@DABBBCBBBEHHHABHJDABBEFCFAFABDHCFBBAHF@ADC@AAE@AFBBABE@IECBADECCBDDADBBABC@AC@EAACBCCCDDHEBKEA@BCA@KBCDECG@ABBDCD@DEBACCACDDDFDABKA@FDBADBBEHIGE@E@ACBAIAAECDE@AC@CAACD@BABKEABEA@AC@CB@FDBKDAC@E@AE@KHIAADJBEDC@CEGBBDFD@BEAEEE@@BKDEECD@DCBA@AEDEE@@BC@@@BA@CE@KBCCGB@FC@DF@LDBBFKLLPGDCDG@BCAAEJMCJR@BCHEC@SEUAWOEBUPQPCAMNKDEFMPabQLFFWJKJ@BCACBCAMFIHKDE@AAIBGCWDEDDB@HDJ@HDHKJGLA@G@CBODWFCJEDQF@HBBAFCDDB@DBBADBBDBCJ@FFF@FPJJNHFOFMJFDGFADMHEEYLOCWNSJB@@BQLIBBGKMEBCACBE@C@AACD@D@@GCCEC@EBGIGCGAEA@ENGAICCBEAAGACGBAHEBAC@G@CADCJCGCGCOOC@GBAAAABADCJ@@AAAC@IDKAIIEBCAACDC@AGEAAHE@AEAI@FMIGAEBALABADEAAQ@CC@EDALA@ACIāGqVklQTQNY[OEIHQTUZENIPKLOCK@EHKAEoUKbe`KP@PAHIPONODEJ{CgVT^HZo`C`TVBLLJBQ¦YFDBLLTAB@BAF[XOA@CICYnF@AFDLCF@FFCDKHEHCJDBAACDCLCRALCBAAEBCBAF@LJFBD@DCLBJAJBTFHADD@JDLCDIF@BLHADEF@BJB@BED@BJDH@BDJ@FGD@@BADLFDFIH@DBFD@DBGDFDBDGBABDHCDED@FCD@HEFCHBDCBADCDBFHFBB@F@HGD@DCDBDBFCBACCBBDF@EDABBDC@CFG@AFCB@BCB@DGLCBDFA@CCECEAEDKNAJHF@dJD@JNBB@C^A@EH@FIBIGE@JHGDMT@DB@ARM@AFEBAF@D@HBBAD@JLHABBXCDEBAFBF@FGL@BC@@FB@EDCDSAETCDBDCHDFAFSbAB@RGBECADC@@BE@GLBD@BE@ABG@CJCFGPOEADEBACCAM\\IJL@A@LJT@BBHBJDtEJAJE@ADCBMHiP@@A@GLB@ANAHG@CNVHELHBCDFBIJrFLBFAJ@\\EVAPEBJNFBDHBT@HCF@DAFDFABDJ@BAL@BBDDD@JAB@@DN@TDFBPCN@\\CCHHLF\\HPBXAhMTCdAJDPPRHH`JD^@BCJUVMGG@E@AJId[DMBAH@GKPI@EHEHDJAHDLGJDHE@ABAZYACMI@EDEKENG¦c^\\CzD¶CHJxDPL@DNHLCRAdIbA@CBAJADCDBHFfFPO@KACJCXANEEE@CBAHLBEPJRBJHLMAFBJHOH@@DFBDIDBBDH@@OD@@DF@ALD@N@B@AIF@BPAHT@FBDAACDAVAPGZDPELFADCBFBADJHGFBBABRCD@IJB@DCLARFNBAJB@FEB@BAAF@BDED@@HD@@DDCNBACD@@C@FDAAFBBZF@LBFB@@IDGDB@DBBB@@EFBBJD@BGB@AHB@DGBBCNBDBBBDDADE@CBGPJNDDDJCLPBDGDBBHCBBBBEDFCB@EHHE@BGFHCBJAD@DPH@@DGPH@HPHDAHDFEAFB@DEAJCBBB`\\D@FFVLH@ALA@CFFFTHZF\\BFDJCFBHCFCFAFFFAFBF@DBDAF@L@@BCD@BFAN@HDZBBA@AF@BADD@BVBN@BAEKHJDEFHJ@DD@CPECLPDLHADDDBG@B@HBBBI`PVDdN@CFB@BH@@CF@@CBALFBNFB@D"],"encodeOffsets":[[127730,45219]]},"properties":{"cp":[124.370785,43.170344],"name":"四平市","childNum":1}},{"id":"220400","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@AAGCBACCAEC@CACDEAACFKO@ECKB@AGCGEICACAGAABC@SAE@ICIKOEgEECKIKACGCKCKBE@GCEEKAECWGKECCKCSKAAGESGDCMAAEEFUGKABEC@EEKCCCGAq@IFC@QEKI_KQGiICEE@CI@ICAGEBIUIKKCCG@MEKBGAMIGIMCIDIAMAKIE@ODGFMIOCCIGAC@EFCCCAKDG@GFSDC@CAGDE@E@AFAPHHDHFB@DKPBH@LIBADGD@HBBDCD@VHFDPATN@JEFAFKBMFABDJ@BCD@BDFHDBBJVCFIBGFDJCH@DADILGBK@KFYHIDMDAB@BLHFBBPMFIJ@FCBKDEBSDM@EFBFBDIF@HMDCBEBOLaA@DCBJBLDBBAHHFJ@FADDCJKFEJQHGFADHFJ@BBBFCLDPAD@BBBHB@FHD@BHB@DDDEJ@JAFKHFJTLDDABCDGFBBNFFDAB@DCH@FKBGDKBSAACE@CCCAC@EFGBGEKACEEACAQBAB@LE@IJICAFIFFLHH@DEDLPABEBEJ@DDB@DSFQD@JIDM@ACSCK@EH@BDDH@HD@DNDHBHRELIDEF@FMH@BJD@BCDIBCDJDLJH@FCHB@DCFFD@FHBAHFFQNEBEACB@DF@CFBDF@BAFBHL@JEPGDKBADGH@BDF@BABBFADAHABGDM@EBE@CBMACFCDMB@BEBILE@EGODKCHC@MBEICGQKIEAWFKCKBCDAHEFARGFAD@FCBAFAD@DCBBDADBBADFDADBBAJFHCBE@AB@DBBCFBJCFFFAFBBCDADEB@BD@BBIFBDAHJDFDEFBDABE@@DDDAFFD@FJBBDAFDDCFFFHB@DBBEDBDADD@DB@DBFCDDBABGDDJCFFDBBCDBBD@@DJDEDG@DBFB@DE@CAABBDH@@FBBDABBGHEBAF@FDDCBBDF@@DA@ADCDEBE@AB@BBD@DEBCHJB@BED@JCFMFITIB@DBHJFN@RCDB@BAFKDDHANVFLX^T@DGBADBFATINHFBD@DEDBDJHPH@JAFDFADC@CDRJFLRBHDDFJABFTJXRPHBAFDNHJDEZVNPAZHPENFLFDFAHLHBDRDTLJEJBTMH@FD\\DLCF@JDFFFADBF@fBVFHAT@LJfAtDHCDCBMFCBACEDAJGFCHINKJCDCBGLKDADITIJKLGDIBCNENCZMNCVKTA^IvcJAHERCLF@FCFHFAF@DDFHFJNDBBLCJCD[DOBM@CAADGFCFC@GFBHJJALDFPL@LAFDFAFHD@HG@GLBFCF@FFBJJNGNAFAL@LBN@BFBFXPJENA@ADIDAPBD@BCACDCJ@FEDEFMDAFAH@HCH@HIFKHIBIEKQY@EDKCGJQ@GAE@GLKBGAGDKBGBEDGfCTCVDjINGTONEJMVEP@VCbFHBLAv]VWPCTI\\ELKPCJEBC@GBCAA@EHALGEEBCDC@A@ABACEBA@CDCFABCAADA@GFA@A@@@AFC@ADCAACAD@ACAABA@@FE@CBABCD@DAACC@@AAAB@C@FEBA@ADAAEBB@@@AB@@AA@CADAA@@AEE@CE@B@ABAAACC@@BC@AAAEBAE@AGFA@@A@BEIIDGA@BCA@FA@ACCBAAAACA@@CAABCC@@AHCC@BA@AA@@CAABAEBDCE@BCCADCC@BA@AB@ACD@AABECADAC@BCDACC@CBBBAAADGACDAAAFG@CCAFAAA@CAAJEFB@ABAAAF@@ABA@AFBBA@CAADCC@@ADAE@BCC@AABAAABCHCC@@CBAF@@BB@@ADAAAB@AADAB@@CDBD@BCF@DC@ABA@DD@@CF@AAHABCF@@CD@@EHACAF@@CJCF@@CD@@ANC@ABA@CHADGFAHGBBDCDABB@ADA@@DCC@D@BCB@@ABCB@BDBCF@BAGEUKSJAAEAIOB@D@B@EGGDI@GDGBOKCBCACBC@GACBI@ICAEKAc@CDA@KAIEI@ICGDMDEACGKCQCKBAAIAK@ULKACDCAACEGJGNGJMFAHBJEDB@GBAAKKACGECIMDCBEFCEICA@EFI@AGIBIDABGIGBAFBDADECGBABEB@@AJALI@EDCDKNG@IIAECDC@ADCLDDCTE@BCDBBABB@BDN@@AFADOBBF@ANHBF@JGIEGAUMEGBIIWGCCBKASQIK@EBCKGBAIGAEIBCFIDEHGBIEOA@CCEDGECAA"],"encodeOffsets":[[128646,43557]]},"properties":{"cp":[125.145349,42.902692],"name":"辽源市","childNum":1}},{"id":"220500","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@GDC@GDCAKFGAGEMCGECEBECE]E@EAGBGEE@IIKMC@CBGI@GG@CFG@EBI@AQAOGM@CEGGAEUGE@GACGACECGBECDM@IL@DACEFEACCAAGAOM@SCGDO@EGE@EEQCUOUCCGEEKAGBGCKDEECAODCE@CIAMGCEGCG@CCCAEEEAEMBMECKCIHMEGKKCCICCECI@QEEKKC[DSJMAGCGAEEGCACKEE@CDO@CGCA@CEAKKDCBCFAHENCFEBENCF@BCNGD@BCLGBCTK@CNODGBAB@jJLQDAEGLAD@FFLCFEJADEDA@ECE@ACG@AC@ICACC@KG@ECAAGEEHC@AHCBEFA@CDAJBPJJBVIDDF@TGBGBGDCJCFAJLHIHCDQDAJABA@GBCCEFAPGFCEM@EDC@EIOGACCDAHEAGGG@AFCIACCGCBCBA@IBEGCCEE@CDK@@CEC@ANKDCEKGECEBADEBCIOAMC@ACHAJ@B@@DBBHEDICC@ENIFGGKJCN@HEDKAIFDL@FJJDJAPBJBJCD@BAD@LDLAJF\\@HDPH@ED@L@HCPMDAKECCBIAIGG@IAIGGAGEIEO@EFGFEGQ@EBGCCOACEQGGMFCJK@GDCHIDEHKJEFAJEAEKEEEEGAGBARAJ@JEL@HCJDH@BLFDH@HALBHADBH@HC@IBCCOBEJBFDN@FBHALBREJH@BB@DBBHABHHABJRADLPL@HAHBPEHDDAIGAMKBLGDG@CAAI@@EACI@JCEM@GLIJA@@IGUKECMcAAEB@GICDA@CU_CM@CEEBGAICICG@IDGNUHE\\M^SBGGKIIIEIAKA]BaAE@AD@DFDLBN@NBFDH@DBHFBHAHCDGDWBO@MCgUgIKECCCK@IDKACEAWDIAGECEM_IKGGgYOMAMK[@UEIGEiMSKOYGiAGEA_AEC@ABEBKFK@EEIGESKoI_KGEESAEIA]GiQ@ACA@ICGOK[OMCWAaFGACAQWAC@EFEHE\\IBGACMOAKSGQBEAIGCGBIBGRY@E@CGAIA_HMCSMCGBI\\WDC@AGEKG[CKEAGDSAEYKCE@GFKACGAG@[RIBO@gSQSCG@CDANCHB^NJBTELGHIBCAAOCUAQEG@GBYPK@GEKS@AF@BAAECCQGaESDMBOLCFAF@FLNDH@FEDEBEAMSEAGAMBKLMDIAGGKWIIcUEIBEFABBDH@BBEDCJGHaVMDGAEC[W_QGAQBIA]ICCCPcpIFYJGDMNGBEBEACAAKACI@UBIA]GoUE@IBCFAFBFDJLLBFAFDBDCBDDJCHAFPDdRRBHAFBJAFJLFAD@HLNAJDFFDLDHFHBJEFAJFBFD@@HDDGNBDCF@DFFCJJFAHAFBJHHPDHHLDDFDBJPXT@FBDADJHDJ@LHFAFHHAFEFEBCBE@CBGBU@@FDLLFBFBDDFBDJDBFFFLBFCL@HHLDFFAFBFJLBHDDHDFFJ@FHRNABOJOCKDI@KBEDQFGBEACB@PENFFAFFBAFLTFFBHLFBDAHHH@BADGBGRO@EAEBKCU@MJSAQEEDDDAFBDABAHIZ@DCDQFIC@EICAE]GEBAFCFAHGHAJHP@JKLCBBDIBCFKJEHXHJHFLBNELabSHUCKGIBOHCH@NNLBDEHETABGBEAU@IBIFI@@BBF@DFFAF@DGBAHCBGACJGJBDDB@FFDCJED@HDFBLBBBBALFHEDKPABGAIBO@@HDB@JIJCFIFAHKDKHBDCFBJBFL@FDDD@LDDKDQBQL@DGBADCBFDGNBFEDC@GHKFCJHLABMPCBCDAJCD@NFDCJFFBNPLDDHFFNCDSDCHEFAJCD@BHFBDABGBAB@FABBJGDGCIBK@ABEBGFYXMEGDGACAAACASBIAMIAAMGGDSACAGIEBI@IBKGABEBGJDH@FNXALPTDLALCJAHPTGHADDBEJFDFFFBFBDDCDGBADAACBAFCBIAABCAKDBBADBBCBB@BBABBB@DCDCBBFADBFCD@DCBADODCJCLABENABCFBDAHBDCDFFC@CDBBA@BFAB@BADBFAFBBJDBBBB@@C@@BBDAB@BDD@DDD@BEDBDEF@DBBCDDFAHBBBFHDDF@HADFJABAL@DDB@JBFRDHDJBLAJDXCJ@CH@FEH]DGDWDEFIPMAEFOBBJDDFFBLNBFDLAHBJLJBRFHL@H@BBFJ@JEHD^FCD@HAFAHCD@@LJPNFHJDFH^ZBD@FHFBFNDDBDJADBHHFADBDALCDGBCF@FED@DFBJ@JAP@FDHGDBHCHBDFF@DD@FBBBFAFHCJ@BLPHHA@DCDBDNFDBHLIDAHGHI@@FCDEB@BEDCDEBADGBEECEOEQBGAGDSBIDCBIBADIDEHI@GDAJGHSDKHMCCCC@GADGBMEQCG@ADALAEKWEQFCCGC[@EFCCCFCACBAFFL@HNLAFGHFJCLDHHFBLEFDHFB@DCDC@@AFCKKAEIMCGMQCAM@EEG@@DCBHBBHDDHB@BCDFD@DADBFLBBB@@BDCDBBH@FDB@BDADAHG@KCA@@BTFFFDDDBBDE@ADEACBG@QJOFOBDBDFJ@DLDFBFADCLIFAHCBCDAF@DDDNDDFHDBDFLF@B@BHK@BFEDIAOFCFCHC@AA@DA@@AA@EDCBALABLBJBJCJDD@HJNJHBLANFJBNNVJAJHFDB@JDJF@DFjJRH`LLJRFD@JEr@HBDDLDFFD@AFLBVHFEBFNBCDTHHFBBTLLDDDLFXHFDLBFFHDRATHJNFNFFFhLPDH@LBF@TADDLLFHFHD@BLAFDP@ELBDFBDCDBD@BFDDABHDDDFDCHDF@DPBFFD@HAFGJCDEJABFJHABLHAD@FJLTRLBDAHDJXAHBDDFLHJFJDHFIFE@GABME@AACPEB@BM@ACA@BAAADC@ASFCDKCCD@BCDFDJB@JMHCLCD@FKJIB@BA@AFABDHCFCBEAABJHAHCBAJHJ@BEJ@FDBFJEDAFCDJNFDDHLBBLAB@HCAIFGAEBINMHIHFHBDDBDCLBVKL@JBBBLARDLDDHFBNCHCJDJ@JFLBB@DCd@LBBFJDJ@DAHBD@DADBDAPLHAHCJ@HCFHA@C@A@JPFBBBTIVLHFABE@ADACA@AD@BA@ADC@D@CD@@CB@BAACBCDAAGHEBCHGB@DAB@BMD@BC@@DE@ID@DE@DBGB@FC@@DE@ADGBBBE@@DC@@CAB@BCDE@ADC@CA@DA@CBBBA@BBCB@BA@@AE@AB@DD@GDADBBABBBD@ADF@CB@BD@CDBB@DABEA@BAB@BE@BBAB@BEAIFBB@DBBEBDB@DEHBBCBBDCHBBABAA@DDDCBADD@CBDBAFBBC@BDA@@BABD@CDDBADF@CDFAABBB@DB@@BABD@GD@BD@ADBB@DB@BDBBABDD@BEBB@ADB@CHJJAFB@@@EBBHF@ABBFBBD@@AD@BDBBBAA@F@@DFF@BB@CBDBB@@BA@@B@@AABFCB@BABEFD@A@BB@BD@BDCBC@ADAB@DEF@@ABBBBDC@DBBBCD@BED@B@@@BEB@HCBBBADEBCD@DABDFAB@B@BCDADDFHD@FDBJ@FDH@ZHNDPGLA`KDABCH@BAIAHCF@DGFBJCBCDADC@IJKAA@EFKBIPCBCF@BEHCVDFABAAA@C@AO@IBCCPIH@HAOGOMGIBC@AKGC@LA\\@NGjML@NEPKCBFCKB@ADCAABKECD@DCAGAABAAGC@FC@EP@BC@IBA@AAA@ABCAA@CFADE@CFEAABAB@B@AAFA@CFABCB@BACCF@DC@ADE@A@AD@AEDB@@B@@AB@@BDA@BACBA@ABDFCB@BABBBCDBBAAA@@@AD@@AD@AAF@BA@ADBBA@AHBBCD@@AB@@BBABBBCHABDBA@AFABDLABBD@BBD@BCBADABCAAFCB@BAAADC@@DAAAD@@ABABCAAB@JBFCDDBA@ABAAAPEDCBBD@FDACPCFB@@B@D@@@FCJBDAACF@DCBFBABBDBDA@B@BB@BBDAFBBAA@DADAD@@BD@BDB@@CB@BBF@BDDAD@@EFABB@CB@@AFBFAFFD@F@@AD@DABBAB@BDAPBJABBB@BDB@@CBFBA@DBBFABBH@DBB@DEB@DCD@BDFABAFBDAAADCDBDA@AF@JF@BH@DB@AN@HFF@BCJ@LABCN@DGDACCFCHADCFBJAPFBBAFDDN@TDHHDHDDNFD@RATFDBFFHRLFHBXAbSHAN@JDHLHFLBLBJCLEFGDEBM@IKK@CBCAAA@CEBCBIBAACDCBEFAFEACGEAABEACFC@ABABCBCAADEDACEQE@ACMBAAABA@CGCBEAACGAADA@CDA@CDA@CBAAAHADBTIBGFCBCDAF@@AB@LGT@LIDDH@DBHAHDF@L@BDHD\\DLBHIH@DBBBFBBDFAJDHCDCBALAJCFBJMPGRBJ@FBL@BB@DFJAHBF@BJB@HDBPHDBZAJFFLDBH@RNJDDAF@DDJFDHJDNJBD@CFCF@HBDAJKHADCHDD@JEBIAEFEJBTAJIPCLE`A@IJGLQJKCGOECC@GDCAKGA@EEGMI@CIKKGDA@AAKCIBCGEKGeBAEBCGCBGKFCEKEGDEEI@EDI@IEAA@GCAGCSBMO@@JEFKDEAEBGDC@ICE@A@CBC@CDABCDC@CDCGIHEIEACBIHGCCDGCAEC@ECC@GEIBCFE@GMIBCDEGAMMG@ECOHiAGDA@ACGG@EOK@CCEEBMEKIAEQGEAEC@CCEI@QSECAAEAFCBIACNICMCMDK@ILIFGHGHCDK@CCAD@FGACCOACAICEICCK@EDGDCBKEEIKAYBGFIAEBAAEEC@CFABACE@CBAJAFGPAHIDAVERGNANMCEDUCCCMEEEBGAMGK@IIFKGE[ASN"],"encodeOffsets":[[129561,43204]]},"properties":{"cp":[125.936501,41.721177],"name":"通化市","childNum":1}},{"id":"220600","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@DFJDAEKC"],["@@EAAFBBHJ@DABIDMCSAQ@MFEHAFBHFBF@PIJ@BFBVDFDDJBPAJFBDERNJJBXC\\@DDDF@DADGHCB]BsAODGBEJBBHFBDCRCDIBQEKAWHCDBDVFJJBFAHGFEBKAMEKDK@ADAHAHEHQFaJKHCF@FPRFPBBL@LIFAHBJBHDJHBH@FEDG@_EIDAJBJAJ@DEF@D@JFN@FADCDE@Y@OAO@IBOFCB@DJNALEBGA[DGBCBAJGJQ@eCKEEBKFEDDPBDHBLADBHL@RCJEDcFICOKSMiMYSYYIQGUGMAG@IKKMAKDCHGRENIFEAGASYEKCYDKHWCGCAK@QDEFAHAFBPADWPWNWT]TOFGBMA[GEEIMAGBIHGPGPA\\CBAECLEBIG@AESQGIEBBGSCMIAEAEDE@AQGUAMMEAMAODWXMFOAOICGCKBIDCBCGYSKCCAICGKF_IIKAMFQ@MPMHOHWAMCCWIMGAC@MIGEA@CCBGCOFGAGBK@KOBCIQBAGGBAAGCAA@@AGEEAGDEBKAGBEAM@ECIAAFDPAD@JGDG@CAGBKAGBG@ECAKG@ICGDK@IFYBCBDHJNLFBFIFEBIFGLCFGJCD@HILEDHNRHDFPBDDAH@FHREFEH@FFPFJBHHHBJ@JHHBJAJDDLFCBONGDK@C@@FOGGC[@IEKBKCC@ABC@IDIAOAIBICEIK@ECBJCLGFM@IDHLEHMJ@FDDCJGFAA@CA@I@GBBDD@BNJPADCFABDFHFFLCDML@BFD@DL@DCF@DFHDAF@JABADHDDDJBED@BHHBHGFCBDDHBJP@FCD@FFNEDOHEBDFAD@HABIBCBCRGDGJIKEBIDCDAHAHSHE@CCUJIAOIIACB@DEBAFGD@BGDFFBHDB@FLHD@BDJDD@@BDH@BDF@FCBCFIBEFKDEEC@KBFHCBKRiIA@ABCHMP@DSLADKHADC@MHADE@MDAFEFMDGFEBEJLJFB@DDBDHP@DCF@LFBDHDFFHBHDNBTI\\CLDFLRFJ@FDDDDJLDHLNFJGLDFDANFNFBFFDBDDH@HDDFNHJB@DDFPCDBFFLCHDHALBFFDHVDVPRDFFF@FHP@HCTDN@BPBHDBBDEFDFCBK@@JCNFDHAFDBDDHHBF@VHBFHHDFN@PHRB@BAJ@FEH@DHHJ@AH@DNDJL@JFFAHBH@F^FDFAHJJPDHFHBLEDBHCD@HCTM\\BHFELJJL@NHHBFAFFDNDDCVDFILCBMBQHUFCBGJQBAFABIBAB@DDFGD@FFBBFABBFEJAHBZJLFFALABEJBPBBJDDFBJBDDPBDEHC@DB@DCLGDGHEHKJ@JCLDNDNMJBDAJEDFBBBFDRTJ@DF@DFDFBRHBFLJNFFADF@DPL@FHHBDB@HCjBPGFDH@NNHBCFADNJ@HEFADFJ@HDD@FFDDBCHDDGHAJBDJFGFHJCD@DCDADCB@DAD@D@BDF@JCDAHBFCFAFEFGFBBLNTAHDDB@HBBJFJ@FCJ@FFHCLFDFLEAHHDADBFfALHHHABDJBNCBLHJL@DNJFH@FHBBLCDAFFFPFDHF@LINBPFBDDF@DDBDFFBBH@HFJJDFFFDH@J@FDDJAF@TG@GJAHCD@HBDBFDDFBBFDD@DFDDRCHLDFTTAHDDDP@HFJBTCF@DBF@HEFALFVBHFCP@PHF@DNDLGLANDNAT@JBFLVCJCL@PIFBDABDH@BELGFIH@FEJ@JCJHBFLBFHDBBDDDLBHCL@FBFDL@HJFDFAJIH@HGJCJEHFJBL@\\DD@JDB@BCHGTDHDFA@EB@LFABFLNDFLJDJH@HBBADHL@BFBHHHBHGDKQYAQ@OJQHGBGBGC_@IDCRO@KDCZODKFGBKDCBARCFAJGDIAQAQIYOQKMOMEOGK@ODC@ECEMGIOCMBGFCF@RFJBZKH@RJXHJHXDBBBFAPHHJDb@LFNHHBBCDSPYJGDKDCVCDC@ECO@CDADA^A^MN@JEP@BACGFAXFPBR@RIJCLGHATNARBFDF@DMP@DBDHDPATBXHAJFDAFGBKCEDAZDLBBJBRADBFJDADEDAPHVFHDNADBRLLRH@FADBNZHBRAHDLLDHBXDFh`PF^@HDFDDHBJCDSFAFDFNDDF@DGJ@DJFJNJAFCDEH@FJLLXHDBDHDBVAHBBBDJIL@HDFJCJFHFFFADEBQEE@CDN\\HHHB\\@ZKPAp@VCN@FALI@MJILCRAVK@CKQBM@MBAFCPBJCB@FGDCTBB@DCAGEC@GFIJCAEEACAIDGFCBMEE@@CFKNEJEFMNU@CHGLCRDFALGDKCAE@QJGAAC@EBKBADAbID@RFT@FCHGNGXCJERCHECI@IM@GC@GDCACJGAEAKB@DAZD@CCCCCCGBCTBH@@CCG@CFAHFFEHCBAI@EA@CNKBC@AEC@ADADEFATCJGDCBEGI@ABAFAFFFBHCDA@CKGBEEU@ABAFAFBDAAEGEAGBANAF@BAAG@UAEBABOEIJK@ENOEGGQcaI[DI@GEEEOEEK@KCSOoQEEMeOM]@MBSCU@CKDKBKKEKKCCCOEI@OFA@CGA@GBOGU@@EIKEKAIFOACHAb[F@\\FPBNSNFDCBGLG@EFGBE@OHKHEB@F@PANHD@@EFSAMAGFE@EAEDCBIHGBGPO`ONODAP@DGLG@CGG@MGK@CFGNGNKVIHSFENUXWR[DI@GDEDIFEDQHKAGBGDEFGLEHG\\SkMSGDIXSp[^UXQJEJ@BACiCID[DKPOGQAaGiEM@GFEAGDKAEBEFEDI@CGGHYDCNAXOH@HDBEDAHA@AGEDECEBGBCJAAG@EEE@CJGBQJK@EJKDGHADIHCN@HEL@FIPGAE@CJGFGTBFKDAVCDDDBHEN@BCCC@ANCL@@EAC@AFAJBF@EMDGH@HBD@@EIG@EBCL@@GDEAIBAJ@BE@AECBAFAHFL@JBCGHKAEEAEDC@GG@CHCLFD@BA@CGC@EDCD@JBF@B@BA@CGE@EJGBAAECEBC@EECBAHCACSEEGOG@CHCCCICAIBCHAHE@E@CICO@CAGGDEAEMIOKOOCAKAEEOCECCGBEJE@S@EGGCGGKAIBCDAP@DC@ACEECGAQ@MIGQIGAWCGACIAOFK@eQECKWEGIESCYBICEEAMKMC@IDOLYDBHHHHDRBBBDNGFEFE@BIAAYDICAEFM@CEAG@EFEH@NABKDOBKGGAM@EBADJF@BCRLN@DIHIBAACGIGC@I@EDAD@HDLABCBUACDABDDRJHH@HGDM@ICEGOgGGEACBAFBTCFKFKDM@OAKDC@@DHLBFCBKECBABALABG@EC@C@MACIEQGECCICAC@IJEDMEGBCBCFHJADGDK@CAIM@]AOHK@CAGICIBEDINENEDG@OAGACEBQEAE@EDCFCLCFCBQFOAGCACAM@G@CC@EBCF@R@FKHEAOI_L[@SEOGIAUBWFQBIAMOC@GBGPIFIDEACA@C@GFERKBEGEK@SDSLKJMVGDG@gIGAkJMDIHIJOTAJ@TFHBHCFM@IACA@ECAIEIAOFONMBGEGAMCG@CDBN@DCBK@ICCEAMHKCCGCIAQ@YFMBICGEG@KDGJATADEDYDWEYBEACCDKAKEAI@YFfKAMEGEE@Y@OHCF@BDB^HRBFDLJBD@FENGDOBQAWUGCC@[PBDLJBHABGFI@]GEBCB@DDRGDO@KIKCQBIDEVCBM@EASMQG"]],"encodeOffsets":[[[129967,42810]],[[130196,42528]]]},"properties":{"cp":[126.427839,41.942505],"name":"白山市","childNum":2}},{"id":"220700","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@JMBGDA@BFCHDDCBCCC@EFC@CF@FIFC@AGAEGAAC@YODABCBA@AC@BACADI@A@EHCA@BAB@CA@CA@@AAABCAAB@ECDACAB@ACDCCAAGA@@CDEBCBEACZK@AAC@AA@BEAA@ABCAADC@AFECEC@AGBAAEBCACSE@EKAWOABGAC@QGAA@OBEB@@CAADIJG@AJGAAJ@D@DCJ@BAAQBCDAP@D@@EBAHABC@ED@@ED@BDB@AGAABKEEKEBAAAI@WHAE@ACA@EBAACMBGFEACAECABBNBdsE[@AA@IGABGAIIaCDSH]HUBEYAO@CB@DB@DD@@GAGI@AKIOQBE]LEDBBFD@AIB@DHJ@GQAKIDEKJCBAGSFCEIBAA@GBGIBCLEAAJIAADG@EmIQ@KFCAYOYGG@EDME@CECMESEiPUDIJCFEVFBFJIHCB@F@DEFGBQFUDGDEHAHCLBLABKDIBI@MCWB@BADMBIACAAECCEECCIAIBKTD@FJJH@DSLEBM@QHAD@DLP@DCFCDQHCDYBQLAF@LAHMNCNEHCDEBKREDGDI@]CeBYCQBMDE@GCECEIACDO@C{cGKMGAKGAE@GBGJQHOEsAUGCCKAI@_BGAKCEMEAQAGDELCFEBg@GDCBCNCDEBG@OEGGMQAIACKCK@SAI@CD@DDDJB@F@BOD[@MAQE[AEAECIQMEUAQIMKKCO@QFMH]AA@AFG@ECMCIC@QF@@CF@HINEJEJA@BABDBFGFBBFDBHAFCF@HJBBDADCFKBCDALAJCNOF@@CSIKAQGsOG@CACBBDABCBABKBC@CDAFCDEAGGGAEFGAHFCBKIC@@CCCGAEDAA@CG@GCQCE@GE@CI@KECDK@EBI@ADBFCDA@UMQIAAHKIECCIEHEEBGFC@EA@CICKAEDEHAADGE@CDC@TY@@adG@SAADE@AFwKGPAAICABIVaOBCMKIOECCES@kQIH½yIFKBQEKJEB½ybaLIAIECFICKCFCAGJ_QONE@UTGCDMACWSiSIDOJSFK@eEUGMASEI@WE[GGGGFaWLKJEaYIC@AGEAAIDUGGKEQE@CAm[`[@ADCAALMGIHKAIGDACCBECCBACBEMCEBCCGCDGECLKJEHADDB@DBZQLGJDHKEC@AEADGG@CDCADCCAFGC@JIFBHGDCJHD@FAHCZS\\KJGF@GUCCGCIBEFOGIHQMEF_KONCCMFKOGECBME@GLOPDHKF@@CCAFKDIVFBEF@DMFBADBBD@BCH@T[GCCBADC@@G@AHGNDJGLGDECS_IHGGC@ANICAROEALOBC@CHIAA@OMIOGJACAJEEABCA@BAE@WODGOGDADOCEJ_HB@I@EFI@CEEBAF@BGHGHBALB@DIDC@ELADGF@GNDBDGHADEH@ENB@DGTB@BDBBIVJDIA@BKJBDHB@@GB@BHB@AGDIBBCHBHD@@EB@@J@@BIB@AJD@@GDD@DJ@DEDBAFB@BCB@AD@BJMAFBBDEJAJOPH@D@DBCAHB@BCJDDAXHDFHDBDAH@HHFHDD@BCBQAKGIOKAD]aCFMGBECABAHABOFCCA@AHK@CEAAMME@FE@@DG@@AEA@DcMUC_OAJAA@G@AAHCCBCKGOCDKOF@DCCI@EGCFGIFLABM@UA@ACCABE@@BABYAGCM@EB@ADC@AK@E@CBCAE@EAEBEEEBEDGDEAIDEC[AYESGEEDEB@BKG@UKEEC@_[AADABICFA@BEEFGCCBOG@GOGCH@@OG@CBCAIGDHE@AGFFGA@EDFCAAAAGDAAHCACKOIDCCMCOIAH@DCFCBACAAACDMAACHA@BGA@AHC@AIEA@FA@AA@CCACH@JA@AE@KYEAABECB@E@DC@BDMACD@CC@@GC@CF@ABEABA@EFA@BIMAQEKBCDA@JIC@QDBAAAHEIGBCEADABCKEOFYCOHUBCBBDCBEAS@BGAOE@BJA@M@C@BKE@@CC@@PG@ACCACJEA@CG@GPAIBEKNIGQAOIAFGKAB@DFFMFWBIDBD@LOPeEGECACDIBAB@DaBcJQBKDMG@COKwCIGµDyC[D]¥dMHLFCF@FNJBDYZAB@BGFICKHGCIBGCGF@FOJHLG@ABCNc\\IJ@B@FHHUNIVAD]@ICG_QGOOICcBSDgNWBOA[GKEGGD[DM@ODEASCM@@CA@IBC@CCAAK@ABI@ACEBECCBE@GDS@GAACMEAIOFUB[FI@EBKAqEFDEP@FLJHAFFFGFBHJEJLT@FBB@FHN@BDTDDlRCH@JDNFAADHHGA¿fIFCJ@DcJIXAPMEBDU¤QA]BCJC@iXaBQD@FJAUxEL@FVFV@ATD@JZc|H@RHCB@JEBMRJBNR@FEHDRGDBBOH^^BDARDF@PNR`R^H@F`JNDXCFTHLrNHD@JCBBBFBHA\\TJHPDJFBLFJLF^DNA^VlJbP^BPrNBLFPZBVCDjUNS^efgUPVRLNzpDNGDGJBBCF@DEBDDFLDBH@ZJRBBA@ERQBCTBbP`FLHRHrpj^¶r~^VNfVÆ°PNLHRXJH@AZN^ZNLFBFLzJF^HPLbFXFLBlBTDFA^F|B`HT\\BHNVOLW\\EDRzD@DD@BAFHB@DHDBD`LHAVBJHL@ÜnPDJTDVP\\LrdnNF@pRXTBAv\\DERMPINEXEFBFDFJFDXJpJbBFAHAJKV_VURGzQJ@L@VN\\LDFDF@DCHIJCF@FBHLFH@PATGnWNCN@dFLDXRRFPB\\GdKPBJFLJXXPJPBPAFEBGEW@IDGPGL@ZHbVNHJBNARIdSTELDHFHL@PMlAVDN^THPLLATBHDFHHRDPEFCLMDO@YHMFCZIlEx@RBN@FADEBSDE@QDQP[NcLGPC^BL@HEFE@EEGIGOGOCCC@ODGDED@JBfETFPJrhJDNBPCTGTKPCJ@hJbP^HRDb@VA\\SXIHBFF@FCN@DNHHDJCLG\\cNILCP@PDPJlb@JAHEHKHEH@HDDDBdApHTAHALYFEJCH@¬dhDZFVJplLFLBRCTQNELAzNDAPMHIBAACME@CECAA@CBALCLBF@FEDMKEKC@CAKDCF@FDH@DA@GCECAM@IC@GJEJABA@EGG@IHQRE@C@W@IG[EGKKCMIM@CNG@E@AK@AAAE@AVSJC\\CBAEICCGCAAFEFAHBJAHE@EJKFCLABAAIHCBCEI@GBCHEFCD@DHCF@DD@DCH@JFBBRGJADEEGBEdQPAFE@AGI@IDQHKLEH@dBH@FADABKDCNBHABCBGDCJAJ@HBF@DA@KDCVEDAHOFEHAHAhFT@JFF@JIHABEJAN@PHJCFEACEAE@@EA@C@@DC@@A@CFC@AO@IEACBAF@HFDBLEHBHDF@FA@ACCIA@A@CHKACDAH@NFF@JEN@LDAFBDTAHDH@LAHGVBdGDEBKJADABA@AGAB@DCXCHEFBBBBJDDD@FGHCDAHHD@FALBDAHELAJKFEHAFB"],"encodeOffsets":[[129198,46218]]},"properties":{"cp":[124.823608,45.118243],"name":"松原市","childNum":1}},{"id":"220800","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@IAOK]GIEyEKEAMK]YYM@BKIOUKGOMË³}cuYµqi]qoQGKG_EaOSAADQR@FABQAYIG@CAEKCCFA@CDEAAHIHCCMyoKMUQVOhfeT]VMCiUDYAOKEMAqO]AaOkISMIGQ@YAKCEKAKIEOCIG[SGBEAAADA@IGCqMGKESWDMC_I@E]G_QMQ@OCEBQAC]][@yEa@uM_MkYEESGo]aSSEi]kWOEaQICIEQIámaKiaYUqoU_CM]UCUaKoMiIsIkUQEġAAaCOD]LABs\\IXPNdFĎQÊYI[F]@aH[\\DDLDHjCP_^K\\MLPTNVK`eXU¸\\`DTAF\\PdLRNEJN@Q`G[GGRXpNGTMPAPEVVXFHFWPq@UCOB]LKRCPPTAPSbML@HDH@LEJIBCDANAJBJGJIDC@EEGBALCBDFAJSFJRBBAFNAHDHCVDDAFDNW®r`RzXfAQbbPVR\\¦Ep\\\\ZXE`@Z§VREx@\\@dFjfl^\\WjBNAFGFMFYHI@eHZmL}`SDkfB`S`@\\URI@AJC@@DE@CR@JG\\JBL@FCbHALPfETMHC@@FBBOfUjGZkfEBADKBACGEIDADMAIHCAEAYFIIgJEAIF[CCEC@KAeKC@CEQABMIGFM{NI@SASCqReDsVE@MPQF@JGACFDFJDCHKDABGBCFKBCBILJJDHJDBLBBD@HCF@FALBHERER@CHPFHHDHDBJFFBHFNBADC@ELH@FGA@BCB@@CJAJBFDCFTHFA@HCFAHDABGBJENDHFFHANBJPEHC@CA@BCBBJFBDHADHBBDBBHB@DDBHH@JJDFFDFHBFFDBHBTDIL@DD@IJDB@DGHF@DFKFDDFBHJDDADBDJHADGFADDFCDK@EEA@FHCBDDDHCBADIBDDADNDCFAFCHFHEFCHIDEHIFAFMB@LQAICEBCJKHFJDDHAFDF@FBRBBH@HL@HAFDF@JHJDFFCJB@JEJ@JDFAZ@BABEA@FIVI@CBCHGJCDAF@DDDAJBVBBFADDBbCDFDCPEBEAGDGD@@EBCHBZ@BEF@FANBH@ACBCACFCDBLCFCJBLEBABCHHFNJDJB@EDCCEFEBICENGDCDBP@DAL@FCJ@DGKGJA@EDGJC@EHA@CFCHBFCBCFBLALI@EHADG@EDC@ECEAADEEC@CBED@DABEFC@GBA@ETADA@ED@@DDARIPAJADDP@FCACNID@NDJCHBPGHAH@LCBADADETFHMHAFEJA@CFCAKBKN@HBBALDBIHBAEFBDG@EB@BEC@@KDABEJGBIHEHB@BD@@DJB@DLHFAFCJ@EHAFNAAFDDJCNDBFEDFFLBJFABQ@ADBDT@FB@@J@@DCFDJ@HLFRFFDCBDBEFDFVANGfBILKtC`BD@ZRDVBÄG|JGFGPKJMDI@KBGBQH[AGDG@GEED_BEBAF@PCD@FBDDPVFNNPHFRJFBDARM@MHGZQlcNCzGPkDcVAJACQHADGD_ÐJ@HL@AFD@CP^DAHMJCJNBBJXJA@DHFB@DdZAFCD@HGFERIJCLIHBJIRKLQ\\BFHHRHHJFNx@dr@DFJ@FLNAVDFBBƈɄxrpNStD@bfhPDtXPNHDtDFIDA@CTDBGHBPEDDB@@AAIFA@AAAB@LGNDRGJ@HDRBBBCBDBHED@FEH@DGHBFCLDDA@CDGJICCF@DAGEdIPDDHFAFD@DBBGB@DJBEFBDH@@DBBD@DEDBJEF@DJDALEBBFAL@DFF@JCHEFDBAB@FED@FGLDDBABHFD@JFBCJB@DDBADF@EFL@FHPFJFTGJAHGLAD@DGHGNGD@DADCP@FBNB@GBEHGFE@B@FJFLDP@RDADF@@BAFA@@BDF@DJD@BDBADJBTAVDtFJ@PDN@HIJ@LBN@DDNDhEXJPHLA@ALCpHPFBHHDH@FBBDH@BPJ@RA@@FDHBFDAHDBDCfXLCVA|HL@HEFG@AKGBEDE@EDG@CEGKECGBCHGDALCPATPBHBXLLFBP@LFBBH@DABALOBG@CGKOKCE@IFM@GFEF@LIDCXMDC@CAEEE[IECKI@GJOTKHIBG@EGM@EDCXCPDRBFALGAGAEQIMECC@CBEFCj[BE@EIGWIGECE@EBCHEHARILKBGCGWOAC@EFIFCVEVIJWHY@ICCKAIAQB[HOAKEEIBEFAnSFEDG@EAEMG{GKCMIEICK@KD[HQXU\\]XI\\EbIVARGFEDQHIDG@ODK@SAEECEAaBQACAGIDMFKJKJEbSDC@CAACAQ@IC]SsEGCEG@INULUDAL@`F`@`QVIRUJCHE@E@YBGFCTG\\CLCHCFGBCCKOKMEAA@CBALAb@D@DC@CGGAADI@C_KCC@EBCJCLMNIPGNELA^AJBXL\\RRFL@JCHEBE@ECEMMEG@KDGHEPIN@RFJ@RCFEDC@EW_AMJMf[HCP@\\D~HTDJAJCHGFIFS@YAEEGUOCC@GBEFERIFGDKH[u[ABWSoQE@mMqc[KUOSCCImOÛK@IGUAGB_KACGC@CGABE@ACCC@QyFCX[PKMUAGS[_G{A]EEBSCkAcGWC"],"encodeOffsets":[[126922,46306]]},"properties":{"cp":[122.841114,45.619026],"name":"白城市","childNum":1}},{"id":"222400","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@DDHF@FHJGJLBBFDBGFGBCHM@ADCD@DCF@HAFIBIFEBAB@BBHADADHHAFBDADBDLNGFAHG@QFC@GGC@M@EHKFKJAD@HEFMD@BKDCFIAEECEGGAAGCEFWBGAEAE@I@GDIHMFIDE@EBE@EAGBGDGDYVCBGFO@BHIJ@BDDAFEDEDOJOBED@HCDEBKACDIDOCE@GHAHIFEPKAA@@DGBGFSAQLGBK@IJCLIHAHEFIFG@A@@FABADEFBFADM@YAGDEBGH@FDDCBBFLLHH@DFF@HBHXJLB@JCFCLCDBLCDGBDBFRHJCLJBCFBFDDEHWL@FOHAHLAHBjBnJFLD@TJBBAFDDHDJHFBBTDFFDBDJDR@DBBHFFRDPHHFHDFJJB^VDN@LBDHHBFJPTPADFDALDHILAHEDAFIF]NYDCJLJJ@HF@FFBBHAFURID@DFBHHLAT@PLL@XDNDDFPDBHEB@DADDBLFADDLNFFNFHFNILNPBTJR@BABQ@EFCH@^JJ@DHHBFAFBLAJADMHJJFBDHNH@BABHDFPDCXGVANFBH@FDB@FHBFJDBL@LDEHCF@B@FDDEFFLAF@@LJR@FCB@DDBRNB@HAFDHLBJHF@JDBHEHLHBFNBJCLABHLFDLFFDLHHFBDFD@NANCJAHBDFDAHBFF@HC@@FABFDEDD@@FBBBFDBJ@HHDBBFFDCHBBEDBDEDABGD@@DBAHABDDAFFFEDADEBFFJ@FF@DED@HC@PFL@DB@DCB@FIJ@BFF@DGBDD@DEFODGGKFICKHWDEDOHADKFABDFAFEHIJ@B@HABKDGR@RJFGJBFFDCDMAADEBAFGF[DFF@DDD@DED@FMF@BRNGDCFDDBJDJVRFBLABDBFTEJEDEFPFDFF@BIBDNBF@DCBKBCB@DDFCHWBABADGDYHEDEBGFG@EDIBIFBDABIDGFCBEHUFOHLBPADJBPFJHBBDAFEDCFAH@DDDJBNAEFOF@HFN@FCHJH@DXLFJHFBDZDNJBDDFJD@L^HBBDLPBHFJD@DEFCFTFNBPHdIL@FBDHFDHBLFFABF`VVAD@HH`APBFDD@ZBNHLNNFL@TGD@FBBDH@HFJ@BFFFJFHDHHZPVHB@KBIDGHCJDVADI@MCEFEFMFCDDJRH@H`CLBAZHFGF@LBHCJDBLCJ@DD@FAJ@NGBADGBOLBBLBCH@DGBSEODGBCFARHJLJXHHDJNFDFFBFBFABEBKEIBMR@J_@DHCHCRIHCDDFLRQDGHAFNJLBBJHJAF@DLHD@BKLAFIRMHCLDTBRIBED@D@VRTAHAF@TWDAFBJH`bDHALDFFRHLAJHPBLHNFJDTNHDHDDNHPATDP@BBDPFFXDjNBBCFFPFHRHLBJFLDNFDDLNTJH@HDN@VFJMJGBGHGDKNIHCPANENINANWHCCMFEDELABEHCBEJAHE@IGICG@EDEAIFMBEJKHADCBEFELSEGEQ@]ACKEG@EAMBQGJCFABKLEVODIBIIM@ECC@GDC@EGGCGCIKSEQFERAHEFGACAIACDCECCICCMCFIAOMKEGXCHI@ACEAMHODG@IFMBILCJGT]HCHEFICGB@JBLEJABAHKLCFSLC@CCG@CFAFEFGFAHMPOBCAGBGNG@IFCJABODIEEDKBAAGBA@E@EBAFCHQAMBEACBCLIFC@GJCJQNMPMHADCNCN@DADKCCJGACIACEKIAAAEJKACBENEECGEBEBCACBINBJFJC@CPANHDFFENCFBDBDAPFBBBJ@BB@ZKJAN@DANK`cJGHAJIDGIEAAIC@AGAIIC@@CEA@CA@ACQMCEGI@ECELIPAFGHADC@CBA@AB@AABMHE@EHGRmDCLACCEAWDGACCOCOK@CAEBGDADBFBR@@AEGXKDAJHJ@FDJGACDECGXGDC@ACEBGAC@CFAFKCG@IROVYAEDCDCCG@CHEFKCKJCF@DG@CDI@KFG@CBK@AL[@MLKVK@KACBGFMJ@PBXcJBXARFR@PHLLRFT@JCLOBEJCDENA\\AJETCNIFEJARLJDFHHDFFHDbHZ@FDJ@TBLADBBD@FDFH@HFH@RGF@HFLBJHJDHJHBf@DSDDHBNHFBJJFDJCPB@FBHHFJBL@HDJNBVDH@DCDBFADDBAHBDAF@PEFADBDADEHOBBHAHCJCNJPCFBDFBCHAJEJDFTHDJHB@BCFBDADEDIBCHGB@JFNDLSLPJAJIZ@JCH@HBDFDDFJHFJPJPFFNXNHARGVAHIHQHEH@PAJDHFAF@JAF@@NAJ@JGN@@CBAJAFCBAJCT@^HDDADFDN@JBDHAHBBFBR@LB@FBH@D@FDFLJDHV@ZLRDTTRJ@R^ANBFBHHDBNCJIVAJCH@VFPBXEPALDlDFHHDJ@DDVEL@XAL@NDAEBGFAHAJDNFbBTFHFNANAJCPATBPECHCL@LBH\\BZILDJ@FADNJDADBB@D@FGHHHADIDEJ@DDHFDH@HABFFHGH@FID@BCB@DCB@DBDCFDFDBD@LCD@BHPABBNBADPJDDFHBFPF@FFBHFDHFADBH@HBBLL@BFBDNHB@BACKDAACVCDFHFDBBFFDJBJABHDD@DFB@FLBHCBAACNIHFBFDFJHF@\\ALGDEJ@^IBCAGHCDEACBEAAH@@DBBH@D@FADCCGEAFCJEECIAACGBCC@ADABGFBD@FCACPGEKDAFBD@BCDAFBDAAEGCJE@AJGACHECCC@@CEC@ACCBAHC@CDGCEBC@GB@CCGAEIBCCCNGGAG@@CECAGBCLBIEC@DE@GDC@KDCFAAGJMFCBEBA@ERFLCH@FCBGBEB@BCDADCDAN@BABEDDJBLC@DDBBDD@@DHADBJ@FDD@DFJDFDBDEDADFBBDADABFHCFJDDDBDAFL@HCPFPADBDD@LFDLFCL@JADDFAFBJFDLDDABFFFDFHBFHNAD@HHAHBDNDP@@JDBDATGFDBBLDJAFEBEDALBBFD@JDHBD@HD@DCF@FHB@DLFDHFB@FADBFCD@HJDD@BDVNNNTFAH@HBFDFCH@DBFHFHLDLDBNAFFJ@HHH@BBBHD@LAFCD@BCNE@CCCDKGEGMFA@EBCFEFACEBEGC@CAC@EC@HK@EEAACKAHACG@CGCCC@EEE@GCA@CM@@ECADCBEBAEG@CBALAHGFBHCBGDABCFCBENOAKVGDADG@AQG@IKECCAEDIFGDG@EAEDCLGJEBEBIK@EEGBCCGAGEAEFGDMH@DGFAFCAA@IFCBCAAAMBMBCACBEACFGGGAEHIHEJM`QLCFEFKHGACBAAEMA@ECA@KECCEBEAAIG@AIGEECGBEDEAIDE@EBEAEDKLEFADAAGAA@GDCFMNCFBF@DCFAHBDCBAHDBHBBFCBGD@LBDDRHBDDBLBDABAL@DAFBDA@CBCFA@CDCFGFABACGH@FBBAN@B@AAHA@CDBFCBDDCL@HCHABEHCHDDC@FNHBAHADELBFGAABAL@DA@ED@DAACFBBCDBBDDBFJJBBAB@FAD@BBD@HBD@@BBBFABADDDCACLDAGJIEAACAEBACEAGCECKAADE@CD@HCTDFAJFFGJEJ@JFDEDEDSAEJBF@DFJ@HBFANADAAIDCbBRAHIBIFKJBRET@@GDGNC@CJEDMFFHDVD@IHIACDEJILEJ@HCJ@DABQAAHIFQJIDMFEBIAINCHELMJI~GXDHCJTNPDHLFDJPJFJHBBDJDF@FCBLFHRDJDZH\\RAFBBHD\\ATBXORQjQNUVSLG\\MFAJ@PEJKAIBERKPCBDFDLCFDHBZRHJDBH@HCNIJFH@FN@HBDTBNDL@HBLN@BEJBD@DBBRDTCHGREV@LARBDB@FKD@BFD^D@NQPFJHFLAFCFBFAFGAKKMDEEE@EBGACEEBCDC@AEGOCEIAECA@EAAHIAE@GDG@ELGNCBA@ICA@IHIBGEAAGKCG@A@AEBGGCGBCBCACBOGAAAGGKBICACGBGCOEE@GCC@GCEDKCGJABCAEIE@ADCBOBGEKKCEC@IECBGBOAIKACCEAGEICEC@MKBGEMAAEIAGGAEEKFKCEEO@IBC@CFEL@HGB@BEFCAABEDGAAGGCKIGDEBIHK@CDC@GGAEEAIEG@EGEEGGECGM@IEMCECCKGGCKBCHAAGBIBAAADE@GAE@CG@@DEDKDM@OCAAGCE@GDUGAC@IHK@ABEC@GCCE@AGCAEC@CG@KIKAE@CF@FACEBCL@BIHEAADCCABGAA@AAACACC@KB@F@BAACDCBCCECAAAHEAAREFELBDAJDR@BCECEIECBCAEDCEGJAEIBIKBEEE@AAGC@EECACMGAGCAGDI@EBK@GCC@GDIJC@QFICAGCCC@IDGBCDAFKGIHCFE@IKEEOGCCDELKACDIAGHA@EFCHCDCAGDGBCFAFO@CA@ACQAGBGCCBGDGBICIAGEMDKEOACBGJIDADKAIDEFGD@DGFMEUBC@AEC@IEG@EBE@EG@ECGKCAEECM@WLGLKCSACH@DADEBAFIDELC@EAEBCBQ@ECK@EDOEI@MKIAIGACJE@AACEC@EGI@EDCAEBAIGIBICUHGHC@IAOAEEEKCAKCOBCHBFADMJU@WHIAI@IAI@GEC@CCCBKEAACCACCCYBIEIAAEE@ECGASKYCCC@EIDIF]CAAEGGEG@AEEGAEOG@CMIMAE@EAEBIACCC@SG@EICQBOCCCQBAE@EAIIAGCCAIA[KEGICAI@GDCBEACG@UDI@ME@A@AH@HADGFE@EBADCPMXHFCDEFANAH@FI@GFAHKLBJHNAJ@FAF@FDRDBBBFRAJHPDFCVCDEHEH@FCJ@FCF@HEJMXGJGBEFCDKDEDG@EFKAGJGF@DC@EL@JCAEBCACDCBCCMFILGDCBECCBCCCBGKEBGCCEOIAMOAUSLABCAKBKAGBMEIA@EBCBC@CHK@AEECC@ECAEG@IHGKYNINIlWF]GGA@@ABCAEDCACDEAEBCPKNAFEBCL@HCHAFGJCBAHCKGWNcJ{DIFCXBHPfJN@FCDoPGFAZ@RCNijGNA^CLOXATJJHRAPIPSJaD[EMMW]IU@KJMXWDIEE]QUEO@MFWl@NFHVRPNDL]NWFWGUMMEE@KNSlMJiNWNSPIJKTAHKRMTQPkHMDIDEHAXQPEJBLPVBNAJGNENPBHHDLIHMHAFDNBZNNBLF^@XHHLJJFBPHVAFSRGDMBwGQ@U@MFYJWDOBQE_MSBgT]TDJVFZBBHQTAJDHdXLJ@JyZMBcQOIaKMACUDOTKDOAYEGAUDKDELGtIDSAUQMCM@EDCDAhELCBEAAIECAIAMBYHOBK@ICMKCKAGBKP]NQFE@C@AGCM@MFG@ICACCaS@GCIKGM@IEEQBI@IAKKY@IFMBMIS[WQUCaGMQSGOAKFQ~u@CEAYGIIFM@IBEXI@AAGGAODCFCJEHE@YICAAG@CFGFAPAJIQIII@CDKHALBP@PC@EAGBCKAQ@OCGKDGACCIYEIGCMBUHGJY@IMUDaAEGKAGVkAOACKKIQ_eUOKCHUAUGOJYjMPK@UKiIBGnGDGW]BMCGECY@_UIOBEZI@EUEWCAEHSGEODONSbMNYJKRILMHYDSJafKB[MMBcVODKAEICK@QECICO@KBCH@HPRBLGJOFM@G@QGGMFIZYFOCGMBACLICAIAMDILCVEFICIIK@GABSOQ@E\\MLIGEeFOOIBOHSHCG@KEGICKFMDI@GCAOOQAGFGLIjWBGIQOCQASBYFOAIGDK\\C^DNAAKKEYMQ@MEAMHINCRJHEEKQOQE_BQAEM@[DIFAH@TJJ@HCBGQQ@EFKRCT@@KKGiCCACMEEUKWCCCAKHQCEIAmDIEAGBKUSCIMAIHC@SEG@GFAFCLCFIFI@IG@CHKFIACIBKAKBAACIAAIDC@MK@ABE@CAAQE@CB@FAV@ACOCAA@EDC@AKCGGCASDEAGGCKUDOBICMAOJEAEEQKMQ@MBIPU@GGMB]EIYAKC_MQEQDEDGNEDQCO@gN]CSFMJOFiFSCCKIAKBMDSVKFY@MMMOm_WGUCaDGFANEJSHMBaKOAMBKKBOGQcOWEQDULOCECGBWDQAMC}ZUPCAADE@CEEAEBIECDEBAD@BC@@BGīPşCiGDsW[TGHKFCDEJAHBHGLCREFCJCF@HAFOZ[^MVEFITSJMLMHEH@DHL@NHH@DKHCHQ@CDKNaPMPAHGFALCDBF@FEFBHBNET@FC@MGOBE@A@GFGL@PAFEH@FKHAHCDMEMTOA[EE@a\\GBBDEPBJFLJL@FV@PHHAB@DHB@PEJ@FDPDDLLLFALCLDLV@TDNA^@PNNfFFpRTPLDL@FFFPFF@HCJJ\\dbHRFHMP@FILFJAPABBF@VBHABE@MBABBHHFBFCBEAEBAB@BFVAFLH@DCBGDEAEEEBAB@BHJAFCDIHSDEBCFCB@BFD@BADML@DFBJ@ABGDEFGEEB@DDH@DG@SAADDHDDDD@DYCCB@LBFIHBDCD@FHFN@@JDJEFEBMBKHM@GBMHGHIDO@QEC@aJCBABAL@FBDHBRIF@DBCJGHEDC@QCKDGH@DMVENIFKDEHAF@DHBHDHAHEJCHBDHIDEJ@HHH@DCDUACDEHA@IDQAEF@NANLR@DCD"],"encodeOffsets":[[130906,43816]]},"properties":{"cp":[129.513228,42.904823],"name":"延边朝鲜族自治州","childNum":1}}],"UTF8Encoding":true});
}));