[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-green.svg)](https://www.webcomponents.org/element/arsnebula/nebula-button)
[![Polymer Version](https://img.shields.io/badge/polymer-v2-blue.svg)](https://www.polymer-project.org)
[![Sauce Labs Build Status](https://img.shields.io/badge/saucelabs-passing-red.svg)](https://saucelabs.com/beta/builds/0cf16e39be9b47638e70e12749c9b574)
[![Gitter Chat](https://badges.gitter.im/org.png)](https://gitter.im/arsnebula/webcomponents)
[![Become a Patreon](https://img.shields.io/badge/patreon-support_us-orange.svg)](https://www.patreon.com/arsnebula)

# \<nebula-button\>

A web component to display a ghost-style command or toggle button.

* Elegant ghost-style flat button
* Supports standard and toggle states
* Customizable with standard CSS, variables and mixins.
* Supports [WAI-ARIA](https://www.w3.org/TR/wai-aria-practices-1.1/#button) authoring practices for **a11y**

> This package is part of the [Nebula Essentials](https://www.webcomponents.org/collection/arsnebula/nebula-essentials) collection.

## Installation

```sh
$ bower install -S arsnebula/nebula-button
```

## Getting Started

Import the element.

```html
<link rel="import" href="/bower_components/nebula-button/nebula-button.html"> 
```

Add the element. The default is a standard command button.

```html
<nebula-button on-click="_onClick">
  Button
</nebula-button>
```

Add define a toggle button, enabled the `toggle` property.

```html
<nebula-button toggle pressed="{{pressed}}" on-change="_onChange">
  Button
</nebula-button>
```

Style the button with standard CSS.

```css
nebula-button {
  color: teal;
}
```

*For more information see the API Reference documentation.*

## Contributing

We welcome and appreciate feedback from the community. Here are a few ways that you can show your appreciation for this package:

* Give us a **Star on GitHub** from either [webcomponents.org](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin) or directly on [GitHub](https://github.com/arsnebula/nebula-element-mixin).

* Submit a feature request, or a defect report on the [Issues List](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin/issues).

* Become a [Patreon](https://www.patreon.com/arsnebula). It takes a lot of time and effort to develop, document, test and support the elements in our [Nebula Essentials](https://www.webcomponents.org/collection/arsnebula/nebula-essentials) collection. Your financial contribution will help ensure that our entire collection continues to grow and improve.

If you are a developer, and are interested in making a code contribution, consider opening an issue first to describe the change, and discuss with the core repository maintainers. Once you are ready, prepare a pull request:

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request :D

## Change Log

See [CHANGELOG](/CHANGELOG.md)

## License

See [LICENSE](/LICENSE.md)