[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-green.svg)](https://www.webcomponents.org/element/arsnebula/nebula-flexbox)
[![Polymer Version](https://img.shields.io/badge/polymer-v2-blue.svg)](https://www.polymer-project.org)
[![Sauce Labs Build Status](https://img.shields.io/badge/saucelabs-passing-red.svg)](https://saucelabs.com/beta/builds/ed3ece07066d44368d04f998a9f86c3f)
[![Gitter Chat](https://badges.gitter.im/org.png)](https://gitter.im/arsnebula/webcomponents)
[![Become a Patreon](https://img.shields.io/badge/patreon-support_us-orange.svg)](https://www.patreon.com/arsnebula)

# \<nebula-flexbox\>

A Polymer stylesheet module to apply flexbox styles using attributes.

* Declarative approach to applying a flexbox layout
* Easy to read and remember
* Import for an entire page, or scope to an individual element

## Installation

```sh
$ bower install -S arsnebula/nebula-flexbox
```

## Usage

Import the package element:

```html
<link rel="import" href="/bower_components/nebula-flexbox/nebula-flexbox.html"> 
```

Import the stylesheet module for an entire page.

```html
<custom-style>
  <style include="nebula-flexbox">
  </style>
</custom-style>
```

Import the stylesheet module for a specific element template.

```html
<dom-module id="my-element">
  <template>
    <style include="nebula-flexbox">
    </style>
  </template>
</dom-module>
```

Use flexbox attributes to apply flexbox styles to container and descendent elements.

```html
<div flexbox="flex"
  flex-direction="row"
  align-items="center"
  justify-content="center">

  <div flexbox flex="auto"></div>
  <div flexbox flex="2"></div>
  <div flexbox flex="auto"></div>
</div>
```

*For more information API Reference documentation.*

## Contributing

We welcome and appreciate feedback from the community. Here are a few ways that you can show your appreciation for this package:

* Give us a **Star on GitHub** from either [webcomponents.org](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin) or directly on [GitHub](https://github.com/arsnebula/nebula-element-mixin).

* Submit a feature request, or a defect report on the [Issues List](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin/issues).

* Become a [Patreon](https://www.patreon.com/arsnebula). It takes a lot of time and effort to develop, document, test and support the elements in our [Nebula Essentials](https://www.webcomponents.org/collection/arsnebula/nebula-essentials) collection. Your financial contribution will help ensure that our entire collection continues to grow and improve.

If you are a developer, and are interested in making a code contribution, consider opening an issue first to describe the change, and discuss with the core repository maintainers. Once you are ready, prepare a pull request:

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request :D

## Change Log

See [CHANGELOG](/CHANGELOG.md)

## License

See [LICENSE](/LICENSE.md)