# \<nebula-flexbox\>

`<nebula-flexbox>` is a stylesheet module for applying flexbox styles using attributes. While there are a myriad of **flexbox** CSS strategies often involving complex combinations of CSS classes, the purpose of this module is to provide a simple way to achieve declarative flexbox layouts with a syntax that is clear and easy to remember.

## Usage

Import the package element:

```html
<link rel="import" href="/bower_components/nebula-flexbox/nebula-flexbox.html"> 
```

To apply flexbox attributes you must import the stylesheet module. This can be done for an entire web-page by including a `<custom-style` block in your page.

```html
<custom-style>
  <style is="custom-style" include="nebula-flexbox">
  </style>
</custom-style>
```

To scope the flexbox attributes within a custom element, include the stylesheet module in your template styles.

```html
<dom-module id="nebula-button">
  <template>
    <style include="nebula-flexbox">
    </style>
  </template>
</dom-module>
```

All flexbox-related attributes are scoped by `flexbox`. Without a `flexbox` attribute on a container or descendent element, no other flexbox attributes will be applied.

For container elements, use the `flexbox` attribute to set the `display` style to `flex` or `inline-flex`. The remainder of the flexbox attributes match their CSS property equivalents exactly. If you know flexbox, you know how to use `nebula-flexbox` attributes.

```html
<div flexbox="flex"
  flex-direction="row"
  align-items="center"
  justify-content="center">
</div>
```

For immediate descendents of flexbox containers, things get a little more complicated. The `flex-stretch`, `flex-grow` and `flex-basis` properties potentially all utilize numeric ranges. To solve this, a common strategy has been adopted to use the flexbox defaults, and support a 12-column grid.

The `flex` attribute supports `none`, `auto`, or a value from `1` to `12`.

Descendent elements can also utilize the `align-self` attribute to override container alignment.

```html
<div flexbox="flex">
  <div flexbox flex="auto"></div>
  <div flexbox flex="2"></div>
  <div flexbox flex="2"></div>
  <div flexbox flex="none" align-self="flex-end">
</div>
```

Any element can be both a flexbox container, and a descendent using the combination of `flexbox` and providing a display value, and the `flex` attribute.

```html
<div flexbox="flex" flex="auto"></div>
```
