# Nebula.FocusBehavior

`Nebula.FocusBehavior` is a Polymer Project [Class Expression Mixin](https://www.polymer-project.org/2.0/docs/devguide/custom-elements#mixins) that extends a custom element with focus-related properties and user interaction states.

The focus behavior was designed to support styling an element based on the following user experience goals:

- if the control is focused by keyboard, show a focus ring and preserve until native focus is moved to another element.
- if the element is hovered over with a mouse, show a focus ring until the mouse moves off the element
- if the element is focused by a touch interaction, don't display any focus ring

## Usage

Extend the base element using the mixin class factory method.

```js
class MyElement extends Nebula.FocusBehavior(Polymer.Element) {}
```

The element will now support attributes that can be used to style the element based on focus. It also includes some utility functionality such as automatically removing the tabindex if the element is disabled.

The following example applies a focus-ring to a control for keyboard and mouse user interaction (but not for touch):

```css
:host {
  outline: none;
}
:host([focused]) {
  box-shadow: 0 0 1px 1px teal;
}
```

Use the `focusmode` attribute to style based on specic user interaction modes:

```css
:host {
  outline: none;
}
:host([focusmode=key]):focus {
  box-shadow: 0 0 1px 1px teal;
}
:host([focusmode=mouse]):hover {
  box-shadow: 0 0 1px 1px darkred;
}
```

## API Reference

### Properties

#### disabled : Boolean

Indicates if the element is disabled.

#### focused : Boolean

Indicates if the element (or a child element) has received focus.

#### focusmode : String

The type of user interaction used to trigger focus (key, mouse or touch).
