[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-green.svg)](https://www.webcomponents.org/element/arsnebula/nebula-inputbox)
[![Polymer Version](https://img.shields.io/badge/polymer-v2-blue.svg)](https://www.polymer-project.org)
[![Sauce Labs Build Status](https://img.shields.io/badge/saucelabs-passing-red.svg)](https://saucelabs.com/beta/builds/d0eb7561afab4d79b73ee2a9c8bc5301)
[![Gitter Chat](https://badges.gitter.im/org.png)](https://gitter.im/arsnebula/webcomponents)
[![Become a Patreon](https://img.shields.io/badge/patreon-support_us-orange.svg)](https://www.patreon.com/arsnebula)

# \<nebula-inputbox\>

Add labels and hints to an input control.

* Provides named slots to add hints around a standard input control
* Easily styled with CSS variables and mixins.

## Installation

```sh
$ bower install -S arsnebula/nebula-inputbox
```

## Getting Started

Import the element:

```html
<link rel="import" href="/bower_components/nebula-inputbox/nebula-inputbox.html"> 
```

Add the element. The main `input` slot should contain a normal HTML `input` control. Add hints such as labels, icons and help or validation text around the input control, using the `top`, `left`, `right` and `bottom` named slots.

```html
<nebula-inputbox>
  <input slot="input" id="email" name="email" type="text" autocomplete="off" />
  <label slot="top" for="email">Email</label>
  <iron-icon icon="icons:mail" slot="left"></iron-icon>
  <iron-icon icon="icons:search" slot="right"></iron-icon>
  <div slot="bottom">An email for account verification</div>  
</nebula-inputbox>
```

You can easily theme the element using slot and other attributes.

```css
nebula-inputbox[focused] {
  color: teal;
}
nebula-inputbox[invalid][slot=bottom] {
  color: darkred;
}
```

*For more information, see the API documentation.*

## Contributing

We welcome and appreciate feedback from the community. Here are a few ways that you can show your appreciation for this package:

* Give us a **Star on GitHub** from either [webcomponents.org](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin) or directly on [GitHub](https://github.com/arsnebula/nebula-element-mixin).

* Submit a feature request, or a defect report on the [Issues List](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin/issues).

* Become a [Patreon](https://www.patreon.com/arsnebula). It takes a lot of time and effort to develop, document, test and support the elements in our [Nebula Essentials](https://www.webcomponents.org/collection/arsnebula/nebula-essentials) collection. Your financial contribution will help ensure that our entire collection continues to grow and improve.

If you are a developer, and are interested in making a code contribution, consider opening an issue first to describe the change, and discuss with the core repository maintainers. Once you are ready, prepare a pull request:

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request :D

## Change Log

See [CHANGELOG](/CHANGELOG.md)

## License

See [LICENSE](/LICENSE.md)