# <\nebula-inputbox\>

Add labels and hints to an input control.

## Import

```html
<link rel="import" href="/bower_components/nebula-inputbox/nebula-inputbox.html"> 
```

## Usage

The element provides `input`, `top`, `left`, `right` and `bottom` named slots to provide hints around an input control. The slots can be used to display labels, icons, instructions and/or validation error messages.

The following example demonstrates adding hints like labels, instruction text, and icons to augment an input control:

```html
<nebula-inputbox>
  <input slot="input" id="email" name="email" type="text" autocomplete="off" />
  <label slot="top" for="email">Email</label>
  <iron-icon icon="icons:mail" slot="left"></iron-icon>
  <iron-icon icon="icons:search" slot="right"></iron-icon>
  <div slot="bottom">An email for account verification</div>  
</nebula-inputbox>
```

The `input` slot is expected to contain a normal HTML input control. The remaining slots can contain any kind of element.

## Style

The element can be styled using standard CSS properties.

The element also inherits default values from the following global theme styles. If a global theme variable has not been set, it will use the local default.

Custom property | Description | Default
:--- | :--- | :---
`--nebula-ui-margin` | The margin of the element. | 4px
`--nebula-ui-border-width` | The border width of the element. | 1px
`--nebula-ui-border-radius` | The border-radius of the element. | 2px
`--nebula-ui-focused-box-shadow` | The box-shadow of the element when focused. | 0 0 1px 1px currentColor
`--nebula-ui-disabled-opacity` | Opacity of the element when disabled. | 0.6

**Example**

```css
nebula-inputbox[focused] {
  color: teal;
}
```
