[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-green.svg)](https://www.webcomponents.org/element/arsnebula/nebula-button)
[![Polymer Version](https://img.shields.io/badge/polymer-v2-blue.svg)](https://www.polymer-project.org)
[![Sauce Labs Build Status](https://img.shields.io/badge/saucelabs-passing-red.svg)](https://saucelabs.com/beta/builds/f020cd219c4b498fb5ffbb696e962881)
[![Gitter Chat](https://badges.gitter.im/org.png)](https://gitter.im/arsnebula/webcomponents)
[![Become a Patreon](https://img.shields.io/badge/patreon-support_us-orange.svg)](https://www.patreon.com/arsnebula)

# \<nebula-queue\>

Serialize activity between web components using a FIFO queue.

## Installation

```sh
$ bower install -S arsnebula/nebula-queue
```

## Getting Started

Import the element.

```html
<link rel="import" href="/bower_components/nebula-queue/nebula-queue.html"> 
```

Add and configure a `<nebula-queue>` element to provide access to queue events and methods. Each queue is identified by a unique `name`. You can have as many queues as you want by adding multiple instances of the element to a template. The `length` property wil be updated automatically as requests are added and removed from the queue. If the `length` is zero, the queue is empty. The `changed` event can be used to listen for `push` and `pop` changes to the queue. The event does not bubble.

```html
<nebula-queue
  id="alerts"
  queue-name="alerts"
  length="{{alertsLength}}"
  on-push="_onQueuePush"
  on-pop="_onQueuePop">
</nebula-queue>
```

Add a callback to the queue using the `queue` method. Once the request reaches the top of the queue, the callback will be invoked with a single `done` argument. The `done` argument is a function that must be called to remove the request from the queue.

```js
this.$.alerts.queue(function(done) {
  try {
    alert('My alert is ready!')
  }
  finally {
    done()
  }
})
```

<b>WARNING: Failing to call the `done` method will block the queue from processing any further requests. Ensure you add error handling to your callback to ensure done is called property.</b>

*For more information, see the API documentation.*

## Contributing

We welcome and appreciate feedback from the community. Here are a few ways that you can show your appreciation for this package:

* Give us a **Star on GitHub** from either [webcomponents.org](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin) or directly on [GitHub](https://github.com/arsnebula/nebula-element-mixin).

* Submit a feature request, or a defect report on the [Issues List](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin/issues).

* Become a [Patreon](https://www.patreon.com/arsnebula). It takes a lot of time and effort to develop, document, test and support the elements in our [Nebula Essentials](https://www.webcomponents.org/collection/arsnebula/nebula-essentials) collection. Your financial contribution will help ensure that our entire collection continues to grow and improve.

If you are a developer, and are interested in making a code contribution, consider opening an issue first to describe the change, and discuss with the core repository maintainers. Once you are ready, prepare a pull request:

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request :D

## Change Log

See [CHANGELOG](/CHANGELOG.md)

## License

See [LICENSE](/LICENSE.md)