# \<nebula-rating\>

`<nebula-rating>` is a web component to display a rating control.

## Import

```html
<link rel="import" href="/bower_components/nebula-rating/nebula-rating.html"> 
```

## Usage

The following demonstrates common properties and events.

```html
<nebula-rating
  icon="icons:star"
  max="5"
  value="{{value}}"
  on-change="_onChange">
</nebula-rating>
```

## Style

The element can be styled using standard CSS properties and the following CSS variables:

Custom property | Description
:--- | :---
`--nebula-rating-color` | The default color for icons.
`--nebula-rating-active-color` | The color for icons that are active.
`--nebula-rating-icon-size` | The height and width of the element icons.

The element also inherits default values from the following global theme styles. If a global theme variable has not been set, it will use the local default.

Custom property | Description | Default
:--- | :--- | :---
`--nebula-ui-margin` | The margin of the element. | 4px
`--nebula-ui-border-width` | The border width of the element. | 1px
`--nebula-ui-border-radius` | The border-radius of the element. | 2px
`--nebula-ui-focused-box-shadow` | The box-shadow of the element when focused. | 0 0 1px 1px currentColor
`--nebula-ui-disabled-opacity` | Opacity of the element when disabled. | 0.6

## API Reference

### Properties

#### icon : String

The key of the icon resource to render.

#### value : Number

The current value (between 0 and max).

#### max : Number

The maximum potential value.

### Events

#### value-changed : CustomEvent

Event fired when the value of the `value` property is changed.

### Mixins

#### [Nebula.ElementMixin](https://www.webcomponents.org/element/arsnebula/nebula-element-mixin)

#### [Nebula.FocusBehavior](https://www.webcomponents.org/element/arsnebula/nebula-focus-behavior)