---
layout: layout.njk
tags: ['posts',  'announcements']
title: kutty 0.0.1 has been released!
date: 2020-05-15
---

## Kutty 0.0.1 Release

I'm pleased to announce the [0.0.1 release](https://unpkg.com/browse/kutty.org@0.0.1/) of kutty, the successor
to [intercooler.js](http://intercoolerjs.org)!

Like intercooler, kutty brings features of modern browsers that normally require javascript (AJAX, CSS transitions, etc.) 
directly into HTML.

#### Why the rename?

I chose to rename the project for a few reasons:

* I wanted the freedom to clean up mistakes and remove ideas that hadn't worked out as cleanly as I wanted
* The JS in `intercooler.js` implied a javascript-orientation.  The more I developed intercooler the more I realized
  that it was really about enhancing (completing?) HTML, not javascript.  This project doesn't really compete with tools 
  like angular, vue or react, it's something different, so I wanted a different name.
* `kutty` is short and memorable, `kutty.org` was available, and it has consonance with "cuttlefish" which is the
  official cephalopod of kutty development.

#### So what's new & different about kutty vs. intercooler?

* First and foremost, kutty has [*no external dependencies*](https://github.com/bigskysoftware/kutty/blob/master/package.json) !
  No more dragging in jQuery just to do HTML-oriented web development.  It has been tested with IE11.
* It follows conventional naming and behavior standards more closely than intercooler does (e.g. [`innerHTML`](/attributes/kt-swap) and [`outerHTML`](/attributes/kt-swap))
* Kutty isn't the kitchen-sink-of-features that intercooler is.  Kutty is more focused on the features that are amenable 
  to a declarative approache and less on replacing javascript entirely.
* Kutty has a better swapping mechanism which introduces a settling step, which allows for nice CSS transitions
  with minimal complexity.  Check out the [progress bar](/examples/progress-bar) to see how this works: by returning
  HTML in the old web 1.0 style, you can get nice, smooth CSS-based transitions.  Fun!

Beyond that, basic kutty and intercooler code will look a lot a like:

```html
  <div kt-post="/clicked">Click Me!</div>
```

This will issue an AJAX post to `/clicked`, in a manner familiar to anyone who has used intercooler.

#### What will happen to intercooler?

I'm planning on maintaining both projects.  Intercooler is a slow moving project anyway, and the code is stable and
works fine for people who want to go the jQuery route.  I have a large application written with it and I'm not planning
on moving that to kutty any time soon.

#### How hard will a port to kutty from intercooler be?

Depends a lot on how into the weeds you got with intercooler.  The core attributes are pretty close to one another
but if you were using `ic-action` or event handlers extensively it will be a project.

#### OK, so what should I do?

The usual:

* read the [docs](/docs)
* star the [repo](https://github.com/bigskysoftware/kutty)
* tell your friends
* enjoy fully functional HTML, the way [Roy Fielding](https://en.wikipedia.org/wiki/Representational_State_Transfer) intended it

Cheers!