---
layout: layout.njk
tags: ['posts',  'announcements']
title: htmx 0.0.6 has been released!
date: 2020-06-20
---

## htmx 0.0.6 Release

I'm pleased to announce the [0.0.6 release](https://unpkg.com/browse/htmx.org@0.0.6/) of htmx.

### Changes

#### _hyperscript

With this release comes the release of a new sibling project:

<https://hyperscript.org>

hyperscript is a scripting language designed to be embedded directly in HTML and inspired by 
[HyperTalk](https://hypercard.org/HyperTalk%20Reference%202.4.pdf), the programming language of HyperCard.

You can see how hyperscript and htmx work together [in the docs](/docs#hyperscript).

#### Breaking Changes

* Custom request/response headers no longer start with the `X-` prefix, which is no longer recommended
* The `X-HTTP-Method-Override` is now part of the `method-override` extension, and AJAX requests use the actual
  http method specified for requests.
* Extensions that handle swaps must explicitly return an array of elements to process after the swap
* The `hx-error-url` attribute was removed in favor of hyperscript

#### Other Changes

* empty verb attributes are now allowed and follow the anchor tag semantics (e.g. `<div hx-get></div>`)
* nunjuks inline rendering is now supported in the `client-side-templates` extension
* the new `ajax-header` extension includes the `X-Requested-With` header
* bad JSON is now handled more gracefully
* `hx-swap="none"` will cause no swap to take place <https://github.com/bigskysoftware/htmx/issues/89>
* `hx-trigger` now supports a `throttle` modifier <https://github.com/bigskysoftware/htmx/issues/88>
* the focused element is preserved if possible after a replacement
* perf improvements for large DOM trees with sparse `hx-` annotations
* general bug fixes


Enjoy!