---
layout: layout.njk
tags: ['posts',  'announcements']
title: htmx 1.1.0 has been released!
date: 2021-01-06
---

## htmx 1.1.0 Release

I'm happy to announce the [1.1.0 release](https://unpkg.com/browse/htmx.org@1.1.0/) of htmx.

This is a surprisingly big release, but the star of the show isn't htmx itself, but rather the new 
[preload extension](https://htmx.org/extensions/preload/) which allows you to preload requests into the cache,
cutting down on latency.  (This extension is used in the htmx website!)

There are also new examples, including [keyboard shortcuts](/examples/keyboard-shortcuts) and [drag and drop
list reordering with Sortable.js](/examples/sortable)

### Changes

* Newly added [preload extension](https://htmx.org/extensions/preload/) allows you to preload resources for lower
  latency requests!
* Support the `ignore:` modifier for extensions
* Updated form variable order inclusion to include the enclosing form *last* so that, in the presence of multiple 
  values, the most relevant value is the most likely to be selected by the server
* Support for the [`htmx.ajax()`](https://htmx.org/api/#ajax) javascript function, to issue an htmx-style ajax 
  request from javascript
* Removed the following htmx request headers for better cache behavior: `HX-Event-Target`, `HX-Active-Element`, 
  `HX-Active-Element-Name`, `HX-Active-Element-Value`
* Added the [`hx-preserve`](https://htmx.org/attributes/hx-preserve) attribute, which allows 
  you to preserve elements across requests (for example, to keep a video element playing properly)
* The [path-deps](https://htmx.org/extensions/path-deps/#refresh) now surfaces a small api
  for refreshing path dependencies manually in javascript
* Now support the `from:` clause on [`hx-trigger`](https://htmx.org/attributes/hx-trigger) to
  allow an element to respond to events on other elements.
* Added the `htmx:beforeProcessNode` event, renamed the (previously undocumented) `htmx:processedNode` to `htmx:afterProcessNode`
* Added `closest` syntax support for the [`hx-indicator`](https://htmx.org/attributes/hx-indicator) attribute
* Added `on load` support for the newest version of [hyperscript](https://hyperscript.org)
* Added the `htmx.config.allowEval` configuration value, for CSP compatibility
* Bug fixes & improvements 

Enjoy!
