---
layout: layout.njk
title: </> htmx - Server-Side Examples
---

# htmx Server-Side Examples

There are many examples of integrating htmx with server-side frameworks available on GitHub. Generally speaking,
most server-side frameworks are already pretty well set up to integrate with htmx - after all, most of them were
rendering HTML long before JSON became popular.

Different frameworks and platforms may offer alternative systems for installing htmx - for example, in the Java / JVM
ecosystem, [WebJars](https://www.webjars.org) allows the use of npm packages with popular Java build tools such as
Maven and Gradle.

These examples may make it a bit easier to get started using htmx with your platform of choice.

## General Resources

- <https://github.com/rajasegar/awesome-htmx>

## JavaScript

### Node.js

- <https://github.com/rajasegar/todomvc-htmx>
- <https://github.com/rajasegar/htmx-twitter-clone>
- <https://github.com/rajasegar/htmx-trello>

### hapi

- <https://github.com/DamianStanger/hapi-htmx>

## Python

### Django

- <https://github.com/adamchainz/django-htmx>
- <https://github.com/idlesign/django-siteajax>
- <https://github.com/guettli/django-htmx-fun/>

### FastAPI

- <https://github.com/renceInbox/fastapi-todo>

### Flask

- <https://github.com/cscortes/htmxflask>

### py4web

- <https://github.com/jpsteil/py4web_htmx_demo>

## Java

### Spring Boot

- <https://github.com/wiverson/htmx-demo>

### Quarkus

- <https://github.com/derkoe/quarkus-htmx-todos>

## ColdFusion (CFML - a JVM Language)

### CFWheels Framework

- <https://github.com/bpamiri/cfwheels-todomvc-htmx>
- <https://www.forgebox.io/view/cfwheels-htmx-plugin>
- <https://github.com/chapmandu/cfwheels-htmx-crud>

## C#

### ASP.NET Core

- <https://github.com/jerriepelser-blog/htmx-with-aspnet-core>
- <https://github.com/mryderie/aspnet-core-htmx-example>

## Prolog

- <https://github.com/Anniepoo/declswiplweb>

## Lisp

- <https://github.com/rajasegar/ccl-demo-raja>
- <https://github.com/rajasegar/cl-trello-clone>
- <https://github.com/rajasegar/cl-github-timeline>

## Clojure

- <https://github.com/whamtet/ctmx>
- <https://github.com/jcpsantiago/htmx-clj-dashboard>
- <https://github.com/prestancedesign/babashka-htmx-todoapp>

## Ruby

### Rails

<https://github.com/rootstrap/htmx-rails>

### Sinatra

- <https://github.com/libsyz/htmx-to-do-app>
- <https://github.com/beechnut/pokebutt-htmx>

## Julia

- <https://github.com/clarkevans/TodoMVC.jl>
