---
layout: layout.njk
title: </> htmx - Examples
---

## Server-side Integration Examples

A list of [GitHub repositories showing examples of integration](/server-examples) with a wide variety of
server-side languages and platforms, including JavaScript, Python, Java, and many others.

## UI Examples

Below are a set of UX patterns implemented in htmx with minimal HTML and styling.

You can copy and paste them and then adjust them for your needs.

| Pattern | Description |
|-----------|-------------|
| [Click To Edit](/examples/click-to-edit) | Demonstrates inline editing of a data object
| [Bulk Update](/examples/bulk-update) | Demonstrates bulk updating of multiple rows of data
| [Click To Load](/examples/click-to-load) | Demonstrates clicking to load more rows in a table
| [Delete Row](/examples/delete-row) | Demonstrates row deletion in a table
| [Edit Row](/examples/edit-row) | Demonstrates how to edit rows in a table
| [Lazy Loading](/examples/lazy-load) | Demonstrates how to lazy load content
| [Inline Validation](/examples/inline-validation) | Demonstrates how to do inline field validation
| [Infinite Scroll](/examples/infinite-scroll) | Demonstrates infinite scrolling of a page
| [Active Search](/examples/active-search) | Demonstrates the active search box pattern
| [Progress Bar](/examples/progress-bar) | Demonstrates a job-runner like progress bar
| [Value Select](/examples/value-select) | Demonstrates making the values of a select dependent on another select
| [Animations](/examples/animations) | Demonstrates various animation techniques
| [File Upload](/examples/file-upload) | Demonstrates how to upload a file via ajax with a progress bar
| [Dialogs - Browser](/examples/dialogs) | Demonstrates the prompt and confirm dialogs
| [Dialogs - UIKIt](/examples/modal-uikit) | Demonstrates modal dialogs using UIKit
| [Dialogs - Bootstrap](/examples/modal-bootstrap) | Demonstrates modal dialogs using Bootstrap
| [Dialogs - Custom](/examples/modal-custom) | Demonstrates modal dialogs from scratch
| [Tabs (Using HATEOAS)](/examples/tabs-hateoas) | Demonstrates how to display and select tabs using HATEOAS principles
| [Tabs (Using Hyperscript)](/examples/tabs-hyperscript) | Demonstrates how to display and select tabs using Hyperscript
| [Keyboard Shortcuts](/examples/keyboard-shortcuts) | Demonstrates how to create keyboard shortcuts for htmx enabled elements
| [Sortable](/examples/sortable) | Demonstrates how to use htmx with the Sortable.js plugin to implement drag-and-drop reordering
| [Updating Other Content](/examples/update-other-content) | Demonstrates how to update content beyond just the target elements
| [Confirm](/examples/confirm) | Demonstrates how to implement a custom confirmation dialog with htmx

## Migrating from Hotwire / Turbo ?

For common practices see the [Hotwire / Turbo to htmx Migration Guide](/migration-guide-hotwire-turbo).
