---
layout: layout.njk
tags: ['posts',  'announcements']
title: htmx 1.8.0 has been released!
date: 2022-07-12
---

## htmx 1.8.0 Release

I'm happy to announce the [1.8.0 release](https://unpkg.com/browse/htmx.org@1.8.0/) of htmx.

**NOTE:**  This was a big release with some changes to very touchy code that is hard to test (e.g. history support) so
please test thoroughly and let us know if there are any issues.

### New Features

* The [`hx-replace-url`](https://htmx.org/attributes/hx-replace-url) attribute was introduced, allowing you to replace
  the current URL in history (to complement `hx-push-url`)
* `m` is now a valid timing modifier (e.g. `hx-trigger="every 2m"`)
* `next` and `previous` are now valid extended query selector modifiers, e.g. `hx-target="next div"` will target the
  next div from the current element
* The `HX-Location` response header now implements client-side redirects entirely within htmx
* The `HX-Reswap` response header allows you to change the swap behavior of htmx
* The new [`hx-select-oob`](/attributes/hx-select-oob) attribute selects one or more elements from a server response to swap in via an out of band swap
* The new [`hx-replace-url`](/attributes/hx-replace-url) attribute can be used to replace the current URL in the location
  bar (very similar to `hx-push-url` but no new history entry is created).  The corresponding `HX-Replace-Url` response header can be used as well.
  
### Improvements & Bug fixes

* Boosted forms now will automatically push URLs into history as with links.  The [response URL](https://caniuse.com/mdn-api_xmlhttprequest_responseurl)
  detection API support is good enough that we feel comfortable making this the default now.
  * If you do not want this behavior you can add `hx-push-url='false'` to your boosted forms
* If htmx is included in a page more than once, we do not process elements multiple times
* When localStorage is not available we do not attempt to save history in it
* `hx-boost` will boost anchor tags with a `_self` target
* The `load` event now properly supports event filters
* The websocket extension has had many improvements: (A huge thank you to Denis Palashevskii, our newest committer on the project!)
  * Implement proper `hx-trigger` support
  * Expose trigger handling API to extensions
  * Implement safe message sending with sending queue
  * Fix `ws-send` attributes connecting in new elements
  * Fix OOB swapping of multiple elements in response
* htmx now properly handles anchors in both boosted links, as well as in `hx-get`, etc. attributes
* Many, many documentation updates (thank you to all the contributors!)

Enjoy!
