<p align="center">
<img src="https://github.com/CesiumGS/cesium/wiki/logos/Cesium_Logo_Color.jpg" width="50%" />
</p>

[![Build Status](https://travis-ci.org/CesiumGS/cesium.svg?branch=master)](https://travis-ci.org/CesiumGS/cesium)
[![npm](https://img.shields.io/npm/v/cesium)](https://www.npmjs.com/package/cesium)
[![Docs](https://img.shields.io/badge/docs-online-orange.svg)](https://cesium.com/docs/)

CesiumJS is a JavaScript library for creating 3D globes and 2D maps in a web browser without a plugin. It uses WebGL for hardware-accelerated graphics, and is cross-platform, cross-browser, and tuned for dynamic-data visualization.

[CesiumJS Homepage](https://cesium.com/cesiumjs)

[CesiumJS Features Checklist](https://github.com/CesiumGS/cesium/wiki/CesiumJS-Features-Checklist)

### :rocket: Get Started

Visit the [Downloads page](https://cesium.com/downloads/) or use the npm module:

```
npm install cesium
```

Have questions? Ask them on the [community forum](https://community.cesium.com/).

Interested in contributing? See [CONTRIBUTING.md](CONTRIBUTING.md). :heart:

### :snowflake: Mission

Our mission is to create the leading 3D globe and map for static and time-dynamic content, with the best possible performance, precision, visual quality, platform support, community, and ease of use.

### :green_book: License

[Apache 2.0](http://www.apache.org/licenses/LICENSE-2.0.html). CesiumJS is free for both commercial and non-commercial use.

### :earth_americas: Where Does the 3D Content Come From?

CesiumJS can stream 3D content such as terrain, imagery, and 3D Tiles from the commercial [Cesium ion](https://cesium.com/blog/2018/03/01/hello-cesium-ion/)
platform and other content sources. You are free to use any combination of content sources with CesiumJS that you please.
Using Cesium ion helps support CesiumJS development. :heart:

### :clap: Featured Demos

<p>
<a href="https://cesium.com/blog/2018/08/21/cybercity/"><img src="https://cesium.com/blog/images/2018/08-21/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://apps.agi.com/SatelliteViewer/?Status=Operational"><img src="https://cesium.com/blog/images/2018/03-29/comspoc-cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2018/02/05/historic-pharsalia-cabin-point-cloud/"><img src="https://cesium.com/blog/images/2018/02-05/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2017/12/12/onesky/"><img src="https://cesium.com/blog/images/2017/12-12/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2017/11/20/nasa-storm-virtual-globe/"><img src="https://cesium.com/blog/images/2017/11-20/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2017/11/16/gefs/"><img src="https://cesium.com/blog/images/2017/11-16/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2019/01/04/norad-tracks-santa/"><img src="https://cesium.com/blog/images/2019/01-04/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2017/07/23/drcog/"><img src="https://cesium.com/blog/images/2017/07-23/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://demos.cesium.com/NewYork/"><img src="https://cesium.com/blog/images/2017/05-05/nyc-cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2018/09/27/swisstopo-live/"><img src="https://cesium.com/blog/images/2018/09-27/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2016/12/12/stk-czml/"><img src="https://cesium.com/blog/images/2016/12-12/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2016/09/29/contextcapture/"><img src="https://cesium.com/blog/images/2016/09-29/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2016/04/20/flightradar24/"><img src="https://cesium.com/blog/images/2016/04-20/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2016/02/03/fodarearth/"><img src="https://cesium.com/blog/images/2016/02-03/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2015/08/19/mars-trek/"><img src="https://cesium.com/blog/images/2015/08-19/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2015/07/16/hiroshima-archive/"><img src="https://cesium.com/blog/images/2015/07-16/cover.jpg" width="30%" /></a>&nbsp;
<a href="https://cesium.com/blog/2019/06/13/red-bull-x-alps-in-cesium/"><img src="https://cesium.com/blog/images/2019/06-12/redbullxalps.jpg" width="30%" /></a>&nbsp;
<br/>
<br/>
</p>
<h4><a href="https://cesium.com/blog/categories/userstories">See all demos</a></h4>
