"use strict";

module.exports = {
  extends: "eslint:recommended",
  globals: {
    DataView: false,
    ArrayBuffer: false,
    Float32Array: false,
    Float64Array: false,
    Int16Array: false,
    Int32Array: false,
    Int8Array: false,
    Uint16Array: false,
    Uint32Array: false,
    Uint8Array: false,
    Uint8ClampedArray: false,
  },
  rules: {
    "comma-dangle": ["error", "never"],
    curly: "error",
    "block-scoped-var": "error",
    eqeqeq: "error",
    "eol-last": ["error", "always"],
    "guard-for-in": "error",
    "new-cap": ["error", { properties: false }],
    "no-alert": "error",
    "no-caller": "error",
    "no-console": "off",
    "no-else-return": "error",
    "no-empty": "error",
    "no-extend-native": "error",
    "no-extra-boolean-cast": "off",
    "no-floating-decimal": "error",
    "no-irregular-whitespace": "error",
    "no-lonely-if": "error",
    "no-loop-func": "error",
    "no-multiple-empty-lines": ["error", { max: 1, maxEOF: 1 }],
    "no-new": "error",
    "no-prototype-builtins": "off",
    "no-sequences": "error",
    "no-tabs": "error",
    "no-trailing-spaces": "error",
    "no-undef": "error",
    "no-undef-init": "error",
    "no-restricted-globals": ["error", "fdescribe", "fit"],
    "no-unused-expressions": "error",
    "no-unused-vars": ["error", { vars: "all", args: "all" }],
    "no-useless-escape": "off",
    "no-use-before-define": ["error", "nofunc"],
    quotes: ["error", "single", { avoidEscape: true }],
    "require-atomic-updates": "off",
    semi: "error",
    strict: "error",
    "wrap-iife": ["error", "any"],
  },
};
