## Description

Please include a summary of the changes and be sure to follow our [Contribution Guidelines](../CONTRIBUTIONS.md).

<!--
Optional if an issue is fixed:
Fixes #(issue)
-->

## Type of change

<!-- Please delete options that are not relevant. -->

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)

## Checklist:

- [ ] I have selected the correct base branch.
- [ ] I have performed a self-review of my own code.
- [ ] I have commented my code, particularly in hard-to-understand areas.
- [ ] I have made corresponding changes to the documentation.
- [ ] My changes generate no new warnings.
- [ ] Any dependent changes have been merged and published in downstream modules.
- [ ] I ran `npm run dtslint` with success and extended the tests and types if necessary.
- [ ] I ran `npm run test:unit` with success.
- [ ] I ran `npm run test:cov` and my test cases cover all the lines and branches of the added code.
- [ ] I ran `npm run build` and tested `dist/web3.min.js` in a browser.
- [ ] I have tested my code on the live network.
- [ ] I have checked the Deploy Preview and it looks correct.
- [ ] I have updated the `CHANGELOG.md` file in the root folder.
