var chai = require('chai');
var assert = chai.assert;
var Abi = require('../packages/web3-eth-abi');

var tests = [{
    params: [['uint256','string'], ['2345675643', 'Hello!%']],
    result: '0x000000000000000000000000000000000000000000000000000000008bd02b7b0000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000000748656c6c6f212500000000000000000000000000000000000000000000000000'
},{
    params: [['uint64[]','bytes32'], [['34','434'], '0x324567dfff']],
    result: '0x0000000000000000000000000000000000000000000000000000000000000040324567dfff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000002200000000000000000000000000000000000000000000000000000000000001b2'
},{
    params: [['address','address','address', 'address'], ['0x90F8bf6A479f320ead074411a4B0e7944Ea8c9C1','0x10f8bf6a479f320ead074411a4b0e7944ea8c9c1','0xfff8bf6a479f320ead074411a4b0e7944ea8c9c1', '0xddd8bf6a479f320ead074411a4b0e7944ea8c9c1']],
    result: '0x00000000000000000000000090f8bf6a479f320ead074411a4b0e7944ea8c9c100000000000000000000000010f8bf6a479f320ead074411a4b0e7944ea8c9c1000000000000000000000000fff8bf6a479f320ead074411a4b0e7944ea8c9c1000000000000000000000000ddd8bf6a479f320ead074411a4b0e7944ea8c9c1'
}];

describe('encodeParameters', function () {
    tests.forEach(function (test) {
        it('should convert correctly', function () {
            assert.equal(Abi.encodeParameters.apply(Abi, test.params), test.result);
        });
    });
});
