/*!
 *  dc 2.2.2
 *  http://dc-js.github.io/dc.js/
 *  Copyright 2012-2016 Nick Zhu & the dc.js Developers
 *  https://github.com/dc-js/dc.js/blob/master/AUTHORS
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

!function(){function t(t,e){"use strict";var n={version:"2.2.2",constants:{CHART_CLASS:"dc-chart",DEBUG_GROUP_CLASS:"debug",STACK_CLASS:"stack",DESELECTED_CLASS:"deselected",SELECTED_CLASS:"selected",NODE_INDEX_NAME:"__index__",GROUP_INDEX_NAME:"__group_index__",DEFAULT_CHART_GROUP:"__default_chart_group__",EVENT_DELAY:40,NEGLIGIBLE_NUMBER:1e-10},_renderlet:null};n.chartRegistry=function(){function t(t){return t||(t=n.constants.DEFAULT_CHART_GROUP),e[t]||(e[t]=[]),t}var e={};return{has:function(t){for(var n in e)if(e[n].indexOf(t)>=0)return!0;return!1},register:function(n,r){r=t(r),e[r].push(n)},deregister:function(n,r){r=t(r);for(var i=0;i<e[r].length;i++)if(e[r][i].anchorName()===n.anchorName()){e[r].splice(i,1);break}},clear:function(t){t?delete e[t]:e={}},list:function(n){return n=t(n),e[n]}}}(),n.registerChart=function(t,e){n.chartRegistry.register(t,e)},n.deregisterChart=function(t,e){n.chartRegistry.deregister(t,e)},n.hasChart=function(t){return n.chartRegistry.has(t)},n.deregisterAllCharts=function(t){n.chartRegistry.clear(t)},n.filterAll=function(t){for(var e=n.chartRegistry.list(t),r=0;r<e.length;++r)e[r].filterAll()},n.refocusAll=function(t){for(var e=n.chartRegistry.list(t),r=0;r<e.length;++r)e[r].focus&&e[r].focus()},n.renderAll=function(t){for(var e=n.chartRegistry.list(t),r=0;r<e.length;++r)e[r].render();null!==n._renderlet&&n._renderlet(t)},n.redrawAll=function(t){for(var e=n.chartRegistry.list(t),r=0;r<e.length;++r)e[r].redraw();null!==n._renderlet&&n._renderlet(t)},n.disableTransitions=!1,n.transition=function(t,e,r,i){if(n.disableTransitions||e<=0)return t;var a=t.transition(i);return(e>=0||void 0!==e)&&(a=a.duration(e)),(r>=0||void 0!==r)&&(a=a.delay(r)),a},n.optionalTransition=function(t,e,r,i){return t?function(t){return n.transition(t,e,r,i)}:function(t){return t}},n.afterTransition=function(t,e){if(t.empty()||!t.duration)e.call(t);else{var n=0;t.each(function(){++n}).each("end",function(){--n||e.call(t)})}},n.units={},n.units.integers=function(t,e){return Math.abs(e-t)},n.units.ordinal=function(t,e,n){return n},n.units.fp={},n.units.fp.precision=function(t){var e=function(t,r){var i=Math.abs((r-t)/e.resolution);return n.utils.isNegligible(i-Math.floor(i))?Math.floor(i):Math.ceil(i)};return e.resolution=t,e},n.round={},n.round.floor=function(t){return Math.floor(t)},n.round.ceil=function(t){return Math.ceil(t)},n.round.round=function(t){return Math.round(t)},n.override=function(t,e,n){var r=t[e];t["_"+e]=r,t[e]=n},n.renderlet=function(t){return arguments.length?(n._renderlet=t,n):n._renderlet},n.instanceOfChart=function(t){return t instanceof Object&&t.__dcFlag__&&!0},n.errors={},n.errors.Exception=function(t){var e=t||"Unexpected internal error";this.message=e,this.toString=function(){return e},this.stack=(new Error).stack},n.errors.Exception.prototype=Object.create(Error.prototype),n.errors.Exception.prototype.constructor=n.errors.Exception,n.errors.InvalidStateException=function(){n.errors.Exception.apply(this,arguments)},n.errors.InvalidStateException.prototype=Object.create(n.errors.Exception.prototype),n.errors.InvalidStateException.prototype.constructor=n.errors.InvalidStateException,n.errors.BadArgumentException=function(){n.errors.Exception.apply(this,arguments)},n.errors.BadArgumentException.prototype=Object.create(n.errors.Exception.prototype),n.errors.BadArgumentException.prototype.constructor=n.errors.BadArgumentException,n.dateFormat=t.time.format("%m/%d/%Y"),n.printers={},n.printers.filters=function(t){for(var e="",r=0;r<t.length;++r)r>0&&(e+=", "),e+=n.printers.filter(t[r]);return e},n.printers.filter=function(t){var e="";return void 0!==t&&null!==t&&(t instanceof Array?t.length>=2?e="["+n.utils.printSingleValue(t[0])+" -> "+n.utils.printSingleValue(t[1])+"]":t.length>=1&&(e=n.utils.printSingleValue(t[0])):e=n.utils.printSingleValue(t)),e},n.pluck=function(t,e){return e?function(n,r){return e.call(n,n[t],r)}:function(e){return e[t]}},n.utils={},n.utils.printSingleValue=function(t){var e=""+t;return t instanceof Date?e=n.dateFormat(t):"string"==typeof t?e=t:n.utils.isFloat(t)?e=n.utils.printSingleValue.fformat(t):n.utils.isInteger(t)&&(e=Math.round(t)),e},n.utils.printSingleValue.fformat=t.format(".2f"),n.utils.add=function(e,n,r){if("string"==typeof n&&(n=n.replace("%","")),e instanceof Date)return"string"==typeof n&&(n=+n),"millis"===r?new Date(e.getTime()+n):(r=r||"day",t.time[r].offset(e,n));if("string"==typeof n){var i=+n/100;return e>0?e*(1+i):e*(1-i)}return e+n},n.utils.subtract=function(e,n,r){if("string"==typeof n&&(n=n.replace("%","")),e instanceof Date)return"string"==typeof n&&(n=+n),"millis"===r?new Date(e.getTime()-n):(r=r||"day",t.time[r].offset(e,-n));if("string"==typeof n){var i=+n/100;return e<0?e*(1+i):e*(1-i)}return e-n},n.utils.isNumber=function(t){return t===+t},n.utils.isFloat=function(t){return t===+t&&t!==(0|t)},n.utils.isInteger=function(t){return t===+t&&t===(0|t)},n.utils.isNegligible=function(t){return!n.utils.isNumber(t)||t<n.constants.NEGLIGIBLE_NUMBER&&t>-n.constants.NEGLIGIBLE_NUMBER},n.utils.clamp=function(t,e,n){return t<e?e:t>n?n:t};var r=0;return n.utils.uniqueId=function(){return++r},n.utils.nameToId=function(t){return t.toLowerCase().replace(/[\s]/g,"_").replace(/[\.']/g,"")},n.utils.appendOrSelect=function(t,e,n){n=n||e;var r=t.select(e);return r.empty()&&(r=t.append(n)),r},n.utils.safeNumber=function(t){return n.utils.isNumber(+t)?+t:0},n.logger={},n.logger.enableDebugLog=!1,n.logger.warn=function(t){return console&&(console.warn?console.warn(t):console.log&&console.log(t)),n.logger},n.logger.debug=function(t){return n.logger.enableDebugLog&&console&&(console.debug?console.debug(t):console.log&&console.log(t)),n.logger},n.logger.deprecate=function(t,e){var r=!1;return function(){return r||(n.logger.warn(e),r=!0),t.apply(this,arguments)}},n.events={current:null},n.events.trigger=function(t,e){e?(n.events.current=t,setTimeout(function(){t===n.events.current&&t()},e)):t()},n.filters={},n.filters.RangedFilter=function(t,e){var n=new Array(t,e);return n.isFiltered=function(t){return t>=this[0]&&t<this[1]},n.filterType="RangedFilter",n},n.filters.TwoDimensionalFilter=function(t){if(null===t)return null;var e=t;return e.isFiltered=function(t){return t.length&&t.length===e.length&&t[0]===e[0]&&t[1]===e[1]},e.filterType="TwoDimensionalFilter",e},n.filters.RangedTwoDimensionalFilter=function(t){if(null===t)return null;var e,n=t;return e=n[0]instanceof Array?[[Math.min(t[0][0],t[1][0]),Math.min(t[0][1],t[1][1])],[Math.max(t[0][0],t[1][0]),Math.max(t[0][1],t[1][1])]]:[[t[0],-1/0],[t[1],1/0]],n.isFiltered=function(t){var n,r;return t instanceof Array?(n=t[0],r=t[1]):(n=t,r=e[0][1]),n>=e[0][0]&&n<e[1][0]&&r>=e[0][1]&&r<e[1][1]},n.filterType="RangedTwoDimensionalFilter",n},n.baseMixin=function(r){function i(){c&&(D?c.attr("viewBox")||c.attr("viewBox","0 0 "+r.width()+" "+r.height()):c.attr("width",r.width()).attr("height",r.height()))}function a(t){if(!r[t]||!r[t]())throw new n.errors.InvalidStateException("Mandatory attribute chart."+t+" is missing on chart[#"+r.anchorName()+"]")}r.__dcFlag__=n.utils.uniqueId();var o,l,u,s,c,d,f,g,h,p,y,x=200,v=function(t){var e=t&&t.getBoundingClientRect&&t.getBoundingClientRect().width;return e&&e>x?e:x},m=v,A=200,b=function(t){var e=t&&t.getBoundingClientRect&&t.getBoundingClientRect().height;return e&&e>A?e:A},_=b,D=!1,k=n.pluck("key"),C=n.pluck("value"),L=n.pluck("key"),M=n.pluck("key"),w=!1,R=function(t){return r.keyAccessor()(t)+": "+r.valueAccessor()(t)},S=!0,E=!1,O=750,B=0,T=n.printers.filters,F=["dimension","group"],N=n.constants.DEFAULT_CHART_GROUP,G=t.dispatch("preRender","postRender","preRedraw","postRedraw","filtered","zoomed","renderlet","pretransition"),H=[],P=function(t,e){return 0===e.length?t.filter(null):1!==e.length||e[0].isFiltered?1===e.length&&"RangedFilter"===e[0].filterType?t.filterRange(e[0]):t.filterFunction(function(t){for(var n=0;n<e.length;n++){var r=e[n];if(r.isFiltered&&r.isFiltered(t))return!0;if(r<=t&&r>=t)return!0}return!1}):t.filterExact(e[0]),e},Y=function(t){return t.all()};r.height=function(e){return arguments.length?(_=t.functor(e||b),g=void 0,r):(n.utils.isNumber(g)||(g=_(s.node())),g)},r.width=function(e){return arguments.length?(m=t.functor(e||v),f=void 0,r):(n.utils.isNumber(f)||(f=m(s.node())),f)},r.minWidth=function(t){return arguments.length?(x=t,r):x},r.minHeight=function(t){return arguments.length?(A=t,r):A},r.useViewBoxResizing=function(t){return arguments.length?(D=t,r):D},r.dimension=function(t){return arguments.length?(o=t,r.expireCache(),r):o},r.data=function(e){return arguments.length?(Y=t.functor(e),r.expireCache(),r):Y.call(r,l)},r.group=function(t,e){return arguments.length?(l=t,r._groupName=e,r.expireCache(),r):l},r.ordering=function(t){return arguments.length?(M=t,h=e.quicksort.by(M),r.expireCache(),r):M},r._computeOrderedGroups=function(t){var n=t.slice(0);return n.length<=1?n:(h||(h=e.quicksort.by(M)),h(n,0,n.length))},r.filterAll=function(){return r.filter(null)},r.select=function(t){return s.select(t)},r.selectAll=function(t){return s?s.selectAll(t):null},r.anchor=function(e,i){if(!arguments.length)return u;if(n.instanceOfChart(e))u=e.anchor(),s=e.root(),d=!0;else{if(!e)throw new n.errors.BadArgumentException("parent must be defined");u=e.select&&e.classed?e.node():e,(s=t.select(u)).classed(n.constants.CHART_CLASS,!0),n.registerChart(r,i),d=!1}return N=i,r},r.anchorName=function(){var t=r.anchor();return t&&t.id?t.id:t&&t.replace?t.replace("#",""):"dc-chart"+r.chartID()},r.root=function(t){return arguments.length?(s=t,r):s},r.svg=function(t){return arguments.length?(c=t,r):c},r.resetSvg=function(){return r.select("svg").remove(),c=r.root().append("svg"),i(),c},r.filterPrinter=function(t){return arguments.length?(T=t,r):T},r.controlsUseVisibility=function(t){return arguments.length?(E=t,r):E},r.turnOnControls=function(){if(s){var t=r.controlsUseVisibility()?"visibility":"display";r.selectAll(".reset").style(t,null),r.selectAll(".filter").text(T(r.filters())).style(t,null)}return r},r.turnOffControls=function(){if(s){var t=r.controlsUseVisibility()?"visibility":"display",e=r.controlsUseVisibility()?"hidden":"none";r.selectAll(".reset").style(t,e),r.selectAll(".filter").style(t,e).text(r.filter())}return r},r.transitionDuration=function(t){return arguments.length?(O=t,r):O},r.transitionDelay=function(t){return arguments.length?(B=t,r):B},r._mandatoryAttributes=function(t){return arguments.length?(F=t,r):F},r.render=function(){g=f=void 0,G.preRender(r),F&&F.forEach(a);var t=r._doRender();return p&&p.render(),r._activateRenderlets("postRender"),t},r._activateRenderlets=function(t){G.pretransition(r),r.transitionDuration()>0&&c?c.transition().duration(r.transitionDuration()).delay(r.transitionDelay()).each("end",function(){G.renderlet(r),t&&G[t](r)}):(G.renderlet(r),t&&G[t](r))},r.redraw=function(){i(),G.preRedraw(r);var t=r._doRedraw();return p&&p.render(),r._activateRenderlets("postRedraw"),t},r.commitHandler=function(t){return arguments.length?(y=t,r):y},r.redrawGroup=function(){return y?y(!1,function(t,e){t?console.log(t):n.redrawAll(r.chartGroup())}):n.redrawAll(r.chartGroup()),r},r.renderGroup=function(){return y?y(!1,function(t,e){t?console.log(t):n.renderAll(r.chartGroup())}):n.renderAll(r.chartGroup()),r},r._invokeFilteredListener=function(t){void 0!==t&&G.filtered(r,t)},r._invokeZoomedListener=function(){G.zoomed(r)};var U=function(t,e){return null===e||void 0===e?t.length>0:t.some(function(t){return e<=t&&e>=t})};r.hasFilterHandler=function(t){return arguments.length?(U=t,r):U},r.hasFilter=function(t){return U(H,t)};var z=function(t,e){for(var n=0;n<t.length;n++)if(t[n]<=e&&t[n]>=e){t.splice(n,1);break}return t};r.removeFilterHandler=function(t){return arguments.length?(z=t,r):z};var V=function(t,e){return t.push(e),t};r.addFilterHandler=function(t){return arguments.length?(V=t,r):V};var I=function(t){return[]};return r.resetFilterHandler=function(t){return arguments.length?(I=t,r):I},r.replaceFilter=function(t){return H=I(H),r.filter(t),r},r.filter=function(t){if(!arguments.length)return H.length>0?H[0]:null;var e=H;return t instanceof Array&&t[0]instanceof Array&&!t.isFiltered?t[0].forEach(function(t){e=U(e,t)?z(e,t):V(e,t)}):e=null===t?I(e):U(e,t)?z(e,t):V(e,t),H=function(t){if(r.dimension()&&r.dimension().filter){var e=P(r.dimension(),t);e&&(t=e)}return t}(e),r._invokeFilteredListener(t),null!==s&&r.hasFilter()?r.turnOnControls():r.turnOffControls(),r},r.filters=function(){return H},r.highlightSelected=function(e){t.select(e).classed(n.constants.SELECTED_CLASS,!0),t.select(e).classed(n.constants.DESELECTED_CLASS,!1)},r.fadeDeselected=function(e){t.select(e).classed(n.constants.SELECTED_CLASS,!1),t.select(e).classed(n.constants.DESELECTED_CLASS,!0)},r.resetHighlight=function(e){t.select(e).classed(n.constants.SELECTED_CLASS,!1),t.select(e).classed(n.constants.DESELECTED_CLASS,!1)},r.onClick=function(t){var e=r.keyAccessor()(t);n.events.trigger(function(){r.filter(e),r.redrawGroup()})},r.filterHandler=function(t){return arguments.length?(P=t,r):P},r._doRender=function(){return r},r._doRedraw=function(){return r},r.legendables=function(){return[]},r.legendHighlight=function(){},r.legendReset=function(){},r.legendToggle=function(){},r.isLegendableHidden=function(){return!1},r.keyAccessor=function(t){return arguments.length?(k=t,r):k},r.valueAccessor=function(t){return arguments.length?(C=t,r):C},r.label=function(t,e){return arguments.length?(L=t,(void 0===e||e)&&(w=!0),r):L},r.renderLabel=function(t){return arguments.length?(w=t,r):w},r.title=function(t){return arguments.length?(R=t,r):R},r.renderTitle=function(t){return arguments.length?(S=t,r):S},r.renderlet=n.logger.deprecate(function(t){return r.on("renderlet."+n.utils.uniqueId(),t),r},'chart.renderlet has been deprecated.  Please use chart.on("renderlet.<renderletKey>", renderletFunction)'),r.chartGroup=function(t){return arguments.length?(d||n.deregisterChart(r,N),N=t,d||n.registerChart(r,N),r):N},r.expireCache=function(){return r},r.legend=function(t){return arguments.length?((p=t).parent(r),r):p},r.chartID=function(){return r.__dcFlag__},r.options=function(t){var e=["anchor","group","xAxisLabel","yAxisLabel","stack","title","point","getColor","overlayGeoJson"];for(var i in t)"function"==typeof r[i]?t[i]instanceof Array&&-1!==e.indexOf(i)?r[i].apply(r,t[i]):r[i].call(r,t[i]):n.logger.debug("Not a valid option setter name: "+i);return r},r.on=function(t,e){return G.on(t,e),r},r},n.marginMixin=function(t){var e={top:10,right:50,bottom:30,left:30};return t.margins=function(n){return arguments.length?(e=n,t):e},t.effectiveWidth=function(){return t.width()-t.margins().left-t.margins().right},t.effectiveHeight=function(){return t.height()-t.margins().top-t.margins().bottom},t},n.colorMixin=function(e){var n,r=t.scale.category20c(),i=!0,a=function(t){return e.keyAccessor()(t)};return e.colors=function(n){return arguments.length?(r=n instanceof Array?t.scale.quantize().range(n):t.functor(n),e):r},e.ordinalColors=function(n){return e.colors(t.scale.ordinal().range(n))},e.linearColors=function(n){return e.colors(t.scale.linear().range(n).interpolate(t.interpolateHcl))},e.colorAccessor=function(t){return arguments.length?(a=t,i=!1,e):a},e.defaultColorAccessor=function(){return i},e.colorDomain=function(t){return arguments.length?(r.domain(t),e):r.domain()},e.calculateColorDomain=function(){var n=[t.min(e.data(),e.colorAccessor()),t.max(e.data(),e.colorAccessor())];return r.domain(n),e},e.getColor=function(t,e){return n?n.call(this,t,e):r(a.call(this,t,e))},e.colorCalculator=function(t){return arguments.length?(n=t,e):n||e.getColor},e},n.coordinateGridMixin=function(e){function r(t,r){e.isOrdinal()?(e.elasticX()||0===y.domain().length)&&y.domain(e._ordinalXDomain()):e.elasticX()&&y.domain([e.xAxisMin(),e.xAxisMax()]);var i=y.domain();(r||function(t,e){return!t||!e||t.length!==e.length||t.some(function(t,n){return t&&e[n]?t.toString()!==e[n].toString():t===e[n]})}(m,i))&&e.rescale(),m=i,e.isOrdinal()?y.rangeBands([0,e.xAxisLength()],Z,e._useOuterPadding()?j:0):y.range([0,e.xAxisLength()]),L=L.scale(e.x()),function(t){var r=t.select("g."+f);if(P){r.empty()&&(r=t.insert("g",":first-child").attr("class",d+" "+f).attr("transform","translate("+e.margins().left+","+e.margins().top+")"));var i=L.tickValues()?L.tickValues():"function"==typeof y.ticks?y.ticks(L.ticks()[0]):y.domain(),a=r.selectAll("line").data(i),o=a.enter().append("line").attr("x1",function(t){return y(t)}).attr("y1",e._xAxisY()-e.margins().top).attr("x2",function(t){return y(t)}).attr("y2",0).attr("opacity",0);n.transition(o,e.transitionDuration(),e.transitionDelay()).attr("opacity",1),n.transition(a,e.transitionDuration(),e.transitionDelay()).attr("x1",function(t){return y(t)}).attr("y1",e._xAxisY()-e.margins().top).attr("x2",function(t){return y(t)}).attr("y2",0),a.exit().remove()}else r.selectAll("line").remove()}(t)}function i(){return e._xAxisY()-e.margins().top}function a(){return e.anchorName().replace(/[ .#=\[\]"]/g,"-")+"-clip"}function o(){var t=n.utils.appendOrSelect(g,"defs"),r=a(),i=n.utils.appendOrSelect(t,"#"+r,"clipPath").attr("id",r),o=2*K;n.utils.appendOrSelect(i,"rect").attr("width",e.xAxisLength()+o).attr("height",e.yAxisHeight()+o).attr("transform","translate(-"+K+", -"+K+")")}function l(t){e.isOrdinal()&&(G=!1),r(e.g(),t),e._prepareYAxis(e.g()),e.plotData(),(e.elasticX()||U||t)&&e.renderXAxis(e.g()),(e.elasticY()||U||t)&&e.renderYAxis(e.g()),t?e.renderBrush(e.g(),!1):e.redrawBrush(e.g(),U),e.fadeDeselectedArea(),U=!1}function u(){W?e._enableMouseZoom():q&&e._disableMouseZoom()}function s(){if(Y=!0,V){var t=x;k&&(t=function(t,e){(t[0]>e[1]||t[1]<e[0])&&console.warn("could not intersect extents");return[Math.max(t[0],e[0]),Math.min(t[1],e[1])]}(t,k.x().domain()));var r=function(t,e){var r=t[1]-t[0];return t[0]<e[0]?[e[0],Math.min(e[1],n.utils.add(e[0],r,"millis"))]:t[1]>e[1]?[Math.max(e[0],n.utils.subtract(e[1],r,"millis")),e[1]]:null}(e.x().domain(),t);r&&e.x().domain(r)}var i=e.x().domain(),a=n.filters.RangedFilter(i[0],i[1]);e.replaceFilter(a),e.rescale(),e.redraw(),k&&!c(e.filter(),k.filter())&&n.events.trigger(function(){k.replaceFilter(a),k.redraw()}),e._invokeZoomedListener(),n.events.trigger(function(){e.redrawGroup()},n.constants.EVENT_DELAY),Y=!c(i,x)}function c(t,e){return!t&&!e||!(!t||!e)&&(0===t.length&&0===e.length||t[0].valueOf()===e[0].valueOf()&&t[1].valueOf()===e[1].valueOf())}var d="grid-line",f="vertical";(e=n.colorMixin(n.marginMixin(n.baseMixin(e)))).colors(t.scale.category10()),e._mandatoryAttributes().push("x");var g,h,p,y,x,v,m,A,b,_,D,k,C,L=t.svg.axis().orient("bottom"),M=n.units.integers,w=0,R="day",S=!1,E=0,O=t.svg.axis().orient("left"),B=0,T=!1,F=0,N=t.svg.brush(),G=!0,H=!1,P=!1,Y=!1,U=!1,z=[1,1/0],V=!0,I=t.behavior.zoom().on("zoom",s),X=t.behavior.zoom().on("zoom",null),q=!1,W=!1,K=0,j=.5,Z=0,J=!1;return e.rescale=function(){return D=void 0,U=!0,e},e.resizing=function(){return U},e.rangeChart=function(t){return arguments.length?((k=t).focusChart(e),e):k},e.zoomScale=function(t){return arguments.length?(z=t,e):z},e.zoomOutRestrict=function(t){return arguments.length?(z[0]=t?1:0,V=t,e):V},e._generateG=function(t){g=void 0===t?e.svg():t;var n=window.location.href.split("#")[0];return h=g.append("g"),p=h.append("g").attr("class","chart-body").attr("transform","translate("+e.margins().left+", "+e.margins().top+")").attr("clip-path","url("+n+"#"+a()+")"),h},e.g=function(t){return arguments.length?(h=t,e):h},e.mouseZoomable=function(t){return arguments.length?(W=t,e):W},e.chartBodyG=function(t){return arguments.length?(p=t,e):p},e.x=function(t){return arguments.length?(y=t,x=y.domain(),e.rescale(),e):y},e.xOriginalDomain=function(){return x},e.xUnits=function(t){return arguments.length?(M=t,e):M},e.xAxis=function(t){return arguments.length?(L=t,e):L},e.elasticX=function(t){return arguments.length?(S=t,e):S},e.xAxisPadding=function(t){return arguments.length?(w=t,e):w},e.xAxisPaddingUnit=function(t){return arguments.length?(R=t,e):R},e.xUnitCount=function(){if(void 0===D){var t=e.xUnits()(e.x().domain()[0],e.x().domain()[1],e.x().domain());D=t instanceof Array?t.length:t}return D},e.useRightYAxis=function(t){return arguments.length?(J=t,e):J},e.isOrdinal=function(){return e.xUnits()===n.units.ordinal},e._useOuterPadding=function(){return!0},e._ordinalXDomain=function(){return e._computeOrderedGroups(e.data()).map(e.keyAccessor())},e.renderXAxis=function(t){var r=t.select("g.x");r.empty()&&(r=t.append("g").attr("class","axis x").attr("transform","translate("+e.margins().left+","+e._xAxisY()+")"));var i=t.select("text.x-axis-label");i.empty()&&e.xAxisLabel()&&(i=t.append("text").attr("class","x-axis-label").attr("transform","translate("+(e.margins().left+e.xAxisLength()/2)+","+(e.height()-E)+")").attr("text-anchor","middle")),e.xAxisLabel()&&i.text()!==e.xAxisLabel()&&i.text(e.xAxisLabel()),n.transition(r,e.transitionDuration(),e.transitionDelay()).attr("transform","translate("+e.margins().left+","+e._xAxisY()+")").call(L),n.transition(i,e.transitionDuration(),e.transitionDelay()).attr("transform","translate("+(e.margins().left+e.xAxisLength()/2)+","+(e.height()-E)+")")},e._xAxisY=function(){return e.height()-e.margins().bottom},e.xAxisLength=function(){return e.effectiveWidth()},e.xAxisLabel=function(t,n){return arguments.length?(v=t,e.margins().bottom-=E,E=void 0===n?12:n,e.margins().bottom+=E,e):v},e._prepareYAxis=function(n){if(void 0===A||e.elasticY()){void 0===A&&(A=t.scale.linear());var r=e.yAxisMin()||0,i=e.yAxisMax()||0;A.domain([r,i]).rangeRound([e.yAxisHeight(),0])}A.range([e.yAxisHeight(),0]),O=O.scale(A),J&&O.orient("right"),e._renderHorizontalGridLinesForAxis(n,A,O)},e.renderYAxisLabel=function(t,r,i,a){a=a||F;var o=e.g().select("text.y-axis-label."+t+"-label"),l=e.margins().top+e.yAxisHeight()/2;o.empty()&&r&&(o=e.g().append("text").attr("transform","translate("+a+","+l+"),rotate("+i+")").attr("class","y-axis-label "+t+"-label").attr("text-anchor","middle").text(r)),r&&o.text()!==r&&o.text(r),n.transition(o,e.transitionDuration(),e.transitionDelay()).attr("transform","translate("+a+","+l+"),rotate("+i+")")},e.renderYAxisAt=function(t,r,i){var a=e.g().select("g."+t);a.empty()&&(a=e.g().append("g").attr("class","axis "+t).attr("transform","translate("+i+","+e.margins().top+")")),n.transition(a,e.transitionDuration(),e.transitionDelay()).attr("transform","translate("+i+","+e.margins().top+")").call(r)},e.renderYAxis=function(){var t=J?e.width()-e.margins().right:e._yAxisX();e.renderYAxisAt("y",O,t);var n=J?e.width()-F:F,r=J?90:-90;e.renderYAxisLabel("y",e.yAxisLabel(),r,n)},e._renderHorizontalGridLinesForAxis=function(t,r,i){var a=t.select("g.horizontal");if(H){var o=i.tickValues()?i.tickValues():r.ticks(i.ticks()[0]);a.empty()&&(a=t.insert("g",":first-child").attr("class",d+" horizontal").attr("transform","translate("+e.margins().left+","+e.margins().top+")"));var l=a.selectAll("line").data(o),u=l.enter().append("line").attr("x1",1).attr("y1",function(t){return r(t)}).attr("x2",e.xAxisLength()).attr("y2",function(t){return r(t)}).attr("opacity",0);n.transition(u,e.transitionDuration(),e.transitionDelay()).attr("opacity",1),n.transition(l,e.transitionDuration(),e.transitionDelay()).attr("x1",1).attr("y1",function(t){return r(t)}).attr("x2",e.xAxisLength()).attr("y2",function(t){return r(t)}),l.exit().remove()}else a.selectAll("line").remove()},e._yAxisX=function(){return e.useRightYAxis()?e.width()-e.margins().right:e.margins().left},e.yAxisLabel=function(t,n){return arguments.length?(b=t,e.margins().left-=F,F=void 0===n?12:n,e.margins().left+=F,e):b},e.y=function(t){return arguments.length?(A=t,e.rescale(),e):A},e.yAxis=function(t){return arguments.length?(O=t,e):O},e.elasticY=function(t){return arguments.length?(T=t,e):T},e.renderHorizontalGridLines=function(t){return arguments.length?(H=t,e):H},e.renderVerticalGridLines=function(t){return arguments.length?(P=t,e):P},e.xAxisMin=function(){var r=t.min(e.data(),function(t){return e.keyAccessor()(t)});return n.utils.subtract(r,w,R)},e.xAxisMax=function(){var r=t.max(e.data(),function(t){return e.keyAccessor()(t)});return n.utils.add(r,w,R)},e.yAxisMin=function(){var r=t.min(e.data(),function(t){return e.valueAccessor()(t)});return n.utils.subtract(r,B)},e.yAxisMax=function(){var r=t.max(e.data(),function(t){return e.valueAccessor()(t)});return n.utils.add(r,B)},e.yAxisPadding=function(t){return arguments.length?(B=t,e):B},e.yAxisHeight=function(){return e.effectiveHeight()},e.round=function(t){return arguments.length?(_=t,e):_},e._rangeBandPadding=function(t){return arguments.length?(Z=t,e):Z},e._outerRangeBandPadding=function(t){return arguments.length?(j=t,e):j},n.override(e,"filter",function(t){return arguments.length?(e._filter(t),t?e.brush().extent(t):e.brush().clear(),e):e._filter()}),e.brush=function(t){return arguments.length?(N=t,e):N},e.renderBrush=function(t){if(G){N.on("brush",e._brushing),N.on("brushstart",e._disableMouseZoom),N.on("brushend",u);var n=t.append("g").attr("class","brush").attr("transform","translate("+e.margins().left+","+e.margins().top+")").call(N.x(e.x()));e.setBrushY(n,!1),e.setHandlePaths(n),e.hasFilter()&&e.redrawBrush(t,!1)}},e.setHandlePaths=function(t){t.selectAll(".resize").append("path").attr("d",e.resizeHandlePath)},e.setBrushY=function(t){t.selectAll("rect").attr("height",i()),t.selectAll(".resize path").attr("d",e.resizeHandlePath)},e.extendBrush=function(){var t=N.extent();return e.round()&&(t[0]=t.map(e.round())[0],t[1]=t.map(e.round())[1],h.select(".brush").call(N.extent(t))),t},e.brushIsEmpty=function(t){return N.empty()||!t||t[1]<=t[0]},e._brushing=function(){var t=e.extendBrush();if(e.redrawBrush(h,!1),e.brushIsEmpty(t))n.events.trigger(function(){e.filter(null),e.redrawGroup()},n.constants.EVENT_DELAY);else{var r=n.filters.RangedFilter(t[0],t[1]);n.events.trigger(function(){e.replaceFilter(r),e.redrawGroup()},n.constants.EVENT_DELAY)}},e.redrawBrush=function(t,r){if(G){e.filter()&&e.brush().empty()&&e.brush().extent(e.filter());var i=n.optionalTransition(r,e.transitionDuration(),e.transitionDelay())(t.select("g.brush"));e.setBrushY(i),i.call(e.brush().x(e.x()).extent(e.brush().extent()))}e.fadeDeselectedArea()},e.fadeDeselectedArea=function(){},e.resizeHandlePath=function(t){var e=+("e"===t),n=e?1:-1,r=i()/3;return"M"+.5*n+","+r+"A6,6 0 0 "+e+" "+6.5*n+","+(r+6)+"V"+(2*r-6)+"A6,6 0 0 "+e+" "+.5*n+","+2*r+"ZM"+2.5*n+","+(r+8)+"V"+(2*r-8)+"M"+4.5*n+","+(r+8)+"V"+(2*r-8)},e.clipPadding=function(t){return arguments.length?(K=t,e):K},e._preprocessData=function(){},e._doRender=function(){return e.resetSvg(),e._preprocessData(),e._generateG(),o(),l(!0),u(),e},e._doRedraw=function(){return e._preprocessData(),l(!1),o(),e},e._enableMouseZoom=function(){q=!0,I.x(e.x()).scaleExtent(z).size([e.width(),e.height()]).duration(e.transitionDuration()),e.root().call(I)},e._disableMouseZoom=function(){e.root().call(X)},e.focus=function(t){!function(t){return t instanceof Array&&t.length>1}(t)?e.x().domain(x):e.x().domain(t),I.x(e.x()),s()},e.refocused=function(){return Y},e.focusChart=function(t){return arguments.length?(C=t,e.on("filtered",function(t){t.filter()?c(t.filter(),C.filter())||n.events.trigger(function(){C.focus(t.filter())}):n.events.trigger(function(){C.x().domain(C.xOriginalDomain())})}),e):C},e.brushOn=function(t){return arguments.length?(G=t,e):G},e},n.stackMixin=function(e){function r(n,r){var i=n.accessor||e.valueAccessor();return n.name=String(n.name||r),n.values=n.group.all().map(function(t,r){return{x:e.keyAccessor()(t,r),y:n.hidden?null:i(t,r),data:t,layer:n.name,hidden:n.hidden}}),n.values=n.values.filter(function(){if(!e.x()||d)return t.functor(!0);var n=e.x().domain();if(e.isOrdinal())return function(){return!0};if(e.elasticX())return function(){return!0};return function(t){return t.x>=n[0]&&t.x<=n[n.length-1]}}()),n.values}function i(t){var e=u.map(n.pluck("name")).indexOf(t);return u[e]}function a(){var t=e.data().map(function(t){return t.values});return Array.prototype.concat.apply([],t)}function o(t){return!t.hidden}var l=t.layout.stack().values(r),u=[],s={},c=!1,d=!1;return e.stack=function(t,n,r){if(!arguments.length)return u;arguments.length<=2&&(r=n);var i={group:t};return"string"==typeof n&&(i.name=n),"function"==typeof r&&(i.accessor=r),u.push(i),e},n.override(e,"group",function(t,n,r){return arguments.length?(u=[],s={},e.stack(t,n),r&&e.valueAccessor(r),e._group(t,n)):e._group()}),e.hidableStacks=function(t){return arguments.length?(c=t,e):c},e.hideStack=function(t){var n=i(t);return n&&(n.hidden=!0),e},e.showStack=function(t){var n=i(t);return n&&(n.hidden=!1),e},e.getValueAccessorByIndex=function(t){return u[t].accessor||e.valueAccessor()},e.yAxisMin=function(){var r=t.min(a(),function(t){return t.y<0?t.y+t.y0:t.y0});return n.utils.subtract(r,e.yAxisPadding())},e.yAxisMax=function(){var r=t.max(a(),function(t){return t.y>0?t.y+t.y0:t.y0});return n.utils.add(r,e.yAxisPadding())},e.xAxisMin=function(){var r=t.min(a(),n.pluck("x"));return n.utils.subtract(r,e.xAxisPadding(),e.xAxisPaddingUnit())},e.xAxisMax=function(){var r=t.max(a(),n.pluck("x"));return n.utils.add(r,e.xAxisPadding(),e.xAxisPaddingUnit())},n.override(e,"title",function(t,n){return t?"function"==typeof t?e._title(t):t===e._groupName&&"function"==typeof n?e._title(n):"function"!=typeof n?s[t]||e._title():(s[t]=n,e):e._title()}),e.stackLayout=function(n){return arguments.length?((l=n).values()===t.layout.stack().values()&&l.values(r),e):l},e.evadeDomainFilter=function(t){return arguments.length?(d=t,e):d},e.data(function(){var t=u.filter(o);return t.length?e.stackLayout()(t):[]}),e._ordinalXDomain=function(){var t=a().map(n.pluck("data"));return e._computeOrderedGroups(t).map(e.keyAccessor())},e.colorAccessor(function(t){return this.layer||this.name||t.name||t.layer}),e.legendables=function(){return u.map(function(t,n){return{chart:e,name:t.name,hidden:t.hidden||!1,color:e.getColor.call(t,t.values,n)}})},e.isLegendableHidden=function(t){var e=i(t.name);return!!e&&e.hidden},e.legendToggle=function(t){c&&(e.isLegendableHidden(t)?e.showStack(t.name):e.hideStack(t.name),e.renderGroup())},e},n.capMixin=function(e){var r=1/0,i=!0,a="Others";e.ordering(function(t){return-t.value});var o=function(n,r){var i=t.sum(r,e.valueAccessor()),a=r.map(e.keyAccessor());return i>0?n.concat([{others:a,key:e.othersLabel(),value:i}]):n};return e.cappedKeyAccessor=function(t,n){return t.others?t.key:e.keyAccessor()(t,n)},e.cappedValueAccessor=function(t,n){return t.others?t.value:e.valueAccessor()(t,n)},e.data(function(t){if(r===1/0)return e._computeOrderedGroups(t.all());var n,a=t.all();if(a=e._computeOrderedGroups(a),r)if(i)n=a.slice(r),a=a.slice(0,r);else{var l=Math.max(0,a.length-r);n=a.slice(0,l),a=a.slice(l)}return o?o(a,n):a}),e.cap=function(t){return arguments.length?(r=t,e):r},e.takeFront=function(t){return arguments.length?(i=t,e):i},e.othersLabel=function(t){return arguments.length?(a=t,e):a},e.othersGrouper=function(t){return arguments.length?(o=t,e):o},n.override(e,"onClick",function(t){t.others&&e.filter([t.others]),e._onClick(t)}),e},n.bubbleMixin=function(e){var r=.3,i=10,a=!1,o=!1;e.BUBBLE_NODE_CLASS="node",e.BUBBLE_CLASS="bubble",e.MIN_RADIUS=10,(e=n.colorMixin(e)).renderLabel(!0),e.data(function(n){var r=n.all();if(a){var i=e.radiusValueAccessor();r.sort(function(e,n){return t.descending(i(e),i(n))})}return r});var l=t.scale.linear().domain([0,100]),u=function(t){return t.r};e.r=function(t){return arguments.length?(l=t,e):l},e.elasticRadius=function(t){return arguments.length?(o=t,e):o},e.calculateRadiusDomain=function(){o&&e.r().domain([e.rMin(),e.rMax()])},e.radiusValueAccessor=function(t){return arguments.length?(u=t,e):u},e.rMin=function(){return t.min(e.data(),function(t){return e.radiusValueAccessor()(t)})},e.rMax=function(){return t.max(e.data(),function(t){return e.radiusValueAccessor()(t)})},e.bubbleR=function(t){var n=e.radiusValueAccessor()(t),r=e.r()(n);return(isNaN(r)||n<=0)&&(r=0),r};var s=function(t){return e.label()(t)},c=function(t){return e.bubbleR(t)>i},d=function(t){return c(t)?1:0},f=function(t){return c(t)?"all":"none"};e._doRenderLabel=function(t){if(e.renderLabel()){var r=t.select("text");r.empty()&&(r=t.append("text").attr("text-anchor","middle").attr("dy",".3em").on("click",e.onClick)),r.attr("opacity",0).attr("pointer-events",f).text(s),n.transition(r,e.transitionDuration(),e.transitionDelay()).attr("opacity",d)}},e.doUpdateLabels=function(t){if(e.renderLabel()){var r=t.select("text").attr("pointer-events",f).text(s);n.transition(r,e.transitionDuration(),e.transitionDelay()).attr("opacity",d)}};var g=function(t){return e.title()(t)};return e._doRenderTitles=function(t){if(e.renderTitle()){t.select("title").empty()&&t.append("title").text(g)}},e.doUpdateTitles=function(t){e.renderTitle()&&t.select("title").text(g)},e.sortBubbleSize=function(t){return arguments.length?(a=t,e):a},e.minRadius=function(t){return arguments.length?(e.MIN_RADIUS=t,e):e.MIN_RADIUS},e.minRadiusWithLabel=function(t){return arguments.length?(i=t,e):i},e.maxBubbleRelativeSize=function(t){return arguments.length?(r=t,e):r},e.fadeDeselectedArea=function(){e.hasFilter()?e.selectAll("g."+e.BUBBLE_NODE_CLASS).each(function(t){e.isSelectedNode(t)?e.highlightSelected(this):e.fadeDeselected(this)}):e.selectAll("g."+e.BUBBLE_NODE_CLASS).each(function(){e.resetHighlight(this)})},e.isSelectedNode=function(t){return e.hasFilter(t.key)},e.onClick=function(t){var r=t.key;n.events.trigger(function(){e.filter(r),e.redrawGroup()})},e},n.pieChart=function(e,r){function i(){var e=t.min([E.width(),E.height()])/2;p=y&&y<e?y:e;var r,i=u(),h=t.layout.pie().sort(null).value(E.cappedValueAccessor);if(t.sum(E.data(),E.valueAccessor())?(r=h(E.data()),x.classed(C,!1)):(r=h([{key:L,value:1,others:[L]}]),x.classed(C,!0)),x){var v=x.select("g."+D).selectAll("g."+b).data(r),m=x.select("g."+k).selectAll("text."+_).data(r);!function(t,e,r,i){var u=function(t){return t.enter().append("g").attr("class",function(t,e){return b+" _"+e})}(t);(function(t,e){var r=t.append("path").attr("fill",d).on("click",f).attr("d",function(t,n){return g(t,n,e)}),i=n.transition(r,E.transitionDuration(),E.transitionDelay());i.attrTween&&i.attrTween("d",c)})(u,r),function(t){E.renderTitle()&&t.append("title").text(function(t){return E.title()(t.data)})}(u),function(t,e,n){if(E.renderLabel()){var r=t.enter().append("text").attr("class",function(t,e){var n=b+" "+_+" _"+e;return A&&(n+=" external"),n}).on("click",f).on("mouseover",function(t,e){o(e,!0)}).on("mouseout",function(t,e){o(e,!1)});a(r,n),A&&S&&l(e,n)}}(e,i,r)}(v,m,i,r),function(t,e){(function(t,e){var r=x.selectAll("g."+b).data(t).select("path").attr("d",function(t,n){return g(t,n,e)}),i=n.transition(r,E.transitionDuration(),E.transitionDelay());i.attrTween&&i.attrTween("d",c);i.attr("fill",d)})(t,e),function(t,e){if(E.renderLabel()){var n=x.selectAll("text."+_).data(t);a(n,e),A&&S&&l(t,e)}}(t,e),function(t){E.renderTitle()&&x.selectAll("g."+b).data(t).select("title").text(function(t){return E.title()(t.data)})}(t)}(r,i),function(t,e){t.exit().remove(),e.exit().remove()}(v,m),E.hasFilter()?E.selectAll("g."+b).each(function(t){s(t)?E.highlightSelected(this):E.fadeDeselected(this)}):E.selectAll("g."+b).each(function(){E.resetHighlight(this)}),n.transition(x,E.transitionDuration(),E.transitionDelay()).attr("transform","translate("+E.cx()+","+E.cy()+")")}}function a(e,r){E._applyLabelText(e),n.transition(e,E.transitionDuration(),E.transitionDelay()).attr("transform",function(e){return function(e,n){var r;r=A?t.svg.arc().outerRadius(p-w+A).innerRadius(p-w+A).centroid(e):n.centroid(e);return isNaN(r[0])||isNaN(r[1])?"translate(0,0)":"translate("+r+")"}(e,r)}).attr("text-anchor","middle")}function o(t,e){E.select("g.pie-slice._"+t).classed("highlight",e)}function l(e,r){var i=x.selectAll("polyline."+b).data(e);i.enter().append("polyline").attr("class",function(t,e){return"pie-path _"+e+" "+b}).on("click",f).on("mouseover",function(t,e){o(e,!0)}).on("mouseout",function(t,e){o(e,!1)}),i.exit().remove();var a=t.svg.arc().outerRadius(p-w+A).innerRadius(p-w),l=n.transition(i,E.transitionDuration(),E.transitionDelay());l.attrTween?l.attrTween("points",function(e){var n=this._current||e;n={startAngle:n.startAngle,endAngle:n.endAngle};var i=t.interpolate(n,e);return this._current=i(0),function(t){var e=i(t);return[r.centroid(e),a.centroid(e)]}}):l.attr("points",function(t){return[r.centroid(t),a.centroid(t)]}),l.style("visibility",function(t){return t.endAngle-t.startAngle<1e-4?"hidden":"visible"})}function u(){return t.svg.arc().outerRadius(p-w).innerRadius(M)}function s(t){return E.hasFilter(E.cappedKeyAccessor(t.data))}function c(e){e.innerRadius=M;var n=this._current;n=function(t){return!t||isNaN(t.startAngle)||isNaN(t.endAngle)}(n)?{startAngle:0,endAngle:0}:{startAngle:n.startAngle,endAngle:n.endAngle};var r=t.interpolate(n,e);return this._current=r(0),function(t){return g(r(t),0,u())}}function d(t,e){return E.getColor(t.data,e)}function f(t,e){x.attr("class")!==C&&E.onClick(t.data,e)}function g(t,e,n){var r=n(t,e);return r.indexOf("NaN")>=0&&(r="M0,0"),r}function h(e,n){E.selectAll("g.pie-slice").each(function(r){e.name===r.data.key&&t.select(this).classed("highlight",n)})}var p,y,x,v,m,A,b="pie-slice",_="pie-label",D="pie-slice-group",k="pie-label-group",C="empty-chart",L="empty",M=0,w=0,R=.5,S=!1,E=n.capMixin(n.colorMixin(n.baseMixin({})));return E.colorAccessor(E.cappedKeyAccessor),E.title(function(t){return E.cappedKeyAccessor(t)+": "+E.cappedValueAccessor(t)}),E.slicesCap=E.cap,E.label(E.cappedKeyAccessor),E.renderLabel(!0),E.transitionDuration(350),E.transitionDelay(0),E._doRender=function(){return E.resetSvg(),(x=E.svg().append("g").attr("transform","translate("+E.cx()+","+E.cy()+")")).append("g").attr("class",D),x.append("g").attr("class",k),i(),E},E._applyLabelText=function(t){t.text(function(t){return!function(t){return 0===E.cappedValueAccessor(t)}(t.data)&&!function(t){var e=t.endAngle-t.startAngle;return isNaN(e)||e<R}(t)||s(t)?E.label()(t.data):""})},E.externalRadiusPadding=function(t){return arguments.length?(w=t,E):w},E.innerRadius=function(t){return arguments.length?(M=t,E):M},E.radius=function(t){return arguments.length?(y=t,E):y},E.cx=function(t){return arguments.length?(v=t,E):v||E.width()/2},E.cy=function(t){return arguments.length?(m=t,E):m||E.height()/2},E._doRedraw=function(){return i(),E},E.minAngleForLabel=function(t){return arguments.length?(R=t,E):R},E.emptyTitle=function(t){return 0===arguments.length?L:(L=t,E)},E.externalLabels=function(t){return 0===arguments.length?A:(A=t||void 0,E)},E.drawPaths=function(t){return 0===arguments.length?S:(S=t,E)},E.legendables=function(){return E.data().map(function(t,e){var n={name:t.key,data:t.value,others:t.others,chart:E};return n.color=E.getColor(t,e),n})},E.legendHighlight=function(t){h(t,!0)},E.legendReset=function(t){h(t,!1)},E.legendToggle=function(t){E.onClick({key:t.name,others:t.others})},E.anchor(e,r)},n.barChart=function(e,r){function i(t){return n.utils.safeNumber(Math.abs(s.y()(t.y+t.y0)-s.y()(t.y0)))}function a(e,n){return function(){var r=t.select(this).attr("fill")===e;return n?!r:r}}var o,l=1,u=3,s=n.stackMixin(n.coordinateGridMixin({})),c=2,d=!1,f=!1;return n.override(s,"rescale",function(){return s._rescale(),o=void 0,s}),n.override(s,"render",function(){return s.round()&&d&&!f&&n.logger.warn("By default, brush rounding is disabled if bars are centered. See dc.js bar chart API documentation for details."),s._render()}),s.label(function(t){return n.utils.printSingleValue(t.y0+t.y)},!1),s.plotData=function(){var e=s.chartBodyG().selectAll("g.stack").data(s.data());!function(){if(void 0===o){var t=s.xUnitCount();((o=s.isOrdinal()&&void 0===c?Math.floor(s.x().rangeBand()):c?Math.floor((s.xAxisLength()-(t-1)*c)/t):Math.floor(s.xAxisLength()/(1+s.barPadding())/t))===1/0||isNaN(o)||o<l)&&(o=l)}}(),e.enter().append("g").attr("class",function(t,e){return"stack _"+e});var r=e.size()-1;e.each(function(e,a){var l=t.select(this);!function(t,e,r){var a=t.selectAll("rect.bar").data(r.values,n.pluck("x")),l=a.enter().append("rect").attr("class","bar").attr("fill",n.pluck("data",s.getColor)).attr("y",s.yAxisHeight()).attr("height",0);s.renderTitle()&&l.append("title").text(n.pluck("data",s.title(r.name))),s.isOrdinal()&&a.on("click",s.onClick),n.transition(a,s.transitionDuration(),s.transitionDelay()).attr("x",function(t){var e=s.x()(t.x);return d&&(e-=o/2),s.isOrdinal()&&void 0!==c&&(e+=c/2),n.utils.safeNumber(e)}).attr("y",function(t){var e=s.y()(t.y+t.y0);return t.y<0&&(e-=i(t)),n.utils.safeNumber(e)}).attr("width",o).attr("height",function(t){return i(t)}).attr("fill",n.pluck("data",s.getColor)).select("title").text(n.pluck("data",s.title(r.name))),n.transition(a.exit(),s.transitionDuration(),s.transitionDelay()).attr("x",function(t){return s.x()(t.x)}).attr("width",.9*o).remove()}(l,0,e),s.renderLabel()&&r===a&&function(t,e,r){var a=t.selectAll("text.barLabel").data(r.values,n.pluck("x"));a.enter().append("text").attr("class","barLabel").attr("text-anchor","middle"),s.isOrdinal()&&(a.on("click",s.onClick),a.attr("cursor","pointer")),n.transition(a,s.transitionDuration(),s.transitionDelay()).attr("x",function(t){var e=s.x()(t.x);return d||(e+=o/2),n.utils.safeNumber(e)}).attr("y",function(t){var e=s.y()(t.y+t.y0);return t.y<0&&(e-=i(t)),n.utils.safeNumber(e-u)}).text(function(t){return s.label()(t)}),n.transition(a.exit(),s.transitionDuration(),s.transitionDelay()).attr("height",0).remove()}(l,0,e)})},s.fadeDeselectedArea=function(){var t=s.chartBodyG().selectAll("rect.bar"),e=s.brush().extent();if(s.isOrdinal())s.hasFilter()?(t.classed(n.constants.SELECTED_CLASS,function(t){return s.hasFilter(t.x)}),t.classed(n.constants.DESELECTED_CLASS,function(t){return!s.hasFilter(t.x)})):(t.classed(n.constants.SELECTED_CLASS,!1),t.classed(n.constants.DESELECTED_CLASS,!1));else if(s.brushIsEmpty(e))t.classed(n.constants.DESELECTED_CLASS,!1);else{var r=e[0],i=e[1];t.classed(n.constants.DESELECTED_CLASS,function(t){return t.x<r||t.x>=i})}},s.centerBar=function(t){return arguments.length?(d=t,s):d},n.override(s,"onClick",function(t){s._onClick(t.data)}),s.barPadding=function(t){return arguments.length?(s._rangeBandPadding(t),c=void 0,s):s._rangeBandPadding()},s._useOuterPadding=function(){return void 0===c},s.outerPadding=s._outerRangeBandPadding,s.gap=function(t){return arguments.length?(c=t,s):c},s.extendBrush=function(){var t=s.brush().extent();return!s.round()||d&&!f||(t[0]=t.map(s.round())[0],t[1]=t.map(s.round())[1],s.chartBodyG().select(".brush").call(s.brush().extent(t))),t},s.alwaysUseRounding=function(t){return arguments.length?(f=t,s):f},s.legendHighlight=function(t){s.isLegendableHidden(t)||s.g().selectAll("rect.bar").classed("highlight",a(t.color)).classed("fadeout",a(t.color,!0))},s.legendReset=function(){s.g().selectAll("rect.bar").classed("highlight",!1).classed("fadeout",!1)},n.override(s,"xAxisMax",function(){var t=this._xAxisMax();if("resolution"in s.xUnits()){t+=s.xUnits().resolution}return t}),s.anchor(e,r)},n.lineChart=function(e,r){function i(t,e){return x.getColor.call(t,t.values,e)}function a(t){return!t||t.indexOf("NaN")>=0?"M0,0":t}function o(e,r){if("always"===x.xyTipsOn()||!x.brushOn()&&x.xyTipsOn()){var i=f+"-list",a=e.select("g."+i);a.empty()&&(a=e.append("g").attr("class",i)),r.each(function(e,r){var i=e.values;c&&(i=i.filter(c));var o=a.select("g."+f+"._"+r);o.empty()&&(o=a.append("g").attr("class",f+" _"+r)),function(t){(t.select("path."+h).empty()?t.append("path").attr("class",h):t.select("path."+h)).style("display","none").attr("stroke-dasharray","5,5");(t.select("path."+p).empty()?t.append("path").attr("class",p):t.select("path."+p)).style("display","none").attr("stroke-dasharray","5,5")}(o);var s=o.selectAll("circle."+g).data(i,n.pluck("x"));s.enter().append("circle").attr("class",g).attr("r",l()).style("fill-opacity",b).style("stroke-opacity",_).attr("fill",x.getColor).attr("stroke",x.getColor).on("mousemove",function(){var e=t.select(this);!function(t){t.style("fill-opacity",.8),t.style("stroke-opacity",.8),t.attr("r",m)}(e),function(t,e){var n=t.attr("cx"),r=t.attr("cy"),i="M"+(x._yAxisX()-x.margins().left)+" "+r+"L"+n+" "+r,a="M"+n+" "+x.yAxisHeight()+"L"+n+" "+r;e.select("path."+h).style("display","").attr("d",i),e.select("path."+p).style("display","").attr("d",a)}(e,o)}).on("mouseout",function(){!function(t){t.style("fill-opacity",b).style("stroke-opacity",_).attr("r",l())}(t.select(this)),function(t){t.select("path."+h).style("display","none"),t.select("path."+p).style("display","none")}(o)}),s.call(u,e),n.transition(s,x.transitionDuration()).attr("cx",function(t){return n.utils.safeNumber(x.x()(t.x))}).attr("cy",function(t){return n.utils.safeNumber(x.y()(t.y+t.y0))}).attr("fill",x.getColor),s.exit().remove()})}}function l(){return A||m}function u(t,e){x.renderTitle()&&(t.select("title").remove(),t.append("title").text(n.pluck("data",x.title(e.name))))}function s(e,n,r){return function(){var i=t.select(this),a=i.attr("stroke")===e&&i.attr("stroke-dasharray")===(n instanceof Array?n.join(","):null)||i.attr("fill")===e;return r?!a:a}}var c,d,f="dc-tooltip",g="dot",h="yRef",p="xRef",y=3,x=n.stackMixin(n.coordinateGridMixin({})),v=!1,m=5,A=null,b=1e-6,_=1e-6,D="linear",k=.7,C=!0;return x.transitionDuration(500),x.transitionDelay(0),x._rangeBandPadding(1),x.plotData=function(){var e=x.chartBodyG(),r=e.select("g.stack-list");r.empty()&&(r=e.append("g").attr("class","stack-list"));var l=r.selectAll("g.stack").data(x.data()),u=l.enter().append("g").attr("class",function(t,e){return"stack _"+e});!function(e,r){var o=t.svg.line().x(function(t){return x.x()(t.x)}).y(function(t){return x.y()(t.y+t.y0)}).interpolate(D).tension(k);c&&o.defined(c);var l=e.append("path").attr("class","line").attr("stroke",i);d&&l.attr("stroke-dasharray",d),n.transition(r.select("path.line"),x.transitionDuration(),x.transitionDelay()).attr("stroke",i).attr("d",function(t){return a(o(t.values))})}(u,l),function(e,r){if(v){var o=t.svg.area().x(function(t){return x.x()(t.x)}).y(function(t){return x.y()(t.y+t.y0)}).y0(function(t){return x.y()(t.y0)}).interpolate(D).tension(k);c&&o.defined(c),e.append("path").attr("class","area").attr("fill",i).attr("d",function(t){return a(o(t.values))}),n.transition(r.select("path.area"),x.transitionDuration(),x.transitionDelay()).attr("fill",i).attr("d",function(t){return a(o(t.values))})}}(u,l),o(e,l),x.renderLabel()&&function(e){e.each(function(e,r){var i=t.select(this).selectAll("text.lineLabel").data(e.values,n.pluck("x"));i.enter().append("text").attr("class","lineLabel").attr("text-anchor","middle"),n.transition(i,x.transitionDuration()).attr("x",function(t){return n.utils.safeNumber(x.x()(t.x))}).attr("y",function(t){var e=x.y()(t.y+t.y0)-y;return n.utils.safeNumber(e)}).text(function(t){return x.label()(t)}),n.transition(i.exit(),x.transitionDuration()).attr("height",0).remove()})}(l)},x.interpolate=function(t){return arguments.length?(D=t,x):D},x.tension=function(t){return arguments.length?(k=t,x):k},x.defined=function(t){return arguments.length?(c=t,x):c},x.dashStyle=function(t){return arguments.length?(d=t,x):d},x.renderArea=function(t){return arguments.length?(v=t,x):v},x.label(function(t){return n.utils.printSingleValue(t.y0+t.y)},!1),x.xyTipsOn=function(t){return arguments.length?(C=t,x):C},x.dotRadius=function(t){return arguments.length?(m=t,x):m},x.renderDataPoints=function(t){return arguments.length?(t?(b=t.fillOpacity||.8,_=t.strokeOpacity||0,A=t.radius||2):(b=1e-6,_=1e-6,A=null),x):{fillOpacity:b,strokeOpacity:_,radius:A}},x.legendHighlight=function(t){x.isLegendableHidden(t)||x.g().selectAll("path.line, path.area").classed("highlight",s(t.color,t.dashstyle)).classed("fadeout",s(t.color,t.dashstyle,!0))},x.legendReset=function(){x.g().selectAll("path.line, path.area").classed("highlight",!1).classed("fadeout",!1)},n.override(x,"legendables",function(){var t=x._legendables();return d?t.map(function(t){return t.dashstyle=d,t}):t}),x.anchor(e,r)},n.dataCount=function(e,r){var i=t.format(",d"),a=n.baseMixin({}),o={some:"",all:""};return a.html=function(t){return arguments.length?(t.all&&(o.all=t.all),t.some&&(o.some=t.some),a):o},a.formatNumber=function(t){return arguments.length?(i=t,a):i},a._doRender=function(){var t=a.dimension().size(),e=a.group().value(),n=i(t),r=i(e);return t===e&&""!==o.all?a.root().html(o.all.replace("%total-count",n).replace("%filter-count",r)):""!==o.some?a.root().html(o.some.replace("%total-count",n).replace("%filter-count",r)):(a.selectAll(".total-count").text(n),a.selectAll(".filter-count").text(r)),a},a._doRedraw=function(){return a._doRender()},a.anchor(e,r)},n.dataTable=function(e,r){function i(){var e=!0;if(g.forEach(function(t){e&="function"==typeof t}),!e){var n=d.selectAll("thead").data([0]);n.enter().append("thead"),n.exit().remove();var r=n.selectAll("tr").data([0]);r.enter().append("tr"),r.exit().remove();var i=r.selectAll("th").data(g);i.enter().append("th"),i.exit().remove(),i.attr("class",c).html(function(t){return d._doColumnHeaderFormat(t)})}var l=d.root().selectAll("tbody").data(function(){var e;e=p===t.ascending?d.dimension().bottom(f):d.dimension().top(f);return t.nest().key(d.group()).sortKeys(p).entries(e.sort(function(t,e){return p(h(t),h(e))}).slice(y,a))}(),function(t){return d.keyAccessor()(t)}),u=l.enter().append("tbody");return!0===x&&u.append("tr").attr("class",s).append("td").attr("class",o).attr("colspan",g.length).html(function(t){return d.keyAccessor()(t)}),l.exit().remove(),u}var a,o="dc-table-label",l="dc-table-row",u="dc-table-column",s="dc-table-group",c="dc-table-head",d=n.baseMixin({}),f=25,g=[],h=function(t){return t},p=t.ascending,y=0,x=!0;return d._doRender=function(){return d.selectAll("tbody").remove(),function(t){var e=t.order().selectAll("tr."+l).data(function(t){return t.values}),n=e.enter().append("tr").attr("class",l);g.forEach(function(t,e){n.append("td").attr("class",u+" _"+e).html(function(e){return d._doColumnValueFormat(t,e)})}),e.exit().remove()}(i()),d},d._doColumnValueFormat=function(t,e){return"function"==typeof t?t(e):"string"==typeof t?e[t]:t.format(e)},d._doColumnHeaderFormat=function(t){return"function"==typeof t?d._doColumnHeaderFnToString(t):"string"==typeof t?d._doColumnHeaderCapitalize(t):String(t.label)},d._doColumnHeaderCapitalize=function(t){return t.charAt(0).toUpperCase()+t.slice(1)},d._doColumnHeaderFnToString=function(t){var e=String(t),n=e.indexOf("return ");if(n>=0){var r=e.lastIndexOf(";");if(r>=0){(e=e.substring(n+7,r)).indexOf("numberFormat")>=0&&(e=e.replace("numberFormat",""))}}return e},d._doRedraw=function(){return d._doRender()},d.size=function(t){return arguments.length?(f=t,d):f},d.beginSlice=function(t){return arguments.length?(y=t,d):y},d.endSlice=function(t){return arguments.length?(a=t,d):a},d.columns=function(t){return arguments.length?(g=t,d):g},d.sortBy=function(t){return arguments.length?(h=t,d):h},d.order=function(t){return arguments.length?(p=t,d):p},d.showGroups=function(t){return arguments.length?(x=t,d):x},d.anchor(e,r)},n.dataGrid=function(e,r){function i(){var e=u.root().selectAll("div."+l).data(function(){var e=u.dimension().top(s);return t.nest().key(u.group()).sortKeys(f).entries(e.sort(function(t,e){return f(d(t),d(e))}).slice(g,a))}(),function(t){return u.keyAccessor()(t)}),n=e.enter().append("div").attr("class",l);return h&&n.html(function(t){return h(t)}),e.exit().remove(),n}var a,o="dc-grid-item",l="dc-grid-top",u=n.baseMixin({}),s=999,c=function(t){return"you need to provide an html() handling param:  "+JSON.stringify(t)},d=function(t){return t},f=t.ascending,g=0,h=function(t){return"<div class='dc-grid-group'><h1 class='dc-grid-label'>"+u.keyAccessor()(t)+"</h1></div>"};return u._doRender=function(){return u.selectAll("div."+l).remove(),function(t){var e=t.order().selectAll("div."+o).data(function(t){return t.values});e.enter().append("div").attr("class",o).html(function(t){return c(t)}),e.exit().remove()}(i()),u},u._doRedraw=function(){return u._doRender()},u.beginSlice=function(t){return arguments.length?(g=t,u):g},u.endSlice=function(t){return arguments.length?(a=t,u):a},u.size=function(t){return arguments.length?(s=t,u):s},u.html=function(t){return arguments.length?(c=t,u):c},u.htmlGroup=function(t){return arguments.length?(h=t,u):h},u.sortBy=function(t){return arguments.length?(d=t,u):d},u.order=function(t){return arguments.length?(f=t,u):f},u.anchor(e,r)},n.bubbleChart=function(t,e){var r=n.bubbleMixin(n.coordinateGridMixin({}));r.transitionDuration(750),r.transitionDelay(0);var i=function(t){return"translate("+function(t){var e=r.x()(r.keyAccessor()(t));return isNaN(e)&&(e=0),e}(t)+","+function(t){var e=r.y()(r.valueAccessor()(t));return isNaN(e)&&(e=0),e}(t)+")"};return r.plotData=function(){r.calculateRadiusDomain(),r.r().range([r.MIN_RADIUS,r.xAxisLength()*r.maxBubbleRelativeSize()]);var t=r.data(),e=r.chartBodyG().selectAll("g."+r.BUBBLE_NODE_CLASS).data(t,function(t){return t.key});r.sortBubbleSize()&&e.order(),function(t){var e=t.enter().append("g");e.attr("class",r.BUBBLE_NODE_CLASS).attr("transform",i).append("circle").attr("class",function(t,e){return r.BUBBLE_CLASS+" _"+e}).on("click",r.onClick).attr("fill",r.getColor).attr("r",0),n.transition(t,r.transitionDuration(),r.transitionDelay()).select("circle."+r.BUBBLE_CLASS).attr("r",function(t){return r.bubbleR(t)}).attr("opacity",function(t){return r.bubbleR(t)>0?1:0}),r._doRenderLabel(e),r._doRenderTitles(e)}(e),function(t){n.transition(t,r.transitionDuration(),r.transitionDelay()).attr("transform",i).select("circle."+r.BUBBLE_CLASS).attr("fill",r.getColor).attr("r",function(t){return r.bubbleR(t)}).attr("opacity",function(t){return r.bubbleR(t)>0?1:0}),r.doUpdateLabels(t),r.doUpdateTitles(t)}(e),function(t){t.exit().remove()}(e),r.fadeDeselectedArea()},r.renderBrush=function(){},r.redrawBrush=function(){r.fadeDeselectedArea()},r.anchor(t,e)},n.compositeChart=function(e,r){function i(e,r){var i,a,c,d,g;return e&&(i=t.min(u(o())),a=n.utils.add(t.max(s(o())),f.yAxisPadding())),r&&(c=t.min(u(l())),d=n.utils.add(t.max(s(l())),f.yAxisPadding())),f.alignYAxes()&&e&&r&&(g=function(t,e,n,r){var i=(r-n)/(e-t);return{lyAxisMin:Math.min(t,n/i),lyAxisMax:Math.max(e,r/i),ryAxisMin:Math.min(n,t*i),ryAxisMax:Math.max(r,e*i)}}(i,a,c,d)),g||{lyAxisMin:i,lyAxisMax:a,ryAxisMin:c,ryAxisMax:d}}function a(t,e){t._generateG(f.g()),t.g().attr("class",d+" _"+e)}function o(){return g.filter(function(t){return!t.useRightYAxis()})}function l(){return g.filter(function(t){return t.useRightYAxis()})}function u(t){return t.map(function(t){return t.yAxisMin()})}function s(t){return t.map(function(t){return t.yAxisMax()})}var c,d="sub",f=n.coordinateGridMixin({}),g=[],h={},p=!1,y=!0,x=!1,v=t.svg.axis(),m=0,A=12,b=!1;return f._mandatoryAttributes([]),f.transitionDuration(500),f.transitionDelay(0),n.override(f,"_generateG",function(){for(var t=this.__generateG(),e=0;e<g.length;++e){var n=g[e];a(n,e),n.dimension()||n.dimension(f.dimension()),n.group()||n.group(f.group()),n.chartGroup(f.chartGroup()),n.svg(f.svg()),n.xUnits(f.xUnits()),n.transitionDuration(f.transitionDuration(),f.transitionDelay()),n.brushOn(f.brushOn()),n.renderTitle(f.renderTitle()),n.elasticX(f.elasticX())}return t}),f._brushing=function(){for(var t=f.extendBrush(),e=f.brushIsEmpty(t),n=0;n<g.length;++n)g[n].replaceFilter(e?null:t)},f._prepareYAxis=function(){var e=0!==o().length,n=0!==l().length,r=i(e,n);e&&function(e){var n=void 0===f.y()||f.elasticY(),r=n||f.resizing();void 0===f.y()&&f.y(t.scale.linear()),n&&f.y().domain([e.lyAxisMin,e.lyAxisMax]),r&&f.y().rangeRound([f.yAxisHeight(),0]),f.y().range([f.yAxisHeight(),0]),f.yAxis(f.yAxis().scale(f.y())),f.yAxis().orient("left")}(r),n&&function(e){var n=void 0===f.rightY()||f.elasticY(),r=n||f.resizing();void 0===f.rightY()&&f.rightY(t.scale.linear()),n&&f.rightY().domain([e.ryAxisMin,e.ryAxisMax]),r&&f.rightY().rangeRound([f.yAxisHeight(),0]),f.rightY().range([f.yAxisHeight(),0]),f.rightYAxis(f.rightYAxis().scale(f.rightY())),f.rightYAxis().orient("right")}(r),o().length>0&&!b?f._renderHorizontalGridLinesForAxis(f.g(),f.y(),f.yAxis()):l().length>0&&f._renderHorizontalGridLinesForAxis(f.g(),c,v)},f.renderYAxis=function(){0!==o().length&&(f.renderYAxisAt("y",f.yAxis(),f.margins().left),f.renderYAxisLabel("y",f.yAxisLabel(),-90)),0!==l().length&&(f.renderYAxisAt("yr",f.rightYAxis(),f.width()-f.margins().right),f.renderYAxisLabel("yr",f.rightYAxisLabel(),90,f.width()-A))},f.plotData=function(){for(var t=0;t<g.length;++t){var e=g[t];e.g()||a(e,t),p&&e.colors(f.colors()),e.x(f.x()),e.xAxis(f.xAxis()),e.useRightYAxis()?(e.y(f.rightY()),e.yAxis(f.rightYAxis())):(e.y(f.y()),e.yAxis(f.yAxis())),e.plotData(),e._activateRenderlets()}},f.useRightAxisGridLines=function(t){return arguments?(b=t,f):b},f.childOptions=function(t){return arguments.length?(h=t,g.forEach(function(t){t.options(h)}),f):h},f.fadeDeselectedArea=function(){for(var t=0;t<g.length;++t){var e=g[t];e.brush(f.brush()),e.fadeDeselectedArea()}},f.rightYAxisLabel=function(t,e){return arguments.length?(m=t,f.margins().right-=A,A=void 0===e?12:e,f.margins().right+=A,f):m},f.compose=function(t){return(g=t).forEach(function(t){t.height(f.height()),t.width(f.width()),t.margins(f.margins()),y&&t.title(f.title()),t.options(h)}),f},f.children=function(){return g},f.shareColors=function(t){return arguments.length?(p=t,f):p},f.shareTitle=function(t){return arguments.length?(y=t,f):y},f.rightY=function(t){return arguments.length?(c=t,f.rescale(),f):c},f.alignYAxes=function(t){return arguments.length?(x=t,f.rescale(),f):x},delete f.yAxisMin,delete f.yAxisMax,n.override(f,"xAxisMin",function(){return n.utils.subtract(t.min(g.map(function(t){return t.xAxisMin()})),f.xAxisPadding())}),n.override(f,"xAxisMax",function(){return n.utils.add(t.max(g.map(function(t){return t.xAxisMax()})),f.xAxisPadding())}),f.legendables=function(){return g.reduce(function(t,e){return p&&e.colors(f.colors()),t.push.apply(t,e.legendables()),t},[])},f.legendHighlight=function(t){for(var e=0;e<g.length;++e){g[e].legendHighlight(t)}},f.legendReset=function(t){for(var e=0;e<g.length;++e){g[e].legendReset(t)}},f.legendToggle=function(){console.log("composite should not be getting legendToggle itself")},f.rightYAxis=function(t){return arguments.length?(v=t,f):v},f.anchor(e,r)},n.seriesChart=function(e,r){function i(t){u[t].g()&&u[t].g().remove(),delete u[t]}function a(){Object.keys(u).map(i),u={}}var o,l=n.compositeChart(e,r),u={},s=n.lineChart,c=t.ascending,d=function(e,n){return t.ascending(l.keyAccessor()(e),l.keyAccessor()(n))};return l._mandatoryAttributes().push("seriesAccessor","chart"),l.shareColors(!0),l._preprocessData=function(){var e,n=[],a=t.nest().key(o);c&&a.sortKeys(c),d&&a.sortValues(d);var f=a.entries(l.data()).map(function(i,a){var o=u[i.key]||s.call(l,l,r,i.key,a);return u[i.key]||(e=!0),u[i.key]=o,n.push(i.key),o.dimension(l.dimension()).group({all:t.functor(i.values)},i.key).keyAccessor(l.keyAccessor()).valueAccessor(l.valueAccessor()).brushOn(l.brushOn())});Object.keys(u).filter(function(t){return-1===n.indexOf(t)}).forEach(function(t){i(t),e=!0}),l._compose(f),e&&l.legend()&&l.legend().render()},l.chart=function(t){return arguments.length?(s=t,a(),l):s},l.seriesAccessor=function(t){return arguments.length?(o=t,a(),l):o},l.seriesSort=function(t){return arguments.length?(c=t,a(),l):c},l.valueSort=function(t){return arguments.length?(d=t,a(),l):d},l._compose=l.compose,delete l.compose,l},n.geoChoroplethChart=function(e,r){function i(e){var r=function(){for(var t={},e=s.data(),n=0;n<e.length;++n)t[s.keyAccessor()(e[n])]=s.valueAccessor()(e[n]);return t}();if(function(t){return u(t).keyAccessor}(e)){var i=function(t){return s.svg().selectAll(function(t){return"g.layer"+t+" g."+u(t).name}(t)).classed("selected",function(e){return a(t,e)}).classed("deselected",function(e){return o(t,e)}).attr("class",function(e){var r=u(t).name,i=n.utils.nameToId(u(t).keyAccessor(e)),l=r+" "+i;return a(t,e)&&(l+=" selected"),o(t,e)&&(l+=" deselected"),l})}(e);!function(e,r,i){var a=e.select("path").attr("fill",function(){var e=t.select(this).attr("fill");return e||"none"}).on("click",function(t){return s.onClick(t,r)});n.transition(a,s.transitionDuration(),s.transitionDelay()).attr("fill",function(t,e){return s.getColor(i[u(r).keyAccessor(t)],e)})}(i,e,r),function(t,e,n){s.renderTitle()&&t.selectAll("title").text(function(t){var r=l(e,t),i=n[r];return s.title()({key:r,value:i})})}(i,e,r)}}function a(t,e){return s.hasFilter()&&s.hasFilter(l(t,e))}function o(t,e){return s.hasFilter()&&!s.hasFilter(l(t,e))}function l(t,e){return u(t).keyAccessor(e)}function u(t){return f[t]}var s=n.colorMixin(n.baseMixin({}));s.colorAccessor(function(t){return t||0});var c,d=t.geo.path(),f=[];return s._doRender=function(){s.resetSvg();for(var t=0;t<f.length;++t){var e=s.svg().append("g").attr("class","layer"+t).selectAll("g."+u(t).name).data(u(t).data).enter().append("g").attr("class",u(t).name);e.append("path").attr("fill","white").attr("d",d),e.append("title"),i(t)}c=!1},s.onClick=function(t,e){var r=u(e).keyAccessor(t);n.events.trigger(function(){s.filter(r),s.redrawGroup()})},s._doRedraw=function(){for(var t=0;t<f.length;++t)i(t),c&&s.svg().selectAll("g."+u(t).name+" path").attr("d",d);c=!1},s.overlayGeoJson=function(t,e,n){for(var r=0;r<f.length;++r)if(f[r].name===e)return f[r].data=t,f[r].keyAccessor=n,s;return f.push({name:e,data:t,keyAccessor:n}),s},s.projection=function(t){return d.projection(t),c=!0,s},s.geoJsons=function(){return f},s.geoPath=function(){return d},s.removeGeoJson=function(t){for(var e=[],n=0;n<f.length;++n){var r=f[n];r.name!==t&&e.push(r)}return f=e,s},s.anchor(e,r)},n.bubbleOverlay=function(e,r){function i(){var t={};return c.data().forEach(function(e){t[c.keyAccessor()(e)]=e}),t}function a(t,e){var r=u+" "+n.utils.nameToId(t.name),i=o.select("g."+n.utils.nameToId(t.name));return i.empty()&&(i=o.append("g").attr("class",r).attr("transform","translate("+t.x+","+t.y+")")),i.datum(e[t.name]),i}var o,l="bubble-overlay",u="node",s="bubble",c=n.bubbleMixin(n.baseMixin({})),d=[];return c.transitionDuration(750),c.transitionDelay(0),c.radiusValueAccessor(function(t){return t.value}),c.point=function(t,e,n){return d.push({name:t,x:e,y:n}),c},c._doRender=function(){return(o=c.select("g."+l)).empty()&&(o=c.svg().append("g").attr("class",l)),o=o,c.r().range([c.MIN_RADIUS,c.width()*c.maxBubbleRelativeSize()]),function(){var t=i();c.calculateRadiusDomain(),d.forEach(function(e){var r=a(e,t),i=r.select("circle."+s);i.empty()&&(i=r.append("circle").attr("class",s).attr("r",0).attr("fill",c.getColor).on("click",c.onClick)),n.transition(i,c.transitionDuration(),c.transitionDelay()).attr("r",function(t){return c.bubbleR(t)}),c._doRenderLabel(r),c._doRenderTitles(r)})}(),c.fadeDeselectedArea(),c},c._doRedraw=function(){return function(){var t=i();c.calculateRadiusDomain(),d.forEach(function(e){var r=a(e,t),i=r.select("circle."+s);n.transition(i,c.transitionDuration(),c.transitionDelay()).attr("r",function(t){return c.bubbleR(t)}).attr("fill",c.getColor),c.doUpdateLabels(r),c.doUpdateTitles(r)})}(),c.fadeDeselectedArea(),c},c.debug=function(e){if(e){var r=c.select("g."+n.constants.DEBUG_GROUP_CLASS);r.empty()&&(r=c.svg().append("g").attr("class",n.constants.DEBUG_GROUP_CLASS));var i=r.append("text").attr("x",10).attr("y",20);r.append("rect").attr("width",c.width()).attr("height",c.height()).on("mousemove",function(){var e=t.mouse(r.node()),n=e[0]+", "+e[1];i.text(n)})}else c.selectAll(".debug").remove();return c},c.anchor(e,r),c},n.rowChart=function(e,r){function i(){var e=c.select("g.axis");!function(){if(!d||f){var e=t.extent(g,k.cappedValueAccessor);e[0]>0&&(e[0]=0),e[1]<0&&(e[1]=0),d=t.scale.linear().domain(e).range([0,k.effectiveWidth()])}C.scale(d)}(),e.empty()&&(e=c.append("g").attr("class","axis")),e.attr("transform","translate(0, "+k.effectiveHeight()+")"),n.transition(e,k.transitionDuration(),k.transitionDelay()).call(C)}function a(){g=k.data(),i(),c.selectAll("g.tick").select("line.grid-line").remove(),c.selectAll("g.tick").append("line").attr("class","grid-line").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",function(){return-k.effectiveHeight()});var t=c.selectAll("g."+b).data(g);!function(t){var e=t.enter().append("g").attr("class",function(t,e){return b+" _"+e});e.append("rect").attr("width",0),function(t){k.renderLabel()&&t.append("text").on("click",l);k.renderTitleLabel()&&t.append("text").attr("class",_).on("click",l)}(e)}(t),function(t){t.exit().remove()}(t),function(t){var e,r=g.length;e=A||(k.effectiveHeight()-(r+1)*m)/r;y||(p=e/2);var i=t.attr("transform",function(t,n){return"translate(0,"+((n+1)*m+n*e)+")"}).select("rect").attr("height",e).attr("fill",k.getColor).on("click",l).classed("deselected",function(t){return!!k.hasFilter()&&!s(t)}).classed("selected",function(t){return!!k.hasFilter()&&s(t)});n.transition(i,k.transitionDuration(),k.transitionDelay()).attr("width",function(t){return Math.abs(o()-d(k.valueAccessor()(t)))}).attr("transform",u),function(t){k.renderTitle()&&(t.select("title").remove(),t.append("title").text(k.title()))}(t),function(t){if(k.renderLabel()){var e=t.select("text").attr("x",h).attr("y",p).attr("dy",x).on("click",l).attr("class",function(t,e){return b+" _"+e}).text(function(t){return k.label()(t)});n.transition(e,k.transitionDuration(),k.transitionDelay()).attr("transform",u)}if(k.renderTitleLabel()){var r=t.select("."+_).attr("x",k.effectiveWidth()-v).attr("y",p).attr("dy",x).attr("text-anchor","end").on("click",l).attr("class",function(t,e){return _+" _"+e}).text(function(t){return k.title()(t)});n.transition(r,k.transitionDuration(),k.transitionDelay()).attr("transform",u)}}(t)}(t)}function o(){var t=d(0);return t===-1/0||t!=t?d(1):t}function l(t){k.onClick(t)}function u(t){var e=d(k.cappedValueAccessor(t)),n=o();return"translate("+(e>n?n:e)+",0)"}function s(t){return k.hasFilter(k.cappedKeyAccessor(t))}var c,d,f,g,h=10,p=15,y=!1,x="0.35em",v=2,m=5,A=!1,b="row",_="titlerow",D=!1,k=n.capMixin(n.marginMixin(n.colorMixin(n.baseMixin({})))),C=t.svg.axis().orient("bottom");return k.rowsCap=k.cap,k._doRender=function(){return k.resetSvg(),c=k.svg().append("g").attr("transform","translate("+k.margins().left+","+k.margins().top+")"),a(),k},k.title(function(t){return k.cappedKeyAccessor(t)+": "+k.cappedValueAccessor(t)}),k.label(k.cappedKeyAccessor),k.x=function(t){return arguments.length?(d=t,k):d},k.renderTitleLabel=function(t){return arguments.length?(D=t,k):D},k._doRedraw=function(){return a(),k},k.xAxis=function(){return C},k.fixedBarHeight=function(t){return arguments.length?(A=t,k):A},k.gap=function(t){return arguments.length?(m=t,k):m},k.elasticX=function(t){return arguments.length?(f=t,k):f},k.labelOffsetX=function(t){return arguments.length?(h=t,k):h},k.labelOffsetY=function(t){return arguments.length?(p=t,y=!0,k):p},k.titleLabelOffsetX=function(t){return arguments.length?(v=t,k):v},k.anchor(e,r)},n.legend=function(){function t(){return s+u}var e,r,i,a={},o=0,l=0,u=12,s=5,c=!1,d=560,f=70,g=!1,h=n.pluck("name");return a.parent=function(t){return arguments.length?(e=t,a):e},a.render=function(){e.svg().select("g.dc-legend").remove(),i=e.svg().append("g").attr("class","dc-legend").attr("transform","translate("+o+","+l+")");var a=e.legendables();void 0!==r&&(a=a.slice(0,r));var p=i.selectAll("g.dc-legend-item").data(a).enter().append("g").attr("class","dc-legend-item").on("mouseover",function(t){e.legendHighlight(t)}).on("mouseout",function(t){e.legendReset(t)}).on("click",function(t){t.chart.legendToggle(t)});i.selectAll("g.dc-legend-item").classed("fadeout",function(t){return t.chart.isLegendableHidden(t)}),a.some(n.pluck("dashstyle"))?p.append("line").attr("x1",0).attr("y1",u/2).attr("x2",u).attr("y2",u/2).attr("stroke-width",2).attr("stroke-dasharray",n.pluck("dashstyle")).attr("stroke",n.pluck("color")):p.append("rect").attr("width",u).attr("height",u).attr("fill",function(t){return t?t.color:"blue"}),p.append("text").text(h).attr("x",u+2).attr("y",function(){return u/2+(this.clientHeight?this.clientHeight:13)/2-2});var y=0,x=0;p.attr("transform",function(e,n){if(c){var r=!0===g?this.getBBox().width+s:f;y+r>d&&y>0&&(++x,y=0);var i="translate("+y+","+x*t()+")";return y+=r,i}return"translate(0,"+n*t()+")"})},a.x=function(t){return arguments.length?(o=t,a):o},a.y=function(t){return arguments.length?(l=t,a):l},a.gap=function(t){return arguments.length?(s=t,a):s},a.itemHeight=function(t){return arguments.length?(u=t,a):u},a.horizontal=function(t){return arguments.length?(c=t,a):c},a.legendWidth=function(t){return arguments.length?(d=t,a):d},a.itemWidth=function(t){return arguments.length?(f=t,a):f},a.autoItemWidth=function(t){return arguments.length?(g=t,a):g},a.legendText=function(t){return arguments.length?(h=t,a):h},a.maxItems=function(t){return arguments.length?(r=n.utils.isNumber(t)?t:void 0,a):r},a},n.scatterPlot=function(e,r){function i(t,e){return s(t)?b[e]?Math.pow(g,2):Math.pow(h,2):Math.pow(x,2)}function a(t,e){l.renderTitle()&&(t.selectAll("title").remove(),t.append("title").text(function(t){return l.title()(t)}))}function o(e,r){var i=l.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return e(t.select(this))}),a=u.size();u.size(Math.pow(r,2)),n.transition(i,l.transitionDuration(),l.transitionDelay()).attr("d",u),u.size(a)}var l=n.coordinateGridMixin({}),u=t.svg.symbol(),s=function(t){return t.value},c=l.keyAccessor();l.keyAccessor(function(t){return c(t)[0]}),l.valueAccessor(function(t){return c(t)[1]}),l.colorAccessor(function(){return l._groupName}),l.title(function(t){return l.keyAccessor()(t)+","+l.valueAccessor()(t)+": "+l.existenceAccessor()(t)});var d=function(t){return"translate("+l.x()(l.keyAccessor()(t))+","+l.y()(l.valueAccessor()(t))+")"},f=7,g=5,h=3,p=null,y=1,x=0,v=0,m=1,A=null,b=[];return u.size(i),n.override(l,"_filter",function(t){return arguments.length?l.__filter(n.filters.RangedTwoDimensionalFilter(t)):l.__filter()}),l.plotData=function(){var t=l.chartBodyG().selectAll("path.symbol").data(l.data());t.enter().append("path").attr("class","symbol").attr("opacity",0).attr("fill",l.getColor).attr("transform",d),t.call(a,l.data()),t.each(function(t,e){b[e]=!l.filter()||l.filter().isFiltered([t.key[0],t.key[1]])}),n.transition(t,l.transitionDuration(),l.transitionDelay()).attr("opacity",function(t,e){return s(t)?b[e]?m:l.excludedOpacity():v}).attr("fill",function(t,e){return A&&!s(t)?A:l.excludedColor()&&!b[e]?l.excludedColor():l.getColor(t)}).attr("transform",d).attr("d",u),n.transition(t.exit(),l.transitionDuration(),l.transitionDelay()).attr("opacity",0).remove()},l.existenceAccessor=function(t){return arguments.length?(s=t,this):s},l.symbol=function(t){return arguments.length?(u.type(t),l):u.type()},l.customSymbol=function(t){return arguments.length?((u=t).size(i),l):u},l.symbolSize=function(t){return arguments.length?(g=t,l):g},l.highlightedSize=function(t){return arguments.length?(f=t,l):f},l.excludedSize=function(t){return arguments.length?(h=t,l):h},l.excludedColor=function(t){return arguments.length?(p=t,l):p},l.excludedOpacity=function(t){return arguments.length?(y=t,l):y},l.hiddenSize=l.emptySize=function(t){return arguments.length?(x=t,l):x},l.emptyColor=function(t){return arguments.length?(A=t,l):A},l.emptyOpacity=function(t){return arguments.length?(v=t,l):v},l.nonemptyOpacity=function(t){return arguments.length?(m=t,l):v},l.legendables=function(){return[{chart:l,name:l._groupName,color:l.getColor()}]},l.legendHighlight=function(e){o(function(t){return t.attr("fill")===e.color},f),l.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return t.select(this).attr("fill")!==e.color}).classed("fadeout",!0)},l.legendReset=function(e){o(function(t){return t.attr("fill")===e.color},g),l.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return t.select(this).attr("fill")!==e.color}).classed("fadeout",!1)},l.setHandlePaths=function(){},l.extendBrush=function(){var t=l.brush().extent();return l.round()&&(t[0]=t[0].map(l.round()),t[1]=t[1].map(l.round()),l.g().select(".brush").call(l.brush().extent(t))),t},l.brushIsEmpty=function(t){return l.brush().empty()||!t||t[0][0]>=t[1][0]||t[0][1]>=t[1][1]},l._brushing=function(){var t=l.extendBrush();if(l.redrawBrush(l.g()),l.brushIsEmpty(t))n.events.trigger(function(){l.filter(null),l.redrawGroup()});else{var e=n.filters.RangedTwoDimensionalFilter(t);n.events.trigger(function(){l.filter(null),l.filter(e),l.redrawGroup()},n.constants.EVENT_DELAY)}},l.setBrushY=function(t){t.call(l.brush().y(l.y()))},l.anchor(e,r)},n.numberDisplay=function(e,r){var i,a=t.format(".2s"),o=n.baseMixin({}),l={one:"",some:"",none:""};return o._mandatoryAttributes(["group"]),o.ordering(function(t){return t.value}),o.html=function(t){return arguments.length?(t.none?l.none=t.none:t.one?l.none=t.one:t.some&&(l.none=t.some),t.one?l.one=t.one:t.some&&(l.one=t.some),t.some?l.some=t.some:t.one&&(l.some=t.one),o):l},o.value=function(){return o.data()},o.data(function(t){var e=t.value?t.value():function(t){if(!t.length)return null;var e=o._computeOrderedGroups(t);return e[e.length-1]}(t.all());return o.valueAccessor()(e)}),o.transitionDuration(250),o.transitionDelay(0),o._doRender=function(){var e=o.value(),n=o.selectAll(".number-display");n.empty()&&(n=n.data([0]).enter().append("span").attr("class","number-display")),n.transition().duration(o.transitionDuration()).delay(o.transitionDelay()).ease("quad-out-in").tween("text",function(){var n=isFinite(i)?i:0,r=t.interpolateNumber(n||0,e);return i=e,function(t){var n=null,i=o.formatNumber()(r(t));0===e&&""!==l.none?n=l.none:1===e&&""!==l.one?n=l.one:""!==l.some&&(n=l.some),this.innerHTML=n?n.replace("%number",i):i}})},o._doRedraw=function(){return o._doRender()},o.formatNumber=function(t){return arguments.length?(a=t,o):a},o.anchor(e,r)},n.heatMap=function(e,r){function i(t,e){var r=h.selectAll(".box-group").filter(function(n){return n.key[t]===e}),i=r.filter(function(t){return!h.hasFilter(t.key)});n.events.trigger(function(){var t=(i.empty()?r:i).data().map(function(t){return n.filters.TwoDimensionalFilter(t.key)});h._filter([t]),h.redrawGroup()})}var a,o,l,u=t.ascending,s=t.ascending,c=t.scale.ordinal(),d=t.scale.ordinal(),f=6.75,g=6.75,h=n.colorMixin(n.marginMixin(n.baseMixin({})));h._mandatoryAttributes(["group"]),h.title(h.colorAccessor());var p=function(t){return t},y=function(t){return t};h.colsLabel=function(t){return arguments.length?(p=t,h):p},h.rowsLabel=function(t){return arguments.length?(y=t,h):y};var x=function(t){i(0,t)},v=function(t){i(1,t)},m=function(t){var e=t.key;n.events.trigger(function(){h.filter(e),h.redrawGroup()})};return n.override(h,"filter",function(t){return arguments.length?h._filter(n.filters.TwoDimensionalFilter(t)):h._filter()}),h.rows=function(t){return arguments.length?(l=t,h):l},h.rowOrdering=function(t){return arguments.length?(s=t,h):s},h.cols=function(t){return arguments.length?(o=t,h):o},h.colOrdering=function(t){return arguments.length?(u=t,h):u},h._doRender=function(){return h.resetSvg(),a=h.svg().append("g").attr("class","heatmap").attr("transform","translate("+h.margins().left+","+h.margins().top+")"),h._doRedraw()},h._doRedraw=function(){var t=h.data(),e=h.rows()||t.map(h.valueAccessor()),r=h.cols()||t.map(h.keyAccessor());s&&(e=e.sort(s)),u&&(r=r.sort(u)),e=d.domain(e),r=c.domain(r);var i=e.domain().length,o=r.domain().length,l=Math.floor(h.effectiveWidth()/o),p=Math.floor(h.effectiveHeight()/i);r.rangeRoundBands([0,h.effectiveWidth()]),e.rangeRoundBands([h.effectiveHeight(),0]);var y=a.selectAll("g.box-group").data(h.data(),function(t,e){return h.keyAccessor()(t,e)+"\0"+h.valueAccessor()(t,e)}),x=y.enter().append("g").attr("class","box-group");x.append("rect").attr("class","heat-box").attr("fill","white").on("click",h.boxOnClick()),h.renderTitle()&&(x.append("title"),y.select("title").text(h.title())),n.transition(y.select("rect"),h.transitionDuration(),h.transitionDelay()).attr("x",function(t,e){return r(h.keyAccessor()(t,e))}).attr("y",function(t,n){return e(h.valueAccessor()(t,n))}).attr("rx",f).attr("ry",g).attr("fill",h.getColor).attr("width",l).attr("height",p),y.exit().remove();var v=a.select("g.cols");v.empty()&&(v=a.append("g").attr("class","cols axis"));var m=v.selectAll("text").data(r.domain());m.enter().append("text").attr("x",function(t){return r(t)+l/2}).style("text-anchor","middle").attr("y",h.effectiveHeight()).attr("dy",12).on("click",h.xAxisOnClick()).text(h.colsLabel()),n.transition(m,h.transitionDuration(),h.transitionDelay()).text(h.colsLabel()).attr("x",function(t){return r(t)+l/2}).attr("y",h.effectiveHeight()),m.exit().remove();var A=a.select("g.rows");A.empty()&&(A=a.append("g").attr("class","rows axis"));var b=A.selectAll("text").data(e.domain());return b.enter().append("text").attr("dy",6).style("text-anchor","end").attr("x",0).attr("dx",-2).on("click",h.yAxisOnClick()).text(h.rowsLabel()),n.transition(b,h.transitionDuration(),h.transitionDelay()).text(h.rowsLabel()).attr("y",function(t){return e(t)+p/2}),b.exit().remove(),h.hasFilter()?h.selectAll("g.box-group").each(function(t){h.isSelectedNode(t)?h.highlightSelected(this):h.fadeDeselected(this)}):h.selectAll("g.box-group").each(function(){h.resetHighlight(this)}),h},h.boxOnClick=function(t){return arguments.length?(m=t,h):m},h.xAxisOnClick=function(t){return arguments.length?(x=t,h):x},h.yAxisOnClick=function(t){return arguments.length?(v=t,h):v},h.xBorderRadius=function(t){return arguments.length?(f=t,h):f},h.yBorderRadius=function(t){return arguments.length?(g=t,h):g},h.isSelectedNode=function(t){return h.hasFilter(t.key)},h.anchor(e,r)},function(){function e(t){return[0,t.length-1]}function n(e){return[t.quantile(e,.25),t.quantile(e,.5),t.quantile(e,.75)]}t.box=function(){function r(e){e.each(function(e,n){e=e.map(s).sort(t.ascending);var r,A,b=t.select(this),_=e.length;if(0!==_){var D=e.quartiles=d(e),k=c&&c.call(this,e,n),C=k&&k.map(function(t){return e[t]}),L=k?t.range(0,k[0]).concat(t.range(k[1]+1,_)):t.range(_);v?(r=e[0],A=e[_-1]):(r=e[k[0]],A=e[k[1]]);var M=t.range(k[0],k[1]+1),w=t.scale.linear().domain(u&&u.call(this,e,n)||[r,A]).range([a,0]),R=this.__chart__||t.scale.linear().domain([0,1/0]).range(w.range());this.__chart__=w;var S=b.selectAll("line.center").data(C?[C]:[]);S.enter().insert("line","rect").attr("class","center").attr("x1",i/2).attr("y1",function(t){return R(t[0])}).attr("x2",i/2).attr("y2",function(t){return R(t[1])}).style("opacity",1e-6).transition().duration(o).delay(l).style("opacity",1).attr("y1",function(t){return w(t[0])}).attr("y2",function(t){return w(t[1])}),S.transition().duration(o).delay(l).style("opacity",1).attr("x1",i/2).attr("x2",i/2).attr("y1",function(t){return w(t[0])}).attr("y2",function(t){return w(t[1])}),S.exit().transition().duration(o).delay(l).style("opacity",1e-6).attr("y1",function(t){return w(t[0])}).attr("y2",function(t){return w(t[1])}).remove();var E=b.selectAll("rect.box").data([D]);E.enter().append("rect").attr("class","box").attr("x",0).attr("y",function(t){return R(t[2])}).attr("width",i).attr("height",function(t){return R(t[0])-R(t[2])}).style("fill-opacity",g?.1:1).transition().duration(o).delay(l).attr("y",function(t){return w(t[2])}).attr("height",function(t){return w(t[0])-w(t[2])}),E.transition().duration(o).delay(l).attr("width",i).attr("y",function(t){return w(t[2])}).attr("height",function(t){return w(t[0])-w(t[2])});var O=b.selectAll("line.median").data([D[1]]);O.enter().append("line").attr("class","median").attr("x1",0).attr("y1",R).attr("x2",i).attr("y2",R).transition().duration(o).delay(l).attr("y1",w).attr("y2",w),O.transition().duration(o).delay(l).attr("x1",0).attr("x2",i).attr("y1",w).attr("y2",w);var B=b.selectAll("line.whisker").data(C||[]);if(B.enter().insert("line","circle, text").attr("class","whisker").attr("x1",0).attr("y1",R).attr("x2",i).attr("y2",R).style("opacity",1e-6).transition().duration(o).delay(l).attr("y1",w).attr("y2",w).style("opacity",1),B.transition().duration(o).delay(l).attr("x1",0).attr("x2",i).attr("y1",w).attr("y2",w).style("opacity",1),B.exit().transition().duration(o).delay(l).attr("y1",w).attr("y2",w).style("opacity",1e-6).remove(),v){var T=m?"outlierBold":"outlier",F=m?3:5,N=m?function(){return Math.floor(Math.random()*(i*y)+1+(i-i*y)/2)}:function(){return i/2},G=b.selectAll("circle."+T).data(L,Number);G.enter().insert("circle","text").attr("class",T).attr("r",F).attr("cx",N).attr("cy",function(t){return R(e[t])}).style("opacity",1e-6).transition().duration(o).delay(l).attr("cy",function(t){return w(e[t])}).style("opacity",.6),x&&(G.selectAll("title").remove(),G.append("title").text(function(t){return e[t]})),G.transition().duration(o).delay(l).attr("cx",N).attr("cy",function(t){return w(e[t])}).style("opacity",.6),G.exit().transition().duration(o).delay(l).attr("cy",0).style("opacity",1e-6).remove()}if(g){var H=b.selectAll("circle.data").data(M);H.enter().insert("circle","text").attr("class","data").attr("r",h).attr("cx",function(){return Math.floor(Math.random()*(i*y)+1+(i-i*y)/2)}).attr("cy",function(t){return R(e[t])}).style("opacity",1e-6).transition().duration(o).delay(l).attr("cy",function(t){return w(e[t])}).style("opacity",p),x&&(H.selectAll("title").remove(),H.append("title").text(function(t){return e[t]})),H.transition().duration(o).delay(l).attr("cx",function(){return Math.floor(Math.random()*(i*y)+1+(i-i*y)/2)}).attr("cy",function(t){return w(e[t])}).style("opacity",p),H.exit().transition().duration(o).delay(l).attr("cy",0).style("opacity",1e-6).remove()}var P=f||w.tickFormat(8),Y=b.selectAll("text.box").data(D);Y.enter().append("text").attr("class","box").attr("dy",".3em").attr("dx",function(t,e){return 1&e?6:-6}).attr("x",function(t,e){return 1&e?i:0}).attr("y",R).attr("text-anchor",function(t,e){return 1&e?"start":"end"}).text(P).transition().duration(o).delay(l).attr("y",w),Y.transition().duration(o).delay(l).text(P).attr("x",function(t,e){return 1&e?i:0}).attr("y",w);var U=b.selectAll("text.whisker").data(C||[]);U.enter().append("text").attr("class","whisker").attr("dy",".3em").attr("dx",6).attr("x",i).attr("y",R).text(P).style("opacity",1e-6).transition().duration(o).delay(l).attr("y",w).style("opacity",1),U.transition().duration(o).delay(l).text(P).attr("x",i).attr("y",w).style("opacity",1),U.exit().transition().duration(o).delay(l).attr("y",w).style("opacity",1e-6).remove(),delete e.quartiles}}),t.timer.flush()}var i=1,a=1,o=0,l=0,u=null,s=Number,c=e,d=n,f=null,g=!1,h=3,p=.3,y=.8,x=!1,v=!0,m=!1;return r.width=function(t){return arguments.length?(i=t,r):i},r.height=function(t){return arguments.length?(a=t,r):a},r.tickFormat=function(t){return arguments.length?(f=t,r):f},r.showOutliers=function(t){return arguments.length?(v=t,r):v},r.boldOutlier=function(t){return arguments.length?(m=t,r):m},r.renderDataPoints=function(t){return arguments.length?(g=t,r):g},r.renderTitle=function(t){return arguments.length?(x=t,r):x},r.dataOpacity=function(t){return arguments.length?(p=t,r):p},r.dataWidthPortion=function(t){return arguments.length?(y=t,r):y},r.duration=function(t){return arguments.length?(o=t,r):o},r.domain=function(e){return arguments.length?(u=null===e?e:t.functor(e),r):u},r.value=function(t){return arguments.length?(s=t,r):s},r.whiskers=function(t){return arguments.length?(c=t,r):c},r.quartiles=function(t){return arguments.length?(d=t,r):d},r}}(),n.boxPlot=function(e,r){function i(){return t.min(l.data(),function(e){return t.min(l.valueAccessor()(e))})}function a(){return t.max(l.data(),function(e){return t.max(l.valueAccessor()(e))})}function o(){return(a()-i())/l.effectiveHeight()}var l=n.coordinateGridMixin({}),u=function(t){return function(e){var n=e.quartiles[0],r=e.quartiles[2],i=(r-n)*t,a=-1,o=e.length;do{++a}while(e[a]<n-i);do{--o}while(e[o]>r+i);return[a,o]}}(1.5),s=t.box(),c=null,d=!1,f=.3,g=.8,h=!0,p=!1,y=8,x=function(t,e){return l.isOrdinal()?l.x().rangeBand():t/(1+l.boxPadding())/e};l.x(t.scale.ordinal()),l.xUnits(n.units.ordinal),l.data(function(t){return t.all().map(function(t){return t.map=function(e){return e.call(t,t)},t}).filter(function(t){return 0!==l.valueAccessor()(t).length})}),l.boxPadding=l._rangeBandPadding,l.boxPadding(.8),l.outerPadding=l._outerRangeBandPadding,l.outerPadding(.5),l.boxWidth=function(e){return arguments.length?(x=t.functor(e),l):x};var v=function(t,e){return"translate("+l.x()(l.keyAccessor()(t,e))+", 0)"};return l._preprocessData=function(){l.elasticX()&&l.x().domain([])},l.plotData=function(){var e=x(l.effectiveWidth(),l.xUnitCount());s.whiskers(u).width(e).height(l.effectiveHeight()).value(l.valueAccessor()).domain(l.y().domain()).duration(l.transitionDuration()).tickFormat(c).renderDataPoints(d).dataOpacity(f).dataWidthPortion(g).renderTitle(l.renderTitle()).showOutliers(h).boldOutlier(p);var r=l.chartBodyG().selectAll("g.box").data(l.data(),l.keyAccessor());!function(t){t.enter().append("g").attr("class","box").attr("transform",v).call(s).on("click",function(t){l.filter(l.keyAccessor()(t)),l.redrawGroup()})}(r),function(e){n.transition(e,l.transitionDuration(),l.transitionDelay()).attr("transform",v).call(s).each(function(e){var n=l.getColor(e,0);t.select(this).select("rect.box").attr("fill",n),t.select(this).selectAll("circle.data").attr("fill",n)})}(r),function(t){t.exit().remove().call(s)}(r),l.fadeDeselectedArea()},l.fadeDeselectedArea=function(t){if(l.hasFilter())if(l.isOrdinal())l.g().selectAll("g.box").each(function(t){l.isSelectedNode(t)?l.highlightSelected(this):l.fadeDeselected(this)});else{if(!l.brushOn()&&!l.parentBrushOn())return;var e=t[0],n=t[1],r=l.keyAccessor();l.g().selectAll("g.box").each(function(t){var i=r(t);i<e||i>=n?l.fadeDeselected(this):l.highlightSelected(this)})}else l.g().selectAll("g.box").each(function(){l.resetHighlight(this)})},l.isSelectedNode=function(t){return l.hasFilter(l.keyAccessor()(t))},l.yAxisMin=function(){var t=y*o();return n.utils.subtract(i()-t,l.yAxisPadding())},l.yAxisMax=function(){var t=y*o();return n.utils.add(a()+t,l.yAxisPadding())},l.tickFormat=function(t){return arguments.length?(c=t,l):c},l.yRangePadding=function(t){return arguments.length?(y=t,l):y},l.renderDataPoints=function(t){return arguments.length?(d=t,l):d},l.dataOpacity=function(t){return arguments.length?(f=t,l):f},l.dataWidthPortion=function(t){return arguments.length?(g=t,l):g},l.showOutliers=function(t){return arguments.length?(h=t,l):h},l.boldOutlier=function(t){return arguments.length?(p=t,l):p},l.anchor(e,r)},n.selectMenu=function(e,r){function i(e,n){var r,i=t.event.target;if(i.selectedOptions){r=Array.prototype.slice.call(i.selectedOptions).map(function(t){return t.value})}else{r=[].slice.call(t.event.target.options).filter(function(t){return t.selected}).map(function(t){return t.value})}1===r.length&&""===r[0]?r=c||null:s||1!==r.length||(r=r[0]),l.onChange(r)}var a,o="dc-select-option",l=n.baseMixin({}),u="Select all",s=!1,c=null,d=null,f=function(t,e){return l.keyAccessor()(t)>l.keyAccessor()(e)?1:l.keyAccessor()(e)>l.keyAccessor()(t)?-1:0},g=function(t){return l.valueAccessor()(t)>0};l.data(function(t){return t.all().filter(g)}),l._doRender=function(){return l.select("select").remove(),(a=l.root().append("select").classed("dc-select-menu",!0)).append("option").text(u).attr("value",""),l._doRedraw(),l};var h=window.navigator.userAgent;return h.indexOf("Trident/")>0&&-1===h.indexOf("MSIE")&&(l.redraw=l.render),l._doRedraw=function(){return s?a.attr("multiple",!0):a.attr("multiple",null),null!==d?a.attr("size",d):a.attr("size",null),function(){var t=a.selectAll("option."+o).data(l.data(),function(t){return l.keyAccessor()(t)});t.enter().append("option").classed(o,!0).attr("value",function(t){return l.keyAccessor()(t)}),t.text(l.title()),t.exit().remove(),a.selectAll("option."+o).sort(f),a.on("change",i)}(),l.hasFilter()&&s?a.selectAll("option").property("selected",function(t){return void 0!==t&&l.filters().indexOf(String(l.keyAccessor()(t)))>=0}):l.hasFilter()?a.property("value",l.filter()):a.property("value",""),l},l.onChange=function(t){t&&s?l.replaceFilter([t]):t?l.replaceFilter(t):l.filterAll(),n.events.trigger(function(){l.redrawGroup()})},l.order=function(t){return arguments.length?(f=t,l):f},l.promptText=function(t){return arguments.length?(u=t,l):u},l.filterDisplayed=function(t){return arguments.length?(g=t,l):g},l.multiple=function(t){return arguments.length?(s=t,l):s},l.promptValue=function(t){return arguments.length?(c=t,l):c},l.numberVisible=function(t){return arguments.length?(d=t,l):d},l.size=n.logger.deprecate(l.numberVisible,"selectMenu.size is ambiguous - use numberVisible instead"),l.anchor(e,r)},n.abstractBubbleChart=n.bubbleMixin,n.baseChart=n.baseMixin,n.capped=n.capMixin,n.colorChart=n.colorMixin,n.coordinateGridChart=n.coordinateGridMixin,n.marginable=n.marginMixin,n.stackableChart=n.stackMixin,n.d3=t,n.crossfilter=e,n}if("function"==typeof define&&define.amd)define(["d3","crossfilter2"],t);else if("object"==typeof module&&module.exports){var e=require("d3"),n=require("crossfilter2");"function"!=typeof n&&(n=n.crossfilter),module.exports=t(e,n)}else this.dc=t(d3,crossfilter)}();
//# sourceMappingURL=dc.min.js.map