import * as React from 'react';
import * as PropTypes from 'prop-types';
declare type EventType = React.MouseEvent<HTMLDivElement> | React.MouseEvent<HTMLButtonElement>;
declare type getContainerfunc = () => HTMLElement;
declare type placementType = 'top' | 'right' | 'bottom' | 'left';
export interface DrawerProps {
    closable?: boolean;
    destroyOnClose?: boolean;
    getContainer?: string | HTMLElement | getContainerfunc;
    maskClosable?: boolean;
    mask?: boolean;
    maskStyle?: React.CSSProperties;
    style?: React.CSSProperties;
    title?: React.ReactNode;
    visible?: boolean;
    width?: number | string;
    height?: number | string;
    wrapClassName?: string;
    zIndex?: number;
    prefixCls?: string;
    push?: boolean;
    placement?: placementType;
    onClose?: (e: EventType) => void;
    className?: string;
}
export interface IDrawerState {
    push?: boolean;
}
export default class Drawer extends React.Component<DrawerProps, IDrawerState> {
    static propTypes: {
        closable: PropTypes.Requireable<boolean>;
        destroyOnClose: PropTypes.Requireable<boolean>;
        getContainer: PropTypes.Requireable<string | boolean | object>;
        maskClosable: PropTypes.Requireable<boolean>;
        mask: PropTypes.Requireable<boolean>;
        maskStyle: PropTypes.Requireable<object>;
        style: PropTypes.Requireable<object>;
        title: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        visible: PropTypes.Requireable<boolean>;
        width: PropTypes.Requireable<string | number>;
        zIndex: PropTypes.Requireable<number>;
        prefixCls: PropTypes.Requireable<string>;
        placement: PropTypes.Requireable<string>;
        onClose: PropTypes.Requireable<(...args: any[]) => any>;
        className: PropTypes.Requireable<string>;
    };
    static defaultProps: {
        prefixCls: string;
        width: number;
        height: number;
        closable: boolean;
        placement: string;
        maskClosable: boolean;
        mask: boolean;
        level: null;
    };
    readonly state: {
        push: boolean;
    };
    parentDrawer: Drawer;
    destoryClose: boolean;
    componentDidUpdate(preProps: DrawerProps): void;
    close: (e: EventType) => void;
    onMaskClick: (e: EventType) => void;
    push: () => void;
    pull: () => void;
    onDestoryTransitionEnd: () => void;
    getDestoryOnClose: () => boolean | undefined;
    getPushTransform: (placement?: "bottom" | "left" | "right" | "top" | undefined) => string | undefined;
    renderBody: () => JSX.Element | null;
    getRcDrawerStyle: () => {
        zIndex: number | undefined;
        alignContent?: string | undefined;
        alignItems?: string | undefined;
        alignSelf?: string | undefined;
        animationDelay?: string | undefined;
        animationDirection?: string | undefined;
        animationDuration?: string | undefined;
        animationFillMode?: string | undefined;
        animationIterationCount?: string | number | undefined;
        animationName?: string | undefined;
        animationPlayState?: string | undefined;
        animationTimingFunction?: string | undefined;
        appearance?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        backdropFilter?: string | undefined;
        backfaceVisibility?: "inherit" | "hidden" | "visible" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        backgroundAttachment?: string | undefined;
        backgroundBlendMode?: string | undefined;
        backgroundClip?: string | undefined;
        backgroundColor?: string | undefined;
        backgroundImage?: string | undefined;
        backgroundOrigin?: string | undefined;
        backgroundPosition?: string | number | undefined;
        backgroundPositionX?: string | number | undefined;
        backgroundPositionY?: string | number | undefined;
        backgroundRepeat?: string | undefined;
        backgroundSize?: string | number | undefined;
        blockOverflow?: string | undefined;
        blockSize?: string | number | undefined;
        borderBlockEndColor?: string | undefined;
        borderBlockEndStyle?: string | undefined;
        borderBlockEndWidth?: string | number | undefined;
        borderBlockStartColor?: string | undefined;
        borderBlockStartStyle?: string | undefined;
        borderBlockStartWidth?: string | number | undefined;
        borderBottomColor?: string | undefined;
        borderBottomLeftRadius?: string | number | undefined;
        borderBottomRightRadius?: string | number | undefined;
        borderBottomStyle?: "none" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderBottomWidth?: string | number | undefined;
        borderCollapse?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "collapse" | "separate" | undefined;
        borderImageOutset?: string | number | undefined;
        borderImageRepeat?: string | undefined;
        borderImageSlice?: string | number | undefined;
        borderImageSource?: string | undefined;
        borderImageWidth?: string | number | undefined;
        borderInlineEndColor?: string | undefined;
        borderInlineEndStyle?: string | undefined;
        borderInlineEndWidth?: string | number | undefined;
        borderInlineStartColor?: string | undefined;
        borderInlineStartStyle?: string | undefined;
        borderInlineStartWidth?: string | number | undefined;
        borderLeftColor?: string | undefined;
        borderLeftStyle?: "none" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderLeftWidth?: string | number | undefined;
        borderRightColor?: string | undefined;
        borderRightStyle?: "none" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderRightWidth?: string | number | undefined;
        borderSpacing?: string | number | undefined;
        borderTopColor?: string | undefined;
        borderTopLeftRadius?: string | number | undefined;
        borderTopRightRadius?: string | number | undefined;
        borderTopStyle?: "none" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderTopWidth?: string | number | undefined;
        bottom?: string | number | undefined;
        boxDecorationBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        boxShadow?: string | undefined;
        boxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        breakAfter?: "left" | "right" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | "column" | "page" | "recto" | "region" | "verso" | undefined;
        breakBefore?: "left" | "right" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | "column" | "page" | "recto" | "region" | "verso" | undefined;
        breakInside?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | undefined;
        captionSide?: "bottom" | "top" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "block-end" | "block-start" | "inline-end" | "inline-start" | undefined;
        caretColor?: string | undefined;
        clear?: "left" | "right" | "none" | "both" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inline-end" | "inline-start" | undefined;
        clipPath?: string | undefined;
        color?: string | undefined;
        colorAdjust?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "economy" | "exact" | undefined;
        columnCount?: number | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        columnFill?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "balance" | "balance-all" | undefined;
        columnGap?: string | number | undefined;
        columnRuleColor?: string | undefined;
        columnRuleStyle?: string | undefined;
        columnRuleWidth?: string | number | undefined;
        columnSpan?: "all" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        columnWidth?: string | number | undefined;
        contain?: string | undefined;
        content?: string | undefined;
        counterIncrement?: string | undefined;
        counterReset?: string | undefined;
        cursor?: string | undefined;
        direction?: "ltr" | "rtl" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        display?: string | undefined;
        emptyCells?: "inherit" | "show" | "-moz-initial" | "initial" | "revert" | "unset" | "hide" | undefined;
        filter?: string | undefined;
        flexBasis?: string | number | undefined;
        flexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        flexGrow?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        flexShrink?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        flexWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "nowrap" | "wrap" | "wrap-reverse" | undefined;
        float?: "left" | "right" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inline-end" | "inline-start" | undefined;
        fontFamily?: string | undefined;
        fontFeatureSettings?: string | undefined;
        fontKerning?: "normal" | "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fontLanguageOverride?: string | undefined;
        fontOpticalSizing?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fontSize?: string | number | undefined;
        fontSizeAdjust?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fontStretch?: string | undefined;
        fontStyle?: string | undefined;
        fontSynthesis?: string | undefined;
        fontVariant?: string | undefined;
        fontVariantCaps?: "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "all-petite-caps" | "all-small-caps" | "petite-caps" | "small-caps" | "titling-caps" | "unicase" | undefined;
        fontVariantEastAsian?: string | undefined;
        fontVariantLigatures?: string | undefined;
        fontVariantNumeric?: string | undefined;
        fontVariantPosition?: "normal" | "inherit" | "sub" | "-moz-initial" | "initial" | "revert" | "unset" | "super" | undefined;
        fontVariationSettings?: string | undefined;
        fontWeight?: number | "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "bold" | "bolder" | "lighter" | undefined;
        gridAutoColumns?: string | number | undefined;
        gridAutoFlow?: string | undefined;
        gridAutoRows?: string | number | undefined;
        gridColumnEnd?: string | number | undefined;
        gridColumnStart?: string | number | undefined;
        gridRowEnd?: string | number | undefined;
        gridRowStart?: string | number | undefined;
        gridTemplateAreas?: string | undefined;
        gridTemplateColumns?: string | number | undefined;
        gridTemplateRows?: string | number | undefined;
        hangingPunctuation?: string | undefined;
        height?: string | number | undefined;
        hyphens?: "none" | "auto" | "manual" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        imageOrientation?: string | undefined;
        imageRendering?: "auto" | "inherit" | "pixelated" | "-moz-initial" | "initial" | "revert" | "unset" | "-moz-crisp-edges" | "-o-crisp-edges" | "-webkit-optimize-contrast" | "crisp-edges" | undefined;
        imageResolution?: string | undefined;
        initialLetter?: string | number | undefined;
        inlineSize?: string | number | undefined;
        insetBlockEnd?: string | number | undefined;
        insetBlockStart?: string | number | undefined;
        insetInlineEnd?: string | number | undefined;
        insetInlineStart?: string | number | undefined;
        isolation?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "isolate" | undefined;
        justifyContent?: string | undefined;
        justifyItems?: string | undefined;
        justifySelf?: string | undefined;
        left?: string | number | undefined;
        letterSpacing?: string | number | undefined;
        lineBreak?: "normal" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "strict" | "loose" | undefined;
        lineHeight?: string | number | undefined;
        lineHeightStep?: string | number | undefined;
        listStyleImage?: string | undefined;
        listStylePosition?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inside" | "outside" | undefined;
        listStyleType?: string | undefined;
        marginBlockEnd?: string | number | undefined;
        marginBlockStart?: string | number | undefined;
        marginBottom?: string | number | undefined;
        marginInlineEnd?: string | number | undefined;
        marginInlineStart?: string | number | undefined;
        marginLeft?: string | number | undefined;
        marginRight?: string | number | undefined;
        marginTop?: string | number | undefined;
        maskBorderMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "alpha" | "luminance" | undefined;
        maskBorderOutset?: string | number | undefined;
        maskBorderRepeat?: string | undefined;
        maskBorderSlice?: string | number | undefined;
        maskBorderSource?: string | undefined;
        maskBorderWidth?: string | number | undefined;
        maskClip?: string | undefined;
        maskComposite?: string | undefined;
        maskImage?: string | undefined;
        maskMode?: string | undefined;
        maskOrigin?: string | undefined;
        maskPosition?: string | number | undefined;
        maskRepeat?: string | undefined;
        maskSize?: string | number | undefined;
        maskType?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "alpha" | "luminance" | undefined;
        maxBlockSize?: string | number | undefined;
        maxHeight?: string | number | undefined;
        maxInlineSize?: string | number | undefined;
        maxLines?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        maxWidth?: string | number | undefined;
        minBlockSize?: string | number | undefined;
        minHeight?: string | number | undefined;
        minInlineSize?: string | number | undefined;
        minWidth?: string | number | undefined;
        mixBlendMode?: "color" | "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "color-burn" | "color-dodge" | "darken" | "difference" | "exclusion" | "hard-light" | "hue" | "lighten" | "luminosity" | "multiply" | "overlay" | "saturation" | "screen" | "soft-light" | undefined;
        motionDistance?: string | number | undefined;
        motionPath?: string | undefined;
        motionRotation?: string | undefined;
        objectFit?: "fill" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "cover" | "scale-down" | undefined;
        objectPosition?: string | number | undefined;
        offsetAnchor?: string | number | undefined;
        offsetDistance?: string | number | undefined;
        offsetPath?: string | undefined;
        offsetPosition?: string | number | undefined;
        offsetRotate?: string | undefined;
        offsetRotation?: string | undefined;
        opacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        order?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        orphans?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        outlineColor?: string | undefined;
        outlineOffset?: string | number | undefined;
        outlineStyle?: "none" | "auto" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        outlineWidth?: string | number | undefined;
        overflow?: string | undefined;
        overflowAnchor?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        overflowBlock?: string | undefined;
        overflowClipBox?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "content-box" | "padding-box" | undefined;
        overflowInline?: string | undefined;
        overflowWrap?: "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "break-word" | undefined;
        overflowX?: "clip" | "auto" | "inherit" | "hidden" | "visible" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        overflowY?: "clip" | "auto" | "inherit" | "hidden" | "visible" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        overscrollBehavior?: string | undefined;
        overscrollBehaviorX?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | undefined;
        overscrollBehaviorY?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | undefined;
        paddingBlockEnd?: string | number | undefined;
        paddingBlockStart?: string | number | undefined;
        paddingBottom?: string | number | undefined;
        paddingInlineEnd?: string | number | undefined;
        paddingInlineStart?: string | number | undefined;
        paddingLeft?: string | number | undefined;
        paddingRight?: string | number | undefined;
        paddingTop?: string | number | undefined;
        pageBreakAfter?: "left" | "right" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | "recto" | "verso" | "always" | undefined;
        pageBreakBefore?: "left" | "right" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | "recto" | "verso" | "always" | undefined;
        pageBreakInside?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "avoid" | undefined;
        paintOrder?: string | undefined;
        perspective?: string | number | undefined;
        perspectiveOrigin?: string | number | undefined;
        placeContent?: string | undefined;
        pointerEvents?: "all" | "fill" | "stroke" | "none" | "auto" | "inherit" | "visible" | "-moz-initial" | "initial" | "revert" | "unset" | "painted" | "visibleFill" | "visiblePainted" | "visibleStroke" | undefined;
        position?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "fixed" | "-webkit-sticky" | "absolute" | "relative" | "static" | "sticky" | undefined;
        quotes?: string | undefined;
        resize?: "none" | "both" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "block" | "inline" | "horizontal" | "vertical" | undefined;
        right?: string | number | undefined;
        rotate?: string | undefined;
        rowGap?: string | number | undefined;
        rubyAlign?: "start" | "center" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "space-around" | "space-between" | undefined;
        rubyMerge?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "collapse" | "separate" | undefined;
        rubyPosition?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inter-character" | "over" | "under" | undefined;
        scale?: string | number | undefined;
        scrollBehavior?: "auto" | "smooth" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        scrollSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        shapeImageThreshold?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        shapeMargin?: string | number | undefined;
        shapeOutside?: string | undefined;
        tabSize?: string | number | undefined;
        tableLayout?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "fixed" | undefined;
        textAlign?: "left" | "right" | "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | "match-parent" | undefined;
        textAlignLast?: "left" | "right" | "auto" | "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        textCombineUpright?: string | undefined;
        textDecorationColor?: string | undefined;
        textDecorationLine?: string | undefined;
        textDecorationSkip?: string | undefined;
        textDecorationSkipInk?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        textDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        textEmphasisColor?: string | undefined;
        textEmphasisPosition?: string | undefined;
        textEmphasisStyle?: string | undefined;
        textIndent?: string | number | undefined;
        textJustify?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inter-character" | "inter-word" | undefined;
        textOrientation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mixed" | "sideways" | "upright" | undefined;
        textOverflow?: string | undefined;
        textRendering?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "geometricPrecision" | "optimizeLegibility" | "optimizeSpeed" | undefined;
        textShadow?: string | undefined;
        textSizeAdjust?: string | undefined;
        textTransform?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "full-width" | "capitalize" | "lowercase" | "uppercase" | undefined;
        textUnderlinePosition?: string | undefined;
        top?: string | number | undefined;
        touchAction?: string | undefined;
        transform?: string | undefined;
        transformBox?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "fill-box" | "view-box" | undefined;
        transformOrigin?: string | number | undefined;
        transformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        transitionDelay?: string | undefined;
        transitionDuration?: string | undefined;
        transitionProperty?: string | undefined;
        transitionTimingFunction?: string | undefined;
        translate?: string | number | undefined;
        unicodeBidi?: "normal" | "inherit" | "embed" | "-moz-initial" | "initial" | "revert" | "unset" | "isolate" | "-moz-isolate" | "-moz-isolate-override" | "-moz-plaintext" | "-webkit-isolate" | "bidi-override" | "isolate-override" | "plaintext" | undefined;
        userSelect?: "all" | "none" | "auto" | "inherit" | "text" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "-moz-none" | "element" | undefined;
        verticalAlign?: string | number | undefined;
        visibility?: "inherit" | "hidden" | "visible" | "-moz-initial" | "initial" | "revert" | "unset" | "collapse" | undefined;
        whiteSpace?: "normal" | "inherit" | "pre" | "-moz-initial" | "initial" | "revert" | "unset" | "nowrap" | "-moz-pre-wrap" | "pre-line" | "pre-wrap" | undefined;
        widows?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        width?: string | number | undefined;
        willChange?: string | undefined;
        wordBreak?: "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "break-word" | "break-all" | "keep-all" | undefined;
        wordSpacing?: string | number | undefined;
        wordWrap?: "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "break-word" | undefined;
        writingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        zoom?: string | number | undefined;
        all?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        animation?: string | number | undefined;
        background?: string | number | undefined;
        border?: string | number | undefined;
        borderBlockEnd?: string | number | undefined;
        borderBlockStart?: string | number | undefined;
        borderBottom?: string | number | undefined;
        borderColor?: string | undefined;
        borderImage?: string | number | undefined;
        borderInlineEnd?: string | number | undefined;
        borderInlineStart?: string | number | undefined;
        borderLeft?: string | number | undefined;
        borderRadius?: string | number | undefined;
        borderRight?: string | number | undefined;
        borderStyle?: string | undefined;
        borderTop?: string | number | undefined;
        borderWidth?: string | number | undefined;
        columnRule?: string | number | undefined;
        columns?: string | number | undefined;
        flex?: string | number | undefined;
        flexFlow?: string | undefined;
        font?: string | undefined;
        gap?: string | number | undefined;
        grid?: string | undefined;
        gridArea?: string | number | undefined;
        gridColumn?: string | number | undefined;
        gridRow?: string | number | undefined;
        gridTemplate?: string | undefined;
        lineClamp?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        listStyle?: string | undefined;
        margin?: string | number | undefined;
        mask?: string | number | undefined;
        maskBorder?: string | number | undefined;
        motion?: string | number | undefined;
        offset?: string | number | undefined;
        outline?: string | number | undefined;
        padding?: string | number | undefined;
        placeItems?: string | undefined;
        textDecoration?: string | undefined;
        textEmphasis?: string | undefined;
        transition?: string | undefined;
        MozAnimationDelay?: string | undefined;
        MozAnimationDirection?: string | undefined;
        MozAnimationDuration?: string | undefined;
        MozAnimationFillMode?: string | undefined;
        MozAnimationIterationCount?: string | number | undefined;
        MozAnimationName?: string | undefined;
        MozAnimationPlayState?: string | undefined;
        MozAnimationTimingFunction?: string | undefined;
        MozAppearance?: "none" | "inherit" | "button" | "-moz-initial" | "initial" | "revert" | "unset" | "-moz-mac-unified-toolbar" | "-moz-win-borderless-glass" | "-moz-win-browsertabbar-toolbox" | "-moz-win-communications-toolbox" | "-moz-win-communicationstext" | "-moz-win-exclude-glass" | "-moz-win-glass" | "-moz-win-media-toolbox" | "-moz-win-mediatext" | "-moz-window-button-box" | "-moz-window-button-box-maximized" | "-moz-window-button-close" | "-moz-window-button-maximize" | "-moz-window-button-minimize" | "-moz-window-button-restore" | "-moz-window-frame-bottom" | "-moz-window-frame-left" | "-moz-window-frame-right" | "-moz-window-titlebar" | "-moz-window-titlebar-maximized" | "button-arrow-down" | "button-arrow-next" | "button-arrow-previous" | "button-arrow-up" | "button-bevel" | "button-focus" | "caret" | "checkbox" | "checkbox-container" | "checkbox-label" | "checkmenuitem" | "dualbutton" | "groupbox" | "listbox" | "listitem" | "menuarrow" | "menubar" | "menucheckbox" | "menuimage" | "menuitem" | "menuitemtext" | "menulist" | "menulist-button" | "menulist-text" | "menulist-textfield" | "menupopup" | "menuradio" | "menuseparator" | "meterbar" | "meterchunk" | "progressbar" | "progressbar-vertical" | "progresschunk" | "progresschunk-vertical" | "radio" | "radio-container" | "radio-label" | "radiomenuitem" | "range" | "range-thumb" | "resizer" | "resizerpanel" | "scale-horizontal" | "scale-vertical" | "scalethumb-horizontal" | "scalethumb-vertical" | "scalethumbend" | "scalethumbstart" | "scalethumbtick" | "scrollbarbutton-down" | "scrollbarbutton-left" | "scrollbarbutton-right" | "scrollbarbutton-up" | "scrollbarthumb-horizontal" | "scrollbarthumb-vertical" | "scrollbartrack-horizontal" | "scrollbartrack-vertical" | "searchfield" | "separator" | "sheet" | "spinner" | "spinner-downbutton" | "spinner-textfield" | "spinner-upbutton" | "splitter" | "statusbar" | "statusbarpanel" | "tab" | "tab-scroll-arrow-back" | "tab-scroll-arrow-forward" | "tabpanel" | "tabpanels" | "textfield" | "textfield-multiline" | "toolbar" | "toolbarbutton" | "toolbarbutton-dropdown" | "toolbargripper" | "toolbox" | "tooltip" | "treeheader" | "treeheadercell" | "treeheadersortarrow" | "treeitem" | "treeline" | "treetwisty" | "treetwistyopen" | "treeview" | undefined;
        MozBackfaceVisibility?: "inherit" | "hidden" | "visible" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBinding?: string | undefined;
        MozBorderBottomColors?: string | undefined;
        MozBorderEndColor?: string | undefined;
        MozBorderEndStyle?: string | undefined;
        MozBorderEndWidth?: string | number | undefined;
        MozBorderLeftColors?: string | undefined;
        MozBorderRightColors?: string | undefined;
        MozBorderStartColor?: string | undefined;
        MozBorderStartStyle?: string | undefined;
        MozBorderTopColors?: string | undefined;
        MozBoxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        MozColumnCount?: number | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozColumnFill?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "balance" | "balance-all" | undefined;
        MozColumnGap?: string | number | undefined;
        MozColumnRuleColor?: string | undefined;
        MozColumnRuleStyle?: string | undefined;
        MozColumnRuleWidth?: string | number | undefined;
        MozColumnWidth?: string | number | undefined;
        MozContextProperties?: string | undefined;
        MozFloatEdge?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | "padding-box" | "margin-box" | undefined;
        MozFontFeatureSettings?: string | undefined;
        MozFontLanguageOverride?: string | undefined;
        MozForceBrokenImageIcon?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozHyphens?: "none" | "auto" | "manual" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozImageRegion?: string | undefined;
        MozMarginEnd?: string | number | undefined;
        MozMarginStart?: string | number | undefined;
        MozOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "block" | "inline" | "horizontal" | "vertical" | undefined;
        MozOutlineRadiusBottomleft?: string | number | undefined;
        MozOutlineRadiusBottomright?: string | number | undefined;
        MozOutlineRadiusTopleft?: string | number | undefined;
        MozOutlineRadiusTopright?: string | number | undefined;
        MozPaddingEnd?: string | number | undefined;
        MozPaddingStart?: string | number | undefined;
        MozPerspective?: string | number | undefined;
        MozPerspectiveOrigin?: string | number | undefined;
        MozStackSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ignore" | "stretch-to-fit" | undefined;
        MozTabSize?: string | number | undefined;
        MozTextBlink?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "blink" | undefined;
        MozTextSizeAdjust?: string | undefined;
        MozTransformOrigin?: string | number | undefined;
        MozTransformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        MozTransitionDelay?: string | undefined;
        MozTransitionDuration?: string | undefined;
        MozTransitionProperty?: string | undefined;
        MozTransitionTimingFunction?: string | undefined;
        MozUserFocus?: "normal" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ignore" | "select-after" | "select-all" | "select-before" | "select-menu" | "select-same" | undefined;
        MozUserInput?: "none" | "auto" | "disabled" | "enabled" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozUserModify?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "read-only" | "read-write" | "write-only" | undefined;
        MozUserSelect?: "all" | "none" | "auto" | "inherit" | "text" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "-moz-none" | "element" | undefined;
        MozWindowDragging?: "inherit" | "drag" | "-moz-initial" | "initial" | "revert" | "unset" | "no-drag" | undefined;
        MozWindowShadow?: "none" | "default" | "inherit" | "menu" | "-moz-initial" | "initial" | "revert" | "unset" | "sheet" | "tooltip" | undefined;
        msAccelerator?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "false" | "true" | undefined;
        msAlignSelf?: string | undefined;
        msBlockProgression?: "inherit" | "rl" | "lr" | "-moz-initial" | "initial" | "revert" | "unset" | "bt" | "tb" | undefined;
        msContentZoomChaining?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "chained" | undefined;
        msContentZoomLimitMax?: string | undefined;
        msContentZoomLimitMin?: string | undefined;
        msContentZoomSnapPoints?: string | undefined;
        msContentZoomSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        msContentZooming?: "zoom" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msFilter?: string | undefined;
        msFlexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        msFlexPositive?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msFlowFrom?: string | undefined;
        msFlowInto?: string | undefined;
        msGridColumns?: string | number | undefined;
        msGridRows?: string | number | undefined;
        msHighContrastAdjust?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msHyphenateLimitChars?: string | number | undefined;
        msHyphenateLimitLines?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-limit" | undefined;
        msHyphenateLimitZone?: string | number | undefined;
        msHyphens?: "none" | "auto" | "manual" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msImeAlign?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "after" | undefined;
        msLineBreak?: "normal" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "strict" | "loose" | undefined;
        msOrder?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msOverflowStyle?: "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "-ms-autohiding-scrollbar" | "scrollbar" | undefined;
        msOverflowX?: "clip" | "auto" | "inherit" | "hidden" | "visible" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msOverflowY?: "clip" | "auto" | "inherit" | "hidden" | "visible" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msScrollChaining?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "chained" | undefined;
        msScrollLimitXMax?: string | number | undefined;
        msScrollLimitXMin?: string | number | undefined;
        msScrollLimitYMax?: string | number | undefined;
        msScrollLimitYMin?: string | number | undefined;
        msScrollRails?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "railed" | undefined;
        msScrollSnapPointsX?: string | undefined;
        msScrollSnapPointsY?: string | undefined;
        msScrollSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        msScrollTranslation?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "vertical-to-horizontal" | undefined;
        msTextAutospace?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ideograph-alpha" | "ideograph-numeric" | "ideograph-parenthesis" | "ideograph-space" | undefined;
        msTextCombineHorizontal?: string | undefined;
        msTextOverflow?: string | undefined;
        msTextSizeAdjust?: string | undefined;
        msTouchAction?: string | undefined;
        msTouchSelect?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "grippers" | undefined;
        msTransform?: string | undefined;
        msTransformOrigin?: string | number | undefined;
        msUserSelect?: "none" | "inherit" | "text" | "-moz-initial" | "initial" | "revert" | "unset" | "element" | undefined;
        msWordBreak?: "normal" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "break-word" | "break-all" | "keep-all" | undefined;
        msWrapFlow?: "clear" | "both" | "auto" | "start" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "maximum" | undefined;
        msWrapMargin?: string | number | undefined;
        msWrapThrough?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "wrap" | undefined;
        msWritingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        OBackgroundSize?: string | number | undefined;
        OObjectFit?: "fill" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "cover" | "scale-down" | undefined;
        OObjectPosition?: string | number | undefined;
        OTabSize?: string | number | undefined;
        OTextOverflow?: string | undefined;
        OTransformOrigin?: string | number | undefined;
        WebkitAlignContent?: string | undefined;
        WebkitAlignItems?: string | undefined;
        WebkitAlignSelf?: string | undefined;
        WebkitAnimationDelay?: string | undefined;
        WebkitAnimationDirection?: string | undefined;
        WebkitAnimationDuration?: string | undefined;
        WebkitAnimationFillMode?: string | undefined;
        WebkitAnimationIterationCount?: string | number | undefined;
        WebkitAnimationName?: string | undefined;
        WebkitAnimationPlayState?: string | undefined;
        WebkitAnimationTimingFunction?: string | undefined;
        WebkitAppearance?: "none" | "inherit" | "button" | "meter" | "textarea" | "-moz-initial" | "initial" | "revert" | "unset" | "button-bevel" | "caret" | "checkbox" | "listbox" | "listitem" | "menulist" | "menulist-button" | "menulist-text" | "menulist-textfield" | "radio" | "searchfield" | "textfield" | "default-button" | "inner-spin-button" | "media-controls-background" | "media-controls-fullscreen-background" | "media-current-time-display" | "media-enter-fullscreen-button" | "media-exit-fullscreen-button" | "media-fullscreen-button" | "media-mute-button" | "media-overlay-play-button" | "media-play-button" | "media-seek-back-button" | "media-seek-forward-button" | "media-slider" | "media-sliderthumb" | "media-time-remaining-display" | "media-toggle-closed-captions-button" | "media-volume-slider" | "media-volume-slider-container" | "media-volume-sliderthumb" | "progress-bar" | "progress-bar-value" | "push-button" | "searchfield-cancel-button" | "searchfield-decoration" | "searchfield-results-button" | "searchfield-results-decoration" | "slider-horizontal" | "slider-vertical" | "sliderthumb-horizontal" | "sliderthumb-vertical" | "square-button" | undefined;
        WebkitBackdropFilter?: string | undefined;
        WebkitBackfaceVisibility?: "inherit" | "hidden" | "visible" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBackgroundSize?: string | number | undefined;
        WebkitBorderBeforeColor?: string | undefined;
        WebkitBorderBeforeStyle?: string | undefined;
        WebkitBorderBeforeWidth?: string | number | undefined;
        WebkitBorderBottomLeftRadius?: string | number | undefined;
        WebkitBorderBottomRightRadius?: string | number | undefined;
        WebkitBorderImageSlice?: string | number | undefined;
        WebkitBorderTopLeftRadius?: string | number | undefined;
        WebkitBorderTopRightRadius?: string | number | undefined;
        WebkitBoxDecorationBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        WebkitBoxReflect?: string | number | undefined;
        WebkitBoxShadow?: string | undefined;
        WebkitBoxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        WebkitClipPath?: string | undefined;
        WebkitColorAdjust?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "economy" | "exact" | undefined;
        WebkitColumnCount?: number | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitColumnGap?: string | number | undefined;
        WebkitColumnRuleColor?: string | undefined;
        WebkitColumnRuleStyle?: string | undefined;
        WebkitColumnRuleWidth?: string | number | undefined;
        WebkitColumnSpan?: "all" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitColumnWidth?: string | number | undefined;
        WebkitFilter?: string | undefined;
        WebkitFlexBasis?: string | number | undefined;
        WebkitFlexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        WebkitFlexGrow?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitFlexShrink?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitFlexWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "nowrap" | "wrap" | "wrap-reverse" | undefined;
        WebkitFontFeatureSettings?: string | undefined;
        WebkitFontKerning?: "normal" | "none" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitFontVariantLigatures?: string | undefined;
        WebkitHyphens?: "none" | "auto" | "manual" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitJustifyContent?: string | undefined;
        WebkitLineBreak?: "normal" | "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "strict" | "loose" | undefined;
        WebkitMarginEnd?: string | number | undefined;
        WebkitMarginStart?: string | number | undefined;
        WebkitMaskAttachment?: string | undefined;
        WebkitMaskClip?: string | undefined;
        WebkitMaskComposite?: string | undefined;
        WebkitMaskImage?: string | undefined;
        WebkitMaskOrigin?: string | undefined;
        WebkitMaskPosition?: string | number | undefined;
        WebkitMaskPositionX?: string | number | undefined;
        WebkitMaskPositionY?: string | number | undefined;
        WebkitMaskRepeat?: string | undefined;
        WebkitMaskRepeatX?: "round" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-repeat" | "repeat" | "space" | undefined;
        WebkitMaskRepeatY?: "round" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-repeat" | "repeat" | "space" | undefined;
        WebkitMaskSize?: string | number | undefined;
        WebkitMaxInlineSize?: string | number | undefined;
        WebkitOrder?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitOverflowScrolling?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "touch" | undefined;
        WebkitPaddingEnd?: string | number | undefined;
        WebkitPaddingStart?: string | number | undefined;
        WebkitPerspective?: string | number | undefined;
        WebkitPerspectiveOrigin?: string | number | undefined;
        WebkitScrollSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        WebkitShapeMargin?: string | number | undefined;
        WebkitTapHighlightColor?: string | undefined;
        WebkitTextCombine?: string | undefined;
        WebkitTextDecorationColor?: string | undefined;
        WebkitTextDecorationLine?: string | undefined;
        WebkitTextDecorationSkip?: string | undefined;
        WebkitTextDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        WebkitTextEmphasisColor?: string | undefined;
        WebkitTextEmphasisPosition?: string | undefined;
        WebkitTextEmphasisStyle?: string | undefined;
        WebkitTextFillColor?: string | undefined;
        WebkitTextOrientation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mixed" | "sideways" | "upright" | undefined;
        WebkitTextSizeAdjust?: string | undefined;
        WebkitTextStrokeColor?: string | undefined;
        WebkitTextStrokeWidth?: string | number | undefined;
        WebkitTouchCallout?: "none" | "default" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitTransform?: string | undefined;
        WebkitTransformOrigin?: string | number | undefined;
        WebkitTransformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        WebkitTransitionDelay?: string | undefined;
        WebkitTransitionDuration?: string | undefined;
        WebkitTransitionProperty?: string | undefined;
        WebkitTransitionTimingFunction?: string | undefined;
        WebkitUserModify?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "read-only" | "read-write" | "read-write-plaintext-only" | undefined;
        WebkitUserSelect?: "all" | "none" | "auto" | "inherit" | "text" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "-moz-none" | "element" | undefined;
        WebkitWritingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        MozAnimation?: string | number | undefined;
        MozBorderImage?: string | number | undefined;
        MozColumnRule?: string | number | undefined;
        MozColumns?: string | number | undefined;
        MozOutlineRadius?: string | number | undefined;
        MozTransition?: string | undefined;
        msContentZoomLimit?: string | undefined;
        msContentZoomSnap?: string | undefined;
        msFlex?: string | number | undefined;
        msScrollLimit?: string | undefined;
        msScrollSnapX?: string | undefined;
        msScrollSnapY?: string | undefined;
        OBorderImage?: string | number | undefined;
        WebkitAnimation?: string | number | undefined;
        WebkitBorderBefore?: string | number | undefined;
        WebkitBorderImage?: string | number | undefined;
        WebkitBorderRadius?: string | number | undefined;
        WebkitColumnRule?: string | number | undefined;
        WebkitColumns?: string | number | undefined;
        WebkitFlex?: string | number | undefined;
        WebkitFlexFlow?: string | undefined;
        WebkitLineClamp?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitMask?: string | number | undefined;
        WebkitTextEmphasis?: string | undefined;
        WebkitTextStroke?: string | number | undefined;
        WebkitTransition?: string | undefined;
        azimuth?: string | undefined;
        boxAlign?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "baseline" | undefined;
        boxDirection?: "normal" | "reverse" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        boxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        boxPack?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        clip?: string | undefined;
        fontVariantAlternates?: string | undefined;
        gridColumnGap?: string | number | undefined;
        gridGap?: string | number | undefined;
        gridRowGap?: string | number | undefined;
        imeMode?: "normal" | "auto" | "active" | "disabled" | "inactive" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        offsetBlockEnd?: string | number | undefined;
        offsetBlockStart?: string | number | undefined;
        offsetInlineEnd?: string | number | undefined;
        offsetInlineStart?: string | number | undefined;
        scrollSnapCoordinate?: string | number | undefined;
        scrollSnapDestination?: string | number | undefined;
        scrollSnapPointsX?: string | undefined;
        scrollSnapPointsY?: string | undefined;
        scrollSnapTypeX?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        scrollSnapTypeY?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        textCombineHorizontal?: string | undefined;
        KhtmlBoxAlign?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "baseline" | undefined;
        KhtmlBoxDirection?: "normal" | "reverse" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        KhtmlBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        KhtmlBoxPack?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        MozBackgroundInlinePolicy?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        MozBackgroundSize?: string | number | undefined;
        MozBorderRadius?: string | number | undefined;
        MozBorderRadiusBottomleft?: string | number | undefined;
        MozBorderRadiusBottomright?: string | number | undefined;
        MozBorderRadiusTopleft?: string | number | undefined;
        MozBorderRadiusTopright?: string | number | undefined;
        MozBoxAlign?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "baseline" | undefined;
        MozBoxDirection?: "normal" | "reverse" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        MozBoxPack?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        MozBoxShadow?: string | undefined;
        MozOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozOutline?: string | number | undefined;
        MozOutlineColor?: string | undefined;
        MozOutlineStyle?: "none" | "auto" | "inherit" | "hidden" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        MozOutlineWidth?: string | number | undefined;
        MozResize?: "none" | "both" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "block" | "inline" | "horizontal" | "vertical" | undefined;
        MozTextAlignLast?: "left" | "right" | "auto" | "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        MozTextDecorationColor?: string | undefined;
        MozTextDecorationLine?: string | undefined;
        MozTextDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        msImeMode?: "normal" | "auto" | "active" | "disabled" | "inactive" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msScrollbar3dlightColor?: string | undefined;
        msScrollbarArrowColor?: string | undefined;
        msScrollbarBaseColor?: string | undefined;
        msScrollbarDarkshadowColor?: string | undefined;
        msScrollbarFaceColor?: string | undefined;
        msScrollbarHighlightColor?: string | undefined;
        msScrollbarShadowColor?: string | undefined;
        msScrollbarTrackColor?: string | undefined;
        OAnimation?: string | number | undefined;
        OAnimationDelay?: string | undefined;
        OAnimationDirection?: string | undefined;
        OAnimationDuration?: string | undefined;
        OAnimationFillMode?: string | undefined;
        OAnimationIterationCount?: string | number | undefined;
        OAnimationName?: string | undefined;
        OAnimationPlayState?: string | undefined;
        OAnimationTimingFunction?: string | undefined;
        OTransform?: string | undefined;
        OTransition?: string | undefined;
        OTransitionDelay?: string | undefined;
        OTransitionDuration?: string | undefined;
        OTransitionProperty?: string | undefined;
        OTransitionTimingFunction?: string | undefined;
        WebkitBoxAlign?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "baseline" | undefined;
        WebkitBoxDirection?: "normal" | "reverse" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        WebkitBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        WebkitBoxPack?: "start" | "center" | "end" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "justify" | undefined;
        WebkitScrollSnapPointsX?: string | undefined;
        WebkitScrollSnapPointsY?: string | undefined;
        alignmentBaseline?: "auto" | "inherit" | "hanging" | "middle" | "alphabetic" | "ideographic" | "-moz-initial" | "initial" | "revert" | "unset" | "baseline" | "after-edge" | "before-edge" | "central" | "mathematical" | "text-after-edge" | "text-before-edge" | undefined;
        baselineShift?: string | number | undefined;
        clipRule?: "nonzero" | "evenodd" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        colorInterpolation?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "linearRGB" | "sRGB" | undefined;
        colorRendering?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "optimizeSpeed" | "optimizeQuality" | undefined;
        dominantBaseline?: "auto" | "inherit" | "hanging" | "middle" | "alphabetic" | "ideographic" | "-moz-initial" | "initial" | "revert" | "unset" | "central" | "mathematical" | "text-after-edge" | "text-before-edge" | "no-change" | "reset-size" | "use-script" | undefined;
        fill?: string | undefined;
        fillOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fillRule?: "nonzero" | "evenodd" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        floodColor?: string | undefined;
        floodOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        glyphOrientationVertical?: string | number | undefined;
        lightingColor?: string | undefined;
        marker?: string | undefined;
        markerEnd?: string | undefined;
        markerMid?: string | undefined;
        markerStart?: string | undefined;
        shapeRendering?: "auto" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "geometricPrecision" | "optimizeSpeed" | "crispEdges" | undefined;
        stopColor?: string | undefined;
        stopOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        stroke?: string | undefined;
        strokeDasharray?: string | number | undefined;
        strokeDashoffset?: string | number | undefined;
        strokeLinecap?: "square" | "butt" | "round" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeLinejoin?: "round" | "bevel" | "miter" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeMiterlimit?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeWidth?: string | number | undefined;
        textAnchor?: "start" | "end" | "inherit" | "middle" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        vectorEffect?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "non-scaling-stroke" | undefined;
    };
    renderProvider: (value: Drawer) => JSX.Element;
    render(): JSX.Element;
}
export {};
