'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _reactDom = require('react-dom');

var ReactDOM = _interopRequireWildcard(_reactDom);

var _icon = require('../icon');

var _icon2 = _interopRequireDefault(_icon);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var __rest = undefined && undefined.__rest || function (s, e) {
    var t = {};
    for (var p in s) {
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
    }return t;
};

var Avatar = function (_React$Component) {
    (0, _inherits3['default'])(Avatar, _React$Component);

    function Avatar(props) {
        (0, _classCallCheck3['default'])(this, Avatar);

        var _this = (0, _possibleConstructorReturn3['default'])(this, (Avatar.__proto__ || Object.getPrototypeOf(Avatar)).call(this, props));

        _this.setScale = function () {
            var childrenNode = _this.avatarChildren;
            if (childrenNode) {
                var childrenWidth = childrenNode.offsetWidth;
                var avatarNode = ReactDOM.findDOMNode(_this);
                var avatarWidth = avatarNode.getBoundingClientRect().width;
                // add 4px gap for each side to get better performance
                if (avatarWidth - 8 < childrenWidth) {
                    _this.setState({
                        scale: (avatarWidth - 8) / childrenWidth
                    });
                } else {
                    _this.setState({
                        scale: 1
                    });
                }
            }
        };
        _this.handleImgLoadError = function () {
            var onError = _this.props.onError;

            var errorFlag = onError ? onError() : undefined;
            if (errorFlag !== false) {
                _this.setState({ isImgExist: false });
            }
        };
        _this.state = {
            scale: 1,
            isImgExist: true
        };
        return _this;
    }

    (0, _createClass3['default'])(Avatar, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.setScale();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate(prevProps, prevState) {
            if (prevProps.children !== this.props.children || prevState.scale !== this.state.scale && this.state.scale === 1 || prevState.isImgExist !== this.state.isImgExist) {
                this.setScale();
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _classNames,
                _classNames2,
                _this2 = this;

            var _a = this.props,
                prefixCls = _a.prefixCls,
                shape = _a.shape,
                size = _a.size,
                src = _a.src,
                icon = _a.icon,
                className = _a.className,
                alt = _a.alt,
                others = __rest(_a, ["prefixCls", "shape", "size", "src", "icon", "className", "alt"]);var _state = this.state,
                isImgExist = _state.isImgExist,
                scale = _state.scale;

            var sizeCls = (0, _classnames2['default'])((_classNames = {}, (0, _defineProperty3['default'])(_classNames, prefixCls + '-lg', size === 'large'), (0, _defineProperty3['default'])(_classNames, prefixCls + '-sm', size === 'small'), _classNames));
            var classString = (0, _classnames2['default'])(prefixCls, className, sizeCls, (_classNames2 = {}, (0, _defineProperty3['default'])(_classNames2, prefixCls + '-' + shape, shape), (0, _defineProperty3['default'])(_classNames2, prefixCls + '-image', src && isImgExist), (0, _defineProperty3['default'])(_classNames2, prefixCls + '-icon', icon), _classNames2));
            var sizeStyle = typeof size === 'number' ? {
                width: size,
                height: size,
                lineHeight: size + 'px',
                fontSize: icon ? size / 2 : 18
            } : {};
            var children = this.props.children;
            if (src && isImgExist) {
                children = React.createElement('img', { src: src, onError: this.handleImgLoadError, alt: alt });
            } else if (icon) {
                children = React.createElement(_icon2['default'], { type: icon });
            } else {
                var childrenNode = this.avatarChildren;
                if (childrenNode || scale !== 1) {
                    var transformString = 'scale(' + scale + ') translateX(-50%)';
                    var childrenStyle = {
                        msTransform: transformString,
                        WebkitTransform: transformString,
                        transform: transformString
                    };
                    var sizeChildrenStyle = typeof size === 'number' ? {
                        lineHeight: size + 'px'
                    } : {};
                    children = React.createElement(
                        'span',
                        { className: prefixCls + '-string', ref: function ref(span) {
                                return _this2.avatarChildren = span;
                            }, style: (0, _extends3['default'])({}, sizeChildrenStyle, childrenStyle) },
                        children
                    );
                } else {
                    children = React.createElement(
                        'span',
                        { className: prefixCls + '-string', ref: function ref(span) {
                                return _this2.avatarChildren = span;
                            } },
                        children
                    );
                }
            }
            return React.createElement(
                'span',
                (0, _extends3['default'])({}, others, { style: (0, _extends3['default'])({}, sizeStyle, others.style), className: classString }),
                children
            );
        }
    }]);
    return Avatar;
}(React.Component);

exports['default'] = Avatar;

Avatar.defaultProps = {
    prefixCls: 'ant-avatar',
    shape: 'circle',
    size: 'default'
};
module.exports = exports['default'];