!function(window,angular){"use strict";var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};angular.module("ui-leaflet").config(function($provide){return $provide.decorator("leafletHelpers",function($delegate,leafletLayersLogger){var $log=leafletLayersLogger,_versionCompare=function(left,right){if(("undefined"==typeof left?"undefined":_typeof(left))+("undefined"==typeof right?"undefined":_typeof(right))!=="stringstring")return!1;for(var a=left.split("."),b=right.split("."),i=0,len=Math.max(a.length,b.length);i<len;i++){if(a[i]&&!b[i]&&parseInt(a[i])>0||parseInt(a[i])>parseInt(b[i]))return 1;if(b[i]&&!a[i]&&parseInt(b[i])>0||parseInt(a[i])<parseInt(b[i]))return-1}return 0},basicFunction=function(layerType){return{isLoaded:function(){return angular.isDefined(layerType)},is:function(layer){return!!this.isLoaded()&&layer instanceof layerType}}},plugins={BingLayerPlugin:basicFunction(L.BingLayer),ChinaLayerPlugin:basicFunction(L.tileLayer.chinaProvider),HeatLayerPlugin:basicFunction(L.heatLayer),LeafletProviderPlugin:basicFunction(L.TileLayer.Provider),MapboxGL:basicFunction(L.mapboxGL),UTFGridPlugin:basicFunction(L.UtfGrid),WebGLHeatMapLayerPlugin:basicFunction(L.TileLayer.WebGLHeatMap),WFSLayerPlugin:basicFunction(L.GeoJSON.WFS),YandexLayerPlugin:basicFunction(L.Yandex)};return _versionCompare(L.version,"1.0.0")===-1?plugins.GoogleLayerPlugin=basicFunction(L.Google):plugins.GoogleLayerPlugin=basicFunction(L.GridLayer.GoogleMutant),plugins.versionCompare=_versionCompare,angular.isDefined(L.esri)?angular.extend(plugins,{AGSBaseLayerPlugin:basicFunction(L.esri.basemapLayer),AGSClusteredLayerPlugin:basicFunction(L.esri.clusteredFeatureLayer),AGSDynamicMapLayerPlugin:basicFunction(L.esri.dynamicMapLayer),AGSFeatureLayerPlugin:basicFunction(L.esri.featureLayer),AGSImageMapLayerPlugin:basicFunction(L.esri.imageMapLayer),AGSHeatmapLayerPlugin:basicFunction(L.esri.heatmapFeatureLayer),AGSTiledMapLayerPlugin:basicFunction(L.esri.tiledMapLayer)}):angular.extend(plugins,{AGSBaseLayerPlugin:basicFunction(),AGSClusteredLayerPlugin:basicFunction(),AGSDynamicMapLayerPlugin:basicFunction(),AGSFeatureLayerPlugin:basicFunction(),AGSImageMapLayerPlugin:basicFunction(),AGSHeatmapLayerPlugin:basicFunction(),AGSTiledMapLayerPlugin:basicFunction()}),angular.isDefined(window.lvector)?angular.extend(plugins,{AGSLayerPlugin:basicFunction(window.lvector.AGS)}):angular.extend(plugins,{AGSLayerPlugin:basicFunction()}),angular.extend($delegate,plugins),$log.info("[ui-leaflet-layers] - Layers plugin is loaded"),$delegate})}),angular.module("ui-leaflet").config(function($provide){return $provide.decorator("leafletLayerHelpers",function($delegate,$rootScope,$q,leafletHelpers,leafletLayersLogger){var $log=leafletLayersLogger,isArray=leafletHelpers.isArray,isObject=leafletHelpers.isObject,isDefined=leafletHelpers.isDefined,errorHeader=leafletHelpers.errorHeader,utfGridCreateLayer=function(params){if(!leafletHelpers.UTFGridPlugin.isLoaded())return void $log.error(errorHeader+" The UTFGrid plugin is not loaded.");var utfgrid=new L.UtfGrid(params.url,params.pluginOptions);return utfgrid.on("mouseover",function(e){$rootScope.$broadcast("leafletDirectiveMap.utfgridMouseover",e)}),utfgrid.on("mouseout",function(e){$rootScope.$broadcast("leafletDirectiveMap.utfgridMouseout",e)}),utfgrid.on("click",function(e){$rootScope.$broadcast("leafletDirectiveMap.utfgridClick",e)}),utfgrid.on("mousemove",function(e){$rootScope.$broadcast("leafletDirectiveMap.utfgridMousemove",e)}),utfgrid};return angular.extend($delegate.layerTypes,{ags:{mustHaveUrl:!0,createLayer:function(params){if(leafletHelpers.AGSLayerPlugin.isLoaded()){var options=angular.copy(params.options);angular.extend(options,{url:params.url});var layer=new lvector.AGS(options);return layer.onAdd=function(map){this.setMap(map)},layer.onRemove=function(){this.setMap(null)},layer}}},agsBase:{mustHaveLayer:!0,createLayer:function(params){if(leafletHelpers.AGSBaseLayerPlugin.isLoaded())return L.esri.basemapLayer(params.layer,params.options)}},agsClustered:{mustHaveUrl:!0,createLayer:function(params){return leafletHelpers.AGSClusteredLayerPlugin.isLoaded()?leafletHelpers.MarkerClusterPlugin.isLoaded()?L.esri.clusteredFeatureLayer(params.url,params.options):void $log.warn(errorHeader+" The markercluster plugin is not loaded."):void $log.warn(errorHeader+" The esri clustered layer plugin is not loaded.")}},agsDynamic:{mustHaveUrl:!0,createLayer:function(params){return leafletHelpers.AGSDynamicMapLayerPlugin.isLoaded()?(params.options.url=params.url,L.esri.dynamicMapLayer(params.options)):void $log.warn(errorHeader+" The esri plugin is not loaded.")}},agsFeature:{mustHaveUrl:!0,createLayer:function(params){if(!leafletHelpers.AGSFeatureLayerPlugin.isLoaded())return void $log.warn(errorHeader+" The esri plugin is not loaded.");params.options.url=params.url;var layer=L.esri.featureLayer(params.options),load=function(){isDefined(params.options.loadedDefer)&&params.options.loadedDefer.resolve()};return layer.on("loading",function(){params.options.loadedDefer=$q.defer(),layer.off("load",load),layer.on("load",load)}),layer}},agsHeatmap:{mustHaveUrl:!0,createLayer:function(params){return leafletHelpers.AGSHeatmapLayerPlugin.isLoaded()?leafletHelpers.HeatLayerPlugin.isLoaded()?L.esri.heatmapFeatureLayer(params.url,params.options):void $log.warn(errorHeader+" The heatlayer plugin is not loaded."):void $log.warn(errorHeader+" The esri heatmap layer plugin is not loaded.")}},agsImage:{mustHaveUrl:!0,createLayer:function(params){return leafletHelpers.AGSImageMapLayerPlugin.isLoaded()?(params.options.url=params.url,L.esri.imageMapLayer(params.options)):void $log.warn(errorHeader+" The esri plugin is not loaded.")}},agsTiled:{mustHaveUrl:!0,createLayer:function(params){return leafletHelpers.AGSTiledMapLayerPlugin.isLoaded()?(params.options.url=params.url,L.esri.tiledMapLayer(params.options)):void $log.warn(errorHeader+" The esri plugin is not loaded.")}},bing:{mustHaveUrl:!1,createLayer:function(params){return leafletHelpers.BingLayerPlugin.isLoaded()?new L.BingLayer(params.key,params.options):void $log.error(errorHeader+" The Bing plugin is not loaded.")}},china:{mustHaveUrl:!1,createLayer:function(params){var type=params.type||"";return leafletHelpers.ChinaLayerPlugin.isLoaded()?L.tileLayer.chinaProvider(type,params.options):void $log.error(errorHeader+" The ChinaLayer plugin is not loaded.")}},google:{mustHaveUrl:!1,createLayer:function(params){var type=params.type||"SATELLITE";if(!leafletHelpers.GoogleLayerPlugin.isLoaded())return void $log.error(errorHeader+" The GoogleLayer plugin is not loaded.");var layer=null;return layer=leafletHelpers.versionCompare(L.version,"1.0.0")===-1?new L.Google(type.toUpperCase(),params.options):new L.GridLayer.GoogleMutant({type:type.toLowerCase()})}},heat:{mustHaveUrl:!1,mustHaveData:!0,createLayer:function(params){if(!leafletHelpers.HeatLayerPlugin.isLoaded())return void $log.error(errorHeader+" The HeatMapLayer plugin is not loaded.");var layer=new L.heatLayer;return isArray(params.data)&&layer.setLatLngs(params.data),isObject(params.options)&&layer.setOptions(params.options),layer}},here:{mustHaveUrl:!1,createLayer:function(params){var provider=params.provider||"HERE.terrainDay";if(leafletHelpers.LeafletProviderPlugin.isLoaded())return new L.TileLayer.Provider(provider,params.options)}},mapbox:{mustHaveKey:!0,createLayer:function(params){var url="//api.mapbox.com/styles/v1/{user}/{mapId}/tiles/256/{z}/{x}/{y}?access_token={apiKey}";return L.tileLayer(url,angular.extend(params.options,{mapId:params.key,user:params.user,apiKey:params.apiKey}))}},mapboxGL:{createLayer:function(params){return leafletHelpers.MapboxGL.isLoaded()?new L.mapboxGL(params.options):void $log.error(errorHeader+" The MapboxGL plugin is not loaded.")}},utfGrid:{mustHaveUrl:!0,createLayer:utfGridCreateLayer},webGLHeatmap:{mustHaveUrl:!1,mustHaveData:!0,createLayer:function(params){if(!leafletHelpers.WebGLHeatMapLayerPlugin.isLoaded())return void $log.error(errorHeader+" The WebGLHeatMapLayer plugin is not loaded.");var layer=new L.TileLayer.WebGLHeatMap(params.options);return isDefined(params.data)&&layer.setData(params.data),layer}},wfs:{mustHaveUrl:!0,mustHaveLayer:!0,createLayer:function createLayer(params){if(!leafletHelpers.WFSLayerPlugin.isLoaded())return void $log.error(errorHeader+" The WFSLayer plugin is not loaded.");var options=angular.copy(params.options);return options.crs&&"string"==typeof options.crs&&(options.crs=eval(options.crs)),new L.GeoJSON.WFS(params.url,params.layer,options)}},yandex:{mustHaveUrl:!1,createLayer:function(params){var type=params.type||"map";return leafletHelpers.YandexLayerPlugin.isLoaded()?new L.Yandex(type,params.options):void $log.error(errorHeader+" The YandexLayer plugin is not loaded.")}}}),$delegate})}),angular.module("ui-leaflet").service("leafletLayersLogger",function(nemSimpleLogger){return nemSimpleLogger.spawn()})}(window,angular);