/*!
  * Tempus Dominus v6.2.10 (https://getdatepicker.com/)
  * Copyright 2013-2022 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).tempusDominus={})}(this,(function(t){"use strict";var e;t.Unit=void 0,(e=t.Unit||(t.Unit={})).seconds="seconds",e.minutes="minutes",e.hours="hours",e.date="date",e.month="month",e.year="year";const s={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit"},i=t=>{switch(t){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}};class o extends Date{constructor(){super(...arguments),this.locale="default",this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335]}setLocale(t){return this.locale=t,this}static convert(t,e="default"){if(!t)throw new Error("A date is required");return new o(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()).setLocale(e)}static fromString(t,e){return new o(t)}get clone(){return new o(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocale(this.locale)}startOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":{if(this.startOf(t.Unit.date),this.weekDay===s)break;let e=this.weekDay;0!==s&&0===this.weekDay&&(e=8-s),this.manipulate(s-e,t.Unit.date);break}case"month":this.startOf(t.Unit.date),this.setDate(1);break;case"year":this.startOf(t.Unit.date),this.setMonth(0,1)}return this}endOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":{this.endOf(t.Unit.date);const e=6+s;if(this.weekDay===e)break;this.manipulate(e-this.weekDay,t.Unit.date);break}case"month":this.endOf(t.Unit.date),this.manipulate(1,t.Unit.month),this.setDate(0);break;case"year":this.endOf(t.Unit.date),this.setMonth(11,31)}return this}manipulate(t,e){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this[e]+=t,this}format(t,e=this.locale){return new Intl.DateTimeFormat(e,t).format(this)}isBefore(t,e){if(!e)return this.valueOf()<t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()<t.clone.startOf(e).valueOf()}isAfter(t,e){if(!e)return this.valueOf()>t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()>t.clone.startOf(e).valueOf()}isSame(t,e){if(!e)return this.valueOf()===t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return t=o.convert(t),this.clone.startOf(e).valueOf()===t.startOf(e).valueOf()}isBetween(t,e,s,i="()"){if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const o="("===i[0],a=")"===i[1];return(o?this.isAfter(t,s):!this.isBefore(t,s))&&(a?this.isBefore(e,s):!this.isAfter(e,s))||(o?this.isBefore(t,s):!this.isAfter(t,s))&&(a?this.isAfter(e,s):!this.isBefore(e,s))}parts(t=this.locale,e={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(t,e).formatToParts(this).filter((t=>"literal"!==t.type)).forEach((t=>s[t.type]=t.value)),s}get seconds(){return this.getSeconds()}set seconds(t){this.setSeconds(t)}get secondsFormatted(){return this.parts(void 0,s).second}get minutes(){return this.getMinutes()}set minutes(t){this.setMinutes(t)}get minutesFormatted(){return this.parts(void 0,s).minute}get hours(){return this.getHours()}set hours(t){this.setHours(t)}getHoursFormatted(t="h12"){return this.parts(void 0,{...s,hourCycle:t}).hour}meridiem(t=this.locale){return new Intl.DateTimeFormat(t,{hour:"numeric",hour12:!0}).formatToParts(this).find((t=>"dayPeriod"===t.type))?.value}get date(){return this.getDate()}set date(t){this.setDate(t)}get dateFormatted(){return this.parts(void 0,s).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(t){const e=new Date(this.year,t+1);e.setDate(0);const s=e.getDate();this.date>s&&(this.date=s),this.setMonth(t)}get monthFormatted(){return this.parts(void 0,s).month}get year(){return this.getFullYear()}set year(t){this.setFullYear(t)}get week(){const t=this.computeOrdinal(),e=this.getUTCDay();let s=Math.floor((t-e+10)/7);return s<1?s=this.weeksInWeekYear(this.year-1):s>this.weeksInWeekYear(this.year)&&(s=1),s}weeksInWeekYear(t){const e=(t+Math.floor(t/4)-Math.floor(t/100)+Math.floor(t/400))%7,s=t-1,i=(s+Math.floor(s/4)-Math.floor(s/100)+Math.floor(s/400))%7;return 4===e||3===i?53:52}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}}class a extends Error{}const n="tempus-dominus";class r{}r.NAME=n,r.dataKey="td",r.events=new class{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},r.css=new class{constructor(){this.widget=`${n}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline",this.lightTheme="light",this.darkTheme="dark",this.isDarkPreferredQuery="(prefers-color-scheme: dark)"}},r.errorMessages=new class{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(t){const e=new a(`${this.base} Unexpected option: ${t} does not match a known option.`);throw e.code=1,e}unexpectedOptions(t){const e=new a(`${this.base}: ${t.join(", ")}`);throw e.code=1,e}unexpectedOptionValue(t,e,s){const i=new a(`${this.base} Unexpected option value: ${t} does not accept a value of "${e}". Valid values are: ${s.join(", ")}`);throw i.code=2,i}typeMismatch(t,e,s){const i=new a(`${this.base} Mismatch types: ${t} has a type of ${e} instead of the required ${s}`);throw i.code=3,i}numbersOutOfRange(t,e,s){const i=new a(`${this.base} ${t} expected an array of number between ${e} and ${s}.`);throw i.code=4,i}failedToParseDate(t,e,s=!1){const i=new a(`${this.base} Could not correctly parse "${e}" to a date for ${t}.`);if(i.code=5,!s)throw i;console.warn(i)}mustProvideElement(){const t=new a(`${this.base} No element was provided.`);throw t.code=6,t}subscribeMismatch(){const t=new a(`${this.base} The subscribed events does not match the number of callbacks`);throw t.code=7,t}conflictingConfiguration(t){const e=new a(`${this.base} A configuration value conflicts with another rule. ${t}`);throw e.code=8,e}customDateFormatError(t){const e=new a(`${this.base} customDateFormat: ${t}`);throw e.code=9,e}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string or use the customDateFormat plugin.`)}deprecatedWarning(t,e){console.warn(`${this.base} Warning ${t} is deprecated and will be removed in a future version. ${e}`)}throwError(t){const e=new a(`${this.base} ${t}`);throw e.code=9,e}};class d{constructor(){this.cache=new Map}locate(t){const e=this.cache.get(t);if(e)return e;const s=new t;return this.cache.set(t,s),s}}let c;const l=[{name:"calendar",className:r.css.daysContainer,unit:t.Unit.month,step:1},{name:"months",className:r.css.monthsContainer,unit:t.Unit.year,step:1},{name:"years",className:r.css.yearsContainer,unit:t.Unit.year,step:10},{name:"decades",className:r.css.decadesContainer,unit:t.Unit.year,step:100}];class h{constructor(){this._currentCalendarViewMode=0,this._viewDate=new o,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(t){this._currentCalendarViewMode=t,this.currentView=l[t].name}get viewDate(){return this._viewDate}set viewDate(t){this._viewDate=t,this.options&&(this.options.viewDate=t)}refreshCurrentView(){this.currentView=l[this.currentCalendarViewMode].name}get isTwelveHour(){return["h12","h11"].includes(this.options.localization.hourCycle)}}class p{constructor(){this.optionsStore=c.locate(h)}isValid(e,s){if(s!==t.Unit.month&&this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(e))return!1;if(s!==t.Unit.month&&this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(e))return!1;if(s!==t.Unit.month&&s!==t.Unit.year&&this.optionsStore.options.restrictions.daysOfWeekDisabled?.length>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(e.weekDay))return!1;if(this.optionsStore.options.restrictions.minDate&&e.isBefore(this.optionsStore.options.restrictions.minDate,s))return!1;if(this.optionsStore.options.restrictions.maxDate&&e.isAfter(this.optionsStore.options.restrictions.maxDate,s))return!1;if(s===t.Unit.hours||s===t.Unit.minutes||s===t.Unit.seconds){if(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(e))return!1;if(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(e))return!1;if(this.optionsStore.options.restrictions.disabledTimeIntervals.length>0)for(const t of this.optionsStore.options.restrictions.disabledTimeIntervals)if(e.isBetween(t.from,t.to))return!1}return!0}_isInDisabledDates(e){return!(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)&&this.optionsStore.options.restrictions.disabledDates.find((s=>s.isSame(e,t.Unit.date)))}_isInEnabledDates(e){return!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length||this.optionsStore.options.restrictions.enabledDates.find((s=>s.isSame(e,t.Unit.date)))}_isInDisabledHours(t){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const e=t.hours;return this.optionsStore.options.restrictions.disabledHours.find((t=>t===e))}_isInEnabledHours(t){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const e=t.hours;return this.optionsStore.options.restrictions.enabledHours.find((t=>t===e))}}class u{constructor(){this.subscribers=[]}subscribe(t){return this.subscribers.push(t),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(t){this.subscribers.splice(t,1)}emit(t){this.subscribers.forEach((e=>{e(t)}))}destroy(){this.subscribers=null,this.subscribers=[]}}class m{constructor(){this.triggerEvent=new u,this.viewUpdate=new u,this.updateDisplay=new u,this.action=new u,this.updateViewDate=new u}destroy(){this.triggerEvent.destroy(),this.viewUpdate.destroy(),this.updateDisplay.destroy(),this.action.destroy(),this.updateViewDate.destroy()}}const y={restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:void 0},inline:!1,theme:"auto"},stepping:1,useCurrent:!0,defaultDate:void 0,localization:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",previousMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",previousYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",previousDecade:"Previous Decade",nextDecade:"Next Decade",previousCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",toggleMeridiem:"Toggle Meridiem",selectTime:"Select Time",selectDate:"Select Date",dayViewHeaderFormat:{month:"long",year:"2-digit"},locale:"default",hourCycle:void 0,startOfTheWeek:0,dateFormats:{LTS:"h:mm:ss T",LT:"h:mm T",L:"MM/dd/yyyy",LL:"MMMM d, yyyy",LLL:"MMMM d, yyyy h:mm T",LLLL:"dddd, MMMM d, yyyy h:mm T"},ordinal:t=>t,format:"L LT"},keepInvalid:!1,debug:!1,allowInputToggle:!1,viewDate:new o,multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,meta:{},container:void 0};function g(t,e){if(t.constructor.name===o.name)return t;if(t.constructor.name===Date.name)return o.convert(t);if("string"==typeof t){const s=o.fromString(t,e);return"null"===JSON.stringify(s)?null:s}return null}function v(t,e,s){"string"==typeof t&&"input"!==e&&r.errorMessages.dateString();const i=g(t,s);return i||r.errorMessages.failedToParseDate(e,t,"input"===e),i}function S(t,e,s,i){Array.isArray(e)||r.errorMessages.typeMismatch(t,s,"array of DateTime or Date");for(let s=0;s<e.length;s++){const o=e[s],a=v(o,t,i);a||r.errorMessages.typeMismatch(t,typeof o,"DateTime or Date"),a.setLocale(i?.locale??"default"),e[s]=a}}function w(t,e,s){Array.isArray(e)&&!e.some((t=>"number"!=typeof t))||r.errorMessages.typeMismatch(t,s,"array of numbers")}function f(t){return({value:e,providedType:s,localization:i})=>{const o=v(e,t,i);if(void 0!==o)return o.setLocale(i.locale),o;r.errorMessages.typeMismatch(t,s,"DateTime or Date")}}function b(t){const e=f(t);return t=>void 0===t.value?t.value:e(t)}function D(t,e,s){return({value:i,providedType:o})=>void 0===i?[]:(w(t,i,o),i.some((t=>t<e||t>s))&&r.errorMessages.numbersOutOfRange(t,e,s),i)}function _(t){return D(t,0,23)}function k(t){return({value:e,providedType:s,localization:i})=>void 0===e?[]:(S(t,e,s,i),e)}function C(t){return({value:e,path:s})=>(t.includes(e)||r.errorMessages.unexpectedOptionValue(s.substring(1),e,t),e)}const E=Object.freeze({defaultDate:f("defaultDate"),viewDate:f("viewDate"),minDate:b("restrictions.minDate"),maxDate:b("restrictions.maxDate"),disabledHours:_("restrictions.disabledHours"),enabledHours:_("restrictions.enabledHours"),disabledDates:k("restrictions.disabledDates"),enabledDates:k("restrictions.enabledDates"),daysOfWeekDisabled:D("restrictions.daysOfWeekDisabled",0,6),disabledTimeIntervals:({key:t,value:e,providedType:s,localization:i})=>{if(void 0===e)return[];Array.isArray(e)||r.errorMessages.typeMismatch(t,s,"array of { from: DateTime|Date, to: DateTime|Date }");const o=e;for(let e=0;e<o.length;e++)Object.keys(o[e]).forEach((s=>{const a=`${t}[${e}].${s}`,n=o[e][s],d=v(n,a,i);d||r.errorMessages.typeMismatch(a,typeof n,"DateTime or Date"),d.setLocale(i.locale),o[e][s]=d}));return o},toolbarPlacement:C(["top","bottom","default"]),type:C(["icons","sprites"]),viewMode:C(["clock","calendar","months","years","decades"]),theme:C(["light","dark","auto"]),meta:({value:t})=>t,dayViewHeaderFormat:({value:t})=>t,container:({value:t,path:e})=>(t&&!(t instanceof HTMLElement||t instanceof Element||t?.appendChild)&&r.errorMessages.typeMismatch(e.substring(1),typeof t,"HTMLElement"),t),useTwentyfourHour:({value:t,path:e,providedType:s,defaultType:i})=>{if(r.errorMessages.deprecatedWarning("useTwentyfourHour",'Please use "options.localization.hourCycle" instead'),void 0===t||"boolean"===s)return t;r.errorMessages.typeMismatch(e,s,i)},hourCycle:C(["h11","h12","h23","h24"])}),M=({value:t,defaultType:e,providedType:s,path:i})=>{switch(e){case"boolean":return"true"===t||!0===t;case"number":return+t;case"string":return t.toString();case"object":return{};case"function":return t;default:r.errorMessages.typeMismatch(i,s,e)}};function T(t){return(E[t.key]||M)(t)}class L{static deepCopy(t){const e={};return Object.keys(t).forEach((s=>{const i=t[s];i instanceof o?e[s]=i.clone:i instanceof Date?e[s]=new Date(i.valueOf()):(e[s]=i,"object"!=typeof i||i instanceof HTMLElement||i instanceof Element||Array.isArray(i)||(e[s]=L.deepCopy(i)))})),e}static objectPath(t,e){return"."===t.charAt(0)&&(t=t.slice(1)),t?t.split(".").reduce(((t,e)=>L.isValue(t)||L.isValue(t[e])?t[e]:void 0),e):e}static spread(t,e,s="",i){const o=L.objectPath(s,y),a=Object.keys(t).filter((t=>!Object.keys(o).includes(t)));if(a.length>0){const t=L.getFlattenDefaultOptions(),e=a.map((e=>{let i=`"${s}.${e}" in not a known option.`;const o=t.find((t=>t.includes(e)));return o&&(i+=` Did you mean "${o}"?`),i}));r.errorMessages.unexpectedOptions(e)}Object.keys(t).filter((t=>"__proto__"!==t&&"constructor"!==t)).forEach((a=>{"."===(s+=`.${a}`).charAt(0)&&(s=s.slice(1));const n=o[a],r=typeof t[a],d=typeof n,c=t[a];if(null==c)return e[a]=c,void(s=s.substring(0,s.lastIndexOf(`.${a}`)));"object"!=typeof n||Array.isArray(t[a])||n instanceof Date||L.ignoreProperties.includes(a)?e[a]=L.processKey(a,c,r,d,s,i):L.spread(t[a],e[a],s,i),s=s.substring(0,s.lastIndexOf(`.${a}`))}))}static processKey(t,e,s,i,o,a){return T({key:t,value:e,providedType:s,defaultType:i,path:o,localization:a})}static _mergeOptions(t,e){const s=L.deepCopy(e),i="default"!==e.localization?.locale?e.localization:t?.localization||y.localization;return L.spread(t,s,"",i),s}static _dataToOptions(t,e){const s=JSON.parse(JSON.stringify(t.dataset));if(s?.tdTargetInput&&delete s.tdTargetInput,s?.tdTargetToggle&&delete s.tdTargetToggle,!s||0===Object.keys(s).length||s.constructor!==DOMStringMap)return e;const i={},o=t=>{const e={};return Object.keys(t).forEach((t=>{e[t.toLowerCase()]=t})),e},a=(t,e,s,i)=>{const n=o(s)[t[e].toLowerCase()],r={};return void 0===n||(s[n].constructor===Object?(e++,r[n]=a(t,e,s[n],i)):r[n]=i),r},n=o(e);return Object.keys(s).filter((t=>t.startsWith(r.dataKey))).map((t=>t.substring(2))).forEach((t=>{let o=n[t.toLowerCase()];if(t.includes("_")){const r=t.split("_");o=n[r[0].toLowerCase()],void 0!==o&&e[o].constructor===Object&&(i[o]=a(r,1,e[o],s[`td${t}`]))}else void 0!==o&&(i[o]=s[`td${t}`])})),this._mergeOptions(i,e)}static _dateTypeCheck(t,e){return g(t,e)}static _typeCheckDateArray(t,e,s,i){return S(t,e,s,i)}static _typeCheckNumberArray(t,e,s){return w(t,e,s)}static dateConversion(t,e,s){return v(t,e,s)}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const t=(e,s=[])=>Array.isArray(e)?[]:Object(e)===e?Object.entries(e).flatMap((([e,i])=>t(i,[...s,e]))):s.join(".");return this._flattenDefaults=t(y),this._flattenDefaults}static _validateConflicts(t){!t.display.sideBySide||t.display.components.clock&&(t.display.components.hours||t.display.components.minutes||t.display.components.seconds)||r.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),t.restrictions.minDate&&t.restrictions.maxDate&&(t.restrictions.minDate.isAfter(t.restrictions.maxDate)&&r.errorMessages.conflictingConfiguration("minDate is after maxDate"),t.restrictions.maxDate.isBefore(t.restrictions.minDate)&&r.errorMessages.conflictingConfiguration("maxDate is before minDate"))}}L.ignoreProperties=["meta","dayViewHeaderFormat","container","dateForms","ordinal"],L.isValue=t=>null!=t;class U{constructor(){this._dates=[],this.optionsStore=c.locate(h),this.validation=c.locate(p),this._eventEmitters=c.locate(m)}get picked(){return this._dates}get lastPicked(){return this._dates[this.lastPickedIndex]}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(t){const e=this.optionsStore.options.display.components;return t?t.format({year:e.calendar&&e.year?"numeric":void 0,month:e.calendar&&e.month?"2-digit":void 0,day:e.calendar&&e.date?"2-digit":void 0,hour:e.clock&&e.hours?"2-digit":void 0,minute:e.clock&&e.minutes?"2-digit":void 0,second:e.clock&&e.seconds?"2-digit":void 0,hourCycle:this.optionsStore.options.localization.hourCycle}):""}parseInput(t){return L.dateConversion(t,"input",this.optionsStore.options.localization)}setFromInput(t,e){if(!t)return void this.setValue(void 0,e);const s=this.parseInput(t);s&&(s.setLocale(this.optionsStore.options.localization.locale),this.setValue(s,e))}add(t){this._dates.push(t)}isPicked(t,e){if(!e)return void 0!==this._dates.find((e=>e===t));const s=i(e),o=t.format(s);return void 0!==this._dates.map((t=>t.format(s))).find((t=>t===o))}pickedIndex(t,e){if(!e)return this._dates.indexOf(t);const s=i(e),o=t.format(s);return this._dates.map((t=>t.format(s))).indexOf(o)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:r.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[]}static getStartEndYear(t,e){const s=t/10,i=Math.floor(e/t)*t;return[i,i+9*s,Math.floor(e/s)*s]}updateInput(t){if(!this.optionsStore.input)return;let e=this.formatInput(t);this.optionsStore.options.multipleDates&&(e=this._dates.map((t=>this.formatInput(t))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=e&&(this.optionsStore.input.value=e)}setValue(t,e){const s=void 0===e,i=!t&&s;let o=this.optionsStore.unset?null:this._dates[e];if(!o&&!this.optionsStore.unset&&s&&i&&(o=this.lastPicked),t&&o?.isSame(t))this.updateInput(t);else{if(!t)return!this.optionsStore.options.multipleDates||1===this._dates.length||i?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(e,1),this.updateInput(),this._eventEmitters.triggerEvent.emit({type:r.events.change,date:void 0,oldDate:o,isClear:i,isValid:!0}),void this._eventEmitters.updateDisplay.emit("all");if(e=e||0,t=t.clone,1!==this.optionsStore.options.stepping&&(t.minutes=Math.round(t.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,t.seconds=0),this.validation.isValid(t))return this._dates[e]=t,this._eventEmitters.updateViewDate.emit(t.clone),this.updateInput(t),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),void this._eventEmitters.triggerEvent.emit({type:r.events.change,date:t,oldDate:o,isClear:i,isValid:!0});this.optionsStore.options.keepInvalid&&(this._dates[e]=t,this._eventEmitters.updateViewDate.emit(t.clone),this.updateInput(t),this._eventEmitters.triggerEvent.emit({type:r.events.change,date:t,oldDate:o,isClear:i,isValid:!1})),this._eventEmitters.triggerEvent.emit({type:r.events.error,reason:r.errorMessages.failedToSetInvalidDate,date:t,oldDate:o})}}}var A;!function(t){t.next="next",t.previous="previous",t.changeCalendarView="changeCalendarView",t.selectMonth="selectMonth",t.selectYear="selectYear",t.selectDecade="selectDecade",t.selectDay="selectDay",t.selectHour="selectHour",t.selectMinute="selectMinute",t.selectSecond="selectSecond",t.incrementHours="incrementHours",t.incrementMinutes="incrementMinutes",t.incrementSeconds="incrementSeconds",t.decrementHours="decrementHours",t.decrementMinutes="decrementMinutes",t.decrementSeconds="decrementSeconds",t.toggleMeridiem="toggleMeridiem",t.togglePicker="togglePicker",t.showClock="showClock",t.showHours="showHours",t.showMinutes="showMinutes",t.showSeconds="showSeconds",t.clear="clear",t.close="close",t.today="today"}(A||(A={}));var $=A;class V{constructor(){this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");if(t.classList.add(r.css.daysContainer),t.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(r.css.calendarWeeks,r.css.noHighlight),t.appendChild(e)}for(let e=0;e<42;e++){if(0!==e&&e%7==0&&this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(r.css.calendarWeeks,r.css.noHighlight),t.appendChild(e)}const s=document.createElement("div");s.setAttribute("data-action",$.selectDay),t.appendChild(s)}return t}_update(e,s){const i=e.getElementsByClassName(r.css.daysContainer)[0];if("calendar"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(r.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(r.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.optionsStore.options.display.components.month?s.classList.remove(r.css.disabled):s.classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.month),t.Unit.month)?e.classList.remove(r.css.disabled):e.classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.month),t.Unit.month)?o.classList.remove(r.css.disabled):o.classList.add(r.css.disabled)}const a=this.optionsStore.viewDate.clone.startOf(t.Unit.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,t.Unit.hours);i.querySelectorAll(`[data-action="${$.selectDay}"], .${r.css.calendarWeeks}`).forEach((e=>{if(this.optionsStore.options.display.calendarWeeks&&e.classList.contains(r.css.calendarWeeks)){if("#"===e.innerText)return;return void(e.innerText=`${a.week}`)}const i=[];i.push(r.css.day),a.isBefore(this.optionsStore.viewDate,t.Unit.month)&&i.push(r.css.old),a.isAfter(this.optionsStore.viewDate,t.Unit.month)&&i.push(r.css.new),!this.optionsStore.unset&&this.dates.isPicked(a,t.Unit.date)&&i.push(r.css.active),this.validation.isValid(a,t.Unit.date)||i.push(r.css.disabled),a.isSame(new o,t.Unit.date)&&i.push(r.css.today),0!==a.weekDay&&6!==a.weekDay||i.push(r.css.weekend),s(t.Unit.date,a,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${a.year}-${a.monthFormatted}-${a.dateFormatted}`),e.setAttribute("data-day",`${a.date}`),e.innerText=a.format({day:"numeric"}),a.manipulate(1,t.Unit.date)}))}_daysOfTheWeek(){const e=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(t.Unit.date),s=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(r.css.calendarWeeks,r.css.noHighlight),t.innerText="#",s.push(t)}for(let i=0;i<7;i++){const i=document.createElement("div");i.classList.add(r.css.dayOfTheWeek,r.css.noHighlight),i.innerText=e.format({weekday:"short"}),e.manipulate(1,t.Unit.date),s.push(i)}return s}}class O{constructor(){this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.monthsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",$.selectMonth),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(r.css.monthsContainer)[0];if("months"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(r.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(r.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.optionsStore.options.display.components.year?s.classList.remove(r.css.disabled):s.classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),t.Unit.year)?e.classList.remove(r.css.disabled):e.classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.year),t.Unit.year)?o.classList.remove(r.css.disabled):o.classList.add(r.css.disabled)}const o=this.optionsStore.viewDate.clone.startOf(t.Unit.year);i.querySelectorAll(`[data-action="${$.selectMonth}"]`).forEach(((e,i)=>{const a=[];a.push(r.css.month),!this.optionsStore.unset&&this.dates.isPicked(o,t.Unit.month)&&a.push(r.css.active),this.validation.isValid(o,t.Unit.month)||a.push(r.css.disabled),s(t.Unit.month,o,a,e),e.classList.remove(...e.classList),e.classList.add(...a),e.setAttribute("data-value",`${i}`),e.innerText=`${o.format({month:"short"})}`,o.manipulate(1,t.Unit.month)}))}}class H{constructor(){this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.yearsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",$.selectYear),t.appendChild(e)}return t}_update(e,s){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,t.Unit.year);const i=e.getElementsByClassName(r.css.yearsContainer)[0];if("years"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(r.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(r.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.optionsStore.options.display.components.decades?s.classList.remove(r.css.disabled):s.classList.add(r.css.disabled),this.validation.isValid(this._startYear,t.Unit.year)?e.classList.remove(r.css.disabled):e.classList.add(r.css.disabled),this.validation.isValid(this._endYear,t.Unit.year)?o.classList.remove(r.css.disabled):o.classList.add(r.css.disabled)}const o=this.optionsStore.viewDate.clone.startOf(t.Unit.year).manipulate(-1,t.Unit.year);i.querySelectorAll(`[data-action="${$.selectYear}"]`).forEach((e=>{const i=[];i.push(r.css.year),!this.optionsStore.unset&&this.dates.isPicked(o,t.Unit.year)&&i.push(r.css.active),this.validation.isValid(o,t.Unit.year)||i.push(r.css.disabled),s(t.Unit.year,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.year}`),e.innerText=o.format({year:"numeric"}),o.manipulate(1,t.Unit.year)}))}}class x{constructor(){this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.decadesContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",$.selectDecade),t.appendChild(e)}return t}_update(e,s){const[i,o]=U.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._startDecade.year=i,this._endDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._endDecade.year=o;const a=e.getElementsByClassName(r.css.decadesContainer)[0],[n,d,c]=a.parentElement.getElementsByClassName(r.css.calendarHeader)[0].getElementsByTagName("div");"decades"===this.optionsStore.currentView&&(d.setAttribute(r.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),this.validation.isValid(this._startDecade,t.Unit.year)?n.classList.remove(r.css.disabled):n.classList.add(r.css.disabled),this.validation.isValid(this._endDecade,t.Unit.year)?c.classList.remove(r.css.disabled):c.classList.add(r.css.disabled));const l=this.dates.picked.map((t=>t.year));a.querySelectorAll(`[data-action="${$.selectDecade}"]`).forEach(((e,i)=>{if(0===i)return e.classList.add(r.css.old),this._startDecade.year-10<0?(e.textContent=" ",n.classList.add(r.css.disabled),e.classList.add(r.css.disabled),void e.setAttribute("data-value","")):(e.innerText=this._startDecade.clone.manipulate(-10,t.Unit.year).format({year:"numeric"}),void e.setAttribute("data-value",`${this._startDecade.year}`));const o=[];o.push(r.css.decade);const a=this._startDecade.year,d=this._startDecade.year+9;!this.optionsStore.unset&&l.filter((t=>t>=a&&t<=d)).length>0&&o.push(r.css.active),s("decade",this._startDecade,o,e),e.classList.remove(...e.classList),e.classList.add(...o),e.setAttribute("data-value",`${this._startDecade.year}`),e.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,t.Unit.year)}))}}class P{constructor(){this._gridColumns="",this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p)}getPicker(t){const e=document.createElement("div");return e.classList.add(r.css.clockContainer),e.append(...this._grid(t)),e}_update(e){const s=e.getElementsByClassName(r.css.clockContainer)[0],i=(this.dates.lastPicked||this.optionsStore.viewDate).clone;if(s.querySelectorAll(".disabled").forEach((t=>t.classList.remove(r.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${$.incrementHours}]`).classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${$.decrementHours}]`).classList.add(r.css.disabled),s.querySelector(`[data-time-component=${t.Unit.hours}]`).innerText=i.getHoursFormatted(this.optionsStore.options.localization.hourCycle)),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${$.incrementMinutes}]`).classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${$.decrementMinutes}]`).classList.add(r.css.disabled),s.querySelector(`[data-time-component=${t.Unit.minutes}]`).innerText=i.minutesFormatted),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${$.incrementSeconds}]`).classList.add(r.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${$.decrementSeconds}]`).classList.add(r.css.disabled),s.querySelector(`[data-time-component=${t.Unit.seconds}]`).innerText=i.secondsFormatted),this.optionsStore.isTwelveHour){const e=s.querySelector(`[data-action=${$.toggleMeridiem}]`);e.innerText=i.meridiem(),this.validation.isValid(i.clone.manipulate(i.hours>=12?-12:12,t.Unit.hours))?e.classList.remove(r.css.disabled):e.classList.add(r.css.disabled)}s.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(e){this._gridColumns="";const s=[],i=[],o=[],a=document.createElement("div"),n=e(this.optionsStore.options.display.icons.up),d=e(this.optionsStore.options.display.icons.down);a.classList.add(r.css.separator,r.css.noHighlight);const c=a.cloneNode(!0);c.innerHTML=":";const l=(t=!1)=>t?c.cloneNode(!0):a.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementHour),e.setAttribute("data-action",$.incrementHours),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickHour),e.setAttribute("data-action",$.showHours),e.setAttribute("data-time-component",t.Unit.hours),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementHour),e.setAttribute("data-action",$.decrementHours),e.appendChild(d.cloneNode(!0)),o.push(e),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(s.push(l()),i.push(l(!0)),o.push(l()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementMinute),e.setAttribute("data-action",$.incrementMinutes),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickMinute),e.setAttribute("data-action",$.showMinutes),e.setAttribute("data-time-component",t.Unit.minutes),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementMinute),e.setAttribute("data-action",$.decrementMinutes),e.appendChild(d.cloneNode(!0)),o.push(e)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(s.push(l()),i.push(l(!0)),o.push(l()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementSecond),e.setAttribute("data-action",$.incrementSeconds),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickSecond),e.setAttribute("data-action",$.showSeconds),e.setAttribute("data-time-component",t.Unit.seconds),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementSecond),e.setAttribute("data-action",$.decrementSeconds),e.appendChild(d.cloneNode(!0)),o.push(e)}if(this.optionsStore.isTwelveHour){this._gridColumns+=" a";let t=l();s.push(t);const e=document.createElement("button");e.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),e.setAttribute("data-action",$.toggleMeridiem),e.setAttribute("tabindex","-1"),r.css.toggleMeridiem.includes(",")?e.classList.add(...r.css.toggleMeridiem.split(",")):e.classList.add(r.css.toggleMeridiem),t=document.createElement("div"),t.classList.add(r.css.noHighlight),t.appendChild(e),i.push(t),t=l(),o.push(t)}return this._gridColumns=this._gridColumns.trim(),[...s,...i,...o]}}class I{constructor(){this.optionsStore=c.locate(h),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.hourContainer);for(let e=0;e<(this.optionsStore.isTwelveHour?12:24);e++){const e=document.createElement("div");e.setAttribute("data-action",$.selectHour),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(r.css.hourContainer)[0],o=this.optionsStore.viewDate.clone.startOf(t.Unit.date);i.querySelectorAll(`[data-action="${$.selectHour}"]`).forEach((e=>{const i=[];i.push(r.css.hour),this.validation.isValid(o,t.Unit.hours)||i.push(r.css.disabled),s(t.Unit.hours,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.hours}`),e.innerText=o.getHoursFormatted(this.optionsStore.options.localization.hourCycle),o.manipulate(1,t.Unit.hours)}))}}class z{constructor(){this.optionsStore=c.locate(h),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.minuteContainer);const e=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/e;s++){const e=document.createElement("div");e.setAttribute("data-action",$.selectMinute),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(r.css.minuteContainer)[0],o=this.optionsStore.viewDate.clone.startOf(t.Unit.hours),a=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;i.querySelectorAll(`[data-action="${$.selectMinute}"]`).forEach((e=>{const i=[];i.push(r.css.minute),this.validation.isValid(o,t.Unit.minutes)||i.push(r.css.disabled),s(t.Unit.minutes,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.minutes}`),e.innerText=o.minutesFormatted,o.manipulate(a,t.Unit.minutes)}))}}class N{constructor(){this.optionsStore=c.locate(h),this.validation=c.locate(p)}getPicker(){const t=document.createElement("div");t.classList.add(r.css.secondContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",$.selectSecond),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(r.css.secondContainer)[0],o=this.optionsStore.viewDate.clone.startOf(t.Unit.minutes);i.querySelectorAll(`[data-action="${$.selectSecond}"]`).forEach((e=>{const i=[];i.push(r.css.second),this.validation.isValid(o,t.Unit.seconds)||i.push(r.css.disabled),s(t.Unit.seconds,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.seconds}`),e.innerText=o.secondsFormatted,o.manipulate(5,t.Unit.seconds)}))}}class B{static toggle(t){t.classList.contains(r.css.show)?this.hide(t):this.show(t)}static showImmediately(t){t.classList.remove(r.css.collapsing),t.classList.add(r.css.collapse,r.css.show),t.style.height=""}static show(t){if(t.classList.contains(r.css.collapsing)||t.classList.contains(r.css.show))return;t.style.height="0",t.classList.remove(r.css.collapse),t.classList.add(r.css.collapsing),setTimeout((()=>{B.showImmediately(t)}),this.getTransitionDurationFromElement(t)),t.style.height=`${t.scrollHeight}px`}static hideImmediately(t){t&&(t.classList.remove(r.css.collapsing,r.css.show),t.classList.add(r.css.collapse))}static hide(t){if(t.classList.contains(r.css.collapsing)||!t.classList.contains(r.css.show))return;t.style.height=`${t.getBoundingClientRect().height}px`;t.offsetHeight,t.classList.remove(r.css.collapse,r.css.show),t.classList.add(r.css.collapsing),t.style.height="",setTimeout((()=>{B.hideImmediately(t)}),this.getTransitionDurationFromElement(t))}}B.getTransitionDurationFromElement=t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),o=Number.parseFloat(s);return i||o?(e=e.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0};class F{constructor(){this._isVisible=!1,this._documentClickEvent=t=>{this.optionsStore.options.debug||window.debug||!this._isVisible||t.composedPath().includes(this.widget)||t.composedPath()?.includes(this.optionsStore.element)||this.hide()},this._actionsClickEvent=t=>{this._eventEmitters.action.emit({e:t})},this.optionsStore=c.locate(h),this.validation=c.locate(p),this.dates=c.locate(U),this.dateDisplay=c.locate(V),this.monthDisplay=c.locate(O),this.yearDisplay=c.locate(H),this.decadeDisplay=c.locate(x),this.timeDisplay=c.locate(P),this.hourDisplay=c.locate(I),this.minuteDisplay=c.locate(z),this.secondDisplay=c.locate(N),this._eventEmitters=c.locate(m),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((t=>{this._update(t)}))}get widget(){return this._widget}get isVisible(){return this._isVisible}_update(e){if(this.widget)switch(e){case t.Unit.seconds:this.secondDisplay._update(this.widget,this.paint);break;case t.Unit.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case t.Unit.hours:this.hourDisplay._update(this.widget,this.paint);break;case t.Unit.date:this.dateDisplay._update(this.widget,this.paint);break;case t.Unit.month:this.monthDisplay._update(this.widget,this.paint);break;case t.Unit.year:this.yearDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(t.Unit.hours),this._update(t.Unit.minutes),this._update(t.Unit.seconds);break;case"calendar":this._update(t.Unit.date),this._update(t.Unit.year),this._update(t.Unit.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(t,e,s,i){}show(){if(null==this.widget){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const e=(new o).setLocale(this.optionsStore.options.localization.locale);if(!this.optionsStore.options.keepInvalid){let s=0,i=1;for(this.optionsStore.options.restrictions.maxDate?.isBefore(e)&&(i=-1);!(this.validation.isValid(e)||(e.manipulate(i,t.Unit.date),s>31));)s++}this.dates.setValue(e)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}this._buildWidget(),this._updateTheme();const e=this._hasTime&&!this._hasDate;if(e?(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:$.showClock})):this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),e||"clock"===this.optionsStore.options.display.viewMode||(this._hasTime&&(this.optionsStore.options.display.sideBySide?B.show(this.widget.querySelector(`div.${r.css.timeContainer}`)):B.hideImmediately(this.widget.querySelector(`div.${r.css.timeContainer}`))),B.show(this.widget.querySelector(`div.${r.css.dateContainer}`))),this._hasDate&&this._showMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{(this.optionsStore.options?.container||document.body).appendChild(this.widget),this.createPopup(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?"bottom-end":"bottom-start"}).then()}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:$.showClock}),this.widget.querySelectorAll("[data-action]").forEach((t=>t.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(r.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(r.css.show),this.optionsStore.options.display.inline||(this.updatePopup(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:r.events.show}),this._isVisible=!0}async createPopup(t,e,s){let i;if(window?.Popper)i=window?.Popper?.createPopper;else{const{createPopper:t}=await import("@popperjs/core");i=t}i&&(this._popperInstance=i(t,e,s))}updatePopup(){this._popperInstance?.update()}_showMode(t){if(!this.widget)return;if(t){const e=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+t));if(this.optionsStore.currentCalendarViewMode==e)return;this.optionsStore.currentCalendarViewMode=e}this.widget.querySelectorAll(`.${r.css.dateContainer} > div:not(.${r.css.calendarHeader}), .${r.css.timeContainer} > div:not(.${r.css.clockContainer})`).forEach((t=>t.style.display="none"));const e=l[this.optionsStore.currentCalendarViewMode],s=this.widget.querySelector(`.${e.className}`);switch(e.className){case r.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case r.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case r.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case r.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}s.style.display="grid",this.optionsStore.options.display.sideBySide&&(this.widget.querySelectorAll(`.${r.css.clockContainer}`)[0].style.display="grid"),this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit()}_updateTheme(t){if(this.widget){if(t){if(this.optionsStore.options.display.theme===t)return;this.optionsStore.options.display.theme=t}this.widget.classList.remove("light","dark"),this.widget.classList.add(this._getThemeClass()),"auto"===this.optionsStore.options.display.theme?window.matchMedia(r.css.isDarkPreferredQuery).addEventListener("change",(()=>this._updateTheme())):window.matchMedia(r.css.isDarkPreferredQuery).removeEventListener("change",(()=>this._updateTheme()))}}_getThemeClass(){const t=this.optionsStore.options.display.theme||"auto",e=window.matchMedia&&window.matchMedia(r.css.isDarkPreferredQuery).matches;switch(t){case"light":return r.css.lightTheme;case"dark":return r.css.darkTheme;case"auto":return e?r.css.darkTheme:r.css.lightTheme}}_updateCalendarHeader(){if(!this._hasDate)return;const t=[...this.widget.querySelector(`.${r.css.dateContainer} div[style*="display: grid"]`).classList].find((t=>t.startsWith(r.css.dateContainer))),[e,s,i]=this.widget.getElementsByClassName(r.css.calendarHeader)[0].getElementsByTagName("div");switch(t){case r.css.decadesContainer:e.setAttribute("title",this.optionsStore.options.localization.previousCentury),s.setAttribute("title",""),i.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case r.css.yearsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousDecade),s.setAttribute("title",this.optionsStore.options.localization.selectDecade),i.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case r.css.monthsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousYear),s.setAttribute("title",this.optionsStore.options.localization.selectYear),i.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case r.css.daysContainer:e.setAttribute("title",this.optionsStore.options.localization.previousMonth),s.setAttribute("title",this.optionsStore.options.localization.selectMonth),i.setAttribute("title",this.optionsStore.options.localization.nextMonth),s.setAttribute(t,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat))}s.innerText=s.getAttribute(t)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(r.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:r.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?this.dates.lastPicked.clone:void 0}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent))}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((t=>t.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const t=document.createElement("div");t.classList.add(r.css.widget);const e=document.createElement("div");e.classList.add(r.css.dateContainer),e.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const s=document.createElement("div");s.classList.add(r.css.timeContainer),s.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),s.appendChild(this.hourDisplay.getPicker()),s.appendChild(this.minuteDisplay.getPicker()),s.appendChild(this.secondDisplay.getPicker());const i=document.createElement("div");if(i.classList.add(r.css.toolbar),i.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&t.classList.add(r.css.inline),this.optionsStore.options.display.calendarWeeks&&t.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){t.classList.add(r.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");return o.classList.add("td-row"),e.classList.add("td-half"),s.classList.add("td-half"),o.appendChild(e),o.appendChild(s),t.appendChild(o),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),void(this._widget=t)}"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),this._hasDate&&(this._hasTime&&(e.classList.add(r.css.collapse),"clock"!==this.optionsStore.options.display.viewMode&&e.classList.add(r.css.show)),t.appendChild(e)),this._hasTime&&(this._hasDate&&(s.classList.add(r.css.collapse),"clock"===this.optionsStore.options.display.viewMode&&s.classList.add(r.css.show)),t.appendChild(s)),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");o.classList.add("arrow"),o.setAttribute("data-popper-arrow",""),t.appendChild(o),this._widget=t}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}getToolbarElements(){const t=[];if(this.optionsStore.options.display.buttons.today){const e=document.createElement("div");e.setAttribute("data-action",$.today),e.setAttribute("title",this.optionsStore.options.localization.today),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),t.push(e)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let e,s;"clock"===this.optionsStore.options.display.viewMode?(e=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(e=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.setAttribute("data-action",$.togglePicker),i.setAttribute("title",e),i.appendChild(this._iconTag(s)),t.push(i)}if(this.optionsStore.options.display.buttons.clear){const e=document.createElement("div");e.setAttribute("data-action",$.clear),e.setAttribute("title",this.optionsStore.options.localization.clear),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),t.push(e)}if(this.optionsStore.options.display.buttons.close){const e=document.createElement("div");e.setAttribute("data-action",$.close),e.setAttribute("title",this.optionsStore.options.localization.close),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),t.push(e)}return t}getHeadTemplate(){const t=document.createElement("div");t.classList.add(r.css.calendarHeader);const e=document.createElement("div");e.classList.add(r.css.previous),e.setAttribute("data-action",$.previous),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.previous));const s=document.createElement("div");s.classList.add(r.css.switch),s.setAttribute("data-action",$.changeCalendarView);const i=document.createElement("div");return i.classList.add(r.css.next),i.setAttribute("data-action",$.next),i.appendChild(this._iconTag(this.optionsStore.options.display.icons.next)),t.append(e,s,i),t}_iconTag(t){if("sprites"===this.optionsStore.options.display.icons.type){const e=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",t),s.setAttribute("href",t),e.appendChild(s),e}const e=document.createElement("i");return e.classList.add(...t.split(" ")),e}_rebuild(){const t=this._isVisible;this._dispose(),t&&this.show()}}class q{constructor(){this.optionsStore=c.locate(h),this.dates=c.locate(U),this.validation=c.locate(p),this.display=c.locate(F),this._eventEmitters=c.locate(m),this._eventEmitters.action.subscribe((t=>{this.do(t.e,t.action)}))}do(e,s){const i=e?.currentTarget;if(i?.classList?.contains(r.css.disabled))return!1;s=s||i?.dataset?.action;const a=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(s){case $.next:case $.previous:this.handleNextPrevious(s);break;case $.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case $.selectMonth:case $.selectYear:case $.selectDecade:this.handleSelectCalendarMode(s,i);break;case $.selectDay:this.handleSelectDay(i);break;case $.selectHour:{let t=+i.dataset.value;a.hours>=12&&this.optionsStore.isTwelveHour&&(t+=12),a.hours=t,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(e);break}case $.selectMinute:a.minutes=+i.dataset.value,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(e);break;case $.selectSecond:a.seconds=+i.dataset.value,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(e);break;case $.incrementHours:this.manipulateAndSet(a,t.Unit.hours);break;case $.incrementMinutes:this.manipulateAndSet(a,t.Unit.minutes,this.optionsStore.options.stepping);break;case $.incrementSeconds:this.manipulateAndSet(a,t.Unit.seconds);break;case $.decrementHours:this.manipulateAndSet(a,t.Unit.hours,-1);break;case $.decrementMinutes:this.manipulateAndSet(a,t.Unit.minutes,-1*this.optionsStore.options.stepping);break;case $.decrementSeconds:this.manipulateAndSet(a,t.Unit.seconds,-1);break;case $.toggleMeridiem:this.manipulateAndSet(a,t.Unit.hours,this.dates.lastPicked.hours>=12?-12:12);break;case $.togglePicker:this.handleToggle(i);break;case $.showClock:case $.showHours:case $.showMinutes:case $.showSeconds:this.optionsStore.options.display.sideBySide||"clock"===this.optionsStore.currentView||(B.hideImmediately(this.display.widget.querySelector(`div.${r.css.dateContainer}`)),B.showImmediately(this.display.widget.querySelector(`div.${r.css.timeContainer}`))),this.handleShowClockContainers(s);break;case $.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case $.close:this.display.hide();break;case $.today:{const e=(new o).setLocale(this.optionsStore.options.localization.locale);this._eventEmitters.updateViewDate.emit(e),this.validation.isValid(e,t.Unit.date)&&this.dates.setValue(e,this.dates.lastPickedIndex);break}}}handleShowClockContainers(e){if(!this.display._hasTime)return void r.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${r.css.timeContainer} > div`).forEach((t=>t.style.display="none"));let s="";switch(e){case $.showClock:s=r.css.clockContainer,this.display._update("clock");break;case $.showHours:s=r.css.hourContainer,this.display._update(t.Unit.hours);break;case $.showMinutes:s=r.css.minuteContainer,this.display._update(t.Unit.minutes);break;case $.showSeconds:s=r.css.secondContainer,this.display._update(t.Unit.seconds)}this.display.widget.getElementsByClassName(s)[0].style.display="grid"}handleNextPrevious(t){const{unit:e,step:s}=l[this.optionsStore.currentCalendarViewMode];t===$.next?this.optionsStore.viewDate.manipulate(s,e):this.optionsStore.viewDate.manipulate(-1*s,e),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(t){this.optionsStore.isTwelveHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(t,$.showClock):this.display.hide()}manipulateAndSet(t,e,s=1){const i=t.manipulate(s,e);this.validation.isValid(i,e)&&this.dates.setValue(i,this.dates.lastPickedIndex)}handleSelectCalendarMode(t,e){const s=+e.dataset.value;switch(t){case $.selectMonth:this.optionsStore.viewDate.month=s;break;case $.selectYear:case $.selectDecade:this.optionsStore.viewDate.year=s}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1)}handleToggle(t){t.getAttribute("title")===this.optionsStore.options.localization.selectDate?(t.setAttribute("title",this.optionsStore.options.localization.selectTime),t.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(t.setAttribute("title",this.optionsStore.options.localization.selectDate),t.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.handleShowClockContainers($.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${r.css.dateContainer}, .${r.css.timeContainer}`).forEach((t=>B.toggle(t))),this._eventEmitters.viewUpdate.emit()}handleSelectDay(e){const s=this.optionsStore.viewDate.clone;e.classList.contains(r.css.old)&&s.manipulate(-1,t.Unit.month),e.classList.contains(r.css.new)&&s.manipulate(1,t.Unit.month),s.date=+e.dataset.day;let i=0;this.optionsStore.options.multipleDates?(i=this.dates.pickedIndex(s,t.Unit.date),-1!==i?this.dates.setValue(null,i):this.dates.setValue(s,this.dates.lastPickedIndex+1)):this.dates.setValue(s,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.display.hide()}}class W{constructor(t,e={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=t=>{const e=t?.detail;if(e)return;const s=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked.clone)},i=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates)try{const t=i.split(this.optionsStore.options.multipleDatesSeparator);for(let e=0;e<t.length;e++)this.dates.setFromInput(t[e],e);s()}catch{console.warn("TD: Something went wrong trying to set the multipleDates values from the input field.")}else this.dates.setFromInput(i,0),s()},this._toggleClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||this.toggle()},c=new d,this._eventEmitters=c.locate(m),this.optionsStore=c.locate(h),this.display=c.locate(F),this.dates=c.locate(U),this.actions=c.locate(q),t||r.errorMessages.mustProvideElement(),this.optionsStore.element=t,this._initializeOptions(e,y,!0),this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((t=>{this._triggerEvent(t)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()})),this._eventEmitters.updateViewDate.subscribe((t=>{this.viewDate=t}))}get viewDate(){return this.optionsStore.viewDate}set viewDate(t){this.optionsStore.viewDate=t,this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.display._update("clock"===this.optionsStore.currentView?"clock":"calendar")}updateOptions(t,e=!1){e?this._initializeOptions(t,y):this._initializeOptions(t,this.optionsStore.options),this.display._rebuild()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){this._isDisabled=!0,this.optionsStore.input?.setAttribute("disabled","disabled"),this.display.hide()}enable(){this._isDisabled=!1,this.optionsStore.input?.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(t,e){let s;"string"==typeof t&&(t=[t]),s=Array.isArray(e)?e:[e],t.length!==s.length&&r.errorMessages.subscribeMismatch();const i=[];for(let e=0;e<t.length;e++){const o=t[e];if(Array.isArray(this._subscribers[o])||(this._subscribers[o]=[]),this._subscribers[o].push(s[e]),i.push({unsubscribe:this._unsubscribe.bind(this,o,this._subscribers[o].length-1)}),1===t.length)return i[0]}return i}dispose(){this.display.hide(),this.display._dispose(),this._eventEmitters.destroy(),this.optionsStore.input?.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input?.removeEventListener("click",this._toggleClickEvent),this._toggle?.removeEventListener("click",this._toggleClickEvent),this._subscribers={}}locale(t){const e=Y[t];e&&this.updateOptions({localization:e})}_triggerEvent(t){t.viewMode=this.optionsStore.currentView;const e=t.type===r.events.change;if(e){const{date:e,oldDate:s,isClear:i}=t;if(e&&s&&e.isSame(s)||!i&&!e&&!s)return;this._handleAfterChangeEvent(t),this.optionsStore.input?.dispatchEvent(new CustomEvent(t.type,{detail:t})),this.optionsStore.input?.dispatchEvent(new CustomEvent("change",{detail:t}))}if(this.optionsStore.element.dispatchEvent(new CustomEvent(t.type,{detail:t})),window.jQuery){const s=window.jQuery;e&&this.optionsStore.input?s(this.optionsStore.input).trigger(t):s(this.optionsStore.element).trigger(t)}this._publish(t)}_publish(t){Array.isArray(this._subscribers[t.type])&&this._subscribers[t.type].forEach((e=>{e(t)}))}_viewUpdate(){this._triggerEvent({type:r.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(t,e){this._subscribers[t].splice(e,1)}_initializeOptions(t,e,s=!1){let i=L.deepCopy(t);i=L._mergeOptions(i,e),s&&(i=L._dataToOptions(this.optionsStore.element,i)),L._validateConflicts(i),i.viewDate=i.viewDate.setLocale(i.localization.locale),this.optionsStore.viewDate.isSame(i.viewDate)||(this.optionsStore.viewDate=i.viewDate),i.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),i.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),i.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),l[this.optionsStore.currentCalendarViewMode].name!==i.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(l.findIndex((t=>t.name===i.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),this.display?.isVisible&&this.display._update("all"),i.display.components.useTwentyfourHour&&void 0===i.localization.hourCycle?i.localization.hourCycle="h24":void 0===i.localization.hourCycle&&(i.localization.hourCycle=(t=>{if(!t)return"h12";const e={hour:"2-digit",minute:"2-digit",numberingSystem:"latn"},s=(new o).setLocale(t);s.hours=0;const i=s.parts(void 0,e).hour;if("12"===i)return"h12";if("24"===i)return"h24";s.hours=23;const a=s.parts(void 0,e).hour;return"00"===i&&"11"===a?"h11":"00"===i&&"23"===a?"h23":void console.warn(`couldn't determine hour cycle for ${t}. start: ${i}. end: ${a}`)})(i.localization.locale)),this.optionsStore.options=i}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{const t=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==t||"nearest"==t?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(t)}this.optionsStore.input&&(!this.optionsStore.input.value&&this.optionsStore.options.defaultDate&&(this.optionsStore.input.value=this.dates.formatInput(this.optionsStore.options.defaultDate)),this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input.addEventListener("click",this._toggleClickEvent),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let t=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==t&&(t='[data-td-toggle="datetimepicker"]'),this._toggle=null==t?this.optionsStore.element:this.optionsStore.element.querySelector(t),this._toggle.addEventListener("click",this._toggleClickEvent)}_handleAfterChangeEvent(t){!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||this.display.widget?.getElementsByClassName(r.css.show)[0].classList.contains(r.css.timeContainer)||!t.oldDate&&this.optionsStore.options.useCurrent||t.oldDate&&t.date?.isSame(t.oldDate)||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector(`.${r.css.switch}`)},action:$.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}}const Y={},j=t=>{Y[t.name]||(Y[t.name]=t.localization)},Q=t=>{const e=Y[t];e&&(y.localization=e)},K=function(t,e){return t?(t.installed||(t(e,{TempusDominus:W,Dates:U,Display:F,DateTime:o,Namespace:r},R),t.installed=!0),R):R},J="6.2.10",R={TempusDominus:W,extend:K,loadLocale:j,locale:Q,Namespace:r,DefaultOptions:y,DateTime:o,Unit:t.Unit,version:J};t.DateTime=o,t.DefaultOptions=y,t.Namespace=r,t.TempusDominus=W,t.extend=K,t.loadLocale=j,t.locale=Q,t.version=J,Object.defineProperty(t,"__esModule",{value:!0})}));
