# Contributing

When contributing to this repository, please first discuss the change you wish to make via [issue](https://github.com/fabbricadigitale/paper-chip/issues/new),
[email](mailto:l.didonato@fabbricadigitale.it), or any other method with the owners and the maintainers of this repository before making a change.

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Commit convention

We use the **eslint** commit convention.

You should read more about is [here](https://github.com/conventional-changelog-archived-repos/conventional-changelog-eslint/blob/master/convention.md).

Anyway here are some good commit message summary examples:

```
Build: Update Travis to only test Node 0.10 (refs #734)
Fix: Semi rule incorrectly flagging extra semicolon (fixes #840)
Upgrade: Esprima to 1.2, switch to using Esprima comment attachment (fixes #730)
```

## How to contribute

We want you to **work on something you love**.

So, after discussing the changes, the new feature, or the improvements to this project, **fork** this repository, create a **feature branch** (eg., `feature/awesome-feature`), and start **coding** !

The contribution process is driven via **pull requests**.

Do not forget to:

1. update the README.md (and generally any **documentation**) with details of eventual **changes to the interface**.

2. update **test suites** related to the feature you are contributing.

3. (please) follow our **commit conventions** (read more about them [above](#commit-convention)) and make sure all of your **commits** are **atomic** (ie., one feature per commit)

4. write a **clear**, **concise**, but **communicative one-line commit message** for small changes

5. write multi-line messages for bigger changes - eg.,

    ```
    $ git commit -m "Update: A brief summary of the commit
    > 
    > A paragraph describing what changed and its impact."
    ```

6. verify your code style matches the rules of this repository by the provided **lint** task

7. send a **pull request** containing a clear list of what you have done (read more about [pull requests](http://help.github.com/pull-requests))

8. once you have the evaluation and the sign-off of two other developers your changes will be merged within the repository

## Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

### Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

### Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at this [email](mailto:l.didonato@fabbricadigitale.it). All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version].

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
