[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-blue.svg)](https://www.webcomponents.org/element/gatanaso/multiselect-combo-box)
[![Published on Vaadin  Directory](https://img.shields.io/badge/Vaadin%20Directory-published-00b4f0.svg)](https://vaadin.com/directory/component/gatanasomultiselect-combo-box)
[![Build Status](https://travis-ci.org/gatanaso/multiselect-combo-box.svg?branch=master)](https://travis-ci.org/gatanaso/multiselect-combo-box)
[![codecov](https://codecov.io/gh/gatanaso/multiselect-combo-box/branch/master/graph/badge.svg)](https://codecov.io/gh/gatanaso/multiselect-combo-box)
[![Stars on vaadin.com/directory](https://img.shields.io/vaadin-directory/star/gatanasomultiselect-combo-box.svg)](https://vaadin.com/directory/component/gatanasomultiselect-combo-box)

# \<multiselect-combo-box\>

A multiselect combo box web component based on [Polymer](https://github.com/Polymer/polymer) and the [`vaadin-combo-box`](https://github.com/vaadin/vaadin-combo-box).

*Compatible with the core set of [Vaadin Components](https://github.com/vaadin/vaadin-core).*

#### [Live Demo ↗](https://multiselect-combo-box.web.app/demo/) | [Material Theme Live Demo ↗](https://multiselect-combo-box.web.app/demo/material)

## Getting started
### Polymer 3 (npm)
Install the `multiselect-combo-box`:
```
npm install multiselect-combo-box --save
```
Once installed, import in your applicaiton:
```
import 'multiselect-combo-box/multiselect-combo-box.js';
```
Add to your page:
```
<multiselect-combo-box label="Select items"></multiselect-combo-box>
```
### Polymer 2.x (bower)
Install the `multiselect-combo-box`:
```
bower install --save gatanaso/multiselect-combo-box
```
Once installed, import in your applicaiton:
```
<link rel="import" href="bower_components/multiselect-combo-box/multiselect-combo-box.html">
```
Add to your page:
```
<multiselect-combo-box label="Select items"></multiselect-combo-box>
```

> For more usage examples, see the [demo](https://multiselect-combo-box.firebaseapp.com/demo/).

## Project setup

1. Fork the `multiselect-combo-box` repository and clone it locally.
1. Make sure you have the [Polymer CLI](https://www.npmjs.com/package/polymer-cli) and npm (packaged with [Node.js](https://nodejs.org)) installed locally.
1. To install the element's dependencies, in the `multiselect-combo-box` directory, run: `npm install`
    * if using the Polymer 2.x version, also run: `bower install`

### Running the project locally
To perform linting, run the tests and automatically open the demo page, run:
```
npm run start
```

### Branch information

* `master` the latest (Polymer 3) version of the `multiselect-combo-box`
* `polymer-2` the Polymer 2.x version of the `multiselect-combo-box`

## Java API
The Vaadin Flow Java compatible version of this component is available on the [Vaadin Directory](https://vaadin.com/directory/component/multiselect-combo-box) and [GitHub](https://github.com/gatanaso/multiselect-combo-box-flow).
